
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <stdlib.h>
#include <string>
#include <iostream>
#include <fstream>
#include <signal.h>
#include <pthread.h>
#include <fcntl.h> 

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)

#endif

/*#include "../interface.h"*/
#include "NewProcessesSupport.h"
#include "UnixGenerateGUI.h"

using namespace std;

using namespace GraphGraphics;

/*Path to promela generator*/
const char * GTKUnixGraphGenerationWindow::PROMELA_GENERATOR_DIR = "PROMELA_GENERATOR_DIR";
const char * GTKUnixGraphGenerationWindow::NUSMV_GENERATOR_DIR   = "NUSMV_GENERATOR_DIR";
const char * GTKUnixGraphGenerationWindow::MDLGEN_COMPILER_DIR   = "MDLGEN_COMPILER_DIR";

const char * GTKUnixGraphGenerationWindow::PROMELA_GENERATOR_FILE = "generator";//"../../generator/generator";
const char * GTKUnixGraphGenerationWindow::NUSMV_GENERATOR_FILE = "NuSMV";
const char * GTKUnixGraphGenerationWindow::MDLGEN_GENERATOR_FILE = "mdlgen";
/*Path to original scenario files*/
const char * GTKUnixGraphGenerationWindow::PROMELA_SCENARIO_DIR = "/usr/local/share/generator/scenario/%s";

/*Name of scenario directory where scenario files will be generated*/
const char * GTKUnixGraphGenerationWindow::SCENARIO_DIR = "/tmp/scenario"; 

const int    GTKUnixGraphGenerationWindow::scenario_files_count = 6;
/* names of Scenario files to be copied without changes */
const char * GTKUnixGraphGenerationWindow::unch_scenario_files[] = 
{ 
   "AutomBase.h", 
   "AutomBase.cpp", 
   "graph.hpp",
   "graph.cpp",
   "scenario.cpp",
   "makefile"
};

//availble generators
#define NUSMV_GENERATOR   "NuSMV"
#define PROMELA_GENERATOR "Promela"

//popular editors
#define XEMACS_EDITOR     "XEmacs"
#define GEDIT_EDITOR      "GEdit"
#define KEDIT_EDITOR      "KEdit"
#define OTHER_EDITOR      "Other"

/*******************************************************************************/
/*******************************************************************************/

//This global var is necessary for USR1 signal handling
GtkWidget         *MainWindow;

extern pthread_mutex_t graph_load_mutex;

extern bool              is_load; 
extern pthread_t         curr_thr;

/******************************************************************************/
/******************************************************************************/

struct TimerGraphLoadArgs
{
  GTKUnixGraphGenerationWindow *gen_window;
  char                          graph_name[255];
  pthread_t                     thread_id;
};

gint TimerCalllback(gpointer data)
{
  TimerGraphLoadArgs* timer_args = (TimerGraphLoadArgs*)data;
  GTKUnixGraphGenerationWindow *gen_window = timer_args->gen_window;
  
  if (is_load && (timer_args->thread_id == curr_thr) && gen_window != 0 )
  {
    gen_window->graph_load( timer_args->graph_name );
    is_load = false;
    timer_args->gen_window = 0;
  }
  
  return TRUE;
}

class WidgetTextOutput : public TextOutput
{
  //Private data where to copy the output string
  GtkTextBuffer *m_buffer;
  GtkTextView   *m_view;

public:
  void set_view(GtkTextView *view, GtkTextBuffer *buffer);
  
  void insert(const char *str);
};

struct GraphAppData
{
  GraphViewContext *graph_view_context;
  GraphGUI         *graph_gui;
};

void WidgetTextOutput::set_view(GtkTextView *view, GtkTextBuffer *buffer)
{
  m_view = view;
  m_buffer = buffer;  
}
  
void WidgetTextOutput::insert(const char *str)
{
  GtkTextIter  iter;
  
  gtk_text_buffer_get_end_iter(m_buffer, &iter);
  gtk_text_buffer_insert(m_buffer, &iter, str, -1);
}

/*******************************************************************************/
/*******************************************************************************/

void GTKUnixGraphGenerationWindow::set_TL_entry_active( bool enabled )
{
  gtk_widget_set_sensitive (TLEdit_button, enabled && can_TL_enabled);
  gtk_widget_set_sensitive (TLSelect_button, enabled);
  
  gtk_widget_set_sensitive (TL_entry, enabled);
}

void GTKUnixGraphGenerationWindow::set_TL_formula_entry_active( bool enabled )
{
  gtk_widget_set_sensitive (TL_formula_entry, enabled);
  gtk_widget_set_sensitive (TL_def_entry, enabled);  
  gtk_widget_set_sensitive (TLDefAdd_button, enabled);  
  gtk_widget_set_sensitive (TLGen_button, enabled);    
  gtk_widget_set_sensitive (TLDefRemove_button, enabled);  
}

void GTKUnixGraphGenerationWindow::set_TL_active( bool enabled )
{
  bool       TL_active         = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( TL_checkbutton ) );
  bool       Formula_active    = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Formula_checkbutton ) );  
  
  gtk_widget_set_sensitive (TL_checkbutton, enabled);
  gtk_widget_set_sensitive (Formula_checkbutton, enabled);  
  
  set_TL_entry_active( enabled && (TL_active) );
  set_TL_formula_entry_active( enabled && (Formula_active) );  
}

void GTKUnixGraphGenerationWindow::set_Gen_active( bool enabled )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  bool        promela = ( string( text ) == PROMELA_GENERATOR );
    
  gtk_widget_set_sensitive (Model_entry, enabled);
  gtk_widget_set_sensitive (ModelSelect_button, enabled);
  gtk_widget_set_sensitive (ModelEdit_button, enabled);
  gtk_widget_set_sensitive (Generator_combo, enabled);
  gtk_widget_set_sensitive (Generator_combo_entry, enabled);
  
  set_TL_active( promela && enabled );
}

void GTKUnixGraphGenerationWindow::set_Graph_active( bool enabled )
{
  //gtk_widget_set_sensitive (Attack_checkbutton, enabled);
  gtk_widget_set_sensitive (Graph_entry, enabled);
  gtk_widget_set_sensitive (GraphSelect_button, enabled);
  gtk_widget_set_sensitive (GraphEdit_button, enabled);
}

void GTKUnixGraphGenerationWindow::set_Compilator_active( bool enabled )
{
  gtk_widget_set_sensitive (Run_button, enabled);
  gtk_widget_set_sensitive (GenParams_entry, enabled);
  gtk_widget_set_sensitive (XMLParams_entry, enabled);
  gtk_widget_set_sensitive (ScenarioParam_entry, enabled);
  gtk_widget_set_sensitive (XML_radiobutton, enabled);
  gtk_widget_set_sensitive (Generation_radiobutton, enabled);
  gtk_widget_set_sensitive (XML_Gen_radiobutton, enabled);
}

void GTKUnixGraphGenerationWindow::set_dialog_action_active( bool enabled )
{
  gtk_widget_set_sensitive (Close_button, enabled);
}

void GTKUnixGraphGenerationWindow::set_XML_active( bool enabled )
{
  gtk_widget_set_sensitive (XML_entry, enabled);
  gtk_widget_set_sensitive (XMLSelect_button, enabled);
  gtk_widget_set_sensitive (XMLEdit_button, enabled);
}

void GTKUnixGraphGenerationWindow::set_run_active( bool enabled )
{
  if ( GraphGenerationWindow != 0 )
    gtk_widget_set_sensitive ( Run_button, enabled );
}

void GTKUnixGraphGenerationWindow::set_all_active( bool enabled )
{
   set_Compilator_active( enabled );
   set_Graph_active( enabled );
   set_Gen_active( enabled );
   set_XML_active( enabled );
}

/*******************************************************************************/
/*******************************************************************************/

char* GTKUnixGraphGenerationWindow::copy_str( const char* str )
{
  char *res = new char[strlen( str ) + 1];
  
  res[0] = 0;
  
  strcpy( res, str );
  
  return res;
}

char* GTKUnixGraphGenerationWindow::get_full_path( const char *var_name, const char* app_name, bool is_dir )
{
  char *path = getenv( var_name );
  
  if ( path == 0 )
  {
    path = copy_str( app_name );
  }
  else
  {
    string file_name = string( path );
        
    if ( file_name[file_name.size() - 1] != '/' )
      file_name += '/';
    
    file_name += string( app_name );
    
    ifstream f_stream( file_name.c_str() );
    
    if ( f_stream.is_open( ) || is_dir )
    {
      f_stream.close();
      path = copy_str( file_name.c_str() );
    }
    else
    {
      path = copy_str( app_name );
    }
  }
  
  return path;
}

int GTKUnixGraphGenerationWindow::make_cmd_args( string str_args, const string &file, char ***cmd_args )
{
  vector<string> v_args;
  unsigned int pos = str_args.find( ' ' );
  
  while( pos != string::npos )
  {
    v_args.push_back( str_args.substr( 0, pos ) );
    if ( pos + 1 < str_args.size() )
    {
      str_args = str_args.substr( pos + 1 );
      pos = str_args.find( ' ' );
    }      
    else
    {
      str_args = "";
      pos = string::npos;
    }
  }
  
  if ( !str_args.empty() )
    v_args.push_back( str_args );
  
  if ( v_args.size() > 0 )
  {
    if ( !file.empty() )
      v_args.push_back( file );
    
    char **buff = *cmd_args = new (char*)[v_args.size() + 1];
    
    memset( buff, 0, sizeof(char*) * (v_args.size() + 1) );
    
    for ( unsigned int i = 0; i < v_args.size(); i++ )
      buff[i] = copy_str( v_args[i].c_str() );
  }
  
  return v_args.size();
}

void GTKUnixGraphGenerationWindow::make_XML_argv( char ***argv )
{
  char *text = (char *)gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  bool  is_tl_used = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( TL_checkbutton ) );
  char *model_name = (char *)gtk_entry_get_text( GTK_ENTRY( XML_entry ));
  char *converted_model_file = new char[strlen(model_name) + strlen("_converted") + 1];  
  char **buff;
  char *params = (char *)gtk_entry_get_text( GTK_ENTRY( XMLParams_entry ) );
  char **param_args = 0;
  int   n_pars = make_cmd_args( string( params ), "", &param_args );
  int   argc = 8 + n_pars;
  int   i = 0;
   
  converted_model_file[0] = 0;
  strcat(converted_model_file, model_name);
  strcat(converted_model_file, "_converted");  
  
  *argv = 0;
    
  if ( string( text ) == NUSMV_GENERATOR )
  {
    buff = *argv = new (char*)[argc];
    memset( buff, 0, sizeof(char*) * argc );
    
    buff[0] = get_full_path( MDLGEN_COMPILER_DIR, MDLGEN_GENERATOR_FILE, false );
    
    for ( i = 0; i < n_pars; i++ )
      buff[i + 1] = param_args[i];
    i++;
    
    buff[i++] = copy_str( "-n" );
    buff[i++] = copy_str( "-x" );    
    buff[i++] = copy_str( converted_model_file );    
    buff[i++] = copy_str( "-o" );
    buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( Model_entry ) ) );
    buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( XML_entry ) ) );
  }
  else
  {
    if ( is_tl_used )
      argc += 2;
    
    buff = *argv = new (char*)[argc];
    memset( buff, 0, sizeof(char*) * argc );
    
    buff[0] = get_full_path( MDLGEN_COMPILER_DIR, MDLGEN_GENERATOR_FILE, false );
    
    for ( i = 0; i < n_pars; i++ )
      buff[i + 1] = param_args[i];
    i++;
    
    buff[i++] = copy_str( "-s" );
    buff[i++] = copy_str( "-x" );    
    buff[i++] = copy_str( converted_model_file );    
    buff[i++] = copy_str( "-o" );
    buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( Model_entry ) ) );
    
    if ( is_tl_used )
    {
      buff[i++] = copy_str( "-tl" );
      buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( TL_entry ) ) );
    }
      
    buff[i] = copy_str( gtk_entry_get_text( GTK_ENTRY( XML_entry ) ) );
  }
  
  if ( param_args != 0 )
    delete[] param_args;
  
  if ( converted_model_file != 0 )
    delete[] converted_model_file;
}

void GTKUnixGraphGenerationWindow::make_Generator_argv( char ***argv, char* tmp_path )
{
  char *text = (char *)gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  bool  is_tl_used = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( TL_checkbutton ) );
  int   argc;
  char **buff;
  char *params = (char *)gtk_entry_get_text( GTK_ENTRY( GenParams_entry ) );
  char **param_args = 0;
  int   n_pars = make_cmd_args( string( params ), "", &param_args );
  int   i = 0;
  
  if ( string(text) == NUSMV_GENERATOR )
  {
    argc = 9 + n_pars;
    buff = *argv = new (char*)[argc];
    memset( buff, 0, sizeof(char*) * argc );
    
    buff[0] = get_full_path( NUSMV_GENERATOR_DIR, NUSMV_GENERATOR_FILE, false );
    
    for ( i = 0; i < n_pars; i++ )
      buff[i + 1] = param_args[i];
    i++;
    
    buff[i++] = copy_str( "-f" );
    buff[i++] = copy_str( "-r" );
    buff[i++] = copy_str( "-cp" );
    buff[i++] = copy_str( "10000" );
    buff[i++] = copy_str( "-g" );
    buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( Graph_entry ) ) );
    buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( Model_entry ) ) );
  }
  else
  {
    argc = 6 + n_pars;
    if ( is_tl_used )
      argc += 2;
    
    buff = *argv = new (char*)[argc];
    memset( buff, 0, sizeof(char*) * argc );
    
    buff[0] = get_full_path( PROMELA_GENERATOR_DIR, PROMELA_GENERATOR_FILE, false );//copy_str( PROMELA_GENERATOR_FILE );
    
    for ( i = 0; i < n_pars; i++ )
      buff[i + 1] = param_args[i];
    i++;
    
    buff[i++] = copy_str( "-G" );
    buff[i++] = copy_str( tmp_path );
    buff[i++] = copy_str( "-a" );
    if ( is_tl_used )
    {
      buff[i++] = copy_str( "-N" );
      buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( TL_entry ) ) );
    }
    
    buff[i++] = copy_str( gtk_entry_get_text( GTK_ENTRY( Model_entry ) ) );
  }
  
  if ( param_args != 0 )
    delete[] param_args;
}

void GTKUnixGraphGenerationWindow::make_Scenario_argv( char ***argv, char* tmp_path )
{
  char *scenario_output = (char *)gtk_entry_get_text( GTK_ENTRY( Graph_entry ) );
  char *model_file = (char *)gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
/*  char *converted_model_file = new char[strlen(model_file) + strlen("_converted") + 1];  */
  int   argc;
  char **buff;
  char *params = (char *)gtk_entry_get_text( GTK_ENTRY( ScenarioParam_entry ) );
  char **param_args = 0;
  int   n_pars = make_cmd_args( string( params ), "", &param_args );
  int   i = 0;
  bool  gen_graph_metrics = ((m_app->get_extra_behavior_modes() & ScenarioApp::OUTPUT_GEN_GRAPH_METRICS) == 
                             ScenarioApp::OUTPUT_GEN_GRAPH_METRICS);
  
  argc = 3 + n_pars + ((strlen(model_file) > 0)? 2: 0);
  if ( gen_graph_metrics )
    argc++;
  
  buff = *argv = new (char*)[argc];
  memset( buff, 0, sizeof(char*) * argc );
    
  buff[i++] = copy_str("./scenario");
  
  if ( gen_graph_metrics )
  {
    buff[i++] = copy_str( "-gm" );
  }
  
  if ( strlen(model_file) > 0 )
  {
    buff[i++] = copy_str( "-m" );
    buff[i++] = copy_str(model_file);
  }
    
  for ( int j = 0; j < n_pars; j++ )
    buff[i++] = param_args[j];
      
  buff[i++] = copy_str(scenario_output);
  
  if ( param_args != 0 )
    delete[] param_args;
}

void GTKUnixGraphGenerationWindow::delete_argv( char **argv )
{
  for( int i = 0; argv[i] != 0; i++ )
    if (argv[i] != 0)
      delete argv[i];
  
  delete[] argv; 
}

void GTKUnixGraphGenerationWindow::make_TL_Generator_argv( char ***argv)
{
  char *text = (char *)gtk_entry_get_text( GTK_ENTRY( TL_formula_entry ) );
  char *formula_text = new char[strlen(text) + 3];
  int   argc;
  char **buff;
  int   i = 0;
  
  memset(formula_text, 0, strlen(text) + 3);
  sprintf(formula_text, "\"%s\"", text);
  argc = 4;
    
  buff = *argv = new (char*)[argc];
  memset( buff, 0, sizeof(char*) * argc );
    
  buff[i++] = get_full_path( PROMELA_GENERATOR_DIR, PROMELA_GENERATOR_FILE, false );
  buff[i++] = copy_str( "-f" );
  buff[i++] = copy_str(formula_text);
  
  delete[] formula_text;
}

bool GTKUnixGraphGenerationWindow::file_names_are_not_empty(  )
{
  char *text;
  GraphGUI *gui = m_app->get_GUI();
  bool  compile_XML = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( XML_radiobutton ) ) || 
                      gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( XML_Gen_radiobutton ) );
  bool  gen_graph   = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Generation_radiobutton ) ) || 
                      gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( XML_Gen_radiobutton ) );
  bool  graph_load  = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Graph_load_radiobutton ) )  ;
      
  if ( compile_XML )
  {
    text = (char*)gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
    
    if ( string( text ).empty() )
    {
      // set focus, show message
      gui->show_message_dialog( "Please input XML file name." );
      gtk_widget_grab_focus (XML_entry);
      return false;
    }
  }
  
  if ( gen_graph || compile_XML )
  {
    text = (char*)gtk_entry_get_text( GTK_ENTRY( Model_entry ) );
  
    if ( string( text ).empty() )
    {
      // set focus, show message
      gui->show_message_dialog( "Please input model file name." );
      gtk_widget_grab_focus (Model_entry);
      return false;
    }
  
    text = (char*)gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  
    if ( string(text) == PROMELA_GENERATOR && 
        gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( TL_checkbutton ) ))
    {
      text = (char*)gtk_entry_get_text( GTK_ENTRY( TL_entry ) );
    
      if ( string( text ).empty() )
      {
        // set focus, show message
        gui->show_message_dialog( "Please input TL specification file name." );
        gtk_widget_grab_focus ( TL_entry );
        return false;
      }
    }
  }
  
  if ( gen_graph || graph_load )
  {
    text = (char*)gtk_entry_get_text( GTK_ENTRY( Graph_entry ) );
    
    if ( string( text ).empty() )
    {
      // set focus, show message
      gui->show_message_dialog( "Please input graph file name." );
      gtk_widget_grab_focus ( Graph_entry );
      return false;
    }
  }
  
  return true;
}

string GTKUnixGraphGenerationWindow::make_default_file_name( const string &file_name, const string &file_extension )
{
  string res = "";
  
  unsigned int pos = file_name.rfind( '.' );
  
  if ( pos == string::npos )
    res = file_name;
  else
    res = file_name.substr( 0, pos );
         
  if ( !res.empty() )
    res += "." + file_extension;
  
  return res;  
}

/*******************************************************************************/
/*******************************************************************************/

void GTKUnixGraphGenerationWindow::done_XML_changes( const string &file_name )
{
  const char *gen  = gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  string      other_name = "";
    
  if ( string( gen ) == PROMELA_GENERATOR )
  {
    other_name = make_default_file_name( file_name, "promela" );
    gtk_entry_set_text( GTK_ENTRY( Model_entry ), other_name.c_str() ); 
      
    other_name = make_default_file_name( file_name, "ltl" );
    gtk_entry_set_text( GTK_ENTRY( TL_entry ), other_name.c_str() ); 
  }
  else
  {
    other_name = make_default_file_name( file_name, "smv" );
    gtk_entry_set_text( GTK_ENTRY( Model_entry ), other_name.c_str() ); 
  }
    
  other_name = make_default_file_name( file_name, "graph" );
  gtk_entry_set_text( GTK_ENTRY( Graph_entry ), other_name.c_str() ); 
}

void GTKUnixGraphGenerationWindow::done_Model_changes( const string &file_name )
{
  const char *gen  = gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  const char *tl  = gtk_entry_get_text( GTK_ENTRY( TL_entry ) );
  string      other_name;
    
  if ( string(gen) == PROMELA_GENERATOR && string( tl ).empty() )
  {
    other_name = make_default_file_name( file_name, "ltl" );
    gtk_entry_set_text( GTK_ENTRY( TL_entry ), other_name.c_str() ); 
  }
      
  other_name = make_default_file_name( file_name, "graph" );
  gtk_entry_set_text( GTK_ENTRY( Graph_entry ), other_name.c_str() ); 
}

void GTKUnixGraphGenerationWindow::graph_load( const string &file_name, bool graph_only )
{
  GraphViewContext *gv_context = m_app->get_graph_view_context();
  GraphFileInfo info;
  gv_context->set_load_info( info );
  info.file_name = file_name;
  info.model_file = get_XML_file_name();
  
  GraphGUI* gui = m_app->get_GUI();
  gui->show_wait_dialog( "Graph loading. Please wait..." );
  gv_context->set_load_info( info, true );
  bool is_loaded = m_app->get_event_handler()->handle_open( file_name );  
  gui->hide_wait_dialog();
  
/*  if ( is_loaded && m_load_handler != 0 )
    (*m_load_handler)( );*/
  if (is_loaded)
  {
    LoadHandlerIter  iter = m_load_handler_list.begin();
    LoadHandlerIter  end_iter = m_load_handler_list.end();
    
    for (; iter != end_iter; ++iter)
      (**iter)( );
    
    if ( (m_app->get_behavior_modes() & ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD) != 0 )
      destroy( true );
    
    if ( graph_only &&
         (m_app->get_extra_behavior_modes() & ScenarioApp::OUTPUT_GEN_GRAPH_METRICS) != 0 )
    {
      Graph     *graph = gv_context->get_graph();
      GraphGUI  *gui = m_app->get_GUI();
      
      GraphStatistics    statistics;
  
      statistics.calc_nodes_edges = true;
      statistics.calc_path_depth = true;
      
      statistics.nodes_to_count["({accept = 1; | final = 1;})"] = StringLongTriple( "Accepting/final nodes" );
      statistics.nodes_to_count["{final = 0;}"] = StringLongTriple( "Non-final nodes" );
      statistics.pathes_to_count[StringPair("", "{final = 1;}")] = StringLongTriple( "DFS pathes from the initial node to a final node" );
      
      graph->get_graph_statistics( statistics );
      
      GraphInformationGUI* info_window = gui->create_graph_statistics_info_window( statistics );
      
      if ( info_window != 0 )
        info_window->show( true );
    }
  }
  
}

void GTKUnixGraphGenerationWindow::load_editor( char** cmd_args )
{
  Process*          proc;
  ProcessesVector*  proc_vec = new ProcessesVector();
  ThreadArg*        arg = new ThreadArg();
  char              orig_dir[255];
  WidgetTextOutput* txt_out = new WidgetTextOutput();
  GtkTextBuffer*    buffer; 
  list<pthread_t> *active_thread_list = (list<pthread_t> *)g_object_get_data( G_OBJECT( GraphGenerationWindow ), "active_thread_list" );
  
  
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Output_textview));
  txt_out->set_view(GTK_TEXT_VIEW(Output_textview), buffer);

  memset(arg, 0, sizeof(ThreadArg));
  proc_vec->resize(0);

  getcwd(orig_dir, 255); 

  proc = new Process(cmd_args, orig_dir, "Editor load...\n");
  proc_vec->push_back(proc);
  
  arg->enabling_control = false;//do not disable
  arg->window = this;
  arg->is_load = false;  
  arg->procs = proc_vec;
  arg->txt_out = txt_out;
  strcpy(arg->orig_dir, orig_dir);

  pthread_t t_id;
  pthread_create(&t_id, 0, RunProcesses, (void*)arg);

  active_thread_list->push_back( t_id );
      
  guint     OneSecondTimer;  
  TimerGraphLoadArgs *timer_args = new TimerGraphLoadArgs();
  memset(timer_args, 0, sizeof(TimerGraphLoadArgs));
  timer_args->thread_id = t_id;
  OneSecondTimer = gtk_timeout_add(1000, (GtkFunction)TimerCalllback, gpointer(timer_args));  
  arg->timer_id = OneSecondTimer;
}


/*******************************************************************************/
/*******************************************************************************/

void GTKUnixGraphGenerationWindow::handle_Editor_combo_entry_changed_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( Editor_combo_entry ) );
  string     editor( text );
  string     cmd_line;
  
  gtk_widget_set_sensitive( Editor_button, (editor == OTHER_EDITOR) );
  
  if ( editor == XEMACS_EDITOR )
  {
    cmd_line = "xemacs";
  }
  else if ( editor == GEDIT_EDITOR )
  {
    cmd_line = "gedit";
  }
  else if ( editor == KEDIT_EDITOR )
  {
    cmd_line = "kedit";
  }
  else //other
  {
    cmd_line = "";
  }
  
  gtk_entry_set_text( GTK_ENTRY( Editor_entry ), cmd_line.c_str() ); 
}

void GTKUnixGraphGenerationWindow::handle_Editor_button_clicked_event( )
{
  GraphGUI  *gui = m_app->get_GUI();  
  string     file_name = gui->run_fileselection_dialog ( "Select Editor", "", "" );
  
  if ( !file_name.empty() )
    gtk_entry_set_text( GTK_ENTRY( Editor_entry ), file_name.c_str() );  
  
  set_all_active( true );  
}

void GTKUnixGraphGenerationWindow::handle_XMLSelect_button_clicked_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
  GraphGUI  *gui = m_app->get_GUI();    
  string    file_name = gui->run_fileselection_dialog ( "Select XML file", ((text == 0)?"": string( text )), "*.xml" );
  
  if ( !file_name.empty() )
  {
    gtk_entry_set_text( GTK_ENTRY( XML_entry ), file_name.c_str() ); 
    done_XML_changes( file_name );
  }
}

void GTKUnixGraphGenerationWindow::handle_XMLEdit_button_clicked_event( )
{
  const char *str_args = gtk_entry_get_text( GTK_ENTRY( Editor_entry ) );
  const char *file = gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
  char      **cmd_args = 0;
  make_cmd_args( string( str_args ), string( file ), &cmd_args );
  
  load_editor( cmd_args );

  delete_argv( cmd_args );
}

void GTKUnixGraphGenerationWindow::handle_ModelSelect_button_clicked_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( Model_entry ) );
  const char *gen  = gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  GraphGUI  *gui = m_app->get_GUI();    
  string    file_name = gui->run_fileselection_dialog ( "Select model file", ((text == 0)?"": string( text )), 
                                                                          ( string(gen) == NUSMV_GENERATOR)?"*.smv": "*.promela" );

  if ( !file_name.empty() )
  {
    gtk_entry_set_text( GTK_ENTRY( Model_entry ), file_name.c_str() );
    
    done_Model_changes( file_name );
  }
}

void GTKUnixGraphGenerationWindow::handle_ModelEdit_button_clicked_event( )
{
  const char *str_args = gtk_entry_get_text( GTK_ENTRY( Editor_entry ) );
  const char *file = gtk_entry_get_text( GTK_ENTRY( Model_entry ) );
  char      **cmd_args = 0;
  make_cmd_args( string( str_args ), string( file ), &cmd_args );
  
  load_editor( cmd_args );
  
  delete_argv( cmd_args );
}

void GTKUnixGraphGenerationWindow::handle_TLEdit_button_clicked_event( )
{
  const char *str_args = gtk_entry_get_text( GTK_ENTRY( Editor_entry ) );
  const char *file = gtk_entry_get_text( GTK_ENTRY( TL_entry ) );
  char      **cmd_args = 0;
  make_cmd_args( string( str_args ), string( file ), &cmd_args );
  
  load_editor( cmd_args );  

  delete_argv( cmd_args );
}

void GTKUnixGraphGenerationWindow::handle_TLSelect_button_clicked_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( TL_entry ) );
  GraphGUI  *gui = m_app->get_GUI();   
  string    file_name = gui->run_fileselection_dialog ( "Select TL specification file", ((text == 0)?"": string( text )), "*.ltl" );
  
  if ( !file_name.empty() )
    gtk_entry_set_text( GTK_ENTRY( TL_entry ), file_name.c_str() );
}

void GTKUnixGraphGenerationWindow::handle_TLDefAdd_button_clicked_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( TL_def_entry ) );
  
  TL_def_string += string( text ) + "\n";
}

void GTKUnixGraphGenerationWindow::handle_TLGen_button_clicked_event( )
{
  GraphGUI  *gui = m_app->get_GUI();  
  char      *TL_file_name = (char *)gtk_entry_get_text( GTK_ENTRY( TL_entry ) );            
  char      **Gen_argv = 0;
  Process   *proc;
  char      orig_dir[255];
  ThreadArg *arg;  
  int       fd;

  fd = open(TL_file_name, O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR|S_IWUSR);
  
  if (fd == -1)
    gui->show_message_dialog( "Please input TL file name." );
  else
  {
    pthread_t t_id;
    ProcessesVector *proc_vec = new ProcessesVector();    
    list<pthread_t> *active_thread_list = new list<pthread_t>();  
    WidgetTextOutput  *txt_out = new WidgetTextOutput();
    GtkTextBuffer     *buffer; 
    
    buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Output_textview));
    txt_out->set_view(GTK_TEXT_VIEW(Output_textview), buffer);
 
    getcwd( orig_dir, 255 ); 
    proc_vec->resize(0);

    write( fd, TL_def_string.c_str(), TL_def_string.length() );
    close( fd );
  
          
    make_TL_Generator_argv( &Gen_argv );          
    proc = new Process(Gen_argv, orig_dir, "TL file generation...\n");
    proc->set_out_file(TL_file_name);
    proc_vec->push_back(proc);
    delete_argv(Gen_argv);
  
    arg = new ThreadArg();
    memset(arg->orig_dir, 0, sizeof(arg->orig_dir));
   
    arg->enabling_control = true;//disable
    arg->window = this;
    arg->procs = proc_vec;
    arg->txt_out = txt_out;
    arg->is_load = false;
    strcpy(arg->orig_dir, orig_dir);

    pthread_create(&t_id, 0, RunProcesses, (void*)arg);
      
    active_thread_list->push_back( t_id );

    guint     OneSecondTimer;  
    TimerGraphLoadArgs *timer_args = new TimerGraphLoadArgs();
    memset(timer_args, 0, sizeof(TimerGraphLoadArgs));
    timer_args->thread_id = t_id;
    OneSecondTimer = gtk_timeout_add(1000, (GtkFunction)TimerCalllback, gpointer(timer_args));  
    arg->timer_id = OneSecondTimer;
  } 
}

void GTKUnixGraphGenerationWindow::handle_TLDefRemove_button_clicked_event( )
{
  TL_def_string = "";       
}

void GTKUnixGraphGenerationWindow::handle_Generator_combo_entry_changed_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  const char *xml = gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
  const char *model = gtk_entry_get_text( GTK_ENTRY( Model_entry ) );
  const char *tl = gtk_entry_get_text( GTK_ENTRY( TL_entry ) );
  string      file_name;
  string      other_name;
  
  bool        promela = ( string( text ) == PROMELA_GENERATOR );
  
  if ( promela )
  {
    if ( !string( model ).empty() )
      file_name = model;
    else if ( !string( xml ).empty() )
      file_name = xml;
    
    other_name = make_default_file_name( file_name, "promela" );
    gtk_entry_set_text( GTK_ENTRY( Model_entry ), other_name.c_str() ); 
        
    if ( string( tl ).empty() )
    {  
      other_name = make_default_file_name( file_name, "ltl" );
      gtk_entry_set_text( GTK_ENTRY( TL_entry ), other_name.c_str() ); 
    }
  }
  else
  {
    if ( !string( model ).empty() )
      file_name = model;
    else if ( !string( xml ).empty() )
      file_name = xml;
    
    other_name = make_default_file_name( file_name, "smv" );
    gtk_entry_set_text( GTK_ENTRY( Model_entry ), other_name.c_str() ); 
  }
  
  set_TL_active( promela );
}

void GTKUnixGraphGenerationWindow::handle_TL_checkbutton_clicked_event( )
{
  bool TL_enabled = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(TL_checkbutton) );
  
/*  set_TL_formula_entry_active( false );  */
  set_TL_entry_active( TL_enabled);
  
/*  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Formula_checkbutton), false);  */
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(TL_checkbutton), TL_enabled);    
}

void GTKUnixGraphGenerationWindow::handle_Formula_checkbutton_clicked_event( )
{
  bool Formula_enabled = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Formula_checkbutton ) );
  
  if (Formula_enabled)
  {
    set_TL_entry_active( true);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(TL_checkbutton), true);      
  }
  
  set_TL_formula_entry_active( Formula_enabled );
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Formula_checkbutton), Formula_enabled);  
}

void GTKUnixGraphGenerationWindow::handle_GraphSelect_button_clicked_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( Graph_entry ) );
  GraphGUI  *gui = m_app->get_GUI();   
  string    file_name = gui->run_fileselection_dialog ( "Select graph file name", ((text == 0)?"": string( text )), "*.graph" );

  if ( !file_name.empty() )
    gtk_entry_set_text( GTK_ENTRY( Graph_entry ), file_name.c_str() );
}

void GTKUnixGraphGenerationWindow::handle_Run_button_clicked_event( )
{
  list<pthread_t> *active_thread_list = (list<pthread_t> *)g_object_get_data( G_OBJECT( GraphGenerationWindow ), "active_thread_list" );
  
  guint     OneSecondTimer;
  
  char      *file_name = (char*)gtk_entry_get_text( GTK_ENTRY( Graph_entry ) );
  char **XML_argv = 0;
  char **Gen_argv = 0;
  char **Scen_argv = 0;
  //Graph file name needs to be passed to scenario
  char  *scenario_output = (char *)gtk_entry_get_text( GTK_ENTRY( Graph_entry ) ); 
  
  bool   compile_XML = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( XML_radiobutton ) ) || 
                       gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( XML_Gen_radiobutton ) );
  
  bool   gen_graph   = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Generation_radiobutton ) ) || 
                       gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( XML_Gen_radiobutton ) );
  bool   gr_load     = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Graph_load_radiobutton ) ) || gen_graph;                       
  
  char *text = (char*)gtk_entry_get_text( GTK_ENTRY( Generator_combo_entry ) );
  
  WidgetTextOutput  *txt_out = new WidgetTextOutput();
  GtkTextBuffer     *buffer; 
  
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Output_textview));
  txt_out->set_view(GTK_TEXT_VIEW(Output_textview), buffer);

  if ( file_names_are_not_empty(  ) )
  {
    Process *proc;
    ProcessesVector *proc_vec = new ProcessesVector();
    char  orig_dir[255];
    char  scen_path[255];
    
    memset(scen_path, 0, sizeof(scen_path));
    getcwd(orig_dir, 255); 
    
    proc_vec->resize(0);
    
    ThreadArg *arg = new ThreadArg();
    memset(arg->orig_dir, 0, sizeof(arg->orig_dir));
    memset(arg->tmp_dir, 0, sizeof(arg->tmp_dir));
    
    if ( compile_XML )
    {
      make_XML_argv( &XML_argv );
      
      // compile XML
      proc = new Process(XML_argv, orig_dir, "Compiling XML file...\n");
      proc_vec->push_back(proc);
      
      arg->is_load = false;
      
      delete_argv( XML_argv );
    }
    
    if ( gen_graph )
    {
      // generate graph (NuSMV) or scenario sources
      //...
      if (string( text ) == PROMELA_GENERATOR)
      {
        char    src_buf[255], dest_buf[255];
    
        strcpy(scen_path, SCENARIO_DIR);
		    strcat(scen_path, "vXXXXXX");
		    mkdtemp(scen_path);
        
        if (gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( Formula_checkbutton ) ))
        {
          char *TL_file_name = (char *)gtk_entry_get_text( GTK_ENTRY( TL_entry ) );            
          int fd = open(TL_file_name, O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR|S_IWUSR);
          if (fd != -1)
          {
            write(fd, TL_def_string.c_str(), TL_def_string.length());
            close(fd);
          }
          
          make_TL_Generator_argv( &Gen_argv );          
          proc = new Process(Gen_argv, orig_dir, "TL file generation...\n");
          proc->set_out_file(TL_file_name);
          proc_vec->push_back(proc);
          delete_argv(Gen_argv);
        }

        make_Generator_argv( &Gen_argv, (char*)scen_path );        
        
        // generate scenario process       
        proc = new Process(Gen_argv, orig_dir, "Scenario files generation...\n");
        proc_vec->push_back(proc);
        
        // make scenario process      
        delete Gen_argv[0];        
        Gen_argv[0] = copy_str("make");
        delete Gen_argv[1];                
        Gen_argv[1] = 0;
        
        proc = new Process( Gen_argv, scen_path, "Scenario compiling...\n", true );
        proc_vec->push_back(proc);
        
        // scenario process
        make_Scenario_argv( &Scen_argv, (char*)scen_path );
                        
        proc = new Process(Scen_argv, scen_path, "Graph file generation...\n");
        proc_vec->push_back(proc);

        strcpy(arg->tmp_dir, scen_path);        
        arg->is_load = true;
/*        RunProcesses((void*)arg);*/

        char *orig_scen_dir = get_full_path( PROMELA_GENERATOR_DIR, "scenario/%s", true );
        
        strcat(scen_path, "/%s");

        for (int i = 0; i < scenario_files_count; i++)  
        {
          src_buf[0] = dest_buf[0] = 0;          
          sprintf(src_buf, orig_scen_dir, unch_scenario_files[i]);
          sprintf(dest_buf, scen_path, unch_scenario_files[i]);          
          
          int   fd_src, fd_dest;
          int   size;
          char  str[STR_BUF];
          
//          cout << src_buf << "\n";
          if ((fd_src = open(src_buf, O_RDONLY, 0)) == -1)
          {
            perror("open");
          }
//          cout << dest_buf << "\n";          
          if ((fd_dest = open(dest_buf, O_WRONLY|O_CREAT, S_IWUSR|S_IRUSR)) == -1)
          {
            perror("open");
          }
          
          while ((size=read(fd_src, str, STR_BUF-1)) > 0)
          {
            str[size] = 0;
            write(fd_dest, str, size);
          }
        
          close(fd_src);
          close(fd_dest);
//          link(src_buf, dest_buf);
        }
        
        delete orig_scen_dir;
        delete_argv( Gen_argv );
        delete_argv( Scen_argv );        
      }
      else if (string( text ) == NUSMV_GENERATOR)
      {
      // NuSMF model generatio
        make_Generator_argv( &Gen_argv, (char*)scen_path );                
        proc = new Process(Gen_argv, orig_dir, "Graph file generation...\n");
        proc_vec->push_back(proc);
      
        arg->is_load = true;
        
        delete_argv( Gen_argv );                      
      }
    }
    
    pthread_t t_id;
        
    if (proc_vec->size() > 0)
    {
      arg->enabling_control = true;//disable
      arg->window = this;
      arg->procs = proc_vec;
      arg->txt_out = txt_out;
      strcpy(arg->orig_dir, orig_dir);

      pthread_create(&t_id, 0, RunProcesses, (void*)arg);
      
      active_thread_list->push_back( t_id );
      
      TimerGraphLoadArgs *timer_args = new TimerGraphLoadArgs();
      timer_args->gen_window = this;
      timer_args->thread_id = t_id;
      memset(timer_args->graph_name, 0, sizeof(timer_args->graph_name));
      strcpy(timer_args->graph_name, scenario_output);

      OneSecondTimer = gtk_timeout_add(1000, (GtkFunction)TimerCalllback, gpointer(timer_args));  
     
      arg->timer_id = OneSecondTimer;
    }
    else
    {
      delete arg;
      
      if ( gr_load )
        graph_load( string(file_name), true );
    }
  }
}

void GTKUnixGraphGenerationWindow::handle_Graph_load_radiobutton_activate_event( )
{
  gtk_widget_set_sensitive( GenParams_entry, false );
  gtk_widget_set_sensitive( XMLParams_entry, false );
  gtk_widget_set_sensitive( ScenarioParam_entry, false );
}

void GTKUnixGraphGenerationWindow::handle_XML_radiobutton_activate_event( )
{
  gtk_widget_set_sensitive( GenParams_entry, false );
  gtk_widget_set_sensitive( XMLParams_entry, true );
  gtk_widget_set_sensitive( ScenarioParam_entry, false );
}

void GTKUnixGraphGenerationWindow::handle_Generation_radiobutton_activate_event( )
{
  gtk_widget_set_sensitive( GenParams_entry, true );
  gtk_widget_set_sensitive( XMLParams_entry, false );
  gtk_widget_set_sensitive( ScenarioParam_entry, true );
}


void GTKUnixGraphGenerationWindow::handle_XML_Gen_radiobutton_activate_event( )
{
  gtk_widget_set_sensitive( GenParams_entry, true );
  gtk_widget_set_sensitive( XMLParams_entry, true );
  gtk_widget_set_sensitive( ScenarioParam_entry, true );
}

void GTKUnixGraphGenerationWindow::handle_XML_entry_changed_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
  string      file_name( text );
  
  done_XML_changes( file_name );
}

void GTKUnixGraphGenerationWindow::handle_Model_entry_changed_event( )
{
  const char *text = gtk_entry_get_text( GTK_ENTRY( Model_entry ) );
  string      file_name( text );
  
  done_Model_changes( file_name );
}

void GTKUnixGraphGenerationWindow::handle_Clear_button_clicked_event( )
{
  GtkTextBuffer*    buffer; 
  
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Output_textview));
  
  gtk_text_buffer_set_text( buffer, "", -1 );
}


/*******************************************************************************/
/*******************************************************************************/

gboolean on_GraphGenerationWindow_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  bool close = gen_window->destroy( true );
  return (close? TRUE: FALSE); 
}

gboolean on_GraphGenerationWindow_destroy_event( GtkWidget *widget, GdkEvent *event, gpointer user_data )
{
  return TRUE;
}

void on_Editor_combo_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Editor_combo_entry_changed_event( );
}

void on_Editor_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Editor_button_clicked_event( );
}

void on_XMLSelect_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_XMLSelect_button_clicked_event( );
}

void on_XMLEdit_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_XMLEdit_button_clicked_event( );
}

void on_ModelSelect_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_ModelSelect_button_clicked_event( );
}

void on_ModelEdit_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_ModelEdit_button_clicked_event( );
}

void on_TLEdit_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_TLEdit_button_clicked_event( );
}

void on_TLSelect_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_TLSelect_button_clicked_event( );
}

void on_TLDefAdd_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_TLDefAdd_button_clicked_event( );    
}

void on_TLGen_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_TLGen_button_clicked_event( );
}

void on_TLDefRemove_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_TLDefRemove_button_clicked_event( );       
}

void on_Generator_combo_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Generator_combo_entry_changed_event( );
}

void on_TL_checkbutton_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_TL_checkbutton_clicked_event( );   
}

void on_Formula_checkbutton_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Formula_checkbutton_clicked_event( );  
}

void on_GraphSelect_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_GraphSelect_button_clicked_event( );
}

void on_Run_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Run_button_clicked_event( );
}

void on_Graph_load_radiobutton_activate( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Graph_load_radiobutton_activate_event( );
}

void on_XML_radiobutton_activate( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_XML_radiobutton_activate_event( );
}

void on_Generation_radiobutton_activate( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Generation_radiobutton_activate_event( );
}


void on_XML_Gen_radiobutton_activate( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_XML_Gen_radiobutton_activate_event( );
}

void on_Close_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->destroy( false );
}

void on_XML_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_XML_entry_changed_event( );
}

void on_Model_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Model_entry_changed_event( );
}

void on_Clear_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKUnixGraphGenerationWindow *gen_window = (GTKUnixGraphGenerationWindow*)user_data;
  gen_window->handle_Clear_button_clicked_event( );
}

/******************************************************************************/
/******************************************************************************/

void GTKUnixGraphGenerationWindow::create( )
{
  list<pthread_t> *active_thread_list = new list<pthread_t>();
  
  GraphGenerationWindow = MainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (GraphGenerationWindow), m_title.c_str() );
  gtk_window_set_position (GTK_WINDOW (GraphGenerationWindow), GTK_WIN_POS_CENTER);
  
  tooltips = gtk_tooltips_new ();
  
  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (main_vbox);
  gtk_container_add (GTK_CONTAINER (GraphGenerationWindow), main_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 3);

  Edit_frame = gtk_frame_new (NULL);
  gtk_widget_show (Edit_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), Edit_frame, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (Edit_frame), GTK_SHADOW_OUT);

  Editor_table = gtk_table_new (1, 3, FALSE);
  gtk_widget_show (Editor_table);
  gtk_container_add (GTK_CONTAINER (Edit_frame), Editor_table);

  Editor_entry = gtk_entry_new ();
  gtk_widget_show (Editor_entry);
  gtk_table_attach (GTK_TABLE (Editor_table), Editor_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  Editor_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (Editor_combo)->popwin),
                       "GladeParentKey", Editor_combo);
  gtk_widget_show (Editor_combo);
  gtk_table_attach (GTK_TABLE (Editor_table), Editor_combo, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (Editor_combo), TRUE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (Editor_combo), TRUE);

  Editor_combo_items = g_list_append (Editor_combo_items, (gpointer) XEMACS_EDITOR);
  Editor_combo_items = g_list_append (Editor_combo_items, (gpointer) GEDIT_EDITOR);
  Editor_combo_items = g_list_append (Editor_combo_items, (gpointer) KEDIT_EDITOR);
  Editor_combo_items = g_list_append (Editor_combo_items, (gpointer) OTHER_EDITOR);
  
  gtk_combo_set_popdown_strings (GTK_COMBO (Editor_combo), Editor_combo_items);
  g_list_free (Editor_combo_items);

  Editor_combo_entry = GTK_COMBO (Editor_combo)->entry;
  gtk_widget_show (Editor_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (Editor_combo_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (Editor_combo_entry), _("XEmacs"));
  gtk_entry_set_invisible_char (GTK_ENTRY (Editor_combo_entry), 32);
  gtk_entry_set_width_chars (GTK_ENTRY (Editor_combo_entry), 20);
  GTK_WIDGET_UNSET_FLAGS (Editor_combo_entry, GTK_CAN_FOCUS);

  Editor_button = gtk_button_new_with_mnemonic (_(" Select editor "));
  gtk_widget_show (Editor_button);
  gtk_table_attach (GTK_TABLE (Editor_table), Editor_button, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label1 = gtk_label_new (_("Editor"));
  gtk_widget_show (label1);
  gtk_frame_set_label_widget (GTK_FRAME (Edit_frame), label1);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

  XML_frame = gtk_frame_new (NULL);
  gtk_widget_show (XML_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), XML_frame, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (XML_frame), GTK_SHADOW_OUT);

  XML_table = gtk_table_new (1, 4, FALSE);
  gtk_widget_show (XML_table);
  gtk_container_add (GTK_CONTAINER (XML_frame), XML_table);

  XML_entry = gtk_entry_new ();
  gtk_widget_show (XML_entry);
  gtk_table_attach (GTK_TABLE (XML_table), XML_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (XML_entry), 32);

  label6 = gtk_label_new (_("XML file                  "));
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (XML_table), label6, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);

  XMLSelect_button = gtk_button_new_with_mnemonic (_("  Select file  "));
  gtk_widget_show (XMLSelect_button);
  gtk_table_attach (GTK_TABLE (XML_table), XMLSelect_button, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  XMLEdit_button = gtk_button_new_with_mnemonic (_("  Edit  "));
  gtk_widget_show (XMLEdit_button);
  gtk_table_attach (GTK_TABLE (XML_table), XMLEdit_button, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label2 = gtk_label_new (_("XML"));
  gtk_widget_show (label2);
  gtk_frame_set_label_widget (GTK_FRAME (XML_frame), label2);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

  Generator_frame = gtk_frame_new (NULL);
  gtk_widget_show (Generator_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), Generator_frame, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (Generator_frame), GTK_SHADOW_OUT);

  Generator_table = gtk_table_new (7, 4, FALSE);
  gtk_widget_show (Generator_table);
  gtk_container_add (GTK_CONTAINER (Generator_frame), Generator_table);

  Model_entry = gtk_entry_new ();
  gtk_widget_show (Model_entry);
  gtk_table_attach (GTK_TABLE (Generator_table), Model_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (Model_entry), 32);

  TL_entry = gtk_entry_new ();
  gtk_widget_show (TL_entry);
  gtk_table_attach (GTK_TABLE (Generator_table), TL_entry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (TL_entry), 32);

  TL_formula_entry = gtk_entry_new ();
  gtk_widget_show (TL_formula_entry);
  gtk_table_attach (GTK_TABLE (Generator_table), TL_formula_entry, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (TL_formula_entry), 32);

  TL_def_entry = gtk_entry_new ();
  gtk_widget_show (TL_def_entry);
  gtk_table_attach (GTK_TABLE (Generator_table), TL_def_entry, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (TL_def_entry), 32);
  gtk_entry_set_text (GTK_ENTRY (TL_def_entry), _("#define "));  

  label8 = gtk_label_new (_("Model file"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (Generator_table), label8, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  label9 = gtk_label_new (_("TL specification file"));
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (Generator_table), label9, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  label_TL_formula = gtk_label_new (_("TL specification formula"));
  gtk_widget_show (label_TL_formula);
  gtk_table_attach (GTK_TABLE (Generator_table), label_TL_formula, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label_TL_formula), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label_TL_formula), 0, 0.5);

  label_TL_def = gtk_label_new (_("TL variables definition"));
  gtk_widget_show (label_TL_def);
  gtk_table_attach (GTK_TABLE (Generator_table), label_TL_def, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label_TL_def), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label_TL_def), 0, 0.5);

  label7 = gtk_label_new (_("Select generator "));
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (Generator_table), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  ModelSelect_button = gtk_button_new_with_mnemonic (_("  Select file  "));
  gtk_widget_show (ModelSelect_button);
  gtk_table_attach (GTK_TABLE (Generator_table), ModelSelect_button, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  ModelEdit_button = gtk_button_new_with_mnemonic (_("  Edit  "));
  gtk_widget_show (ModelEdit_button);
  gtk_table_attach (GTK_TABLE (Generator_table), ModelEdit_button, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TLEdit_button = gtk_button_new_with_mnemonic (_("  Edit  "));
  gtk_widget_show (TLEdit_button);
  gtk_table_attach (GTK_TABLE (Generator_table), TLEdit_button, 3, 4, 3, 4,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TLSelect_button = gtk_button_new_with_mnemonic (_("  Select file  "));
  gtk_widget_show (TLSelect_button);
  gtk_table_attach (GTK_TABLE (Generator_table), TLSelect_button, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TLDefAdd_button = gtk_button_new_with_mnemonic (_("  Add  "));
  gtk_widget_show (TLDefAdd_button);
  gtk_table_attach (GTK_TABLE (Generator_table), TLDefAdd_button, 2, 3, 6, 7,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TLGen_button = gtk_button_new_with_mnemonic (_("  Generate TL file  "));
  gtk_widget_show (TLGen_button);
  gtk_table_attach (GTK_TABLE (Generator_table), TLGen_button, 2, 3, 5, 6,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TLDefRemove_button   = gtk_button_new_with_mnemonic (_("Clear all"));
  gtk_widget_show (TLDefRemove_button  );
  gtk_table_attach (GTK_TABLE (Generator_table), TLDefRemove_button, 3, 4, 6, 7,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  
  GenCombo_alignment = gtk_alignment_new (0, 0.5, 0, 1);
  gtk_widget_show (GenCombo_alignment);
  gtk_table_attach (GTK_TABLE (Generator_table), GenCombo_alignment, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  Generator_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (Generator_combo)->popwin),
                       "GladeParentKey", Generator_combo);
  gtk_widget_show (Generator_combo);
  gtk_container_add (GTK_CONTAINER (GenCombo_alignment), Generator_combo);
  gtk_combo_set_value_in_list (GTK_COMBO (Generator_combo), TRUE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (Generator_combo), TRUE);
  Generator_combo_items = g_list_append (Generator_combo_items, (gpointer) PROMELA_GENERATOR);
  Generator_combo_items = g_list_append (Generator_combo_items, (gpointer) NUSMV_GENERATOR);
  gtk_combo_set_popdown_strings (GTK_COMBO (Generator_combo), Generator_combo_items);
  g_list_free (Generator_combo_items);

  Generator_combo_entry = GTK_COMBO (Generator_combo)->entry;
  gtk_widget_show (Generator_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (Generator_combo_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (Generator_combo_entry), PROMELA_GENERATOR );
  gtk_entry_set_invisible_char (GTK_ENTRY (Generator_combo_entry), 32);
  gtk_entry_set_width_chars (GTK_ENTRY (Generator_combo_entry), 20);
  GTK_WIDGET_UNSET_FLAGS (Generator_combo_entry, GTK_CAN_FOCUS);

  TL_checkbutton = gtk_check_button_new_with_mnemonic (_("Use TL specification file"));
  gtk_widget_show (TL_checkbutton);
  gtk_table_attach (GTK_TABLE (Generator_table), TL_checkbutton, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 30, 0);

  Formula_checkbutton = gtk_check_button_new_with_mnemonic (_("Use TL formula"));
  gtk_widget_show (Formula_checkbutton);
  gtk_table_attach (GTK_TABLE (Generator_table), Formula_checkbutton, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 30, 0);

  label3 = gtk_label_new (_("Generator"));
  gtk_widget_show (label3);
  gtk_frame_set_label_widget (GTK_FRAME (Generator_frame), label3);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  Graph_frame = gtk_frame_new (NULL);
  gtk_widget_show (Graph_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), Graph_frame, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (Graph_frame), GTK_SHADOW_OUT);

  Graph_table = gtk_table_new (2, 4, FALSE);
  gtk_widget_show (Graph_table);
  gtk_container_add (GTK_CONTAINER (Graph_frame), Graph_table);

  label10 = gtk_label_new (_("Output graph file    "));
  gtk_widget_show (label10);
  gtk_table_attach (GTK_TABLE (Graph_table), label10, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label10), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);

  Graph_entry = gtk_entry_new ();
  gtk_widget_show (Graph_entry);
  gtk_table_attach (GTK_TABLE (Graph_table), Graph_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (Graph_entry), 32);

  GraphSelect_button = gtk_button_new_with_mnemonic (_("    Select file    "));
  gtk_widget_show (GraphSelect_button);
  gtk_table_attach (GTK_TABLE (Graph_table), GraphSelect_button, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  GraphEdit_button = gtk_button_new_with_mnemonic (_("  Edit  "));
  gtk_table_attach (GTK_TABLE (Graph_table), GraphEdit_button, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (GraphEdit_button, FALSE);
  

  label4 = gtk_label_new (_("Graph"));
  gtk_widget_show (label4);
  gtk_frame_set_label_widget (GTK_FRAME (Graph_frame), label4);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

  Compilation_frame = gtk_frame_new (NULL);
  gtk_widget_show (Compilation_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), Compilation_frame, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (Compilation_frame), GTK_SHADOW_OUT);

  Compilation_table = gtk_table_new (7, 4, FALSE);
  gtk_widget_show (Compilation_table);
  gtk_container_add (GTK_CONTAINER (Compilation_frame), Compilation_table);

  Output_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (Output_scrolledwindow);
  gtk_table_attach (GTK_TABLE (Compilation_table), Output_scrolledwindow, 0, 4, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 2, 1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (Output_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (Output_scrolledwindow), GTK_SHADOW_OUT);

  Output_textview = gtk_text_view_new ();
  gtk_widget_show (Output_textview);
  gtk_container_add (GTK_CONTAINER (Output_scrolledwindow), Output_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (Output_textview), FALSE);

  label13 = gtk_label_new (_("Standard output"));
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (Compilation_table), label13, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label13), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label13), 0, 0.5);

  label12 = gtk_label_new (_("Optional Graph generator arguments"));
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (Compilation_table), label12, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label12), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label12), 0, 0.5);

  label11 = gtk_label_new (_("Optional XML compiler arguments"));
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (Compilation_table), label11, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (label11), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);
  
  ScenarioParam_label = gtk_label_new (_("Optional Scenario arguments"));
  gtk_widget_show (ScenarioParam_label);
  gtk_table_attach (GTK_TABLE (Compilation_table), ScenarioParam_label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (ScenarioParam_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (ScenarioParam_label), 0, 0.5);

  Run_alignment = gtk_alignment_new (1, 0.5, 0, 1);
  gtk_widget_show (Run_alignment);
  gtk_table_attach (GTK_TABLE (Compilation_table), Run_alignment, 3, 4, 4, 5,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  Run_button = gtk_button_new_with_mnemonic (_("    Run/Load    "));
  gtk_widget_show (Run_button);
  gtk_container_add (GTK_CONTAINER (Run_alignment), Run_button);

  XMLParams_entry = gtk_entry_new ();
  gtk_widget_show (XMLParams_entry);
  gtk_table_attach (GTK_TABLE (Compilation_table), XMLParams_entry, 1, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (XMLParams_entry), 32);

  GenParams_entry = gtk_entry_new ();
  gtk_widget_show (GenParams_entry);
  gtk_table_attach (GTK_TABLE (Compilation_table), GenParams_entry, 1, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (GenParams_entry), 32);
  
  ScenarioParam_entry = gtk_entry_new ();
  gtk_widget_show (ScenarioParam_entry);
  gtk_table_attach (GTK_TABLE (Compilation_table), ScenarioParam_entry, 1, 4, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (ScenarioParam_entry), 32);

  Radio_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (Radio_hbox);
  gtk_table_attach (GTK_TABLE (Compilation_table), Radio_hbox, 0, 4, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  Graph_load_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Graph load only"));
  gtk_widget_show (Graph_load_radiobutton);
  gtk_box_pack_start (GTK_BOX (Radio_hbox), Graph_load_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (Graph_load_radiobutton), Graph_load_radiobutton_group);
  Graph_load_radiobutton_group = gtk_radio_button_group (GTK_RADIO_BUTTON (Graph_load_radiobutton));
  gtk_tooltips_set_tip( tooltips, Graph_load_radiobutton, "Activate the radio button to load the graph from graph file (compilation and generation are not involved)", NULL );

  XML_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("XML compilation only"));
  gtk_widget_show (XML_radiobutton);
  gtk_box_pack_start (GTK_BOX (Radio_hbox), XML_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (XML_radiobutton), Graph_load_radiobutton_group);
  Graph_load_radiobutton_group = gtk_radio_button_group (GTK_RADIO_BUTTON (XML_radiobutton));
  gtk_tooltips_set_tip( tooltips, XML_radiobutton, "Activate the radio button to compile the XML file into the generator model file (a graph file will not be generated and loaded)", NULL );

  Generation_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Graph generation only"));
  gtk_widget_show (Generation_radiobutton);
  gtk_box_pack_start (GTK_BOX (Radio_hbox), Generation_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (Generation_radiobutton), Graph_load_radiobutton_group);
  Graph_load_radiobutton_group = gtk_radio_button_group (GTK_RADIO_BUTTON (Generation_radiobutton));
  gtk_tooltips_set_tip( tooltips, Generation_radiobutton, "Activate the radio button to generate the graph file from the generator model file and load it (the XML file will not be compiled)", NULL );

  XML_Gen_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("XML compilation and graph generation"));
  gtk_widget_show (XML_Gen_radiobutton);
  gtk_box_pack_start (GTK_BOX (Radio_hbox), XML_Gen_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (XML_Gen_radiobutton), Graph_load_radiobutton_group);
  Graph_load_radiobutton_group = gtk_radio_button_group (GTK_RADIO_BUTTON (XML_Gen_radiobutton));
  gtk_tooltips_set_tip( tooltips, XML_Gen_radiobutton, "Activate the radio button to compile the XML file into the generator model file, generate graph file from the model file and load it", NULL );

  Clear_alignment = gtk_alignment_new (0, 0.5, 0, 1);
  gtk_widget_show (Clear_alignment);
  gtk_table_attach (GTK_TABLE (Compilation_table), Clear_alignment, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  Clear_button = gtk_button_new_with_mnemonic (_("             Clear output                "));
  gtk_widget_show (Clear_button);
  gtk_container_add (GTK_CONTAINER (Clear_alignment), Clear_button);

  label5 = gtk_label_new (_("Compilation/Generation"));
  gtk_widget_show (label5);
  gtk_frame_set_label_widget (GTK_FRAME (Compilation_frame), label5);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);

  close_button_alignment = gtk_alignment_new (1, 0.5, 0, 0);
  gtk_widget_show (close_button_alignment);
  gtk_box_pack_start (GTK_BOX (main_vbox), close_button_alignment, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (close_button_alignment), 1);

  Close_button = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_show (Close_button);
  gtk_container_add (GTK_CONTAINER (close_button_alignment), Close_button);

  gtk_signal_connect (GTK_OBJECT (GraphGenerationWindow), "delete_event",
                      GTK_SIGNAL_FUNC (on_GraphGenerationWindow_delete_event),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (GraphGenerationWindow), "destroy_event",
                      GTK_SIGNAL_FUNC (on_GraphGenerationWindow_destroy_event),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Editor_combo_entry), "changed",
                      GTK_SIGNAL_FUNC (on_Editor_combo_entry_changed),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Editor_button), "clicked",
                      GTK_SIGNAL_FUNC (on_Editor_button_clicked),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (XML_entry), "changed",
                      GTK_SIGNAL_FUNC (on_XML_entry_changed),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (XMLSelect_button), "clicked",
                      GTK_SIGNAL_FUNC (on_XMLSelect_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (XMLEdit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_XMLEdit_button_clicked),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (Model_entry), "changed",
                      GTK_SIGNAL_FUNC (on_Model_entry_changed),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (ModelSelect_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ModelSelect_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (ModelEdit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ModelEdit_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (TLEdit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_TLEdit_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (TLSelect_button), "clicked",
                      GTK_SIGNAL_FUNC (on_TLSelect_button_clicked),
                      (gpointer)this);

  gtk_signal_connect (GTK_OBJECT (TLDefAdd_button), "clicked",
                      GTK_SIGNAL_FUNC (on_TLDefAdd_button_clicked),
                      (gpointer)this);

  gtk_signal_connect (GTK_OBJECT (TLGen_button), "clicked",
                      GTK_SIGNAL_FUNC (on_TLGen_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (TLDefRemove_button), "clicked",
                      GTK_SIGNAL_FUNC (on_TLDefRemove_button_clicked),
                      (gpointer)this);

  gtk_signal_connect (GTK_OBJECT (Generator_combo_entry), "changed",
                      GTK_SIGNAL_FUNC (on_Generator_combo_entry_changed),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (TL_checkbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_TL_checkbutton_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Formula_checkbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_Formula_checkbutton_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (GraphSelect_button), "clicked",
                      GTK_SIGNAL_FUNC (on_GraphSelect_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Run_button), "clicked",
                      GTK_SIGNAL_FUNC (on_Run_button_clicked),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (Graph_load_radiobutton), "clicked",
                      GTK_SIGNAL_FUNC (on_Graph_load_radiobutton_activate),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (XML_radiobutton), "clicked",
                      GTK_SIGNAL_FUNC (on_XML_radiobutton_activate),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Generation_radiobutton), "clicked",
                      GTK_SIGNAL_FUNC (on_Generation_radiobutton_activate),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (XML_Gen_radiobutton), "clicked",
                      GTK_SIGNAL_FUNC (on_XML_Gen_radiobutton_activate),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Clear_button), "clicked",
                      GTK_SIGNAL_FUNC (on_Clear_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (Close_button), "clicked",
                      GTK_SIGNAL_FUNC (on_Close_button_clicked),
                      (gpointer)this);

  TL_def_string = "";
  g_object_set_data( G_OBJECT( GraphGenerationWindow ), "active_thread_list", (gpointer)active_thread_list );
      
  set_TL_active( true );
  
  gtk_entry_set_text( GTK_ENTRY( Editor_combo_entry ), "xemacs" );
  gtk_widget_set_sensitive( Editor_button, false );
  
  gtk_widget_grab_focus( XML_entry );
  
  gtk_widget_set_sensitive( GenParams_entry, false );
  gtk_widget_set_sensitive( XMLParams_entry, false );
  
  can_TL_enabled = true;
}

 
/*******************************************************************************/
/*******************************************************************************/

bool GTKUnixGraphGenerationWindow::destroy( bool force )
{
  bool close = true;
  GraphGUI  *gui = m_app->get_GUI();
  
  if ( GraphGenerationWindow == NULL )
    return close;
  
  if ( !GTK_WIDGET_IS_SENSITIVE(Run_button) && !force )
    close = gui->run_promt_dialog( "Closing interupt processing. Are you sure the window should be closed now?" );
  
  if ( close )
  {
    list<pthread_t> *active_thread_list = (list<pthread_t> *)g_object_get_data( G_OBJECT( GraphGenerationWindow ), "active_thread_list" );
    
    while ( !active_thread_list->empty() )
    {
      pthread_t thread_id = active_thread_list->back();
      pthread_cancel( thread_id );
      active_thread_list->pop_back();
    }
    
    active_thread_list->clear();
    
    gtk_widget_destroy( GraphGenerationWindow );
    GraphGenerationWindow = NULL;
    Generator_combo_items = NULL;
    Editor_combo_items = NULL;
    Graph_load_radiobutton_group = NULL;
    TL_def_string = "";
    
/*    if ( m_close_handler != 0 )
      (*m_close_handler)();*/
     
    CloseHandlerIter  iter = m_close_handler_list.begin();
    CloseHandlerIter  end_iter = m_close_handler_list.end();
    
    for (; iter != end_iter; ++iter)
      (**iter)( );
    
  }
  
  return close;
}

void   GTKUnixGraphGenerationWindow::show( bool show_window )
{
  if ( GraphGenerationWindow != NULL )
  {
    if ( show_window )
      gtk_widget_show( GraphGenerationWindow );
    else
      gtk_widget_hide( GraphGenerationWindow );
  }
  else if ( show_window )
  {
    create();
    gtk_widget_show( GraphGenerationWindow );
  }
}

string GTKUnixGraphGenerationWindow::get_XML_file_name()
{
  string res = "";
  
  if ( GraphGenerationWindow != NULL )
  {
    const char *text = gtk_entry_get_text( GTK_ENTRY( XML_entry ) );
    
    res = string(text);
  }
  
  return res;
}

string GTKUnixGraphGenerationWindow::get_graph_file_name()
{
  string res = "";
  
  if ( GraphGenerationWindow != NULL )
  {
    const char *text = gtk_entry_get_text( GTK_ENTRY(Graph_entry) );
    
    res = string(text);
  }
  
  return res;
}

string GTKUnixGraphGenerationWindow::get_model_file_name()
{
  string res = "";
  
  if ( GraphGenerationWindow != NULL )
  {
    const char *text = gtk_entry_get_text( GTK_ENTRY(Model_entry) );
    
    res = string(text);
  }
  
  return res;
}
