
#include "UnixCreateFilterGUI.h"

using namespace GraphGraphics;

void GTKCreateFilterGUI::create()
{
  dialog = gtk_dialog_new_with_buttons( "Create graph attribute template", NULL, GTK_DIALOG_MODAL, 
                                                             GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                                             GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL );
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

  dialog_vbox1 = GTK_DIALOG (dialog)->vbox;
  gtk_widget_show (dialog_vbox1);
  GtkWidget *table = m_search_template_creation.create();
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table, TRUE, TRUE, 0);
  
  name_hbox = gtk_hbox_new( FALSE, 1 );
  gtk_widget_show( name_hbox );
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), name_hbox, TRUE, TRUE, 0);
  
  name_label = gtk_label_new_with_mnemonic( "Filter name: " );
  gtk_widget_show( name_label );
  gtk_box_pack_start( GTK_BOX (name_hbox), name_label, FALSE, FALSE, 0 );
  gtk_label_set_justify( GTK_LABEL (name_label), GTK_JUSTIFY_LEFT );
    
  name_entry = gtk_entry_new();
  gtk_widget_show (name_entry);
  gtk_box_pack_start( GTK_BOX (name_hbox), name_entry, TRUE, TRUE, 0 );
  gtk_entry_set_text( GTK_ENTRY(name_entry), m_filter_name.c_str() );
}

int GTKCreateFilterGUI::run()
{
  create();
  
  gint result = gtk_dialog_run( GTK_DIALOG(dialog) );
  
  m_filter_name = string( gtk_entry_get_text( GTK_ENTRY( name_entry ) ) );
  
  gtk_widget_destroy( dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
