
#include "UnixAttrFilterGUI.h"
#include "UnixCreateFilterGUI.h"

using namespace GraphGraphics;

void GTKAttrFilterGUI::handle_add_button_clicked_event( )
{
  string filter_name = gtk_entry_get_text( GTK_ENTRY(filter_combo_entry) );
  string attr_filter = m_filters->get_template( filter_name );
  GTKCreateFilterGUI filter_creation(m_name_storage);
  
  filter_creation.set_attr_template( m_attr_template );
  filter_creation.set_filter_template( attr_filter );
  filter_creation.set_filter_name( filter_name );

  int res = filter_creation.run( );
    
  if ( res == GraphGUIModalWindow::APPLIED )
  {
    filter_combo_items = NULL;
    
    attr_filter = filter_creation.get_filter_template();
    filter_name = filter_creation.get_filter_name();
    
    m_filters->set_template( filter_name, attr_filter );
    
    for ( string name = m_filters->get_first_template_name(); name != AttrStringTemplateStorage::INVALID_TEMPLATE_NAME; 
               name =  m_filters->get_next_template_name( name) )
    {
      filter_combo_items = g_list_append (filter_combo_items, (gpointer)name.c_str() );
    }
    
    if ( filter_combo_items == NULL )
      filter_combo_items = g_list_append (filter_combo_items, (gpointer)"" );
    
    gtk_combo_set_popdown_strings (GTK_COMBO (filter_combo), filter_combo_items);
    g_list_free (filter_combo_items);
    filter_combo_items = NULL;
  
    gtk_entry_set_text( GTK_ENTRY(filter_combo_entry), filter_name.c_str() );
    m_tree_view.set_attribute_string( attr_filter );
    gtk_entry_set_text( GTK_ENTRY(filter_entry), attr_filter.c_str() );
  }
}

void GTKAttrFilterGUI::handle_del_button_clicked_event( )
{
  string     filter_name = gtk_entry_get_text( GTK_ENTRY(filter_combo_entry) );
  
  filter_combo_items = NULL;  
  m_filters->remove_template( filter_name );
  filter_name = m_filters->get_current_template_name();
  
  for ( string name = m_filters->get_first_template_name(); name != AttrStringTemplateStorage::INVALID_TEMPLATE_NAME; 
               name = m_filters->get_next_template_name( name) )
  {
    filter_combo_items = g_list_append (filter_combo_items, (gpointer)name.c_str() );
  }
  
  if ( filter_combo_items == NULL )
    filter_combo_items = g_list_append (filter_combo_items, (gpointer)"" );
  
  gtk_combo_set_popdown_strings (GTK_COMBO (filter_combo), filter_combo_items);
  g_list_free (filter_combo_items);
  
  gtk_entry_set_text( GTK_ENTRY(filter_combo_entry), filter_name.c_str() );
  
  string filter = m_filters->get_template( filter_name );
  
  m_tree_view.set_attribute_string( filter );
  gtk_entry_set_text( GTK_ENTRY(filter_entry), filter.c_str() ); 
}

void GTKAttrFilterGUI::handle_filter_combo_entry_changed_event( )
{
  string filter_name = gtk_entry_get_text( GTK_ENTRY(filter_combo_entry) );
  string filter = m_filters->get_template( filter_name );
  
  m_tree_view.set_attribute_string( filter );
  gtk_entry_set_text( GTK_ENTRY(filter_entry), filter.c_str() );  
}

/******************************************************************************/
/******************************************************************************/

static void on_add_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttrFilterGUI *dialog = (GTKAttrFilterGUI *)user_data;
  dialog->handle_add_button_clicked_event();
}


static void on_del_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttrFilterGUI *dialog = (GTKAttrFilterGUI *)user_data;
  dialog->handle_del_button_clicked_event();
}

static void on_filter_combo_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKAttrFilterGUI *dialog = (GTKAttrFilterGUI *)user_data;
  dialog->handle_filter_combo_entry_changed_event();
}

void GTKAttrFilterGUI::create()
{
  string curr_filter_name = m_filters->get_current_template_name();
  m_tree_view.set_attribute_string( m_filters->get_template( curr_filter_name ) );
  
  filter_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (filter_dialog), "Node attributes filters...");
  gtk_window_set_position (GTK_WINDOW (filter_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (filter_dialog), TRUE);

  dialog_vbox2 = GTK_DIALOG (filter_dialog)->vbox;
  gtk_widget_show (dialog_vbox2);

  main_table = gtk_table_new (3, 4, FALSE);
  gtk_widget_show (main_table);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), main_table, TRUE, TRUE, 0);

  filter_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (filter_combo)->popwin),
                       "GladeParentKey", filter_combo);
  gtk_widget_show (filter_combo);
  gtk_table_attach (GTK_TABLE (main_table), filter_combo, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (filter_combo), TRUE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (filter_combo), TRUE);
  
  for ( string name = m_filters->get_first_template_name(); name != AttrStringTemplateStorage::INVALID_TEMPLATE_NAME; 
               name = m_filters->get_next_template_name( name) )
  {
    filter_combo_items = g_list_append (filter_combo_items, (gpointer)name.c_str() );
  }
  
  gtk_combo_set_popdown_strings (GTK_COMBO (filter_combo), filter_combo_items);
  g_list_free (filter_combo_items);

  filter_combo_entry = GTK_COMBO (filter_combo)->entry;
  gtk_widget_show (filter_combo_entry);
  GTK_WIDGET_UNSET_FLAGS (filter_combo_entry, GTK_CAN_FOCUS);
  gtk_entry_set_editable (GTK_ENTRY (filter_combo_entry), FALSE);

  add_button = gtk_button_new_with_mnemonic ("Add/Change");
  gtk_widget_show (add_button);
  gtk_table_attach (GTK_TABLE (main_table), add_button, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  del_button = gtk_button_new_with_mnemonic ("Remove");
  gtk_widget_show (del_button);
  gtk_table_attach (GTK_TABLE (main_table), del_button, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  filter_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (filter_scrolledwindow);
  gtk_table_attach (GTK_TABLE (main_table), filter_scrolledwindow, 0, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (filter_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (filter_scrolledwindow), GTK_SHADOW_IN);

  filter_treeview = m_tree_view.get_widget();
  gtk_widget_show (filter_treeview);
  gtk_container_add (GTK_CONTAINER (filter_scrolledwindow), filter_treeview);

  filter_entry = gtk_entry_new ();
  gtk_widget_show (filter_entry);
  gtk_table_attach (GTK_TABLE (main_table), filter_entry, 0, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (filter_entry), FALSE);

  filter_label = gtk_label_new (" Select filter: ");
  gtk_widget_show (filter_label);
  gtk_table_attach (GTK_TABLE (main_table), filter_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (filter_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (filter_label), 0, 0.5);

  dialog_action_area2 = GTK_DIALOG (filter_dialog)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (filter_dialog), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (filter_dialog), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  
  gtk_signal_connect ( GTK_OBJECT (filter_combo_entry), "changed",
                      GTK_SIGNAL_FUNC (on_filter_combo_entry_changed),
                      (gpointer)this );
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (del_button), "clicked",
                      GTK_SIGNAL_FUNC (on_del_button_clicked),
                      (gpointer)this);
}

int GTKAttrFilterGUI::run()
{
  create();
  
  gint result = gtk_dialog_run( GTK_DIALOG(filter_dialog) );
  
  if ( result == GTK_RESPONSE_OK )
  {
    string res_filter = gtk_entry_get_text( GTK_ENTRY(filter_combo_entry) );
    
    if ( res_filter != AttrStringTemplateStorage::INVALID_TEMPLATE_NAME )
      m_filters->set_current_template_name( res_filter );
  }
  
  gtk_widget_destroy( filter_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
  
