#include <iostream>
#include <unistd.h>
#include <pthread.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h> 
#include "NewProcessesSupport.h"
/*#include "../interface.h"*/
#include "UnixGenerateGUI.h"

typedef struct dirent Dirent;
  
extern pthread_mutex_t graph_load_mutex;

bool              is_load;
pthread_t         curr_thr;

void KillProgram(void* arg)
{
  int p_id = *((int*)arg);
  
  kill(p_id, SIGTERM);
}

bool RunOneProcess(void *params, int proc_ind)
{
  int	    std_out[2];
	int     ret;
  char    str[STR_BUF];
  int     size;
  int     program_pid;
  int     program_output;
  char**  argv;
  TextOutput  *txt_out = ((ThreadArg*)params)->txt_out;
  ProcessesVector *procs = ((ThreadArg*)params)->procs;  
  char        *orig_dir = ((ThreadArg*)params)->orig_dir;
  char    *mess;
  char    comm_line[4096];
  char   *comm_line_ref = 0;
  int     i;
    
  memset( comm_line, 0, sizeof(comm_line) );  
  
  Process *p;
  int     status;
  bool    prog_ret = true;
  char    *out_file_name;

  ret = pipe(std_out);
    
    p = (*procs)[proc_ind];
    
  if ((mess = p->get_intr_message()) != 0)
  {
    txt_out->insert(mess);
  } 
  
  chdir(p->get_path());
    
  argv = p->get_argv();
  out_file_name = p->get_out_file();
  
  for ( i = 0, comm_line_ref = &(comm_line[1]); i < p->get_argc(); i++ )
  {
    sprintf( comm_line_ref, "%s ", argv[i] );
    comm_line_ref += strlen(argv[i]) + 1;
  }
  comm_line[0] = '\n';
  comm_line[ strlen(comm_line) ] = '\n';
  comm_line[ strlen(comm_line) ] = '\n';
  
  txt_out->insert( &(comm_line[0]) );
    
  program_pid = vfork();
  
  if ( p->get_run_timer() )
    p->set_timer();
  
    if (program_pid == 0)
	  { /* child */
      char  file_name[255];
      
	    close(std_out[0]);

      if (out_file_name != 0)
      {
        int fd = open(out_file_name, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR|S_IWUSR);
        if (fd != -1)
        {
          dup2(fd, 1);
          close(fd);
        }
      }
      else
      {
		    dup2(std_out[1], 1);
  		  close(std_out[1]);
      }
      
      memset(file_name, 0, sizeof(file_name));
      sprintf(file_name, "/tmp/grapherr%i", getpid());
      
      FILE  *fd = freopen(file_name, "w", stderr);
      
      execvp((char*)argv[0], (char**)argv);

      perror((char*)argv[0]);
      
      exit(errno);
	  }
	  else
	  { /*parent*/
      char  file_name[255];      
      
      chdir(orig_dir);      
      
	    close(std_out[1]);
		  program_output = std_out[0];
      
      pthread_cleanup_push(KillProgram, (void*)&program_pid);
    
      while ((size=read(program_output, str, STR_BUF-1)) > 0)
      {
        str[size] = 0;
        txt_out->insert(str);
      }
      
      if (waitpid(program_pid,&status,0)==program_pid && (WIFEXITED(status) != 0) && (WEXITSTATUS(status) != 0))
        prog_ret = false;
      
      pthread_cleanup_pop(0);
      
      memset(file_name, 0, sizeof(file_name));
      sprintf(file_name, "/tmp/grapherr%i", program_pid);
      
      int fd;
      
      if ((fd = open(file_name, O_RDONLY, 0)) > 0)
      {
        while ((size=read(fd, str, STR_BUF-1)) > 0)
        {
          str[size] = 0;
          txt_out->insert(str);
        }
        
        close(fd);
        unlink(file_name);
      }
      else
        perror((char*)argv[0]);
      
      if ( p->get_run_timer() )
      {
        string time  = p->get_time();
        txt_out->insert( "\nPerformance time: " );
        txt_out->insert( time.c_str() );
        txt_out->insert( "\n\n" );
      }


      if (prog_ret)
        txt_out->insert("Done\n\n");
      else
        txt_out->insert("Error\n\n");
	  }	  
    
  return prog_ret;
}

void* RunProcesses(void *params)
{
  ProcessesVector *procs = ((ThreadArg*)params)->procs;  
  char            *tmp_dir = ((ThreadArg*)params)->tmp_dir;  
  //TextOutput      *txt_out = ((ThreadArg*)params)->txt_out;
  Process         *p;
  bool            program_ret = 0;
  GTKUnixGraphGenerationWindow *window = ((ThreadArg*)params)->window;
  list<pthread_t> *active_thread_list = (list<pthread_t> *)g_object_get_data( G_OBJECT( window->get_widget() ), "active_thread_list" );
  uint proc_ind;
  
  is_load = false;
  
  
  if ( ((ThreadArg*)params)->enabling_control && window != 0 )
    window->set_run_active( false );
      
  for (proc_ind = 0; proc_ind < procs->size(); proc_ind++)
  {
    program_ret = RunOneProcess(params, proc_ind);  
  
    p = (*procs)[proc_ind];
    delete p;
    
    if (!program_ret)
      break;
  }
  
  procs->clear();
  procs->resize(0);

  
  if (((ThreadArg*)params)->is_load && program_ret)
  {
      pthread_mutex_lock(&graph_load_mutex);
    
      is_load = true;
      curr_thr = pthread_self();
    
      while (is_load);
      
      pthread_mutex_unlock(&graph_load_mutex);
    
  }
  
  
  if (strlen(tmp_dir) > 0)
  {
    Dirent  *fd;
    DIR     *d;
    char    file_name[1024];  
  
    d = opendir(tmp_dir);  
    if (d != 0)
    {
      while ((fd = readdir(d)) != 0)
      {
        memset(file_name, 0, sizeof(file_name));
        strcat(file_name, tmp_dir);
        strcat(file_name, "/");
        strcat(file_name, fd->d_name);
        unlink(file_name);
      }
      closedir(d);
    
      rmdir(tmp_dir);
    }
  }
  
  if ( ((ThreadArg*)params)->enabling_control && window != 0 )
    window->set_run_active( true );
  
  gtk_timeout_remove(((ThreadArg*)params)->timer_id);
  
  delete (ThreadArg*)params;
  
  
  active_thread_list->remove( pthread_self() );
  
  return NULL;
}
