
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <set>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "GTKInformationWindow.h"

/*extern GtkWidget*  lookup_widget(GtkWidget       *widget, const gchar     *widget_name);*/

#define _(String) (String)

enum InfoTreeColumnes
{
  NAME_COLUMN = 0,
  VALUE_COLUMN,
  ITEM_COLUMN
};

using namespace std;

using namespace GraphGraphics;

static void on_close_dialog( GtkWidget *dialog );
static void on_dock_menu_activate(GtkMenuItem *menuitem, gpointer user_data );
static gboolean on_info_treeview_button_release_event( GtkWidget *widget, GdkEventButton  *event, gpointer user_data );

void GTKInformationGUI::walk_info_tree( InfoStorageLevel *level, GtkTreeIter *parent_iter)
{
  GtkTreeIter       iter;
   
  gtk_tree_store_append( info_store, &iter, parent_iter );

  if (!level->is_sub_level())
  {
    InfoStorageItemLevel* item_level = (InfoStorageItemLevel*)level;
    
    InfoValueList* values = item_level->get_values();
    InfoValueListIter i = values->begin();
    InfoValueListIter end_i = values->end();    
    
    if (i != end_i)
    {
      gtk_tree_store_set( info_store, &iter, NAME_COLUMN, item_level->get_name().c_str(), VALUE_COLUMN, (*i)->get_name().c_str(), ITEM_COLUMN, (gpointer)(*i), -1 );
    }
    else
    {
      gtk_tree_store_set( info_store, &iter, NAME_COLUMN, item_level->get_name().c_str(), VALUE_COLUMN, "", ITEM_COLUMN, (gpointer)(NULL), -1 );      
    }
    
    for (++i; i != end_i; ++i)
    {
      GtkTreeIter       sub_iter;      
      
      gtk_tree_store_append( info_store, &sub_iter, &iter );      
      gtk_tree_store_set( info_store, &sub_iter, NAME_COLUMN, "", VALUE_COLUMN, (*i)->get_name().c_str(), ITEM_COLUMN, (gpointer)(*i), -1 );
    }
  }  
  else
  {
    InfoStorageSubLevel* sub_level = (InfoStorageSubLevel*)level;    
    int level_count = sub_level->get_level_count();
    
    gtk_tree_store_set( info_store, &iter, NAME_COLUMN, sub_level->get_name().c_str(), VALUE_COLUMN, "", ITEM_COLUMN, 0, -1 );
    
    for (int i = 0; i < level_count; ++i)
    {
      walk_info_tree(sub_level->get_sublevel(i), &iter);
    }
  }
      
};

void tree_sell_data_func( GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *model, GtkTreeIter *iter, gpointer data )
{
  InfoValue *value;      
  GdkColor color;
//  int c;
  
  gtk_tree_model_get( model, iter, ITEM_COLUMN, &value, -1 );
  
  if ( value != 0 )
  {
    color.red = (int)value->get_color().get_RGB().red << 8;
/*    if ( c == 65536 ) color.red = --c;
    else color.red = c;*/
      
    color.green  = (int)value->get_color().get_RGB().green << 8;
/*    if ( c == 65536 ) color.green = --c;
    else color.red = c;      */
      
    color.blue = (int)value->get_color().get_RGB().blue << 8;
/*    if ( c == 65536 ) color.blue = --c;
    else color.blue = c;*/
      
    if (value->get_font_style() == Font::UNDERLINED)
      g_object_set( G_OBJECT(cell), "underline", 1, NULL );
    else
      g_object_set( G_OBJECT(cell), "underline", 0, NULL );
  }
  else 
  {
    color.red = 0;
    color.green  = 0;
    color.blue = 0;
    g_object_set( G_OBJECT(cell), "underline", 0, NULL );
  }
  
  g_object_set( G_OBJECT(cell), "foreground_gdk", &color, NULL );
};

void GTKInformationGUI::set_network_info( )
{
  InfoStorageSubLevel *root_level = get_root_level();  
  
  for (int i = 0; i < root_level->get_level_count(); ++i)
    walk_info_tree(root_level->get_sublevel(i), NULL);
}

void GTKInformationGUI::create()
{
  info_store = gtk_tree_store_new( 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER );
    
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  info_treeview = gtk_tree_view_new_with_model( GTK_TREE_MODEL(info_store) );
  gtk_widget_show (info_treeview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), info_treeview);
  gtk_container_set_border_width (GTK_CONTAINER (info_treeview), 2);
  gtk_widget_set_size_request( info_treeview, 350, 400 );
    
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Names", render, "text", NAME_COLUMN, NULL );
  gtk_tree_view_append_column( GTK_TREE_VIEW( info_treeview ), column );
  gtk_tree_view_set_expander_column( GTK_TREE_VIEW( info_treeview ), column );
  
  render2 = gtk_cell_renderer_text_new( );
  column2 = gtk_tree_view_column_new_with_attributes( "Values", render2, "text", VALUE_COLUMN, NULL );
  gtk_tree_view_append_column( GTK_TREE_VIEW( info_treeview ), column2 );
  gtk_tree_view_column_set_cell_data_func( column2, render2, (GtkTreeCellDataFunc)tree_sell_data_func, NULL, NULL);
    
  gtk_tree_view_set_headers_clickable( GTK_TREE_VIEW( info_treeview ), FALSE );
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (info_treeview), TRUE);

  gtk_signal_connect( GTK_OBJECT (info_treeview), "button_release_event",
                      GTK_SIGNAL_FUNC (on_info_treeview_button_release_event),
                      (gpointer)this );
                      
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( info_treeview ) );
  
  
  gtk_tree_selection_set_mode( selection, GTK_SELECTION_NONE );
  
  gtk_tree_store_clear( info_store );
  set_network_info( );
    
  //expand top level nodes
  gint n = gtk_tree_model_iter_n_children( GTK_TREE_MODEL(info_store), NULL );
  GtkTreePath *path = gtk_tree_path_new_from_string("0");
      
  for ( gint i = 0; i < n; i++ )
  {
    gtk_tree_view_expand_row( GTK_TREE_VIEW( info_treeview ), path, FALSE);
    gtk_tree_path_next( path );
  }
}

void GTKInformationGUI::handle_destroy_event( )
{
  if ( information_window != 0 || scrolledwindow != 0 )
  {
    CloseHandlerIter  iter = m_close_handler_list.begin();
    
    for (; iter != m_close_handler_list.end(); ++iter)
      (**iter)( );
    
    information_window = 0;
    scrolledwindow = 0;
  }
}

void GTKInformationGUI::show(bool show_window)
{
  if ( !m_docked )
  {
    if ( information_window != NULL )
    {
      if ( show_window )
        gtk_widget_show( information_window );
      else
        gtk_widget_hide( information_window );
    }
    else if ( show_window )
    {
      create();
      information_window = gtk_dialog_new( );
      gtk_window_set_title (GTK_WINDOW (information_window), _("Information Window"));
      g_signal_connect_swapped( GTK_OBJECT(information_window), "response", G_CALLBACK(on_close_dialog), GTK_OBJECT(information_window) );
      dialog_vbox1 = GTK_DIALOG (information_window)->vbox;
      gtk_widget_show (dialog_vbox1);
      
      gtk_box_pack_start (GTK_BOX (dialog_vbox1), scrolledwindow, TRUE, TRUE, 0);
      
      dialog_action_area1 = GTK_DIALOG (information_window)->action_area;
      gtk_widget_show (dialog_action_area1);
      gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
    
      closebutton1 = gtk_button_new_from_stock ("gtk-close");
      gtk_widget_show (closebutton1);
      gtk_dialog_add_action_widget (GTK_DIALOG (information_window), closebutton1, GTK_RESPONSE_CLOSE);
      GTK_WIDGET_SET_FLAGS (closebutton1, GTK_CAN_DEFAULT);
      
      g_object_set_data( G_OBJECT(information_window), "info object", (gpointer)this );
      gtk_widget_show( information_window );
    }
  }
}

void GTKInformationGUI::handle_dock_menu_event( bool docked )
{
  list<GUIDockMenuHandler*>::iterator  iter = m_dock_menu_handler_list.begin();
        
  for (; iter != m_dock_menu_handler_list.end(); ++iter)
    (**iter)( docked );
}

static void on_dock_menu_activate(GtkMenuItem *menuitem, gpointer user_data )
{
  GTKInformationGUI *dialog = (GTKInformationGUI *)user_data;
  dialog->handle_dock_menu_event( (bool)( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ));
}
  
static gboolean on_info_treeview_button_release_event( GtkWidget *widget, GdkEventButton  *event, gpointer user_data )
{
  GTKInformationGUI *dialog = (GTKInformationGUI *)user_data;
  
  if ( event->button == 1 )
  {
    GtkTreeModel   *model = gtk_tree_view_get_model( GTK_TREE_VIEW( widget ) );
    GtkTreeIter    sel_iter;
    char          *value = 0;
  //  int            is_cve = 0;
    GtkTreePath    *path = NULL;
    GtkTreeViewColumn *column = NULL;
    gint cell_x;
    gint cell_y;
    gint x_offset;
    gint y_offset;
    gint width;
    gint height;
    InfoValue *val;    
    
    if ( gtk_tree_view_get_path_at_pos( GTK_TREE_VIEW( widget ),(int)(event->x), (int)(event->y),
                                             &path, &column, &cell_x, &cell_y) )
    {
      if ( strcmp(gtk_tree_view_column_get_title( column ), "Values") == 0 && 
           gtk_tree_model_get_iter( model, &sel_iter, path ) )
      {
        gtk_tree_model_get( model, &sel_iter, VALUE_COLUMN, &value, ITEM_COLUMN, &val, -1 );
        
        if (val != 0)
        {
          gtk_tree_view_column_cell_get_size( column, NULL, &x_offset, &y_offset, &width, &height);
          
          if ( cell_x <= width && cell_y <= height )
          {
            ClickHandler *handler = (val)->get_click_handler(); 
          
            if (handler != 0)
              (*handler)( *val );
          }
        }
      }
    }
      
    if ( path != NULL )
      gtk_tree_path_free( path ); 
  }
  else if ( event->button == 3 && dialog->is_dock_handler_registered() )
  {
    GtkWidget *dock_menu;
    GtkWidget *popup_menu = gtk_menu_new ();
    gtk_widget_show (popup_menu);
    
    dock_menu = gtk_check_menu_item_new_with_mnemonic( "Docked" );
    gtk_widget_show (dock_menu);
    gtk_container_add (GTK_CONTAINER (popup_menu), dock_menu);
    gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(dock_menu), dialog->is_docked() );
    
    gtk_signal_connect( GTK_OBJECT (dock_menu), "activate",
                          GTK_SIGNAL_FUNC (on_dock_menu_activate),
                          (gpointer)dialog);
    
    gtk_menu_popup (GTK_MENU (popup_menu), NULL, NULL, NULL, NULL,
                      0, event->time);
  }
  
  return FALSE;
}

static void on_close_dialog( GtkWidget *dialog )
{
  GTKInformationGUI *info_object = (GTKInformationGUI*)g_object_get_data( G_OBJECT(dialog), "info object" );  
  info_object->handle_destroy_event( );
  
  delete info_object;
    
  gtk_widget_destroy( dialog );
}

string GTKInformationGUI::get_label()
{
  string res = "Info";
  
  switch( m_type )
  {
  case GraphGUI::DOCKABLE_PATH_INFO:
    res = "Path Info";
    break;
  
  case GraphGUI::DOCKABLE_EDGE_INFO:
    res = "Edge Info";
    break;
  default:;
  }
    
  return res;
}

void GTKInformationGUI::make_docked( bool docked )
{
  if ( !m_docked && docked )
  {
    if ( information_window != 0 )
    {
      gtk_widget_destroy( information_window );
      information_window = 0;  
      scrolledwindow = 0;
    }
    create();
  }  
  else if ( m_docked && !docked )
  {
    //Need to be destroyed outside
//    if ( GTK_IS_WIDGET(scrolledwindow) )
//      gtk_widget_destroy(scrolledwindow);
    scrolledwindow = 0;
  }
  
  m_docked = docked;
}

void* GTKInformationGUI::get_dockable()
{
  void * res = 0;
  
  if ( m_docked )
    res = scrolledwindow;
  
  return res;
}

void GTKInformationGUI::set_root_level( InfoStorageSubLevel *level )
{
  InfoStorage::set_root_level( level );
  if ( (information_window != 0 || scrolledwindow != 0) && info_store != 0)
  {
    gtk_tree_store_clear( info_store );
    set_network_info( );
        
    gint n = gtk_tree_model_iter_n_children( GTK_TREE_MODEL(info_store), NULL );
    GtkTreePath *path = gtk_tree_path_new_from_string("0");
          
    for ( gint i = 0; i < n; i++ )
    {
      gtk_tree_view_expand_row( GTK_TREE_VIEW( info_treeview ), path, FALSE);
      gtk_tree_path_next( path );
    }
  }
}
