
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "net_callbacks.h"
#include "net_interface.h"
#include "support.h"


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_object_set_data_full (GTK_OBJECT (component), name, \
    gtk_widget_ref (widget), (GtkDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  gtk_object_set_data (GTK_OBJECT (component), name, widget)
  

class NetWindowFileLoadHandler: public GUIGraphLoadHandler
{
private:
  GtkWidget *m_main_window;
  ScenarioApp *m_app;
  NetworkComp *m_net_comp;
  
  
public:
  NetWindowFileLoadHandler( GtkWidget *main_window, NetworkComp *net_comp, ScenarioApp *app )
  {
    m_main_window = main_window;    
    m_net_comp = net_comp;
    m_app = app;
  }
  ~NetWindowFileLoadHandler() {}
    
  void operator () ( )
  {
    GtkWidget *net_window = (GtkWidget *)g_object_get_data( G_OBJECT(m_main_window), "net_window" );
    GtkWidget *drawing_area;
    GdkRectangle invalidate_rect;
               
    if ( net_window == NULL && m_net_comp->is_component_active() )
    {
      NetDrawingData *net_draw_data = new NetDrawingData();
      net_draw_data->net_comp = m_net_comp;
      
      net_window = create_net_window ( net_draw_data, m_app, m_main_window );
      gtk_widget_show (net_window);
      m_net_comp->set_graphic_area( m_app->get_GUI()->get_graphic_area( net_draw_data->drawing_area ) );
    }
    
    
    if ( net_window != NULL )
    {
      GraphViewContext *net_context = m_net_comp->get_network_context();
      GraphView *view;
      //GraphicArea *g = m_net_comp->get_graphic_area();
      
      drawing_area = lookup_widget( net_window, "drawingarea" );
    
      view = net_context->get_view();
      
      //if ( view->get_layout() == GraphView::ARBITRARY_SIZE && g != 0 )
      //  view->zoom_to_label_view( g );
      
      update_scrollbars( drawing_area, view);    
    
      invalidate_rect.x = 0;
      invalidate_rect.y = 0;
      gdk_window_get_size( drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
      gdk_window_invalidate_rect( drawing_area->window, &invalidate_rect, TRUE );
      gdk_window_process_updates( drawing_area->window, TRUE );
    }
  }
};

GtkWidget* create_net_window ( NetDrawingData *net_draw_data, ScenarioApp *graph_app, GtkWidget *parent )
{
//	GraphView				 *view = 0;
//	GraphGUI         *gui = 0;
  
  GtkWidget *vscrollbar1;
  GtkWidget *hscrollbar1;
  GtkWidget *net_window;
  GtkWidget *table1;
  GtkWidget *menubar1;
  GtkWidget *separatormenuitem2;
  GtkWidget *view_mnu;
  GtkWidget *view_mnu_menu;
  GtkWidget *zoom_in_mnu;
  GtkWidget *zoom_out_mnu;
  GtkWidget *layout_mnu;
  GtkWidget *centering_mnu;
  GtkWidget *groups_mnu;
  GtkWidget *properties_mnu;
  GtkWidget *preferences_mnu;
  GtkWidget *drawingarea;
  GtkAccelGroup *accel_group;
  GtkWidget *fit_menu;
  GtkWidget *fit_to_width_mnu;
  GtkWidget *fit_to_height_mnu;
  GtkWidget *fit_to_window_mnu;
  GtkWidget *fit_selected_to_window_mnu;
  GtkWidget *arbitrary_size_mnu;
  
  gdouble   *last_vvalue = new gdouble;
  gdouble   *last_hvalue = new gdouble;
  string     title = "Network";
  NetworkComp *net_comp;
  //GraphicArea *g;  
  GraphGenerationGUI *gen_window;  
  
  if (net_draw_data == 0)
    net_draw_data = new NetDrawingData();
    
  if ( parent != 0 )
    title += " [" + string( gtk_window_get_title( GTK_WINDOW( parent ) ) ) + "]";
  
  *last_vvalue = 0.0;
  *last_hvalue = 0.0;
  
  accel_group = gtk_accel_group_new ();

  net_window = gtk_window_new ( GTK_WINDOW_TOPLEVEL );
    
  gtk_window_set_title ( GTK_WINDOW (net_window), title.c_str() );
  gtk_window_set_default_size (GTK_WINDOW (net_window), 500, 500);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (net_window), TRUE);
	
/***************************************************	
	<AR>
****************************************************/
  GtkWidget *parent_drawing_area = lookup_widget( parent, "drawingarea" );
  
  if ( parent_drawing_area == NULL )
    parent_drawing_area = parent;
  
	net_comp = net_draw_data->net_comp;
  net_draw_data->parent_drawing_area = parent_drawing_area;
/**************************************************/

  table1 = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (net_window), table1);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_show (menubar1);
  gtk_table_attach (GTK_TABLE (table1), menubar1, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  view_mnu = gtk_menu_item_new_with_mnemonic (_("_View"));
  gtk_widget_show (view_mnu);
  gtk_container_add (GTK_CONTAINER (menubar1), view_mnu);

  view_mnu_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (view_mnu), view_mnu_menu);

  zoom_in_mnu = gtk_image_menu_item_new_from_stock ("gtk-zoom-in", accel_group);
  gtk_widget_show (zoom_in_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), zoom_in_mnu);

  zoom_out_mnu = gtk_image_menu_item_new_from_stock ("gtk-zoom-out", accel_group);
  gtk_widget_show (zoom_out_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), zoom_out_mnu);

  layout_mnu = gtk_menu_item_new_with_mnemonic (_("_Layout..."));
  gtk_widget_show (layout_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), layout_mnu);
  
  fit_menu = gtk_menu_new();
  gtk_widget_show (fit_menu);
  fit_to_width_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window width"));
  gtk_widget_show (fit_to_width_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_width_mnu);
  
  fit_to_height_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window height"));
  gtk_widget_show (fit_to_height_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_height_mnu);

  fit_to_window_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window"));
  gtk_widget_show (fit_to_window_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_window_mnu);
  
  fit_selected_to_window_mnu = gtk_menu_item_new_with_mnemonic (_("Fit selection to window"));
  gtk_widget_show (fit_selected_to_window_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_selected_to_window_mnu);
  
  arbitrary_size_mnu = gtk_menu_item_new_with_mnemonic (_("Arbitrary size"));
  gtk_widget_show (arbitrary_size_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), arbitrary_size_mnu);
  
  gtk_menu_item_set_submenu( GTK_MENU_ITEM( layout_mnu ), fit_menu );

  centering_mnu = gtk_menu_item_new_with_mnemonic (_("_Centering"));
  gtk_widget_show (centering_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), centering_mnu);
  
  separatormenuitem2 = gtk_menu_item_new ();
  gtk_widget_show (separatormenuitem2);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), separatormenuitem2);
  gtk_widget_set_sensitive (separatormenuitem2, FALSE);


  groups_mnu = gtk_menu_item_new_with_mnemonic (_("_Groups"));
  gtk_widget_show (groups_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), groups_mnu);

  properties_mnu = gtk_image_menu_item_new_from_stock ("gtk-properties", accel_group);
  gtk_widget_show (properties_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), properties_mnu);
  
  preferences_mnu = gtk_image_menu_item_new_from_stock (_("_Preferences"), accel_group);
  gtk_widget_show (preferences_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), preferences_mnu);

/******************************/
  vscrollbar1 = gtk_vscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 100, 2, 10, 1)));
  gtk_widget_show (vscrollbar1);
  gtk_table_attach (GTK_TABLE (table1), vscrollbar1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  g_object_set_data( G_OBJECT( vscrollbar1 ), "visible", (gpointer)false );
  g_object_set_data( G_OBJECT( vscrollbar1 ), "last_value", (gpointer)last_vvalue );  
                    
  hscrollbar1 = gtk_hscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 100, 2, 10, 1)));
  gtk_widget_show (hscrollbar1);
  gtk_table_attach (GTK_TABLE (table1), hscrollbar1, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 0, 0);
  g_object_set_data( G_OBJECT( hscrollbar1 ), "visible", (gpointer)false ); 
  g_object_set_data( G_OBJECT( hscrollbar1 ), "last_value", (gpointer)last_hvalue );    
/******************************/

  drawingarea = gtk_drawing_area_new ();
  gtk_widget_show (drawingarea);
  gtk_table_attach (GTK_TABLE (table1), drawingarea, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  
  gtk_widget_set_events (drawingarea, GDK_EXPOSURE_MASK | GDK_POINTER_MOTION_MASK | GDK_BUTTON1_MOTION_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

  net_draw_data->drawing_area = drawingarea;
  
 
  gtk_signal_connect (GTK_OBJECT (net_window), "destroy_event",
                      GTK_SIGNAL_FUNC (on_net_window_destroy_event),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (net_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_net_window_delete_event),
                      (gpointer)net_draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (zoom_in_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_zoom_in_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (zoom_out_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_zoom_out_activate),
                      (gpointer)net_draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (arbitrary_size_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_arbitrary_size_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_width_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_to_width_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_height_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_to_height_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_window_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_to_window_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_selected_to_window_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_selected_to_window_activate),
                      (gpointer)net_draw_data);
                        
  gtk_signal_connect (GTK_OBJECT (centering_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_centering_activate),
                      (gpointer)net_draw_data);
  
  gtk_signal_connect (GTK_OBJECT (groups_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_groups_activate),
                      (gpointer)net_draw_data);

  gtk_signal_connect (GTK_OBJECT (properties_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_properties_activate),
                      (gpointer)net_draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (preferences_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_preference_activate),
                      (gpointer)net_draw_data);
					  
  gtk_signal_connect (GTK_OBJECT (drawingarea), "button_press_event",
                      GTK_SIGNAL_FUNC (on_net_drawingarea_button_press_event),
                      (gpointer)net_draw_data);

/*  ButtonData *bd = new ButtonData;
  bd->view = view;
  bd->menu = view_mnu_menu;
*/
  gtk_signal_connect (GTK_OBJECT (drawingarea), "button_release_event",
                      GTK_SIGNAL_FUNC (on_net_drawingarea_button_release_event),
                      (gpointer)net_draw_data);
  
  gtk_signal_connect (GTK_OBJECT (drawingarea), "expose_event",
                      GTK_SIGNAL_FUNC (on_net_drawingarea_expose_event),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (drawingarea), "configure_event",
                      GTK_SIGNAL_FUNC (on_net_drawingarea_configure_event),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (drawingarea), "motion_notify_event",
                      GTK_SIGNAL_FUNC (on_net_drawingarea_motion_notify_event),
                      (gpointer)net_draw_data);
  
  gtk_signal_connect (GTK_OBJECT (vscrollbar1), "value_changed",
                      GTK_SIGNAL_FUNC (on_net_vscrollbar1_value_changed),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (hscrollbar1), "value_changed",
                      GTK_SIGNAL_FUNC (on_net_hscrollbar1_value_changed),
                      (gpointer)net_draw_data);
                      
  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (net_window, net_window, "net_window");
  GLADE_HOOKUP_OBJECT (net_window, table1, "table1");
  GLADE_HOOKUP_OBJECT (net_window, menubar1, "menubar1");
  GLADE_HOOKUP_OBJECT (net_window, view_mnu, "view_mnu");
  GLADE_HOOKUP_OBJECT (net_window, view_mnu_menu, "view_mnu_menu");
  GLADE_HOOKUP_OBJECT (net_window, zoom_in_mnu, "zoom_in_mnu");
  GLADE_HOOKUP_OBJECT (net_window, zoom_out_mnu, "zoom_out_mnu");
  GLADE_HOOKUP_OBJECT (net_window, layout_mnu, "layout_mnu");
  GLADE_HOOKUP_OBJECT (net_window, centering_mnu, "centering_mnu");
  GLADE_HOOKUP_OBJECT (net_window, groups_mnu, "groups_mnu");
  GLADE_HOOKUP_OBJECT (net_window, properties_mnu, "properties_mnu");
  GLADE_HOOKUP_OBJECT (net_window, drawingarea, "drawingarea");
  
  GLADE_HOOKUP_OBJECT (net_window, vscrollbar1, "vscrollbar1");
  GLADE_HOOKUP_OBJECT (net_window, hscrollbar1, "hscrollbar1");
  
  gtk_window_add_accel_group (GTK_WINDOW (net_window), accel_group);
  
  g_object_set_data( G_OBJECT( net_window ), "draw_data", (gpointer)net_draw_data );
  g_object_set_data( G_OBJECT( net_window ), "parent_window", (gpointer)parent );
  g_object_set_data( G_OBJECT( parent ), "net_window", (gpointer)net_window );
  
  gen_window = (GraphGenerationGUI*)g_object_get_data( G_OBJECT( parent ), "generate_graph_window" );  
  gen_window->register_load_handler( new NetWindowFileLoadHandler( parent, net_comp, graph_app ) );
/*  gen_window->register_close_handler( new NetWindowGenCloseHandler( open_mnu ) );*/

  if ( parent != NULL )
    g_object_set_data( G_OBJECT( parent ), "net_window", (gpointer)net_window );
  
  
  return net_window;
}

GtkWidget *make_net_view_menu( NetDrawingData *net_draw_data )
{
  GtkWidget *view_mnu_menu;
  GtkWidget *zoom_in_mnu;
  GtkWidget *zoom_out_mnu;
  GtkWidget *layout_mnu;
  GtkWidget *centering_mnu;
  GtkWidget *groups_mnu;
  //GtkWidget *new_wnd_mnu;
  GtkWidget *properties_mnu;
  //GtkWidget *preference_mnu;    
  //GtkWidget *filter_mnu;
  //GtkWidget *attributes_mnu;
  //GtkWidget *find_mnu;
  //GtkWidget *select_path_mnu;
  GtkWidget *fit_menu;
  GtkWidget *fit_to_width_mnu;
  GtkWidget *fit_to_height_mnu;
  GtkWidget *fit_to_window_mnu;
  GtkWidget *fit_selected_to_window_mnu;
  GtkWidget *arbitrary_size_mnu;
  GtkWidget *separatormenuitem2;
  GtkAccelGroup *accel_group;
  
  accel_group = gtk_accel_group_new ();
  
  view_mnu_menu = gtk_menu_new ();
  gtk_widget_show (view_mnu_menu);
    
  zoom_in_mnu = gtk_image_menu_item_new_from_stock ("gtk-zoom-in", accel_group);
  gtk_widget_show (zoom_in_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), zoom_in_mnu);

  zoom_out_mnu = gtk_image_menu_item_new_from_stock ("gtk-zoom-out", accel_group);
  gtk_widget_show (zoom_out_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), zoom_out_mnu);

  layout_mnu = gtk_menu_item_new_with_mnemonic (_("_Layout..."));
  gtk_widget_show (layout_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), layout_mnu);
  
  fit_menu = gtk_menu_new();
  gtk_widget_show (fit_menu);
  fit_to_width_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window width"));
  gtk_widget_show (fit_to_width_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_width_mnu);
  
  fit_to_height_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window height"));
  gtk_widget_show (fit_to_height_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_height_mnu);

  fit_to_window_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window"));
  gtk_widget_show (fit_to_window_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_window_mnu);
  
  fit_selected_to_window_mnu = gtk_menu_item_new_with_mnemonic (_("Fit selection to window"));
  gtk_widget_show (fit_selected_to_window_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_selected_to_window_mnu);
  
  arbitrary_size_mnu = gtk_menu_item_new_with_mnemonic (_("Arbitrary size"));
  gtk_widget_show (arbitrary_size_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), arbitrary_size_mnu);
  
  gtk_menu_item_set_submenu( GTK_MENU_ITEM( layout_mnu ), fit_menu );

  centering_mnu = gtk_menu_item_new_with_mnemonic (_("_Centering"));
  gtk_widget_show (centering_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), centering_mnu);
  
  separatormenuitem2 = gtk_menu_item_new ();
  gtk_widget_show (separatormenuitem2);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), separatormenuitem2);
  gtk_widget_set_sensitive (separatormenuitem2, FALSE);

  groups_mnu = gtk_menu_item_new_with_mnemonic (_("_Groups"));
  gtk_widget_show (groups_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), groups_mnu);

  properties_mnu = gtk_image_menu_item_new_from_stock ("gtk-properties", accel_group);
  gtk_widget_show (properties_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), properties_mnu);
  
  
  gtk_signal_connect (GTK_OBJECT (zoom_in_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_zoom_in_activate),
                      (gpointer)net_draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (zoom_out_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_zoom_out_activate),
                      (gpointer)net_draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (arbitrary_size_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_arbitrary_size_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_width_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_to_width_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_height_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_to_height_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_window_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_to_window_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_selected_to_window_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_fit_selected_to_window_activate),
                      (gpointer)net_draw_data);
                        
  gtk_signal_connect (GTK_OBJECT (centering_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_centering_activate),
                      (gpointer)net_draw_data);
  gtk_signal_connect (GTK_OBJECT (groups_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_groups_activate),
                      (gpointer)net_draw_data);

  gtk_signal_connect (GTK_OBJECT (properties_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_net_properties_activate),
                      (gpointer)net_draw_data);

  return view_mnu_menu;
}
