
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "docked.h"


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_object_set_data_full (GTK_OBJECT (component), name, \
    gtk_widget_ref (widget), (GtkDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  gtk_object_set_data (GTK_OBJECT (component), name, widget)
  
static int title_number = 0;
extern int wnd_nmb;

static char * attr_xpm[] = {
"32 32 4 1",
" 	c #E6E6E6E6E6E6",
".	c #333333333333",
"X	c #000000000000",
"o	c #00000000EEEE",
"                                ",
"                                ",
"   .........................X   ",
"   .      o                 X   ",
"   .     ooo   o   o        X   ",
"   .     o o   o   o    oo  X   ",
"   .    oo oo ooo ooo  o    X   ",
"   X    ooooo  o   o   o    X   ",
"   X   oo   oo o   o   o    X   ",
"   .   o     o  oo  oo o    X   ",
"   XXXXXXXXXXXXXXXXXX.......X   ",
"   .                        X   ",
"   .                        X   ",
"   . XXXXXXXXXXX            X   ",
"   .                        X   ",
"   .   XXXXXXXXXXX          X   ",
"   .                        X   ",
"   .   XXXXXXXXXXX          X   ",
"   .                        X   ",
"   .         XXXXXXX        X   ",
"   .                        X   ",
"   .                        X   ",
"   . XXXXXXXXXXXXX          X   ",
"   .                        X   ",
"   .   XXXXXXXXXX           X   ",
"   .                        X   ",
"   .        XXXXXXXX        X   ",
"   .                        X   ",
"   .........................X   ",
"                                ",
"                                ",
"                                "};

static char * info_xpm[] = {
"32 32 5 1",
" 	c #E6E6E6E6E6E6",
".	c #333333333333",
"X	c #000000000000",
"o	c #00000000EEEE",
"O	c #00000000FFFF",
"                                ",
"                                ",
"   .........................X   ",
"   .                        X   ",
"   .   ooo         o        X   ",
"   .    o   OO    o   oo    X   ",
"   .    o  O  O  ooo o  o   X   ",
"   X    o  o  o   o  o  o   X   ",
"   X    o  o  o   o  o  o   X   ",
"   .   ooo o   o  o   oo    X   ",
"   XXXXXXXXXXXXXXXXXX.......X   ",
"   .                        X   ",
"   .                        X   ",
"   . XXXXXXXXXXX            X   ",
"   .                        X   ",
"   .   XXXXXXXXXXX          X   ",
"   .                        X   ",
"   .   XXXXXXXXXXX          X   ",
"   .                        X   ",
"   .         XXXXXXX        X   ",
"   .                        X   ",
"   .                        X   ",
"   . XXXXXXXXXXXXX          X   ",
"   .                        X   ",
"   .   XXXXXXXXXX           X   ",
"   .                        X   ",
"   .        XXXXXXXX        X   ",
"   .                        X   ",
"   .........................X   ",
"                                ",
"                                ",
"                                "};

static char * over_node_xpm[] = {
"32 32 5 1",
" 	c #E6E6E6E6E6E6",
"O	c #959595959595",
"o	c #C5C5C5C5C5C5",
".	c #000000000000",
"X	c #00000000EEEE",
"                                ",
"                                ",
"                                ",
"                                ",
"        ....                    ",
"      ..XXXX..                  ",
"     .XXXXXXXX.                 ",
"     .XXXXXXXX.                 ",
"    .XXXXXXXXXX.                ",
"    .XXXXXXXXXX.                ",
"    .XXXXXXXXXX.                ",
"    .XXXXXXXXXX.                ",
"     .XXXXXXXX. .               ",
"     .XXXXXXXX. ..              ",
"      ..XXXX..  ...             ",
"        ....  O ....            ",
"              OO...             ",
"              OO. .             ",
"            o OOOO .            ",
"            ooOOO  .  ......... ",
"            ooO O     .       . ",
"            oooo O    ......  . ",
"            ooo  O    .       . ",
"            o o       ....    . ",
"               o      .       . ",
"               o      ....    . ",
"                      .       . ",
"                      ....... . ",
"                      .       . ",
"                      .       . ",
"                      ......... ",
"                                "};

static char * select_node_xpm[] = {
"32 32 4 1",
" 	c #E6E6E6E6E6E6",
".	c #000000000000",
"X	c #00000000EEEE",
"o  c #FFFF00000000",
"                                ",
"                                ",
"                                ",
"                                ",
"        oooo                    ",
"      ooXXoXoo                  ",
"     oXXXoXXoXo                 ",
"     oXXoXXoXXo                 ",
"    oXXoXXoXXoXo                ",
"    oXoXXoXXoXXo                ",
"    ooXXoXXoXXoo                ",
"    oXXoXXoXXoXo                ",
"     ooXXoXXoXo .               ",
"     oXXoXXoXXo ..              ",
"      ooXXoXoo  ...             ",
"        oooo    ....            ",
"                ...             ",
"                . .             ",
"                   .            ",
"                   .  ......... ",
"                      .       . ",
"                      ......  . ",
"                      .       . ",
"                      ....    . ",
"                      .       . ",
"                      ....    . ",
"                      .       . ",
"                      ....... . ",
"                      .       . ",
"                      .       . ",
"                      ......... ",
"                                "};


static char * edge_selecting_xpm[] = {
"32 32 4 1",
" 	c #E6E6E6E6E6E6",
".	c #000000000000",
"X	c #00000000EEEE",
"I	c #EEEE00000000",
"                                ",
"         II                     ",
"       I.XX.I                   ",
"      IXXXXXXI                  ",
"     I.XXXXXX.I                 ",
"     IXXXXXXXXI                 ",
"     IXXXXXXXXI                 ",
"     I.XXXXXX.I                 ",
"      IXXXXXXI                  ",
"       I.XX.I                   ",
"         IIII                   ",
"             I                  ",
"             I                  ",
"              I                 ",
"              I                 ",  
"               I                ",
"               I                ",
"                II              ",  
"               III              ",
"                II              ",
"                 I..            ",
"                ..XX..          ",
"               .XXXXXX.         ",
"       .      ..XXXXXX..        ",
"       .      .XXXXXXXX.        ",
"       .      .XXXXXXXX.        ",
"    ... ...   ..XXXXXX..        ",
"       .       .XXXXXX.         ",
"       .        ..XX..          ",
"       .          ..            ",
"                                ",
"                                "};

static char * load_close_xpm[] = {
"32 32 4 1",
" 	c #E6E6E6E6E6E6",
"I	c #EEEE00000000",
"X	c #000000000000",
"o	c #00000000EEEE",
"                                ",
"                                ",
"                                ",
"  o                             ",
"  o        ooo    ooo   oooo    ",
"  o       o   o  o   o  o   o   ",
"  o       o   o  o   o  o   o   ",
"  o       o   o  ooooo  o   o   ",
"  oooooo   ooo   o   o  oooo    ",
"                                ",
"               X                ",
"               X                ",
"               X                ",
"               X                ",
"               X                ",
"               X                ",
"               X                ",
"               X                ",
"            X  X  X             ",
"             X X X              ",
"              XXX               ",
"               X                ",
"                                ",
"   III                          ",
"  I   I I     III   III  IIII   ",
"  I     I    I   I I     I      ",
"  I     I    I   I  II   III    ",
"  I   I I    I   I    I  I      ",
"   III  IIII  III  III   IIII   ",
"                                ",
"                                ",
"                                "};

static char * select_path_xpm[] = {
"32 32 11 1",
". c #E6E6E6E6E6E6",
"# c #000000000000",
"b c #00000000FFFF",
"h c #808000000000",
"i c #808080808080",
"e c #A0A0A0A0A0A0",
"a c #C0C000000000",
"g c #C3C3C3C3C3C3",
"f c #DCDCDCDCDCDC",
"d c #FFFF00000000",
"c c #FFFFFFFFFFFF",
"................................",
"................................",
"................................",
".....#........aaa...............",
".....#.......abbba..............",
".....#.......abbba..............",
"..###c###....abbba..............",
".....#.......daaae..............",
".....#......d...fdg.............",
".....#.....d.....fdf............",
"........g.d.......gdf...........",
"........dh.........eif..........",
"........ddg.........dgg.........",
".....bbb.............hd.........",
"....bbbbb...........gddbbb......",
"....bbbbb.............bbbbb.....",
"....bbbbb.............bbbbb.....",
".....bbb..............bbbbb.....",
"......gdg.............dbbb......",
".......gd............d..........",
"........gd..........d...........",
".........dgg.......d............",
"..........hd....gfd.............",
".........gdd....dhf.............",
"............aaa.ddg.............",
"...........abbba................",
"...........abbba................",
"...........abbba................",
"............aaa.................",
"................................",
"................................",
"................................"};

static char * next_path_xpm[] = {
"32 32 10 1",
". c #E6E6E6E6E6E6",
"g c #000000000000",
"a c #00000000FFFF",
"f c #585858585858",
"h c #808000000000",
"e c #808080808080",
"# c #C0C000000000",
"d c #C3C3C3C3C3C3",
"c c #DCDCDCDCDCDC",
"b c #FFFF00000000",
"................................",
"................................",
"................................",
"..............###...............",
".............#aaa#..............",
".............#aaa#..............",
".............#aaa#..............",
".............b###...............",
"............b...c...............",
"...........b....ded....ded......",
"........d.b.....efgd...efgd.....",
"........bh.......efgd...efgd....",
"........bbd.......efgd...efgd...",
".....aaa...........efgd...efgd..",
"....aaaaa...........efgd...efgd.",
"....aaaaa............efgd...efgd",
"....aaaaa.............efgd...efg",
".....aaa.............efgd...efgd",
"......dbd...........efgd...efgd.",
".......db..........efgd...efgd..",
"........db........efgd...efgd...",
".........bdd.....efgd...efgd....",
"..........hb....efgd...efgd.....",
".........dbb....ded....ded......",
"............###.................",
"...........#aaa#................",
"...........#aaa#................",
"...........#aaa#................",
"............###.................",
"................................",
"................................",
"................................"};

static char * prev_path_xpm[] = {
"32 32 11 1",
". c #E6E6E6E6E6E6",
"g c #000000000000",
"a c #00000000FFFF",
"h c #585858585858",
"i c #808000000000",
"f c #808080808080",
"b c #A0A0A0A0A0A0",
"# c #C0C000000000",
"e c #C3C3C3C3C3C3",
"c c #DCDCDCDCDCDC",
"d c #FFFF00000000",
"................................",
"................................",
"................................",
"..............###...............",
".............#aaa#..............",
".............#aaa#..............",
".............#aaa#..............",
"..............###b..............",
"................cde.............",
"......efe....efe.cdc............",
".....eghe...eghe..edc...........",
"....eghf...eghf....bfc..........",
"...eghf...eghf......dee.........",
"..eghf...eghf........id.........",
".eghf...eghf........eddaaa......",
"eghf...eghf...........aaaaa.....",
"ghf...eghf............aaaaa.....",
"eghf...eghf...........aaaaa.....",
".eghf...eghf..........daaa......",
"..eghf...eghf........d..........",
"...eghf...eghf......d...........",
"....eghf...eghf....d............",
".....eghe...egheecd.............",
"......efe.....e.dic.............",
"............###.dde.............",
"...........#aaa#................",
"...........#aaa#................",
"...........#aaa#................",
"............###.................",
"................................",
"................................",
"................................"};

class MainWindowGenCloseHandler: public GUICloseHandler
{
private:
  GtkWidget *m_open_mnu;
  GtkWidget *m_open_btn;

public:
  MainWindowGenCloseHandler( GtkWidget *open_mnu, GtkWidget *open_btn )
  {
    m_open_mnu = open_mnu;
    m_open_btn = open_btn;      
  }
  
  ~MainWindowGenCloseHandler() {};
    
  void operator () ( )
  {
    gtk_widget_set_sensitive ( m_open_mnu, true );
    gtk_widget_set_sensitive ( m_open_btn, true );      
  }
};

class MainWindowFileLoadHandler: public GUIGraphLoadHandler
{
private:
  GtkWidget *m_main_window;
  ScenarioApp *m_app;
  GraphGenerationGUI *m_gen_window;
    
public:
  MainWindowFileLoadHandler( GtkWidget *main_window, ScenarioApp *app, GraphGenerationGUI *gen_window )
  {
    m_main_window = main_window;
    m_app  = app;
    m_gen_window = gen_window;
  }
  ~MainWindowFileLoadHandler() {}
    
  void operator () ( )
  {
    GtkWidget *drawing_area = lookup_widget( m_main_window, "drawingarea" );
    GtkWidget *status_bar  = lookup_widget( m_main_window, "statusbar1");  
    GtkWidget *use_aliases_mnu  = lookup_widget( m_main_window, "use_aliases_mnu");      
    
    GdkRectangle invalidate_rect;
    GraphView *view = m_app->get_graph_view_context()->get_view();
    string          status_str;      
   
    update_scrollbars( drawing_area, view);
 
    invalidate_rect.x = 0;
    invalidate_rect.y = 0;
    gdk_window_get_size( drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
    gdk_window_invalidate_rect( drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( drawing_area->window, TRUE );
      
    status_str = m_app->get_graph_view_context()->get_status_mngr()->get_current_status()->get_status_str();
    set_new_status_message(status_bar, status_str);
 /*   
    if ( m_app->get_graph_view_context()->get_graph()->get_graph_attr_name_storage()->get_curr_alias_set( ) < 0 )
      gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(use_aliases_mnu), FALSE );
    else
      gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(use_aliases_mnu), TRUE );
 */
  }
};

class CreateDockedHandler: public GUICreateDockableWindowEventHandler
{
private:
  GraphDrawingData *m_data;

public:
  CreateDockedHandler( GraphDrawingData *draw_data )
  {
    m_data = draw_data;
  }
  
  ~CreateDockedHandler() {}
      
  void operator () ( GraphGUIDockableWindow* window, bool new_created )
  {
    if ( window->is_docked() && !new_created )
      add_dock_notebook_page( m_data->dock, window );
    else    
      switch ( window->get_dockable_type() )
      {
      case GraphGUI::DOCKABLE_NODE_INFO:
        if ( new_created )
          window->register_dock_menu_handler( new DockNotebookHandler( m_data->dock, window ) );
        
        if ( m_data->graph_app->get_extra_behavior_modes() & ScenarioApp::DOCK_ATTR_ON_START ) 
          add_dock_notebook_page( m_data->dock, window );
        break;
        
      case GraphGUI::DOCKABLE_EDGE_INFO:
          
        if ( new_created )
          window->register_dock_menu_handler( new DockNotebookHandler( m_data->dock, window ) );
        
        if ( m_data->graph_app->get_extra_behavior_modes() & ScenarioApp::DOCK_INFO_ON_START ) 
          add_dock_notebook_page( m_data->dock, window );
        break;
        
      case GraphGUI::DOCKABLE_PATH_INFO:
        if ( new_created )  
        {
          window->register_close_handler( new PathInfoWindowCloseHandler( m_data->dock, window ) );
          window->register_dock_menu_handler( new DockNotebookHandler( m_data->dock, window ) );
          add_dock_notebook_page( m_data->dock, window );
        }
        break;
      
      default:;
      }
  }
  
};
  
GtkWidget*
create_main_window ( GraphDrawingData *draw_data )
{
/***************************************************	
	<AR>
****************************************************/
	ScenarioApp      *graph_app;
  
  GtkWidget *statusbar1;  
  GtkWidget *vscrollbar1;
  GtkWidget *hscrollbar1;
/***************************************************/
  GtkWidget *main_window;
  GtkWidget *table1;
  GtkWidget *menubar1;
  GtkWidget *menuitem1;
  GtkWidget *menuitem1_menu;
  GtkWidget *open_mnu;
  GtkWidget *comp_mnu;
  GtkWidget *save_mnu;
  GtkWidget *show_statistics_mnu;
  GtkWidget *show_gm_on_load_mode_mnu;
  GtkWidget *separatormenuitem1;
  GtkWidget *quit_mnu;
  GtkWidget *view_mnu;
  GtkWidget *view_mnu_menu;
  GtkWidget *modes_mnu;
  GtkWidget *modes_mnu_menu;
  GtkWidget *single_iw_mode_mnu;
  GtkWidget *single_aw_mode_mnu;
  GtkWidget *aw_on_mouse_over_mode_mnu;
  GtkWidget *close_gw_after_load_mode_mnu;
  GtkWidget *edge_selecting_mode_mnu;
  GtkWidget *aw_on_node_select_mode_mnu;
  GtkWidget *network_mnu;
  GtkWidget *network_mnu_menu;
  GtkWidget *del_attack_mnu;
  GtkWidget *critical_attack_mnu;
  GtkWidget *critical_measure_mnu;
  GtkWidget *help_mnu;
  GtkWidget *help_mnu_menu;
  GtkWidget *about_mnu;
  GtkWidget *drawingarea;
  GtkAccelGroup *accel_group;
  gdouble   *last_vvalue = new gdouble;
  gdouble   *last_hvalue = new gdouble;
  string     title = "Graph View";
  GtkWidget *toolbar1;
  GtkWidget *open_btn;  
  GtkWidget *save_btn;  
  GtkWidget *properties_btn;  
  GtkWidget *preferences_btn;    
  GtkWidget *zoom_in_btn;  
  GtkWidget *zoom_out_btn;   
  GtkWidget *select_path_btn;  
  GtkWidget *next_path_btn;  
  GtkWidget *prev_path_btn;  
  GtkWidget *attr_single_btn;
  GtkWidget *info_single_btn;
  GtkWidget *over_node_btn;
  GtkWidget *select_node_btn;
  GtkWidget *edge_selecting_btn;
  GtkWidget *load_close_btn;
  
  GtkWidget *select_path_icon;  
  GtkWidget *next_path_icon;  
  GtkWidget *prev_path_icon;  
  GtkWidget *attr_icon;  
  GtkWidget *info_icon;
  GtkWidget *over_node_icon;
  GtkWidget *select_node_icon;
  GtkWidget *edge_selecting_icon;
  GtkWidget *load_close_icon;
  GdkPixmap *pixmap;
  
  if ( draw_data == 0 )
    draw_data = new GraphDrawingData();
    
  if ( title_number > 0 )
  {
    char buff[255];
    
    sprintf( buff, "%d", title_number );
    title += " - window " + string( buff );
  }
  
  *last_vvalue = 0.0;
  *last_hvalue = 0.0;
  
  accel_group = gtk_accel_group_new ();

  main_window = gtk_window_new ( GTK_WINDOW_TOPLEVEL );
  
  gtk_window_set_title ( GTK_WINDOW (main_window), title.c_str() );
  gtk_window_set_default_size (GTK_WINDOW (main_window), 500, 500);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (main_window), TRUE);
	
/***************************************************	
	<AR>
****************************************************/
	graph_app = new ScenarioApp( (void*)main_window );
  draw_data->graph_app = graph_app;
/**************************************************/

  table1 = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (main_window), table1);

  toolbar1 = gtk_toolbar_new ();
  gtk_widget_show (toolbar1);
  gtk_table_attach (GTK_TABLE (table1), toolbar1, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar1), GTK_TOOLBAR_ICONS);

  open_btn = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar1),
                                "gtk-open",
                                "Open",
                                NULL, NULL, NULL, -1);
  gtk_widget_show (open_btn);
  
  save_btn = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar1),
                                "gtk-save",
                                "Save",
                                NULL, NULL, NULL, -1);
  gtk_widget_show (save_btn);

  properties_btn = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar1),
                                "gtk-properties",
                                "Properties",
                                NULL, NULL, NULL, -1);
  gtk_widget_show (properties_btn);

  preferences_btn = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar1),
                                "gtk-preferences",
                                "Preferences",
                                NULL, NULL, NULL, -1);
  gtk_widget_show (preferences_btn);

  zoom_in_btn = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar1),
                                "gtk-zoom-in",
                                "Zoom in",
                                NULL, NULL, NULL, -1);
  gtk_widget_show (zoom_in_btn);

  zoom_out_btn = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar1),
                                "gtk-zoom-out",
                                "Zoom out",
                                NULL, NULL, NULL, -1);
  gtk_widget_show (zoom_out_btn);
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, select_path_xpm);  
  select_path_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  select_path_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("select_path__btn"),
                                _("Select Scenario"), NULL,
                                select_path_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (select_path_btn);
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, next_path_xpm);  
  next_path_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  next_path_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("next_path__btn"),
                                _("Next Path"), NULL,
                                next_path_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (next_path_btn);
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, prev_path_xpm);  
  prev_path_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  prev_path_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("prev_path__btn"),
                                _("Previous Path"), NULL,
                                prev_path_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (prev_path_btn);
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, attr_xpm);  
  attr_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  attr_single_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("attr_single_btn"),
                                _("Single Attributes Window"), NULL,
                                attr_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (attr_single_btn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(attr_single_btn), (graph_app->get_behavior_modes() & ScenarioApp::SINGLE_ATTR_WINDOW) != 0 );

  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, info_xpm);  
  info_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  info_single_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("info_single_btn"),
                                _("Single Information Window"), NULL,
                                info_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (info_single_btn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(info_single_btn), (graph_app->get_behavior_modes() & ScenarioApp::SINGLE_INFO_WINDOW) != 0 );

  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, over_node_xpm);  
  over_node_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  over_node_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("over_node_btn"),
                                _("Show Attributes if mouse is over node"), NULL,
                                over_node_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (over_node_btn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(over_node_btn), (graph_app->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER) != 0 );
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, select_node_xpm);  
  select_node_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  select_node_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("select_node_btn"),
                                _("Show Attributes if an individual node is selected"), NULL,
                                select_node_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (select_node_btn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(select_node_btn), (graph_app->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT) != 0 );
  
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, edge_selecting_xpm);  
  edge_selecting_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  edge_selecting_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("edge_selecting_btn"),
                                _("Edge selecting mode"), NULL,
                                edge_selecting_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (edge_selecting_btn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(edge_selecting_btn), (graph_app->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 );
  
  pixmap =  gdk_pixmap_colormap_create_from_xpm_d (main_window->window, gdk_colormap_get_system(), NULL, NULL, load_close_xpm);  
  load_close_icon = gtk_image_new_from_pixmap(pixmap, NULL);
  load_close_btn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("load_close_btn"),
                                _("Close Generation Window after graph is loaded"), NULL,
                                load_close_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (load_close_btn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(load_close_btn), (graph_app->get_behavior_modes() & ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD) != 0 );
  
  statusbar1 = gtk_statusbar_new ();
  gtk_widget_show (statusbar1);
  gtk_table_attach (GTK_TABLE (table1), statusbar1, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  menubar1 = gtk_menu_bar_new ();
  gtk_widget_show (menubar1);
  gtk_table_attach (GTK_TABLE (table1), menubar1, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  menuitem1 = gtk_menu_item_new_with_mnemonic (_("_Graph"));
  gtk_widget_show (menuitem1);
  gtk_container_add (GTK_CONTAINER (menubar1), menuitem1);

  menuitem1_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem1), menuitem1_menu);
  
  open_mnu = gtk_image_menu_item_new_from_stock ("gtk-open", accel_group);
  gtk_widget_show (open_mnu);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), open_mnu);
  
  save_mnu = gtk_image_menu_item_new_from_stock ("gtk-save", accel_group);
  gtk_widget_show (save_mnu);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), save_mnu);
  
  comp_mnu = gtk_menu_item_new_with_mnemonic (_("Component manager"));
  gtk_widget_show (comp_mnu);
  gtk_menu_append ( GTK_MENU(menuitem1_menu), comp_mnu);
  
  show_statistics_mnu = gtk_menu_item_new_with_mnemonic (_("Show graph statistics"));
  gtk_widget_show ( show_statistics_mnu );
  gtk_menu_append ( GTK_MENU(menuitem1_menu), show_statistics_mnu );
  
  show_gm_on_load_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("Display graph metrics on graph load"));
  gtk_widget_show (show_gm_on_load_mode_mnu);
  gtk_menu_append ( GTK_MENU(menuitem1_menu), show_gm_on_load_mode_mnu );
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(show_gm_on_load_mode_mnu), (graph_app->get_extra_behavior_modes() & ScenarioApp::OUTPUT_GEN_GRAPH_METRICS) != 0 );

  separatormenuitem1 = gtk_menu_item_new ();
  gtk_widget_show (separatormenuitem1);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), separatormenuitem1);
  gtk_widget_set_sensitive (separatormenuitem1, FALSE);

  quit_mnu = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
  gtk_widget_show (quit_mnu);
  gtk_container_add (GTK_CONTAINER (menuitem1_menu), quit_mnu);
 
  view_mnu = gtk_menu_item_new_with_mnemonic (_("_View"));
  gtk_widget_show (view_mnu);
  gtk_container_add (GTK_CONTAINER (menubar1), view_mnu);
  
  modes_mnu = gtk_menu_item_new_with_mnemonic (_("_Modes"));
  gtk_widget_show (modes_mnu);
  gtk_container_add (GTK_CONTAINER (menubar1), modes_mnu);
  
  modes_mnu_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (modes_mnu), modes_mnu_menu);
  
  single_iw_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("Single _Information Window"));
  gtk_widget_show (single_iw_mode_mnu);
  gtk_container_add (GTK_CONTAINER (modes_mnu_menu), single_iw_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(single_iw_mode_mnu), (graph_app->get_behavior_modes() & ScenarioApp::SINGLE_INFO_WINDOW) != 0 );
  
  single_aw_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("Single _Attributes Window"));
  gtk_widget_show (single_aw_mode_mnu);
  gtk_container_add (GTK_CONTAINER (modes_mnu_menu), single_aw_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(single_aw_mode_mnu), (graph_app->get_behavior_modes() & ScenarioApp::SINGLE_ATTR_WINDOW) != 0 );
  
  aw_on_mouse_over_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("_Show Attributes if mouse is over node"));
  gtk_widget_show (aw_on_mouse_over_mode_mnu);
  gtk_container_add (GTK_CONTAINER (modes_mnu_menu), aw_on_mouse_over_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(aw_on_mouse_over_mode_mnu), (graph_app->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER) != 0 );
  
  aw_on_node_select_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("S_how Attributes if an individual node is selected"));
  gtk_widget_show (aw_on_node_select_mode_mnu);
  gtk_container_add (GTK_CONTAINER (modes_mnu_menu), aw_on_node_select_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(aw_on_node_select_mode_mnu), (graph_app->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT) != 0 );
  
  close_gw_after_load_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("_Close Generation Window after graph loading"));
  gtk_widget_show (close_gw_after_load_mode_mnu);
  gtk_container_add (GTK_CONTAINER (modes_mnu_menu), close_gw_after_load_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(close_gw_after_load_mode_mnu), (graph_app->get_behavior_modes() & ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD) != 0 );
  
  edge_selecting_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("_Edge selecting"));
  gtk_widget_show (edge_selecting_mode_mnu);
  gtk_container_add (GTK_CONTAINER (modes_mnu_menu), edge_selecting_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(edge_selecting_mode_mnu), (graph_app->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 );
  
  network_mnu= gtk_menu_item_new_with_mnemonic (_("_Network"));
  gtk_widget_show (network_mnu);
  gtk_container_add (GTK_CONTAINER (menubar1), network_mnu);
  
  network_mnu_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (network_mnu), network_mnu_menu);
  
  critical_attack_mnu = gtk_menu_item_new_with_mnemonic (_("Find critical _attacks"));
  gtk_widget_show (critical_attack_mnu);
  gtk_container_add (GTK_CONTAINER (network_mnu_menu), critical_attack_mnu);
  
  critical_measure_mnu = gtk_menu_item_new_with_mnemonic (_("Find critical _measures"));
  gtk_widget_show (critical_measure_mnu);
  gtk_container_add (GTK_CONTAINER (network_mnu_menu), critical_measure_mnu);
  
  del_attack_mnu = gtk_menu_item_new_with_mnemonic (_("_Remove attacks"));
  gtk_widget_show (del_attack_mnu);
  gtk_container_add (GTK_CONTAINER (network_mnu_menu), del_attack_mnu);
  
  help_mnu = gtk_menu_item_new_with_mnemonic (_("_Help"));
  gtk_widget_show (help_mnu);
  gtk_container_add (GTK_CONTAINER (menubar1), help_mnu);

  help_mnu_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help_mnu), help_mnu_menu);

  about_mnu = gtk_menu_item_new_with_mnemonic (_("_About"));
  gtk_widget_show (about_mnu);
  gtk_container_add (GTK_CONTAINER (help_mnu_menu), about_mnu);

/******************************/
  GtkWidget *hpaned1;
  GtkWidget *table2;
  DockNotebook *dock_notebook;
  
  hpaned1 = gtk_hpaned_new ();
  gtk_widget_show (hpaned1);
  gtk_table_attach (GTK_TABLE (table1), hpaned1, 0, 2, 2, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), 0, 0);

  dock_notebook = create_dock_notebook();
  gtk_paned_pack1 (GTK_PANED (hpaned1), dock_notebook->notebook, FALSE, TRUE);
  gtk_widget_hide(dock_notebook->notebook);
  
  draw_data->dock = dock_notebook;

  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_paned_pack2 (GTK_PANED (hpaned1), table2, TRUE, TRUE);
  
  vscrollbar1 = gtk_vscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 100, 2, 10, 1)));
  gtk_widget_show (vscrollbar1);
    
  gtk_table_attach (GTK_TABLE (table2), vscrollbar1, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
                    
  //gtk_table_attach (GTK_TABLE (table1), vscrollbar1, 1, 2, 2, 3,                
  //                  (GtkAttachOptions) (GTK_SHRINK),
  //                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  g_object_set_data( G_OBJECT( vscrollbar1 ), "visible", (gpointer)false );
  g_object_set_data( G_OBJECT( vscrollbar1 ), "last_value", (gpointer)last_vvalue );  
                    
  hscrollbar1 = gtk_hscrollbar_new (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 100, 2, 10, 1)));
  gtk_widget_show (hscrollbar1);
  gtk_table_attach (GTK_TABLE (table2), hscrollbar1, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 0, 0);
  //gtk_table_attach (GTK_TABLE (table1), hscrollbar1, 0, 1, 3, 4,
  //                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
  //                  (GtkAttachOptions) (GTK_SHRINK), 0, 0);
  g_object_set_data( G_OBJECT( hscrollbar1 ), "visible", (gpointer)false ); 
  g_object_set_data( G_OBJECT( hscrollbar1 ), "last_value", (gpointer)last_hvalue );    
/******************************/

  drawingarea = gtk_drawing_area_new ();
  gtk_widget_show (drawingarea);
  
  gtk_table_attach (GTK_TABLE (table2), drawingarea, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), 0, 0);
                    
  //gtk_table_attach (GTK_TABLE (table1), drawingarea, 0, 1, 2, 3,
  //                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
  //                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  
  gtk_widget_set_events (drawingarea, GDK_EXPOSURE_MASK | GDK_POINTER_MOTION_MASK | GDK_BUTTON1_MOTION_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

/***************************************************	
	<AR>
****************************************************/
  draw_data->drawing_area = drawingarea;
/**************************************************/
  
  view_mnu_menu = make_view_menu( draw_data, true );
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (view_mnu), view_mnu_menu);

  gtk_signal_connect (GTK_OBJECT (main_window), "destroy_event",
                      GTK_SIGNAL_FUNC (on_main_window_destroy_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_main_window_delete_event),
                      (gpointer)draw_data);

  gtk_signal_connect (GTK_OBJECT (comp_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_comp_activate),
                      (gpointer)(draw_data));
                      
  gtk_signal_connect (GTK_OBJECT (show_statistics_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_show_graph_statistics),
                      (gpointer)(draw_data));
                      
  
  gtk_signal_connect (GTK_OBJECT (show_gm_on_load_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_show_gm_on_load_mode),
                      (gpointer)(draw_data));
  
                      
  gtk_signal_connect (GTK_OBJECT (open_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_open_activate),
                      (gpointer)(draw_data));
  gtk_signal_connect (GTK_OBJECT (save_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_save_activate),
                      (gpointer)(draw_data));
                      
  gtk_signal_connect (GTK_OBJECT (single_iw_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_single_iw_mode_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (single_aw_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_single_aw_mode_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (aw_on_mouse_over_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_aw_on_mouse_over_mode_activate),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (aw_on_node_select_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_aw_on_node_select_mode_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (close_gw_after_load_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_close_gw_after_load_mode_activate),
                      (gpointer)draw_data);
                                            
  gtk_signal_connect (GTK_OBJECT (edge_selecting_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_edge_selecting_mode_activate),
                      (gpointer)draw_data);
                                            
  gtk_signal_connect (GTK_OBJECT (critical_measure_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_critical_measure_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (critical_attack_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_critical_attack_activate),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (del_attack_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_reduce_graph_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (quit_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_quit_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (about_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_about_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (drawingarea), "button_press_event",
                      GTK_SIGNAL_FUNC (on_drawingarea_button_press_event),
                      (gpointer)draw_data);

  gtk_signal_connect (GTK_OBJECT (drawingarea), "button_release_event",
                      GTK_SIGNAL_FUNC (on_drawingarea_button_release_event),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (drawingarea), "expose_event",
                      GTK_SIGNAL_FUNC (on_drawingarea_expose_event),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (drawingarea), "configure_event",
                      GTK_SIGNAL_FUNC (on_drawingarea_configure_event),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (drawingarea), "motion_notify_event",
                      GTK_SIGNAL_FUNC (on_drawingarea_motion_notify_event),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (vscrollbar1), "value_changed",
                      GTK_SIGNAL_FUNC (on_vscrollbar1_value_changed),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (hscrollbar1), "value_changed",
                      GTK_SIGNAL_FUNC (on_hscrollbar1_value_changed),
                      (gpointer)draw_data);
                      

  g_signal_connect ((gpointer) open_btn, "released",
                      GTK_SIGNAL_FUNC (on_open_activate),
                      (gpointer)(draw_data));

  g_signal_connect ((gpointer) save_btn, "released",
                      GTK_SIGNAL_FUNC (on_save_activate),
                      (gpointer)(draw_data));

  g_signal_connect ((gpointer) properties_btn, "released",
                      GTK_SIGNAL_FUNC (on_properties_activate),
                      (gpointer)(draw_data));

  g_signal_connect ((gpointer) preferences_btn, "released",
                      GTK_SIGNAL_FUNC (on_preference_activate),
                      (gpointer)(draw_data));

  g_signal_connect ((gpointer) zoom_in_btn, "released",
                      GTK_SIGNAL_FUNC (on_zoom_in_activate),
                      (gpointer)(draw_data));

  g_signal_connect ((gpointer) zoom_out_btn, "released",
                      GTK_SIGNAL_FUNC (on_zoom_out_activate),
                      (gpointer)(draw_data));

  g_signal_connect ((gpointer) select_path_btn, "released",
                    G_CALLBACK (on_select_path_activate),
                    (gpointer)(draw_data));
                    
  g_signal_connect ((gpointer) next_path_btn, "released",
                    G_CALLBACK (on_next_path_activate),
                    (gpointer)(draw_data));
  
  g_signal_connect ((gpointer) prev_path_btn, "released",
                    G_CALLBACK (on_prev_path_activate),
                    (gpointer)(draw_data));
                    
  g_signal_connect ((gpointer) attr_single_btn, "toggled",
                    G_CALLBACK (on_attr_single_toggled),
                    (gpointer)(draw_data));

  g_signal_connect ((gpointer) info_single_btn, "toggled",
                    G_CALLBACK (on_info_single_toggled),
                    (gpointer)(draw_data));
                    
  g_signal_connect ((gpointer) over_node_btn, "toggled",
                    G_CALLBACK (on_mouse_over_toggled),
                    (gpointer)(draw_data));
  
  g_signal_connect ((gpointer) select_node_btn, "toggled",
                    G_CALLBACK (on_select_node_toggled),
                    (gpointer)(draw_data));
                    
  g_signal_connect ((gpointer) edge_selecting_btn, "toggled",
                    G_CALLBACK (on_edge_selecting_toggled),
                    (gpointer)(draw_data));

  g_signal_connect ((gpointer) load_close_btn, "toggled",
                    G_CALLBACK (on_load_close_toggled),
                    (gpointer)(draw_data));
                    
/* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (main_window, main_window, "main_window");
  GLADE_HOOKUP_OBJECT (main_window, table1, "table1");
  GLADE_HOOKUP_OBJECT (main_window, menubar1, "menubar1");
  GLADE_HOOKUP_OBJECT (main_window, menuitem1, "menuitem1");
  GLADE_HOOKUP_OBJECT (main_window, menuitem1_menu, "menuitem1_menu");
  GLADE_HOOKUP_OBJECT (main_window, open_mnu, "open_mnu");
  GLADE_HOOKUP_OBJECT (main_window, save_mnu, "save_mnu");
  GLADE_HOOKUP_OBJECT (main_window, show_statistics_mnu, "show_statistics_mnu");
  GLADE_HOOKUP_OBJECT (main_window, show_gm_on_load_mode_mnu, "show_gm_on_load_mode_mnu");
  GLADE_HOOKUP_OBJECT (main_window, separatormenuitem1, "separatormenuitem1");
  GLADE_HOOKUP_OBJECT (main_window, quit_mnu, "quit_mnu");
  GLADE_HOOKUP_OBJECT (main_window, view_mnu, "view_mnu");
  GLADE_HOOKUP_OBJECT (main_window, view_mnu_menu, "view_mnu_menu");
  GLADE_HOOKUP_OBJECT (main_window, help_mnu, "help_mnu");
  GLADE_HOOKUP_OBJECT (main_window, help_mnu_menu, "help_mnu_menu");
  GLADE_HOOKUP_OBJECT (main_window, about_mnu, "about_mnu");
  GLADE_HOOKUP_OBJECT (main_window, drawingarea, "drawingarea");
  
  GLADE_HOOKUP_OBJECT (main_window, hpaned1, "hpaned1");
  GLADE_HOOKUP_OBJECT (main_window, statusbar1, "statusbar1");  
  GLADE_HOOKUP_OBJECT (main_window, vscrollbar1, "vscrollbar1");
  GLADE_HOOKUP_OBJECT (main_window, hscrollbar1, "hscrollbar1");
  
  GLADE_HOOKUP_OBJECT (main_window, open_btn, "open_btn");  
  GLADE_HOOKUP_OBJECT (main_window, save_btn, "save_btn");  
  GLADE_HOOKUP_OBJECT (main_window, properties_btn, "properties_btn");    
  GLADE_HOOKUP_OBJECT (main_window, preferences_btn, "preferences_btn");    
  GLADE_HOOKUP_OBJECT (main_window, zoom_in_btn, "zoom_in_btn");    
  GLADE_HOOKUP_OBJECT (main_window, zoom_out_btn, "zoom_out_btn");    

  GLADE_HOOKUP_OBJECT (main_window, single_aw_mode_mnu, "single_aw_mode_mnu");    
  GLADE_HOOKUP_OBJECT (main_window, single_iw_mode_mnu, "single_iw_mode_mnu");    
  GLADE_HOOKUP_OBJECT (main_window, aw_on_mouse_over_mode_mnu, "aw_on_mouse_over_mode_mnu");
  GLADE_HOOKUP_OBJECT (main_window, aw_on_node_select_mode_mnu, "aw_on_node_select_mode_mnu");  
  GLADE_HOOKUP_OBJECT (main_window, close_gw_after_load_mode_mnu, "close_gw_after_load_mode_mnu");  
  GLADE_HOOKUP_OBJECT (main_window, edge_selecting_mode_mnu, "edge_selecting_mode_mnu");  
    
  GLADE_HOOKUP_OBJECT (main_window, select_path_btn, "select_path_btn");
  GLADE_HOOKUP_OBJECT (main_window, next_path_btn, "next_path_btn");
  GLADE_HOOKUP_OBJECT (main_window, prev_path_btn, "prev_path_btn");
  
  GLADE_HOOKUP_OBJECT (main_window, attr_single_btn, "attr_single_btn");      
  GLADE_HOOKUP_OBJECT (main_window, info_single_btn, "info_single_btn");      
  GLADE_HOOKUP_OBJECT (main_window, over_node_btn, "over_node_btn");
  GLADE_HOOKUP_OBJECT (main_window, select_node_btn, "select_node_btn");
  GLADE_HOOKUP_OBJECT (main_window, edge_selecting_btn, "edge_selecting_btn");  
  GLADE_HOOKUP_OBJECT (main_window, load_close_btn, "load_close_btn");  
  
  GLADE_HOOKUP_OBJECT (main_window, draw_data->use_aliases_mnu, "use_aliases_mnu");  
  
  
  
  graph_app->get_GUI()->register_create_dockable_event_handler( new CreateDockedHandler( draw_data ) );
  
  
  gtk_window_add_accel_group (GTK_WINDOW (main_window), accel_group);
  
  GraphGenerationGUI *gen_window = graph_app->get_GUI()->create_graph_generation_window( "Graph Generation [ " + title + " ]");
  
  gen_window->register_load_handler( new MainWindowFileLoadHandler( main_window, graph_app, gen_window ) );
  gen_window->register_close_handler( new MainWindowGenCloseHandler( open_mnu, open_btn ) );
  
  g_object_set_data( G_OBJECT( main_window ), "generate_graph_window", (gpointer)gen_window );
  
  g_object_set_data( G_OBJECT( main_window ), "net_window", (gpointer)NULL );
  
  title_number++;
   
  return main_window; 
}

GtkWidget *make_view_menu( GraphDrawingData *draw_data, bool set_menu_items )
{
  GtkWidget *view_mnu_menu;
  GtkWidget *zoom_in_mnu;
  GtkWidget *zoom_out_mnu;
  GtkWidget *layout_mnu;
  GtkWidget *centering_mnu;
  GtkWidget *groups_mnu;
  GtkWidget *new_wnd_mnu;
  GtkWidget *properties_mnu;
  GtkWidget *preference_mnu;    
  GtkWidget *filter_mnu;
  GtkWidget *attributes_mnu;
  GtkWidget *find_mnu;
  GtkWidget *select_scenario_mnu;
  GtkWidget *select_path_menu;
  GtkWidget *find_scenario_mnu;
  GtkWidget *next_path_mnu;
  GtkWidget *prev_path_mnu;
  GtkWidget *sub_group_mnu;
  GtkWidget *undo_sub_group_mnu;
  GtkWidget *fit_menu;
  GtkWidget *fit_to_width_mnu;
  GtkWidget *fit_to_height_mnu;
  GtkWidget *fit_to_window_mnu;
  GtkWidget *fit_selected_to_window_mnu;
  GtkWidget *arbitrary_size_mnu;
  GtkWidget *separatormenuitem2;
  GtkWidget *dock_attr_mode_mnu;
  GtkWidget *dock_info_mode_mnu;
  GtkWidget *attr_aliases_mode_mnu;
  GtkAccelGroup *accel_group;
      
  accel_group = gtk_accel_group_new ();
  
  view_mnu_menu = gtk_menu_new ();
  gtk_widget_show (view_mnu_menu);
    
  zoom_in_mnu = gtk_image_menu_item_new_from_stock ("gtk-zoom-in", accel_group);
  gtk_widget_show (zoom_in_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), zoom_in_mnu);

  zoom_out_mnu = gtk_image_menu_item_new_from_stock ("gtk-zoom-out", accel_group);
  gtk_widget_show (zoom_out_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), zoom_out_mnu);

  layout_mnu = gtk_menu_item_new_with_mnemonic (_("_Layout..."));
  gtk_widget_show (layout_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), layout_mnu);
  
  fit_menu = gtk_menu_new();
  gtk_widget_show (fit_menu);
  fit_to_width_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window width"));
  gtk_widget_show (fit_to_width_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_width_mnu);
  
  fit_to_height_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window height"));
  gtk_widget_show (fit_to_height_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_height_mnu);

  fit_to_window_mnu = gtk_menu_item_new_with_mnemonic (_("Fit to window"));
  gtk_widget_show (fit_to_window_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_to_window_mnu);
  
  fit_selected_to_window_mnu = gtk_menu_item_new_with_mnemonic (_("Fit selection to window"));
  gtk_widget_show (fit_selected_to_window_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), fit_selected_to_window_mnu);
  
  arbitrary_size_mnu = gtk_menu_item_new_with_mnemonic (_("Arbitrary size"));
  gtk_widget_show (arbitrary_size_mnu);
  gtk_menu_append ( GTK_MENU(fit_menu), arbitrary_size_mnu);
  
  gtk_menu_item_set_submenu( GTK_MENU_ITEM( layout_mnu ), fit_menu );

  centering_mnu = gtk_menu_item_new_with_mnemonic (_("_Centering"));
  gtk_widget_show (centering_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), centering_mnu);
  
  separatormenuitem2 = gtk_menu_item_new ();
  gtk_widget_show (separatormenuitem2);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), separatormenuitem2);
  gtk_widget_set_sensitive (separatormenuitem2, FALSE);

  filter_mnu = gtk_menu_item_new_with_mnemonic (_("_Attributes filter"));
  gtk_widget_show (filter_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), filter_mnu);
  
  attributes_mnu = gtk_menu_item_new_with_mnemonic (_("_Node Attributes"));
  gtk_widget_show (attributes_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), attributes_mnu);

  groups_mnu = gtk_menu_item_new_with_mnemonic (_("_Groups"));
  gtk_widget_show (groups_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), groups_mnu);

  properties_mnu = gtk_image_menu_item_new_from_stock ("gtk-properties", accel_group);
  gtk_widget_show (properties_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), properties_mnu);
  
  preference_mnu = gtk_menu_item_new_with_mnemonic (_("_Preferences"));
  gtk_widget_show (preference_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), preference_mnu);

  find_mnu = gtk_image_menu_item_new_from_stock ("gtk-find", accel_group);
  gtk_widget_show (find_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), find_mnu);
  
  select_scenario_mnu = gtk_image_menu_item_new_with_mnemonic (_("Select _scenario"));
  gtk_widget_show (select_scenario_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), select_scenario_mnu);
  
  select_path_menu = gtk_menu_new ();
  gtk_widget_show (select_path_menu);
  
  find_scenario_mnu = gtk_image_menu_item_new_with_mnemonic (_("_Find scenario"));
  gtk_widget_show (find_scenario_mnu);
  gtk_container_add (GTK_CONTAINER (select_path_menu), find_scenario_mnu);
  
  next_path_mnu = gtk_image_menu_item_new_with_mnemonic (_("_Next scenario"));
  gtk_widget_show (next_path_mnu);
  gtk_container_add (GTK_CONTAINER (select_path_menu), next_path_mnu);
  
  prev_path_mnu = gtk_image_menu_item_new_with_mnemonic (_("_Previous scenario"));
  gtk_widget_show (prev_path_mnu);
  gtk_container_add (GTK_CONTAINER (select_path_menu), prev_path_mnu);
  
  sub_group_mnu = gtk_image_menu_item_new_with_mnemonic (_("Find _scenario group"));
  gtk_widget_show (sub_group_mnu);
  gtk_container_add (GTK_CONTAINER (select_path_menu), sub_group_mnu);
  
  undo_sub_group_mnu = gtk_image_menu_item_new_with_mnemonic (_("_Undo scenario group finding"));
  gtk_widget_show (undo_sub_group_mnu);
  gtk_container_add (GTK_CONTAINER (select_path_menu), undo_sub_group_mnu);
  
  if ( draw_data->graph_app->get_event_handler()->get_sub_group_finding_number() <= 0 )
    gtk_widget_set_sensitive( undo_sub_group_mnu, FALSE );
  
  gtk_menu_item_set_submenu( GTK_MENU_ITEM( select_scenario_mnu ), select_path_menu );

  new_wnd_mnu = gtk_menu_item_new_with_mnemonic (_("_New window"));
  gtk_widget_show (new_wnd_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), new_wnd_mnu);
  
  dock_info_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("Dock Information Windows on start"));
  gtk_widget_show (dock_info_mode_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), dock_info_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(dock_info_mode_mnu), draw_data->graph_app->get_extra_behavior_modes() & ScenarioApp::DOCK_INFO_ON_START );
  
  dock_attr_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("Dock Attributes Windows on start"));
  gtk_widget_show (dock_attr_mode_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), dock_attr_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(dock_attr_mode_mnu), draw_data->graph_app->get_extra_behavior_modes() & ScenarioApp::DOCK_ATTR_ON_START );
  
//  bool check_aliases_menu = (draw_data->graph_app->get_graph_view_context()->get_graph()->get_graph_attr_name_storage()->get_curr_alias_set() >= 0);
  bool check_aliases_menu = ((draw_data->graph_app->get_extra_behavior_modes( ) & ScenarioApp::USE_ATTR_ALIASES) == ScenarioApp::USE_ATTR_ALIASES);
  
  attr_aliases_mode_mnu = gtk_check_menu_item_new_with_mnemonic (_("Use attribute aliases"));
  gtk_widget_show (attr_aliases_mode_mnu);
  gtk_container_add (GTK_CONTAINER (view_mnu_menu), attr_aliases_mode_mnu);
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(attr_aliases_mode_mnu), check_aliases_menu );
    
  gtk_signal_connect (GTK_OBJECT (zoom_in_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_zoom_in_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (zoom_out_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_zoom_out_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (arbitrary_size_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_arbitrary_size_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_width_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_fit_to_width_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_height_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_fit_to_height_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_to_window_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_fit_to_window_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (fit_selected_to_window_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_fit_selected_to_window_activate),
                      (gpointer)draw_data);
                        
  gtk_signal_connect (GTK_OBJECT (centering_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_centering_activate),
                      (gpointer)draw_data);
  gtk_signal_connect (GTK_OBJECT (groups_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_groups_activate),
                      (gpointer)draw_data);

  gtk_signal_connect (GTK_OBJECT (filter_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_filter_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (attributes_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_attributes_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (properties_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_properties_activate),
                      (gpointer)draw_data);
					  
  gtk_signal_connect (GTK_OBJECT (preference_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_preference_activate),
                      (gpointer)draw_data);

  gtk_signal_connect (GTK_OBJECT (new_wnd_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_new_wnd_activate),
                      (gpointer)draw_data);
					  
  gtk_signal_connect (GTK_OBJECT (find_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_find_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (find_scenario_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_select_path_activate),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (next_path_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_next_path_activate),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (prev_path_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_prev_path_activate),
                      (gpointer)draw_data);

  gtk_signal_connect (GTK_OBJECT (sub_group_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_sub_group_activate),
                      (gpointer)draw_data);

  gtk_signal_connect (GTK_OBJECT (undo_sub_group_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_undo_sub_group_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (dock_info_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_dock_info_mode_activate),
                      (gpointer)draw_data);
                      
  gtk_signal_connect (GTK_OBJECT (dock_attr_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_dock_attr_mode_activate),
                      (gpointer)draw_data);
  
  gtk_signal_connect (GTK_OBJECT (attr_aliases_mode_mnu), "activate",
                      GTK_SIGNAL_FUNC (on_attr_aliases_mode_activate),
                      (gpointer)draw_data);
                      
  if ( set_menu_items )
  {
    draw_data->use_aliases_mnu = attr_aliases_mode_mnu;
    draw_data->dock_info_mode_mnu = dock_info_mode_mnu;
    draw_data->dock_attr_mode_mnu = dock_attr_mode_mnu;
    draw_data->undo_scenario_path = undo_sub_group_mnu;
  }
  return view_mnu_menu;
}

/**************************************************************************/
/**************************************************************************/


bool  can_hide_vscroll( GraphView *view, Rectangle rect, OneDValue width )
{
  bool res = true;
  
  if ( view->get_layout() == GraphView::FIT_TO_WIDTH )
  {
    Rectangle curr_view_rect = view->get_view_rect();
    Rectangle view_rect = curr_view_rect;
    Rectangle new_rect = rect;
    TwoDPoint right_bottom = rect.get_right_bottom_corner();
    
    new_rect.set_right_bottom_corner( TwoDPoint(right_bottom.get_x() + width, right_bottom.get_y()) );
    
    view->do_layout( new_rect );
    
    view_rect = view->get_view_rect();
    
    if ( view_rect.get_height() > rect.get_height() )
      res = false;
    
    view->set_view_rect( curr_view_rect );
  }
  return res;
}

bool  can_hide_hscroll( GraphView *view, Rectangle rect, OneDValue width )
{
  bool res = true;
  
  if ( view->get_layout() == GraphView::FIT_TO_HEIGHT )
  {
    Rectangle curr_view_rect = view->get_view_rect();
    Rectangle view_rect = curr_view_rect;
    Rectangle new_rect = rect;
    TwoDPoint right_bottom = rect.get_right_bottom_corner();
    
    new_rect.set_right_bottom_corner( TwoDPoint(right_bottom.get_x(), right_bottom.get_y() + width) );
    
    view->do_layout( new_rect );
    
    view_rect = view->get_view_rect();
    
    if ( view_rect.get_width() > rect.get_width() )
      res = false;
    
    view->set_view_rect( curr_view_rect );
  }
  return res;
}

void  update_scrollbars( GtkWidget* draw_area, GraphView *view )
{
  Rectangle  view_rect = view->get_view_rect();
  Rectangle      display_rect;
  GtkAdjustment *adjustment;
  GtkWidget     *scroll;
  gint           width;
  gint           height;
  gint           scroll_width;
  GtkRequisition scroll_rect;
  bool           hvisible = false;
  bool           vvisible = false;
  bool           hide = true;
  gdouble        *last_hvalue = 0;
  gdouble        *last_vvalue = 0;
  
  gdk_window_get_size( draw_area->window, &width, &height );
  
  display_rect.set_left_top_corner( TwoDPoint(0, 0) );
  display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
  
  scroll = lookup_widget( draw_area, "vscrollbar1" );
  
  last_vvalue = (gdouble*)g_object_get_data( G_OBJECT(scroll), "last_value" );
  *last_vvalue = 0;
  
  gtk_widget_size_request( scroll, &scroll_rect );
  scroll_width = scroll_rect.width;
  
  vvisible = (bool)g_object_get_data( G_OBJECT(scroll), "visible" );
  if ( vvisible )
    hide = can_hide_vscroll( view, display_rect, scroll_width );
  
  if ( view_rect.get_height() <= height && hide )
  {
    view->set_vscroll_value( view_rect.get_left_top_corner().get_y() );
    gtk_widget_hide( scroll );
    gdk_window_get_size( draw_area->window, &width, &height );
    display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
    view->do_layout( display_rect );
    vvisible = false;
  }
  else
  {
    adjustment = gtk_range_get_adjustment( GTK_RANGE(scroll) );
    
    gtk_widget_show( scroll );
    gdk_window_get_size( draw_area->window, &width, &height );
    
    gdk_window_get_size( draw_area->window, &width, &height );
    display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
    view->do_layout( display_rect );
    
    view_rect = view->get_view_rect();
    
    if ( view_rect.get_right_bottom_corner().get_y() < height )
      view->set_vscroll_value( view_rect.get_right_bottom_corner().get_y() - height );
    if ( view_rect.get_left_top_corner().get_y() > 0 )
      view->set_vscroll_value( -view_rect.get_left_top_corner().get_y() );
        
    adjustment->lower = view_rect.get_left_top_corner().get_y() - 1;
    adjustment->upper = view_rect.get_right_bottom_corner().get_y() + 1;
    adjustment->page_size = height;
    adjustment->step_increment = 5;
    adjustment->page_increment = height;
    
    adjustment->value = *last_vvalue;
    
    gtk_adjustment_changed( adjustment );
//    gtk_adjustment_value_changed( adjustment );
    vvisible = true;
  }
  g_object_set_data( G_OBJECT(scroll), "visible", (gpointer)vvisible );
  //g_object_set_data( G_OBJECT( scroll ), "last_value", (gpointer)last_vvalue );
   
  scroll = lookup_widget( draw_area, "hscrollbar1" );
  
  last_hvalue = (gdouble*)g_object_get_data( G_OBJECT(scroll), "last_value" );
  *last_hvalue = 0;
  
  hide = true;
  
  hvisible = (bool)g_object_get_data( G_OBJECT(scroll), "visible" );
  
  if ( hvisible )
    hide = can_hide_hscroll( view, display_rect, scroll_width );
  
  if ( view_rect.get_width() <= width && hide )
  {
    view->set_hscroll_value( view_rect.get_left_top_corner().get_x() );
    gtk_widget_hide( scroll );
    gdk_window_get_size( draw_area->window, &width, &height );
    display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
    view->do_layout( display_rect );
    hvisible = false;
  }
  else
  {  
    adjustment = gtk_range_get_adjustment( GTK_RANGE(scroll) );
    
    gtk_widget_show( scroll );
    gdk_window_get_size( draw_area->window, &width, &height );
    display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
    view->do_layout( display_rect );
    
    view_rect = view->get_view_rect();
    
    if ( view_rect.get_right_bottom_corner().get_x() < width )
      view->set_hscroll_value( view_rect.get_right_bottom_corner().get_x() - width );
    if ( view_rect.get_left_top_corner().get_x() > 0 )
      view->set_hscroll_value( -view_rect.get_left_top_corner().get_x() );
        
            
    adjustment->lower = view_rect.get_left_top_corner().get_x() - 1;
    adjustment->upper = view_rect.get_right_bottom_corner().get_x() + 1;
    adjustment->step_increment = 5;
    adjustment->page_size = width;
    adjustment->page_increment = width;
    
    
    adjustment->value = *last_hvalue;
    
    gtk_adjustment_changed( adjustment );
    
//    gtk_adjustment_value_changed( adjustment );
    hvisible = true;
  }
  g_object_set_data( G_OBJECT( scroll ), "visible", (gpointer)hvisible );
  //g_object_set_data( G_OBJECT( scroll ), "last_value", (gpointer)last_hvalue );
};
