#ifndef _CALLBACKS_H_
#define _CALLBACKS_H_

#include <gtk/gtk.h>

gboolean
on_main_window_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

gboolean
on_drawingarea_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

gboolean
on_drawingarea_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);
                                        
gboolean
on_drawingarea_motion_notify_event     (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data);                                        

gboolean
on_drawingarea_popup_menu              (GtkWidget       *widget,
                                        gpointer         user_data);

gboolean
on_drawingarea_expose_event            (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data);

void
on_file_cancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data);
void
on_file_ok_button_clicked (GtkButton *button,  gpointer user_data);

gboolean
on_drawingarea_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data);

void
on_hscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data);

void
on_vscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data);

void 
on_del_attack_activate                 (GtkMenuItem     *menuitem, 
                                        gpointer  user_data);


void on_single_aw_mode_activate( GtkMenuItem *menuitem, gpointer  user_data );
void on_single_iw_mode_activate( GtkMenuItem *menuitem, gpointer  user_data );
void on_aw_on_mouse_over_mode_activate( GtkMenuItem *menuitem, gpointer  user_data );

void on_aw_on_node_select_mode_activate( GtkMenuItem *menuitem, gpointer  user_data );

void on_close_gw_after_load_mode_activate( GtkMenuItem *menuitem, gpointer  user_data );
void on_edge_selecting_mode_activate( GtkMenuItem *menuitem, gpointer  user_data );

void on_attr_single_toggled( GtkToggleButton *togglebutton, gpointer  user_data);
void on_mouse_over_toggled(GtkToggleButton *togglebutton, gpointer  user_data);
void on_info_single_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_edge_selecting_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_load_close_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_select_node_toggled(GtkToggleButton *togglebutton, gpointer  user_data);

void on_reduce_graph_activate( GtkMenuItem *menuitem, gpointer  user_data );
void on_critical_attack_activate( GtkMenuItem *menuitem, gpointer  user_data );
void on_critical_measure_activate( GtkMenuItem *menuitem, gpointer  user_data );



void
on_open_activate                       (GtkWidget       *widget,
                                        gpointer         user_data);


void
on_comp_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void on_show_graph_statistics          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void on_show_gm_on_load_mode            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
                                        
void
on_save_activate                       (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_zoom_in_activate                    (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_zoom_out_activate                   (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_fit_to_window_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void on_fit_selected_to_window_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void on_select_path_activate           (GtkWidget       *widget,
                                        gpointer         user_data);

void on_next_path_activate           (GtkWidget       *widget,
                                        gpointer         user_data);

void on_prev_path_activate           (GtkWidget       *widget,
                                        gpointer         user_data);
                                        
void on_sub_group_activate           (GtkWidget       *widget,
                                        gpointer         user_data);

void on_undo_sub_group_activate      (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_fit_to_width_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_fit_to_height_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_arbitrary_size_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void
on_centering_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_groups_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_properties_activate                 (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_preference_activate                 (GtkWidget       *widget,
                                        gpointer         user_data);

void 
on_filter_activate                     (GtkMenuItem      *menuitem, 
                                        gpointer          user_data );
void
on_attributes_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_find_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
                                        


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_new_wnd_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
                                        
void
on_dock_attr_mode_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_dock_info_mode_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
                                        
                                        
void on_attr_aliases_mode_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

#endif
