#include <iostream>
#include <set>
#include <map>
#include <list>
#include <vector>
#include <stdlib.h>
#include <cstring>
#include <string>
#include <stdio.h>
#include <outpost.h>
#include "scanners.hpp"

StringSet* Scanner::getIP(const string &host_name) throw(UnknownHostError)
{
  ScannedHostMapIter  host_iter;
  StringSet           *set = new StringSet();
   
  if ((host_iter = hosts.find(host_name)) == hosts.end())
  {
    if (add_host_info(host_name))
      host_iter = hosts.find(host_name);
  }
   
  if (host_iter != hosts.end())
  {
    set->insert((*host_iter).second->IP.begin(), (*host_iter).second->IP.end());
    return set;
  }
  else
    throw UnknownHostError("Host" + host_name + "doesn't exist");
  
  return 0;
}

PortSet* Scanner::getServices(const string &host_name) throw(UnknownHostError)
{
  ScannedHostMapIter  host_iter;
  PortSet           *set = new PortSet();
  
  if ((host_iter = hosts.find(host_name)) == hosts.end())
  {
    if (add_host_info(host_name))
      host_iter = hosts.find(host_name);
  }
   
  if (host_iter != hosts.end())
  {
    set->insert((*host_iter).second->services.begin(), (*host_iter).second->services.end());    
    return set;
  }
  else
    throw UnknownHostError("Host" + host_name + "doesn't exist");
  
  return 0;
}

StringSet* Scanner::getCVEs(const string &host_name) throw(UnknownHostError)
{
  ScannedHostMapIter  host_iter;
  StringSet           *set = new StringSet();
  
  if ((host_iter = hosts.find(host_name)) == hosts.end())
  {
    if (add_host_info(host_name))
      host_iter = hosts.find(host_name);
  }
  
  if (host_iter != hosts.end())
  {
    set->insert((*host_iter).second->CVEs.begin(), (*host_iter).second->CVEs.end());    
    return set;
  }
  else
    throw UnknownHostError("Host" + host_name + "doesn't exist");
  
  return 0;
};
