/* File reachwrap.c -- wrappers around the Caml functions */

#include <stdio.h>
#include <string.h>
#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include <caml/callback.h>

int reachable(const char *topo, const char *spec)
{
  static value *reach_closure = NULL;
  if (reach_closure == NULL) reach_closure = caml_named_value("reachable");

  return Bool_val(callback2(*reach_closure, copy_string(topo), copy_string(spec)));
}

