
let reachable topo_file spec_file =
	let graph = Reachable.load_file topo_file in
	let spec = Reachable.read_spec spec_file in
	let propres = Reachable.get_spec graph spec Savant.savant in
	let result = Srv.savant_call propres in
	  (
		 (*
		 Printf.printf "Spec term: ";
     Term.print_term_nl spec;
	   Printf.printf "Propagation result: ";
	   Term.print_term_nl propres;
	   Printf.printf "Result: ";
	   Term.print_term_nl result;
			*)
	   match result with
		   Term.Name "$T" -> true
		 | Term.Name "$F" -> false
		 | _ -> false
	  )

(* Export to C *)
let _ = Callback.register "reachable" reachable
