
#ifndef _OUTPOST_HEADER_
#define _OUTPOST_HEADER_

#include <set>
#include <string>
#include <cppdecl.h>

using namespace std;

typedef set<string> StringSet;

class FatalError {

public:
  FatalError() { FatalError("unknown error"); }
  FatalError(char *error) { errorString = error; }

private:
  char *errorString;
};

class DBApi {

public:
  
  DBApi() throw(FatalError) {
    serverConfig = new (struct serverConfigType);
    ReadConfig("outpost.conf");
  }
  DBApi(const char *ConfigFile) throw(FatalError) {
    serverConfig = new (struct serverConfigType);
    ReadConfig(ConfigFile);
  }

  ~DBApi() { delete serverConfig; }

  // Database interface
  void EstablishDBConnection() throw(FatalError);
  StringSet *DBGetData(const char *hostname, DBDataType dbtype, int MaxLength, const char *aux = "")
    throw(FatalError);
  int DBGetPidByHostAndService(const char *hostname, const char *svcname) throw(FatalError);
  void TerminateDBConnection();

private:
  void ReadConfig(const char *ConfigFile) throw(FatalError);
  
private:
  struct serverConfigType *serverConfig;
};

#endif // _OUTPOST_HEADER_
