/*
 * $Id: cppdecl.h,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $
 *
 * *************** Property of the Mitre Corporation *****************
 * Redistribution of this code in source or binary form for any reason
 * is prohibited without express permission of the Mitre Corporation.
 *
 * Copyright (C) 2000 - The Mitre Corporation
 * *******************************************************************
 */


/*
 * Define external global variables, data types, and functions
 * accessible to probes
 */

#ifndef __CPPDECL_HEADER__
#define __CPPDECL_HEADER__

#include "control.h"

extern "C" {
  int EstablishDBConnection_Oracle(struct serverConfigType *serverConfig);
  void TerminateDBConnection_Oracle();

  int GetValuesForHost(const char *filter, const char *aux_filter, char **values,
		       const int count, const short datatype);
  int GetCountForHost(const char *filter, const char *aux_filter, int *count, const short datatype);
  int GetPidByHostAndService(const char *hostname, const char *svcname, int *pid);

  int ParseConfigFile(char *, struct serverConfigType *);
  void ClearMemory(serverConfigType *);

  void CloseDebugLog();
  char *FormatErrorMsg(int errorType, int msgFormat, char *message, ...);
  void OpenDebugLog(int level, char *file, int overwrite);
  void LogDebugMsg(int level, char *msg, ...);
  void LogErrorMsg(char *message);

  int reach(char *ipaddr1, char *ipaddr2, int port);
  int testing(int port);
  void CamlStartup(char ** argv);
}

#endif

