/*
 * $Id: cdecl.h,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $
 *
 * *************** Property of the Mitre Corporation *****************
 * Redistribution of this code in source or binary form for any reason
 * is prohibited without express permission of the Mitre Corporation.
 *
 * Copyright (C) 2000 - The Mitre Corporation
 * *******************************************************************
 */


/*
 * Define external global variables, data types, and functions
 * accessible to probes
 */

#ifndef __CDECL_HEADER__
#define __CDECL_HEADER__

#include "control.h"

/*
 * Function Definitions
 */
void AddNode(struct nvListType **list, char *name, char *value);

char *CleanString(char *string, int makelower);
void ClearMemory(serverConfigType *);

void DestroyReply(struct replyType *reply);
void DestroySemaphore(char *);
void DestroySharedMem(char *);

int Exists(struct nvListType *list, char *name);

void FreeList(struct nvListType **);

void GenerateRandomString(char *hashOut);
int GetInput(struct nvListType **, struct replyType *);
int GetOSType(char *ostype);
int GetPatchInfoByID(struct patchInfoType **patchInfo, int patchid, struct replyType *reply);
int GetPatchInfoByName(struct patchInfoType **patchInfo, char *patchName, int match, struct replyType *reply);
char *GetTimeStamp();
char *GetValue(struct nvListType *, char *);

void InitializePatching(struct patchConfigType *patchingConfig);
void InitializeReply(struct replyType *reply, char *contentType);
int InstallAnalysis(struct patchConfigType *patchConfig, struct replyType *reply);
int InstallPatch(struct serverConfigType *, struct nvListType *, struct replyType *, int);
int IsPatchInstalled(char *clientid, char *patchName, int match, struct replyType *reply);

int MakePatchInfoNode(struct patchInfoType **patchInfo, int patchid, char *patchName, struct replyType *reply);

void CloseDebugLog();
char *FormatErrorMsg(int errorType, int msgFormat, char *message, ...);
void OpenDebugLog(int level, char *file, int overwrite);
void LogDebugMsg(int level, char *msg, ...);
void LogErrorMsg(char *message);

int ParseConfigFile(char *, struct serverConfigType *);
int ParsePatchName(char *patchName, char *base, char *version, struct replyType *reply);
int PatchAnalysis(struct serverConfigType *, struct nvListType *, struct replyType *, int);
void PrintVersion();

int RemoveAnalysis(struct patchConfigType *patchConfig, struct replyType *reply);
void ReturnAnalysisFailed(char *);
void ReturnAnalysisSuccess(char *);
void ReturnInstallFailed(char *);
void ReturnProbeXML(char *);
void ReturnTerminationSuccess();

void SendServerShutdown(char *);
void SetErrorLog(char *file);
int SetPersistentMessage(char *, char *, char *, struct replyType *);
void SendReply(struct replyType *reply);
void SetErrorReply(struct nvListType **list, char *message);
void SetReply(struct nvListType **list, char *name, char *value);
int StartPatchingProcess(struct serverConfigType *, struct nvListType *, struct replyType *);

void TerminatePatching(struct serverConfigType *, struct nvListType *, struct replyType *);

int WaitForProbeData(char *, char **, struct replyType *);
 int WindowResponse(struct serverConfigType *, struct nvListType *, struct replyType *);

#endif

