(* $Id: srv.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

let act cin cout =
  let lexbuf = Lexing.from_channel cin in
  try 
    while true do
      let term = Read_term.read_term lexbuf in
      Term.display_term_nl cout (Savant.savant term);
      flush cout
    done
  with End_of_file -> ()

let savant_server path =
  let addr = Unix.ADDR_UNIX(path) in
  Unix.establish_server act addr

let savant_call t =
	Savant.savant t
