/* $Id: parser.mly,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ */

/* parser for Otter terms in pure prefix form  */

/* Author: John D. Ramsdell */

%{
open Term

let is_digits s =
  let rec loop i =
    if i < 0 then
      true
    else 
      let c = String.get s i in
      if c < '0' || c > '9' then
	false
      else
	loop (i - 1) in
  loop (String.length s - 1)      

(*
  This function implements the fixup transformations:
  change !=(a,b) to -(=(a,b))
  change -(3)    to -3              not recursive, -(-(3)) -> -(-3))
  change +(3)    to +3              not recursive, +(+(3)) -> +(+3))
*)
let complex_term(s, ts) =
  match (s, ts) with
    ("-", [Name(a)]) ->
      if is_digits a then
	Name("-" ^ a)
      else
	Complex(s, ts)
  | ("+", [Name(a)]) ->
      if is_digits a then
	Name("+" ^ a)
      else
	Complex(s, ts)
  | ("!=", [a; b]) ->
      Complex("-", [Complex("=", [a; b])])
  | _ -> 
      Complex(s, ts)

let simple_term s =
  let c = String.get s 0 in
  if (c >= 'A' && c <= 'Z') || c == '_' then
    Variable s
  else
    Name s
%}

%token <string> NAME
%token MINUS, PLUS, LPAR, RPAR, LBRA, RBRA, PERIOD, COMMA, VBAR, EOF
%start main
%type <Term.term> main
%%

main:
  term PERIOD             { $1 }
| EOF                     { raise End_of_file }
;

term:
  NAME args               	{ complex_term($1, $2) }
| NAME                    	{ simple_term $1 }
| LBRA terms RBRA	  	{ Complex("$list", List.rev $2) }
| LBRA term VBAR term RBRA	{ Complex("$pair", [$2; $4]) }
| MINUS args              	{ complex_term("-", $2) }
| MINUS term              	{ complex_term("-", [$2]) }
| MINUS                   	{ simple_term "-" }
| PLUS args               	{ complex_term("+", $2) }
| PLUS term               	{ complex_term("+", [$2]) }
| PLUS                    	{ simple_term "+" }
;

args:
  LPAR terms RPAR         { List.rev $2 }
;

terms:
  term                    { [$1] }
| terms COMMA term        { $3 :: $1 }
;
