(* $Id: graph_term.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

open Term

open Actions

open Action_term

open Graph

exception Bad_geometry

let geom2term = function
    Node(label, a) -> 
      Complex("node", [Name label; list2term action2term a])
  | Edge(src, dest, a) ->
      Complex("edge", [Name src; Name dest; list2term action2term a])

let term2geom t = 
  try
    match t with
      Complex("node", [Name label; ls]) ->
	Node(label, term2list term2action ls)
    | Complex("edge", [Name src; Name dest; ls]) ->
	Edge(src, dest, term2list term2action ls)
    | _ -> raise Bad_geometry
  with
    Bad_list -> raise Bad_geometry
  | Bad_action ->  raise Bad_geometry

let print_geometry cout geom =
  display_term cout (geom2term geom);
  output_string cout ".\n"

let print_geometries cout geoms =
  List.iter (fun geom -> print_geometry cout geom) geoms
