(* $Id: action_term.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

open Actions

open Term

(* Term converters *)

let bits2term = function
    "" -> "0"
  | b -> b

let action2term = function
    Accept(b, m) -> Complex("accept", [Name(bits2term b); Name(bits2term m)])
  | Reject(b, m) -> Complex("reject", [Name(bits2term b); Name(bits2term m)])

let term2action = function
    Complex("accept", [Name b; Name m]) -> Accept(b, m)
  | Complex("reject", [Name b; Name m]) -> Reject(b, m)
  | _ -> raise Bad_action

