
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#include "hostnameip.h"


#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

string HostNameToIP( const string &name )
{
  string res = "";
  struct in_addr addr;
  struct hostent *target;
    
  addr.s_addr = inet_addr( name.c_str() );
  
  if ( addr.s_addr == INADDR_NONE )
  {
    target = gethostbyname( name.c_str() );
    
    if ( target )
      memcpy( &(addr), target->h_addr_list[0], sizeof(struct in_addr));
  }
  
  if ( addr.s_addr != INADDR_NONE )
  {
    char buf[255];
    unsigned long ip = addr.s_addr;
        
    memset( buf, 0, sizeof( buf ) );
        
    for ( int i = 3; i >= 0; i-- )
    {
      buf[0] = '\0';
      if ( i != 3 )
        res += '.';
          
      sprintf( buf, "%u", (ip & 0xFF) );
          
      ip >>= 8;
          
      res += string( (const char*) buf );
    }
  }
  
  return res;
}

string HostIPToName( const string &ip )
{
  string res = "";
  string ip_n[4];
  unsigned int start_pos = 0;
  unsigned int pos = 0;
  struct in_addr addr;
  int i;
  struct hostent *target;
  
  for ( i = 0; i < 4; i++ )
  {
    pos = ip.find( '.', start_pos );
    
    if ( start_pos < ip.length() )
      ip_n[i] = ip.substr( start_pos, pos - start_pos );
    else
      ip_n[i] = "0";
    
    start_pos = ( pos != string::npos )? pos + 1: string::npos;
  }
  
  addr.s_addr = 0;
  for ( i = 3; i >= 0; i-- )
    addr.s_addr = (addr.s_addr << 8) | ( (atoi( ip_n[i].c_str() )) & 0xFF );
  
  target = gethostbyaddr( (char *)&addr.s_addr, sizeof(struct in_addr), AF_INET );
      
  if ( target != 0 )
    res = string(target->h_name);
  else
  {
    char *c_name = inet_ntoa( addr );
  
    if ( c_name != 0 )
      res = string( c_name );
  }

  return res;
}

