(* $Id: lexer.mll,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* scanner for a frame geometry *)

(* Author: John D. Ramsdell *)

(* Copyright (C) 2001 The MITRE Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)

{
open Parser

let strip s =
  let n = String.length s in
  String.sub s 1 (n - 2)
} 
rule token = parse
  (* skip comments starting with % *)
  '%' [^ '\n' ]* '\n'	    { token lexbuf }
| [' ' '\t' '\r' '\n']      { token lexbuf }
| '"'[^ '"' '\r' '\n']*'"'  { STRING(strip(Lexing.lexeme lexbuf)) }
| '('                       { LPAR }
| ')'                       { RPAR }
| '['                       { LBRA }
| ']'                       { RBRA }
| ','                       { COMMA }
| '.'                       { PERIOD }
| "node"                    { NODE }
| "edge"                    { EDGE }
| "Accept"                  { ACCEPT }
| "Reject"                  { REJECT }
| eof                       { EOF }
