(* $Id: bdd_utils.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* some common binary operations on bdds and a simple printer *)

(* John D. Ramsdell -- Decemeber 1998 *)

(* Copyright (C) 2001 The MITRE Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)

open Bdd

open Format

let conjoin x y = ite(x, y, falsehood)

let disjoin x y = ite(x, truth, y)

let difference x y = conjoin x (complement y)

let implies x y = ite(x, y, truth)

let path2bdd path =
  let rec loop path bdd =
    match path with 
      [] -> bdd
    | (negate, var) :: p ->
	let b = identity var in
	loop p (conjoin (if negate then complement b else b) bdd) in
  loop path truth

let rec print_bdd b =
  if is_truth b then
    print_char 'T'
  else if is_falsehood b then
    print_char 'F'
  else if is_complement b then
    begin
      print_char '~';
      print_bdd (complement b)
    end
  else
    let v = variable b in
    let c = consequent b in		(* assume c not complemented *)
    let a = alternative b in
    if is_truth c && is_falsehood a then
      print_int v
    else
      begin
	print_char '(';
	open_box 0;
	print_int v;
	if not(is_truth c) then
	  begin
	    print_char '*';
	    print_bdd c
	  end;
	if not(is_falsehood a) then
	  begin
	    print_space();
	    print_string "+ ~";
	    print_int v;
	    if not(is_truth a) then
	      begin
		print_char '*';
	      	print_bdd a
	      end
	  end;
	close_box();
	print_char ')'
      end
