#include "StateInfo.hpp"

ostream &operator<<( ostream &out, NetInfo &net )
{
  map<string,int>::iterator curMap;
  multimap<string,int>::iterator curSVar;
  map<string,pair<int,int> >::iterator curSrv;
  set<string>::iterator curVar;

  out << net.numHosts << endl;
  for( curMap = net.hosts.begin(); curMap != net.hosts.end(); curMap++ )
    out << curMap->first << " " << curMap->second << endl;

  out << net.numAttacks << endl;
  for( curMap = net.attacks.begin(); curMap != net.attacks.end(); curMap++ )
    out << curMap->first << " " << curMap->second << endl;

  out << net.numServices << endl;
  for( curSrv = net.services.begin(); curSrv != net.services.end(); curSrv++ )
    out << curSrv->first << " " << curSrv->second.first << " " <<
	curSrv->second.second << endl;

  out << net.numVars << endl;
  for( curSVar = net.vars.begin(); curSVar != net.vars.end(); curSVar++ )
    out << curSVar->first << " " << curSVar->second << endl;

  out << net.numIVars << endl;
  for( curVar = net.ignore.begin(); curVar != net.ignore.end(); curVar++ )
    out << *curVar << endl;

  return out;
}


void ParseNetInfo( istream &in, NetInfo &net )
{
  int i;
  string temp;

  in >> net.numHosts;
  for( i = 1; i <= net.numHosts; i++ )
    {
      in >> temp;
      in >> net.hosts[temp];
    }

  in >> net.numAttacks;
  for( i = 1; i <= net.numAttacks; i++ )
    {
      in >> temp;
      in >> net.attacks[temp];
    }

  in >> net.numServices;
  for( i = 1; i <= net.numServices; i++ )
    {
      pair<int,int> x;
      in >> temp;
      in >> x.first;
      in >> x.second;
      net.services[temp] = x;
    }

  in >> net.numVars;
  for( i = 1; i <= net.numVars; i++ )
    {
      int x;     

      in >> temp;
      in >> x;
      net.vars.insert( mType( temp, x ));
    }

  in >> net.numIVars;
  for( i = 1; i <= net.numIVars; i++ )
    {
      in >> temp;
      net.ignore.insert(temp);
    }
}


// itoa : int * (char *) -> (char *)
// The only precondition to this function is that
// the array pointed to by 'storage' is large enough to hold
// the resulting string.
//
// Arguments:
// n - argument to convert
// storage - pointer to location where resulting string is stored
// 
// Return Value: pointer to first element of result
char *itoa( int n, char *storage )
{
  int digit;
  int i = 0;

  // Get the first digit.
  digit = n % 10;
  n /= 10;
  storage[i++] = (char)(digit+48);

  // If there are any more digits, convert them as well.
  for( ; n > 0; n /= 10, i++ )
    {
      digit = n % 10;
      storage[i] = (char)(digit+48);
    }
  storage[i] = '\0';

  // The string we created is backwards, so reverse it.
  int len = i;
  int end = i/2 - 1; // to avoid zeroing the middle number if len is odd

  for( i = 0; i <= end; i++ )
    {
      storage[i] ^= storage[len-i-1];
      storage[len-i-1] ^= storage[i];
      storage[i] ^= storage[len-i-1];
    }

  return storage;
}


// priv2int() - convert privilege strings to integers
int priv2int( DOMString priv )
{
  char *str = priv.transcode();

  // Check for "root", "user", and "none".
  if( !strcmp(str,"root"))
    return 3;
  else if( !strcmp(str,"user"))
    return 2;
  else // "none"
    return 1;
}
