
/*
 * $Log: Network.cpp,v $
 * Revision 1.8  2004/04/15 19:07:40  alex
 * Support of firewalls
 *
 * Revision 1.7  2004/03/04 23:39:33  alex
 * *** empty log message ***
 *
 * Revision 1.6  2004/02/17 00:40:21  alex
 * Calculating performance numbers
 *
 * Revision 1.4  2003/11/25 20:54:52  alex
 * Host objects: additional features
 *
 * Revision 1.2  2003/10/31 09:45:26  roman
 * *** empty log message ***
 *
 * Revision 1.1.1.1  2003/10/28 22:15:44  rl
 * Initial import
 *
 * Revision 1.3  2003/04/03 12:52:01  RL
 * full xml_comp version
 *
 * Revision 1.6  2001/06/20 balaji
 * Added support for NetInfo information struct
 *
 * Revision 1.5  2001/05/21 02:59:02  oleg
 * Finished preconditions processing
 *
 * Revision 1.4  2001/05/14 22:03:03  oleg
 * Writing attack processing
 *
 * Revision 1.3  2001/05/14 01:17:28  oleg
 * Finished hosts
 *
 * Revision 1.2  2001/05/12 23:49:42  oleg
 * Development checkpoint
 *
 * Revision 1.1  2001/05/12 03:38:00  oleg
 * Initial revision
 *
 */

#include <fstream>
#include "Network.hpp"
#include "StateInfo.hpp"
#include <outpost.h>
#ifndef NO_ODBC
#include "odbc.hpp" 
#endif
#include "cint.h"

//RL
#include <sstream>
#include <iostream>
#include <string>
#include "scanners.hpp"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>

#include <xercesc/framework/MemBufInputSource.hpp>

#include <xercesc/dom/deprecated/DOM_DOMException.hpp>

#include <xercesc/dom/deprecated/DOMParser.hpp>
#include <xercesc/dom/deprecated/DOM.hpp>
#include "ErrorReporter.hpp"

#include "hostnameip.h"


const long ModelMemUsage::NodeImplSize    = sizeof(void*) + sizeof(short) + sizeof(int);/*base node class size*/
const long ModelMemUsage::ChildImplSize   = 2 * sizeof(void*);/*next and previous nodes*/
const long ModelMemUsage::ParentImplSize  = 3 * sizeof(void*) + 2 * sizeof(int) + /*children list */
                                            ChildImplSize;
const long ModelMemUsage::ElementImplSize = sizeof(DOMString) + /*node name */
                                            ParentImplSize +
                                            sizeof(void*) + 2 * sizeof(bool) + sizeof(int); /*attributes storage*/
const long ModelMemUsage::CharDataImplSize = sizeof(DOMString);
const long ModelMemUsage::AttrImplSize     = sizeof(DOMString) + sizeof(void*); /*name and value*/
const long ModelMemUsage::DocImplSize      = 9 * sizeof(void*) + 
                                             sizeof(int) + 257 * sizeof(void*) + /*strings pool (hash table)*/
                                             ParentImplSize;
const long ModelMemUsage::EntityImplSize   = 4 * sizeof(DOMString) + sizeof(void*) + ParentImplSize;
const long ModelMemUsage::NotationImplSize = 3 * sizeof(DOMString);
const long ModelMemUsage::DocTypeImplSize  = 4 * sizeof(DOMString) + 3* sizeof(void*) + sizeof(bool) + ParentImplSize;


long ModelMemUsage::GetDOMStringSetSize( const DOMStringSet &str_set )
{
  long res = 0;
  
  for (DOMStringSet::const_iterator it = str_set.begin(); it != str_set.end(); it++ )
    res += GetDOMStringSize( *it ) + sizeof(DOMString);
  
  return res;
}

long ModelMemUsage::GetDOMStringMapSize( const DOMStringMap &str_map )
{
  long res = 0;
  
  for (DOMStringMap::const_iterator it = str_map.begin(); it != str_map.end(); it++ )
    res += GetDOMStringSize( it->first ) + GetDOMStringSize( it->second ) + 
           2 * sizeof(DOMString);
  
  return res;
}

long ModelMemUsage::GetDOM_DocumentSize( DOM_Node *node )
{
  DOMStringSet used_str;
  return GetDOM_NodeSize( node, used_str );
}

long ModelMemUsage::GetDOM_NodeSize( DOM_Node *node, DOMStringSet &used_str )
{
  long dom_node_size = NodeImplSize;
  long res = 0;
  bool has_name = true;
  bool has_value = true;

  switch (node->getNodeType()) {
    
  case DOM_Node::ELEMENT_NODE:
    
    dom_node_size += ElementImplSize; 
    if ( node->hasAttributes() ) {
      DOM_NamedNodeMap attr = node->getAttributes();
    
      for ( int i = 0; i < attr.getLength(); i++ ) {
        DOM_Node attr_node = attr.item(i);
        dom_node_size += sizeof(void*) + GetDOM_NodeSize( &attr_node, used_str );
      }
    }
    has_value = false;
    break;
    
  case DOM_Node::ATTRIBUTE_NODE:
    dom_node_size += AttrImplSize;
    break;
  
  case DOM_Node::ENTITY_REFERENCE_NODE:
  case DOM_Node::ENTITY_NODE:
    has_value = false;
    dom_node_size += EntityImplSize;
    break;
  
  case DOM_Node::CDATA_SECTION_NODE:
  case DOM_Node::COMMENT_NODE:
  case DOM_Node::TEXT_NODE:
    has_name = false;
    dom_node_size += CharDataImplSize;
    break;
  
  case DOM_Node::NOTATION_NODE:
    has_value = false;
    dom_node_size += NotationImplSize;
    break;
  
  case DOM_Node::DOCUMENT_NODE:
  case DOM_Node::DOCUMENT_FRAGMENT_NODE:
    dom_node_size += DocImplSize;
    has_name = false;
    has_value = false;
    break;
  
  case DOM_Node::DOCUMENT_TYPE_NODE:
    has_value = false;
    break;
  
  default:
    dom_node_size += ChildImplSize;
  }
  
  res += dom_node_size;
  
  if ( has_name ) {
    DOMString name = node->getNodeName();
    
    if ( name != NULL )
      if ( used_str.find(name) == used_str.end() ) {
        res += GetDOMStringSizeEx( name ) + 
               sizeof(DOMString) + sizeof(void*); //size in pool
        used_str.insert( name );
      }
  }

  if ( has_value ) {  
    DOMString value = node->getNodeValue();
    
    if ( value != NULL )
      if ( used_str.find(value) == used_str.end() ) {
        res += GetDOMStringSizeEx( value ) + 
               sizeof(DOMString) + sizeof(void*);//size in pool
        used_str.insert( value );
      }
  }
  
  if ( node->hasChildNodes() )
    for ( DOM_Node child = node->getFirstChild(); child != 0; child = child.getNextSibling() )
      res += GetDOM_NodeSize( &child, used_str );
     
  return res;
}

Network::Network()
{
  nHosts = 0;
  nServices = 0;
  nAttacks = 0;

  hosts.resize(0);
  auxilary = 0;
  adversary.SetNetwork( this );
  ids.SetNetwork( this );
  max_path_count = 0;
}

void AuxilaryParserData::Initialize()
{
  // Initialize element names map
  enames[NETWORK] = DOMString::transcode("network");
  enames[SERVICES] = DOMString::transcode("services");
  enames[SERVICE] = DOMString::transcode("service");
  enames[FTP] = DOMString::transcode("ftp");
  enames[SSHD] = DOMString::transcode("sshd");
  enames[DATABASE] = DOMString::transcode("database");
  enames[VULNERABILITIES] = DOMString::transcode("vulnerabilities");
  enames[VULNERABILITY] = DOMString::transcode("vulnerability");
  enames[HOST] = DOMString::transcode("host");
  enames[CVE] = DOMString::transcode("cve");
  enames[CVE1] = DOMString::transcode("cve1");  
  enames[CVEID] = DOMString::transcode("cveid");
  enames[CONNECTIVITY] = DOMString::transcode("connectivity");
  enames[REMOTE] = DOMString::transcode("remote");
  enames[TRUST] = DOMString::transcode("trust");
  enames[NO_TRUST] = DOMString::transcode("no_trust");
  enames[ADVERSARY] = DOMString::transcode("adversary");
  enames[PRIVILEGES] = DOMString::transcode("privileges");
  enames[PRIVILEGE] = DOMString::transcode("privilege");
  enames[ATTACK] = DOMString::transcode("attack");
  enames[LOCAL_PRECONDITIONS] = DOMString::transcode("local_preconditions");
  enames[GLOBAL_PRECONDITIONS] = DOMString::transcode("global_preconditions");
  enames[TRACE] = DOMString::transcode("trace");
  enames[LOCAL_EFFECTS] = DOMString::transcode("local_effects");
  enames[GLOBAl_EFFECTS] = DOMString::transcode("global_effects");
  enames[IDS] = DOMString::transcode("ids");
  enames[PATH] = DOMString::transcode("path");
  enames[PORT] = DOMString::transcode("port");
  enames[ID] = DOMString::transcode("id");  
  enames[IP] = DOMString::transcode("ip");  
  enames[HOSTS] = DOMString::transcode("hosts");
  enames[HOST1] = DOMString::transcode("host1");
  enames[HOST2] = DOMString::transcode("host2");
  enames[ATTACKS] = DOMString::transcode("attacks");
  enames[LEVEL] = DOMString::transcode("level");
  enames[DETECTABLE] = DOMString::transcode("detectable");
  enames[MODE] = DOMString::transcode("mode");
  enames[YES] = DOMString::transcode("yes");
  enames[NO] = DOMString::transcode("no");
  enames[XML_TRUE] = DOMString::transcode("TRUE");
  enames[XML_FALSE] = DOMString::transcode("FALSE");
  enames[BOTH] = DOMString::transcode("both");
  enames[NAME] = DOMString::transcode("name");
  enames[LOCAL] = DOMString::transcode("local");
  enames[SERVICE_PORT_AGREEMENT] = DOMString::transcode("service_port_agreement");
  enames[TARGET] = DOMString::transcode("target");
  enames[REL] = DOMString::transcode("rel");
  enames[GTE] = DOMString::transcode("gte");
  enames[EQ] = DOMString::transcode("eq");
  enames[LTE] = DOMString::transcode("lte");
  enames[LS] = DOMString::transcode("ls");
  enames[GT] = DOMString::transcode("gt");
  enames[VALUE] = DOMString::transcode("value");
  enames[NONE] = DOMString::transcode("none");
  enames[USER] = DOMString::transcode("user");
  enames[ROOT] = DOMString::transcode("root");
  enames[SOURCE] = DOMString::transcode("source");
  enames[FROM] = DOMString::transcode("from");
  enames[KNOWLEDGE] = DOMString::transcode("knowledge");
  enames[DESCRIPTION] = DOMString::transcode("description");
  enames[TEXT] = DOMString::transcode("text");
  enames[OBJECTS] = DOMString::transcode("objects");
  enames[OBJECT] = DOMString::transcode("object");
  enames[OBJECT_ATTRIBUTE] = DOMString::transcode("attrib");
  enames[SENDOBJECT] = DOMString::transcode("sendobject");
  enames[SENTOBJECT] = DOMString::transcode("sentobject");
  enames[SRCHOST] = DOMString::transcode("srchost");
  enames[DSTHOST] = DOMString::transcode("dsthost");
  enames[DSTSVC] = DOMString::transcode("dstsvc");
  enames[PASSARG] = DOMString::transcode("passarg");
  enames[LTL_FORMULA] = DOMString::transcode("ltl");
  enames[FORMULA] = DOMString::transcode("formula");
  enames[LTL_ATOMIC_PROPOSITION] = DOMString::transcode("atomic_proposition");
  
  //Firewalls
  enames[FIREWALL] = DOMString::transcode("firewall");
  enames[STATUS] = DOMString::transcode("status");
  enames[RESULT] = DOMString::transcode("result");
  enames[RULE] = DOMString::transcode("rule");
  enames[SRCPORT] = DOMString::transcode("srcport");
  enames[DSTPORT] = DOMString::transcode("dstport");
  enames[FIREWALL_REACHABLE] = DOMString::transcode("firewall_reachable");
  enames[ON] = DOMString::transcode("on");
  enames[OFF] = DOMString::transcode("off");
  enames[ALLOW] = DOMString::transcode("allow");
  enames[DENY] = DOMString::transcode("deny");
  enames[TARGET_FW] = DOMString::transcode("target_fw");
  enames[WILDCARD_ALL] = DOMString::transcode("*");
    
  // Data sources
  enames[OUTPOST_DS] = DOMString::transcode("|Outpost|");
  enames[ODBC_DS] = DOMString::transcode("|ODBC|");
  enames[EMPTY] = DOMString::transcode("");
}
  
// ---------------------------------------------------------------------------
//  Generators (from XML);
// ---------------------------------------------------------------------------
 
void Network::GenerateHost(DOM_Element *element)
{
  assert(element != NULL);
  DOMString hostname;
  DOMString hostip;
  HostID id;
  
  // The 'id' attribute gives the name of the host
  // Add this name to the map from ids to hosts
  DOM_Attr attribute = element->getAttributeNode(auxilary->enames[ID]);
  if (!attribute.isNull()) {
    hostname = attribute.getValue();
    // First check if this host has been declared
    if (hid.find(hostname) == hid.end()) {
      cerr << "Warning: host name" << hostname << " has not been declared, ignored " << endl;
      return;
    }
    id = hid[hostname];
    // Check if this host has already been defined
    if (hosts[id]->IsDefined()) {
      cerr << "Warning: duplicate definition of host " << hostname << ", ignored " << endl;
      return;
    }
    else
      hosts[id]->SetDefined(true);
  }
  else {
    cerr << "Error: host definition has no id tag" << endl;
    return;
  }

  hosts[id]->SetDocument(curr_doc);
  attribute = element->getAttributeNode(auxilary->enames[IP]);
  if (!attribute.isNull()) {
//    hostip = attribute.getValue();
    hosts[id]->GenerateIPs(attribute);
  }
  else {
    cerr << "Error: host definition has no ip tag" << endl;
    return;
  }

  cout << endl << "Host found: name " << hostname << ", id " << id << ", net " << hosts[id]->NetworkName() << ", IPs:";
  StringSet *ips = hosts[id]->IPs();
  for (StringSet::iterator ip = ips->begin(); ip != ips->end(); ip++)
    cout << " " << *ip << endl;  

  // Add this host to the NetInfo object.
  auxilary->theNet.hosts[hostname.transcode()] = id;

  // Process host elements
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    if (nodeName.equals(auxilary->enames[SERVICES]))
      hosts[id]->GenerateServices(el);
    else if (nodeName.equals(auxilary->enames[CONNECTIVITY]))
      hosts[id]->GenerateConnectivity(el);
    else if (nodeName.equals(auxilary->enames[TRUST]))
      hosts[id]->GenerateTrust(el);
    else if (nodeName.equals(auxilary->enames[VULNERABILITIES]))
      hosts[id]->GenerateVulnerabilities(el);
    else if (nodeName.equals(auxilary->enames[CVE]))
      hosts[id]->GenerateCVE(el);
    else if (nodeName.equals(auxilary->enames[OBJECTS]))
      hosts[id]->GenerateObjects(el);
  }
}

void Network::CountingPass(DOM_Element *element)
{
  // Process network elements
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    if (nodeName.equals(auxilary->enames[HOST]))
      CountingHost(el);
    else if (nodeName.equals(auxilary->enames[ATTACK]))
      CountingAttack(el);
    else if ( nodeName.equals(auxilary->enames[FIREWALL]) )
      CountingFirewall( el );
  }
    
  if ( DoesModelHaveFirewalls() ) {
    hostlinking.clear();
    hostlinking.resize( nHosts, HostIdSet() );
    
    if ( fport2name.empty() )
      //Add 'virtual' port in case there are no ports
      AddFirewallPort( "ALL" );
  }
    
}

void Network::CountingHost(DOM_Element *element)
{
  assert(element != NULL);
  DOMString hostname;
  DOMString hostip;
  HostID id;
  bool AlreadyCounted = false;
  
  // The 'id' attribute gives the name of the host
  // Add this name to the map from ids to hosts
  DOM_Attr attribute = element->getAttributeNode(auxilary->enames[ID]);
  if (!attribute.isNull()) {
    hostname = attribute.getValue();
    // Get the network that the host is on
    DOM_Attr netname = element->getAttributeNode(auxilary->enames[NETWORK]);
    DOM_Attr ipattr = element->getAttributeNode(auxilary->enames[IP]);    
    string ip = "";
    
    if (!ipattr.isNull())
      ip = ipattr.getValue().transcode();
    else
      ip = HostNameToIP(hostname.transcode());
    
    if (ip == "") {
      cout << "Warning: can't obtain IP of the host: " << hostname << endl;
      ip = "0.0.0.0";       
    }
      
    
    if (!netname.isNull()) {
      DOMString net = netname.getValue();
      if (AddHost(hostname, ip, net.transcode())) {
	      id = GetHostID(hostname);
      }
      else
	      AlreadyCounted = true;
    }
    else {
      if (AddHost(hostname, ip)) {
	      id = GetHostID(hostname);
      }
      else
	      AlreadyCounted = true;
    }
  }
  else {
    cerr << "Error: host definition has no id tag" << endl;
    return;
  }

  if (!AlreadyCounted) {
    hosts[id]->SetDocument(curr_doc);
    // Process host elements
    for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

      if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
      DOM_Element *el = (DOM_Element *) &child;
    
      DOMString nodeName = el->getNodeName();

      if (nodeName.equals(auxilary->enames[SERVICES]))
        hosts[id]->CountingServices(el);
      else if (nodeName.equals(auxilary->enames[CONNECTIVITY]))
        hosts[id]->CountingConnectivity(el);
      else if (nodeName.equals(auxilary->enames[VULNERABILITIES]))
        hosts[id]->CountingVulnerabilities(el);
      else if (nodeName.equals(auxilary->enames[CVE]))
        hosts[id]->CountingCVE(el);
    }
  }
}

void Network::CountingAttack(DOM_Element *element)
{
  assert(element != NULL);
  DOMString attackname;
  
  // The 'id' attribute gives the name of the host
  // Add this name to the map from names to hosts
  DOM_Attr attribute = element->getAttributeNode(auxilary->enames[NAME]);
  if (!attribute.isNull()) {
    attackname = attribute.getValue();
    if (!AddAttack(attackname))
      return;
  }
  else {
    cerr << "Error: attack definition has no name tag" << endl;
    return;
  }

  AttackID id = GetAttackID(attackname);
  // Check CVE numbers
  for (int cvenum = 1; true; cvenum++) {
    char cveattrname[10];
    sprintf(cveattrname, "cve%d", cvenum);
    DOM_Attr cveattr = element->getAttributeNode(DOMString::transcode(cveattrname));
    
    if (!cveattr.isNull()) {
      DOMString cvename = cveattr.getValue();
      char *cvecs = cvename.transcode();
      // Fix it up so that dashes are turned into underscores
      FixUpCVEname(cvecs);
      cvename = DOMString::transcode(cvecs);
      delete [] cvecs;
      AddVul(cvename);
    }
    else
      break;
  }

  // Process attack elements
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    if (nodeName.equals(auxilary->enames[LOCAL_PRECONDITIONS]))
      attacks[id]->CountingPreconditions(el);
    else if (nodeName.equals(auxilary->enames[GLOBAL_PRECONDITIONS]))
      attacks[id]->CountingPreconditions(el);
    else if (nodeName.equals(auxilary->enames[LOCAL_EFFECTS]))
      attacks[id]->CountingEffects(el);
    else if (nodeName.equals(auxilary->enames[GLOBAl_EFFECTS]))
      attacks[id]->CountingEffects(el);
  }
}

void Firewall::GenerateRules( DOM_Element *element )
{
  DOMString srch;
  DOMString dsth;
  int srchost;
  int srcport;
  int dsthost;
  int dstport;
  bool   result = true;
  
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {
   
    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
      
    DOM_Element *el = (DOM_Element *) &child;
    DOMString name = el->getNodeName();
    
    
    if ( name.equals( m_network->auxilary->enames[RULE] )) {
      DOM_Attr attribute = el->getAttributeNode( m_network->auxilary->enames[SRCHOST] );
      if ( attribute.isNull() ) {
        cerr << "Warning: \'" << m_name << "\' firewall rule definition has no 'srchost' attribute; rule is ignored" << endl;
        continue;
      }
      srch = attribute.getValue();
      if ( srch.equals(m_network->auxilary->enames[WILDCARD_ALL]))
        srchost = -1;
      else {
        if ( m_network->hid.find( srch ) == m_network->hid.end() ) {
          cerr << "Warning: 'srchost' attribute of \'" << m_name << "\' firewall rule; host \'" << srch << "\' is not defined; rule is ignored"  << endl;
          continue;
        }
        srchost = m_network->GetHostID( srch );
      }

      attribute = el->getAttributeNode( m_network->auxilary->enames[DSTHOST] );      
      if ( attribute.isNull() ) {
        cout << "Warning: \'" << m_name << "\' firewall rule definition has no 'dsthost' attribute; rule is ignored" << endl;
        continue;
      }
      dsth = attribute.getValue();
      if ( dsth.equals(m_network->auxilary->enames[WILDCARD_ALL]))
        dsthost = -1;
      else {
        if ( m_network->hid.find( dsth ) == m_network->hid.end() ) {
          cout << "Warning: 'dsthost' attribute of \'" << m_name << "\' firewall rule; host \'" << dsth << "\' is not defined; rule is ignored"  << endl;
          continue;
        }
        dsthost = m_network->GetHostID( dsth );
      }
      
      attribute = el->getAttributeNode( m_network->auxilary->enames[SRCPORT] );      
      if ( attribute.isNull() ) {
        cout << "Warning: '" << m_name << "' firewall rule definition has no 'srcport' attribute; rule is ignored" << endl;
        continue;
      }
      name = attribute.getValue();
      if ( name.equals(m_network->auxilary->enames[WILDCARD_ALL]) )
        srcport = -1;
      else
        srcport = (int)m_network->GetFirewallPortID( name );
      
      attribute = el->getAttributeNode( m_network->auxilary->enames[DSTPORT] );      
      if ( attribute.isNull() ) {
        cout << "Warning: '" << m_name << "' firewall rule definition has no 'dstport' attribute; rule is ignored" << endl;
        continue;
      }
      name = attribute.getValue();
      if ( name.equals(m_network->auxilary->enames[WILDCARD_ALL]) )
        dstport = -1;
      else
        dstport = (int)m_network->GetFirewallPortID( name );
      
      attribute = el->getAttributeNode( m_network->auxilary->enames[RESULT] );      
      if ( attribute.isNull() )
        cout << "Warning: '" << m_name << "' firewall rule definition has no 'result' attribute; default result 'allow' is assumed" << endl;
        
      name = attribute.getValue();
      
      if ( name.equals( m_network->auxilary->enames[DENY] ) ) {
        cout << "Error: '" << m_name << "' firewall rule definition has 'deny' result attribute; anly 'allow' is supported, rule is ignored" << endl;
        continue;
      }
      
      if ( !name.equals( m_network->auxilary->enames[ALLOW] ) )
        cout << "Warning: value of 'result' attribute of \'" << m_name << "\' firewall rule is neither 'allow' nor 'deny'; default 'allow' is assumed" << endl;
            
      FirewallRule rule;
      rule.srcport = srcport;
      rule.srchost = srchost;
      rule.dstport = dstport;
      rule.dsthost = dsthost;
      
      if ( !AddRuleAction( rule, result ) )
        cout << "Warning: redefinition of '" << m_name << "' firewall rule srchost=" 
             << srch << " srcport=" << ((srcport >= 0)? m_network->GetFirewallPortName( (PortID)srcport ): "*") << " dsthost=" 
             << dsth <<" dstport="<< ((dstport >= 0)? m_network->GetFirewallPortName( (PortID)dstport ): "*") << "; ignored" << endl;
    }
  }
}

void Network::GenerateFirewall( DOM_Element *element )
{
  DOMString name;
  DOMString host;
  HostID    host1_id;
  HostID    host2_id;
  bool      status = false;
  
  DOM_Attr attribute = element->getAttributeNode( auxilary->enames[NAME] );
  if ( !attribute.isNull() )
    name = attribute.getValue();
  else {
    cerr << "Error: firewall definition has no name attribute" << endl;
    return;
  }
  
  if ( firewalls.find(name) != firewalls.end() ) {
    cerr << "Warning: duplicate definition of firewall " << name << ", ignored " << endl;
    return;
  }
  
  attribute = element->getAttributeNode( auxilary->enames[HOST1] );
  if ( !attribute.isNull() ) {
    host = attribute.getValue();
    
    if ( hid.find( host ) == hid.end() ) {
      cerr << "Error: 'host1' attribute of firewall " << name << ": host " << host << " not found"<< endl;
      return;
    }
    host1_id = hid[host];
  }
  else {
    cerr << "Error: firewall definition has no 'host1' attribute" << endl;
    return;
  }

  attribute = element->getAttributeNode( auxilary->enames[HOST2] );
  if ( !attribute.isNull() ) {
    host = attribute.getValue();
    
    if ( hid.find( host ) == hid.end() ) {
      cerr << "Error: 'host2' attribute of firewall " << name << ": host " << host << " not found"<< endl;
      return;
    }
    host2_id = hid[host];
  }
  else {
    cerr << "Error: firewall definition has no 'host2' attribute" << endl;
    return;
  }
  
  DOMString status_str;
  attribute = element->getAttributeNode(auxilary->enames[STATUS]);
  if ( !attribute.isNull() ) {
    status_str = attribute.getValue();
    
    if ( status_str.equals( auxilary->enames[ON] ) )
      status = true;
    else if ( !status_str.equals( auxilary->enames[OFF] ) )
      cout << "Warning: value of 'status' attribute of firewall " << name << " is neither 'on' nor 'off'; default 'off' is assumed" << endl;
  }
  else
    cout << "Warning: firewall definition has no 'status' attribute; default status 'off' is assumed" << endl;
  
  cout << endl << "Firewall found: name \"" << name << "\""<< endl;
  
  Firewall *firewall = new Firewall( this, name, GetFirewallID(name), status );
  firewall->SetLocation( host1_id, host2_id );
  
  firewalls[name] = firewall;
  
  firewall->GenerateRules( element );
}

void Network::CountingFirewall(DOM_Element *element)
{
  DOMString name;
  
  DOM_Attr attribute = element->getAttributeNode( auxilary->enames[NAME] );
  if ( !attribute.isNull() ) {
    name = attribute.getValue();
    AddFirewallName( name );
  }
  
  CountingFirewallRulePorts( element );
  
}

void Network::CountingFirewallRulePorts( DOM_Element *element )
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {
    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString name = el->getNodeName();
    
    if ( name.equals( auxilary->enames[RULE] )) {
      DOMString port = el->getAttribute(auxilary->enames[SRCPORT]);
      if ( !port.equals(auxilary->enames[EMPTY]) &&
           !port.equals(auxilary->enames[WILDCARD_ALL]) ) {
        AddFirewallPort( port );
      }
      
      port = el->getAttribute(auxilary->enames[SRCPORT]);
      if ( !port.equals(auxilary->enames[EMPTY]) &&
           !port.equals(auxilary->enames[WILDCARD_ALL]) ) {
        AddFirewallPort( port );
      }
    }
  }
}

void Network::GenerateHosts(DOM_Element *element)
{
  cout << endl << "Generating host names and IDs:" << endl;
  HostID id = 0;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString hostname = el->getNodeName();

    hid[hostname] = id;

    // Get the network that the host is on
    DOM_Attr netname = el->getAttributeNode(auxilary->enames[NETWORK]);
    if (!netname.isNull()) {
      DOMString net = netname.getValue();
      hosts[id] = new Host(this, hostname, id, net.transcode());
      cout << "  " << hostname << ": " << id << ", network: " << hosts[id]->NetworkName() << endl;
    }
    else {
      hosts[id] = new Host(this, hostname, id);
      cout << "  " << hostname << ": " << id << endl;
    }

    // Add the host to the NetInfo object.
    auxilary->theNet.hosts[hostname.transcode()] = id++;
  }
}

void Network::GenerateAttack(DOM_Element *element)
{
  assert(element != NULL);
  DOMString attackname;
  AttackID id;
  const char* BufId = "attack";    
  DOM_Attr attribute;
  DOMParser *parser;
  ErrorHandler *errReporter;
  bool  errorsOccured = false;
  DOM_Element *el;
  
  // The 'id' attribute gives the name of the host
  // Add this name to the map from names to hosts
  DOM_Attr attr_source = element->getAttributeNode(auxilary->enames[SOURCE]);
  if (!attr_source.isNull()) {
    DOM_Attr attr_name = element->getAttributeNode(auxilary->enames[NAME]);
    DOM_Attr attr_cve = element->getAttributeNode(auxilary->enames[CVE1]);
    char *work_buff = 0;
    
    
    work_buff = GenerateWebAttack(element);
    
    if (work_buff != 0)
    {
      MemBufInputSource *input_buf = new MemBufInputSource((const XMLByte*)work_buff, strlen(work_buff) + 1, BufId);
      parser = new DOMParser;
      errReporter = new DOMTreeErrorReporter();
      parser->setErrorHandler(errReporter);

      try
      {
        parser->parse(*input_buf);
      }

      catch (const XMLException& e)
      {
        cerr << "An error occured during parsing\n   Message: "
	      << DOMString(e.getMessage()) << endl;
        errorsOccured = true;
      }

 
      catch (const DOM_DOMException& e)
      {
        cerr << "An error occured during parsing\n   Message: "
	      << DOMString(e.msg) << endl;
        errorsOccured = true;
      }

      catch (...)
      {
        cerr << "An error occured during parsing\n " << endl;
        errorsOccured = true;
      }
    
      if (!errorsOccured) {
        DOM_Node doc = parser->getDocument();
        DOM_Node child = doc.getFirstChild();        
        el = (DOM_Element*)&child;
        attribute = el->getAttributeNode(auxilary->enames[NAME]);
  
        if (!attribute.isNull()) {
          attackname = attribute.getValue();
    // First check if this host has been declared
          if (aid.find(attackname) == aid.end()) {
            cerr << "Warning: attack name" << attackname << " has not been declared, ignored " << endl;
            return;
          }
          id = aid[attackname];
    // Check if this attack has already been defined
          if (attacks[id] != NULL) {
            if ( attacks[id]->IsDefined() ) {
              cerr << "Warning: duplicate definition of attack " << attackname << ", ignored " << endl;
              return;
            }
          }
          else
            attacks[id] = new Attack(this, attackname, id);
          
          attacks[id]->SetDefined( true );
        }
        else {
          cerr << "Error: attack definition has no name tag" << endl;
          return;
        }

  // Check CVE numbers
        for (int cvenum = 1; true; cvenum++) {
          char cveattrname[10];
          sprintf(cveattrname, "cve%d", cvenum);
          DOM_Attr cveattr = el->getAttributeNode(DOMString::transcode(cveattrname));
    
          if (!cveattr.isNull()) {
            DOMString cvename = cveattr.getValue();
            char *cvecs = cvename.transcode();
      // Fix it up so that dashes are turned into underscores
            FixUpCVEname(cvecs);
            cvename = DOMString::transcode(cvecs);
            delete [] cvecs;
            vulnerabilities.insert(cvename);
            attacks[id]->AddCVE(cvename);
          }
          else
            break;
        }

        attribute = el->getAttributeNode(auxilary->enames[LOCAL]);
        if (!attribute.isNull()) {
          if (auxilary->enames[YES].equals(attribute.getValue()))
            attacks[id]->SetLocal();
          else
            attacks[id]->SetGlobal();
        }

        cout << endl << "Attack found: name " << attackname
            << ", id " << id << endl;
        if (attacks[id]->IsLocal())
        cout << "  local" << endl;

        auxilary->theNet.attacks[attackname.transcode()] = id;

  // Process host elements
        for (DOM_Node child = el->getFirstChild(); child != 0; child = child.getNextSibling()) {

          if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
          DOM_Element *el_child = (DOM_Element *) &child;
    
          DOMString nodeName = el_child->getNodeName();

          if (nodeName.equals(auxilary->enames[LOCAL_PRECONDITIONS]))
            attacks[id]->GenerateLocalPreconditions(el_child);
          else if (nodeName.equals(auxilary->enames[GLOBAL_PRECONDITIONS]))
            attacks[id]->GenerateGlobalPreconditions(el_child);
          else if (nodeName.equals(auxilary->enames[TRACE]))
            attacks[id]->GenerateTrace(el_child);
          else if (nodeName.equals(auxilary->enames[LOCAL_EFFECTS]))
            attacks[id]->GenerateLocalEffects(el_child);
          else if (nodeName.equals(auxilary->enames[GLOBAl_EFFECTS]))
            attacks[id]->GenerateGlobalEffects(el_child);
          else if (nodeName.equals(auxilary->enames[DETECTABLE]))
            attacks[id]->GenerateDetectable(el_child);
          else if (nodeName.equals(auxilary->enames[DESCRIPTION])) {
            DOMString desc = el_child->getAttribute(auxilary->enames[TEXT]);
            attacks[id]->SetDescription(desc);
          }
        }
      }
      
      if (work_buff != 0)
        delete work_buff;
      
      if (input_buf != 0)
        delete input_buf;
      
      if (errReporter != 0)
        delete errReporter;
    
      if (parser != 0)
        delete parser;
    }
    else
      exit(1); // Error occured during working with Attack Web server
  }
  else
  {
  
    attribute = element->getAttributeNode(auxilary->enames[NAME]);
  
    if (!attribute.isNull()) {
      attackname = attribute.getValue();
    // First check if this host has been declared
      if (aid.find(attackname) == aid.end()) {
        cerr << "Warning: attack name" << attackname << " has not been declared, ignored " << endl;
        return;
      }
      id = aid[attackname];
    // Check if this attack has already been defined
      if (attacks[id] != NULL) {
        if ( attacks[id]->IsDefined() ) {
          cerr << "Warning: duplicate definition of attack " << attackname << ", ignored " << endl;
          return;
        }
      }
      else
        attacks[id] = new Attack(this, attackname, id);
      
      attacks[id]->SetDefined( true );
    }
    else {
      cerr << "Error: attack definition has no name tag" << endl;
      return;
    }

  // Check CVE numbers
    for (int cvenum = 1; true; cvenum++) {
      char cveattrname[10];
      sprintf(cveattrname, "cve%d", cvenum);
      DOM_Attr cveattr = element->getAttributeNode(DOMString::transcode(cveattrname));
    
      if (!cveattr.isNull()) {
        DOMString cvename = cveattr.getValue();
        char *cvecs = cvename.transcode();
        // Fix it up so that dashes are turned into underscores
        FixUpCVEname(cvecs);
        cvename = DOMString::transcode(cvecs);
        delete [] cvecs;
        vulnerabilities.insert(cvename);
        attacks[id]->AddCVE(cvename);
      } 
      else
        break;
    }

    attribute = element->getAttributeNode(auxilary->enames[LOCAL]);
    if (!attribute.isNull()) {
      if (auxilary->enames[YES].equals(attribute.getValue()))
        attacks[id]->SetLocal();
      else
        attacks[id]->SetGlobal();
    }

    cout << endl << "Attack found: name " << attackname
       << ", id " << id << endl;
    if (attacks[id]->IsLocal())
      cout << "  local" << endl;

    auxilary->theNet.attacks[attackname.transcode()] = id;

  // Process host elements
    for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

      if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
      DOM_Element *el_child = (DOM_Element *) &child;
    
      DOMString nodeName = el_child->getNodeName();

      if (nodeName.equals(auxilary->enames[LOCAL_PRECONDITIONS]))
        attacks[id]->GenerateLocalPreconditions(el_child);
      else if (nodeName.equals(auxilary->enames[GLOBAL_PRECONDITIONS]))
        attacks[id]->GenerateGlobalPreconditions(el_child);
      else if (nodeName.equals(auxilary->enames[TRACE]))
        attacks[id]->GenerateTrace(el_child);
      else if (nodeName.equals(auxilary->enames[LOCAL_EFFECTS]))
        attacks[id]->GenerateLocalEffects(el_child);
      else if (nodeName.equals(auxilary->enames[GLOBAl_EFFECTS]))
        attacks[id]->GenerateGlobalEffects(el_child);
      else if (nodeName.equals(auxilary->enames[DETECTABLE]))
        attacks[id]->GenerateDetectable(el_child);
      else if (nodeName.equals(auxilary->enames[DESCRIPTION])) {
        DOMString desc = el_child->getAttribute(auxilary->enames[TEXT]);
        attacks[id]->SetDescription(desc);
      }
    }
  }
}

void Network::GenerateAttacks(DOM_Element *element)
{
  cout << endl << "Generating attack names and IDs:" << endl;
  AttackID id = 0;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    cout << "  " << nodeName << ": " << id << endl;
    aid[nodeName] = id;

    auxilary->theNet.attacks[nodeName.transcode()] = id++;
  }
}

void Network::GenerateServices(DOM_Element *element)
{
  cout << endl << "Generating network services:" << endl;
  ServiceID id = 1;
  
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    DOM_NamedNodeMap attributes = el->getAttributes();
    cout << "  " << nodeName;

    for (unsigned int i = 0; i < attributes.getLength(); i++) {
      DOM_Node attribute = attributes.item(0);
      if (auxilary->enames[PORT].equals(attribute.getNodeName())) {

        DOM_Attr *attrp = (DOM_Attr *) &attribute;
        ports[nodeName] = atoi(attrp->getValue());
        sid[nodeName] = id;
        sid2name[id] = nodeName;
        cout << ": port " << ports[nodeName] << ", id " << id;
        
        pair<int,int> x;
        x.first = id;
        x.second = ports[nodeName];
        auxilary->theNet.services[nodeName.transcode()] = x;
        id++;
      }
    }
    cout << endl;
  }
}

void Network::GenerateVulnerabilities(DOM_Element *element)
{
  cout << endl << "Vulnerabilities:" << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOMString nodeName = child.getNodeName();
    cout << "  " << nodeName << endl;;
    vulnerabilities.insert(nodeName);
  }
  cout << endl;
}

// Output a PAA-style packet specification that host hid1 can reach host hid2 on port
void Network::OutputIPPacketsSpec(ostream& out, const char *predicate, HostID hid1, HostID hid2)
{
  StringSet::iterator hid1_iter;
  StringSet::iterator hid2_iter;
  
  hid1_iter = hosts[hid1]->IPs()->begin();
  hid2_iter = hosts[hid2]->IPs()->begin();  

  out << predicate << "(" << hosts[hid1]->NetworkName() << ", " << hosts[hid2]->NetworkName()
      << ", ippkts(" << endl;
/*  out << "      [permit(\"0.0.0.0\", \"255.255.255.255\", [[0 | 65535]]," << endl;
  out << "              \"0.0.0.0\", \"255.255.255.255\", [[0 | 65535]], [[0|3]])]))." << endl;*/
  
  out << "      [permit(\"" << *hid1_iter << "\", \"0.0.0.0\", [[0 | 65535]]," << endl;
  out << "              \"" << *hid2_iter << "\", \"0.0.0.0\", [[0 | 65535]], [[0|3]])]))." << endl;
  
}

bool Network::Reachable(const char *filters, HostID hid1, HostID hid2)
{
  const char *specname = "#spec.dat#";
  ofstream specfile(specname);
  OutputIPPacketsSpec(specfile, "some_reachable", hid1, hid2);
  specfile.close();

  bool result = false;
#ifndef NO_REACH
  result = reachable(filters, specname);
#endif
  return result;
}

// Output a PAA-style packet specification that host hid1 can reach host hid2 on port
void Network::OutputIPPacketsSpec(ostream& out, const char *predicate, HostID hid1, HostID hid2, PortID port)
{
  StringSet::iterator hid1_iter;
  StringSet::iterator hid2_iter;
  
  hid1_iter = hosts[hid1]->IPs()->begin();
  hid2_iter = hosts[hid2]->IPs()->begin();  
  
  out << predicate << "(" << hosts[hid1]->NetworkName() << ", " << hosts[hid2]->NetworkName()
      << ", ippkts(" << endl;
/*  out << "      [permit(\"0.0.0.0\", \"255.255.255.255\", [[0 | 65535]]," << endl;
  out << "              \"0.0.0.0\", \"255.255.255.255\", [" << port << "], [[0|3]])]))." << endl;*/
  
  out << "      [permit(\"" << *hid1_iter << "\", \"0.0.0.0\", [[0 | 65535]]," << endl;
  out << "              \"" << *hid2_iter << "\", \"0.0.0.0\", [" << port << "], [[0|3]])]))." << endl;

}

bool Network::Reachable(const char *filters, HostID hid1, HostID hid2, PortID port)
{
  const char *specname = "#spec.dat#";
  ofstream specfile(specname);
  OutputIPPacketsSpec(specfile, "all_reachable", hid1, hid2, port);
  specfile.close();

  bool result = false;
#ifndef NO_REACH
  result = reachable(filters, specname);
#endif
  return result;
}

char* Network::GenerateWebAttack(DOM_Element *element)
{
  const char* MSG_PATTERN = "GET %s?%s%s HTTP/1.0\n\n";  
	const int BUFF_LEN = 200000;    
 	int domain = AF_INET;
	int sockettype = SOCK_STREAM;
	struct sockaddr_in addr;
	struct hostent *hp;
	int rc;
	int len;
	char	*buff;
  char* work_buff;
  char* msg;
  int curr_len = BUFF_LEN;
  bool  isError = false;
  char  name_param[100];
  string cve_params = "";
  char  cve_name[10];
  DOMString name;
  
  memset(name_param, 0, sizeof(name_param));
  
  DOMString source = element->getAttributeNode(auxilary->enames[SOURCE]).getValue();
  DOM_Attr attr_name = element->getAttributeNode(auxilary->enames[NAME]);
  if (!attr_name.isNull())
  {
    name = element->getAttributeNode(auxilary->enames[NAME]).getValue();
    char *name_c = name.transcode();
    sprintf(name_param, "name=%s", name_c);
    delete[] name_c;    
  }

 
  for (int cvenum = 1; true; cvenum++) {
    memset(cve_name, 0, sizeof(cve_name));
    sprintf(cve_name, "cve%i", cvenum);
    DOM_Attr cveattr = element->getAttributeNode(DOMString::transcode(cve_name));
    
    if (!cveattr.isNull()) {
      char *cvecs = cveattr.getValue().transcode();
      cve_params += "&";
      cve_params += (char*)cve_name;
      cve_params += "=";
      cve_params += cvecs;            
      delete [] cvecs;            
    }
    else
      break;
  }
  
	string host_name;
  int port;  
  string path;

  if (!AttackURLParse(source.transcode(), host_name, port, path))
  {
    cerr << "Error on source URL parsing\n " << endl;
    return 0;
  }
  
/*  cout << host_name << endl;
  cout << port << endl;  
  cout << path << endl;*/
  
  buff = new char[BUFF_LEN];
	hp = gethostbyname(host_name.c_str());
	addr.sin_family = domain;
	memcpy((char*)&(addr.sin_addr), (char*)(hp->h_addr), hp->h_length);
	addr.sin_port = htons(port);
		
	int sid;
	if (!isError && (sid = socket(domain, sockettype, 0)) < 0) {
	  cerr << "An error occured during opening socket\n " << endl;
    isError = true;
  }
	
	if (!isError && (rc = connect(sid, (struct sockaddr *)&addr, sizeof(addr))) < 0) {
	  cerr << "An error occured during connection to Attack Web server\n " << endl;
    isError = true;    
  }
	
  if (!isError) {
    msg = new char[strlen(MSG_PATTERN) + strlen(path.c_str()) + strlen(name_param) + strlen(cve_params.c_str()) + 20];
    
    if (msg != 0)
    {
      sprintf(msg, MSG_PATTERN, path.c_str(), name_param, cve_params.c_str());  
      cout << msg << "\n";
    }

	  if ((len = send(sid, msg, strlen(msg) + 1, 0)) < 0) {
  	  cerr << "An error occured during sending request to Attack Web server\n " << endl;
      isError = true;    
    }
    
    if (msg != 0)
      delete[] msg;
  }
	
  work_buff = (char*)buff;
  len = 1;
  memset(work_buff, 0, curr_len);  
  while (!isError && len > 0) {
	  if ((len = recv(sid, work_buff, curr_len, 0)) < 0) {
   	  cerr << "An error occured during receiving Attack description from Web server\n " << endl;
      isError = true;    
    }
	
    curr_len -= len;
    work_buff += len;
  }
  
	shutdown(sid, 2);	
  
  work_buff = strstr(buff, "<attack");
  
  if (work_buff == 0)
 	  cerr << "Specified attack doesn't exist in the Attack database\n " << endl;
  
  
  return work_buff;
}

bool Network::AttackURLParse(const string& url, string& host_name, int& port, string& path)
{
  unsigned int pos;
  unsigned int pos1, pos2;
  string http_prefix = "http://";
  
  if ((pos = url.find(http_prefix)) == url.npos)
    return false;
  
  if ((pos1 = url.find(':', http_prefix.length())) != url.npos) {
    host_name = url.substr(http_prefix.length(), pos1-http_prefix.length());
    
    if ((pos2 = url.find('/', pos1)) != url.npos)
    {
      port = atoi(url.substr(pos1+1, pos2-pos1-1).c_str());
      
      if (port == 0)
        return false;
      
      path = url.substr(pos2);
    }
    else
      return false;
  }
  else {
    port = 80;
    
    if ((pos1 = url.find('/', http_prefix.length())) != url.npos) {
      host_name = url.substr(http_prefix.length(), pos1-http_prefix.length());
      path = url.substr(pos1);
    }
    else
      return false;
  }
  
  return true;
}

//-----------------------------------------------------------------
// Host
//-----------------------------------------------------------------

void Host::GenerateIPs(DOM_Attr &attr)
{
  DOMString ip = attr.getValue();
  StringSet::iterator iter;
  
  if (ip_addrs != 0) {
    ip_addrs->clear();
    delete ip_addrs;
  }
  
  // Check if we are supposed to get the IP from a data source
  if (network->auxilary->enames[ODBC_DS].equals(ip)) {
#ifndef NO_ODBC
    // Get the IP addresses from Outpost
    char *host = name.transcode();
    ip_addrs = network->auxilary->Odbc.DBGetData (host, IP_BY_HOST, BUF_LEN_32);
    if ((iter = ip_addrs->begin()) != ip_addrs->end())
      attr.setValue(DOMString::transcode((*iter).c_str()));
    
    delete [] host;
#endif
  }
#ifdef OUTPOST
  else if (network->auxilary->enames[OUTPOST_DS].equals(ip)) {
    // Get the IP addresses from Outpost
    char *host = name.transcode();
    ip_addrs = network->auxilary->Outpost.DBGetData(host, IP_BY_HOST, BUF_LEN_32);
    if ((iter = ip_addrs->begin()) != ip_addrs->end())
      attr.setValue(DOMString::transcode((*iter).c_str()));
    
    delete [] host;
  }
#endif
  else {
//RL 
    ostringstream ost;
    Scanner *scan;
    ost << ip;    
    if ((scan = network->auxilary->scan_mang.get_scanner(ost.str())) != 0)
    {
      char *host = name.transcode();      
      try{
        ip_addrs = scan->getIP(string(host));      
        if ((iter = ip_addrs->begin()) != ip_addrs->end())
          attr.setValue(DOMString::transcode((*iter).c_str()));
        else
          attr.setValue(DOMString::transcode(""));
      }
      catch (UnknownHostError& err)
      {
        ip_addrs = new StringSet();          
        attr.setValue(DOMString::transcode(""));
      }
            
      delete [] host;
    }
    else
    {
    // Else, IP was specified in the XML source
    // TODO: handle mulitple IPs here
      ip_addrs = new StringSet;
      char *ipcs = ip.transcode();
      string ipstr(ipcs);
      ip_addrs->insert(ipstr);
      delete [] ipcs;
    }
  }
}

void Host::GenerateServices(DOM_Element *element)
{
  cout << "  Generating host services:";

  // Check if we are supposed to get the service names from a data source
  DOM_Attr source = element->getAttributeNode(network->auxilary->enames[SOURCE]);
  bool  is_scanner = false;
  
  if (!source.isNull()) {
    DOMString src = source.getValue();
    ostringstream ost;
    Scanner *scan;
    ost << src;    
    string src_str = ost.str();
    
    if ((network->auxilary->enames[OUTPOST_DS].equals(src)) || (network->auxilary->enames[ODBC_DS].equals(src)) || 
        ((scan = network->auxilary->scan_mang.get_scanner(src_str)) != 0)) {
      // Get the service names from Outpost
      char *host = name.transcode();
      StringSet *svcdata;
      if (network->auxilary->enames[ODBC_DS].equals(src)) {
#ifndef NO_ODBC
	svcdata = network->auxilary->Odbc.DBGetData(host, HOST_SERVICES, BUF_LEN_128);
#endif
      }
//RL
      else if ((scan = network->auxilary->scan_mang.get_scanner(src_str)) != 0) {
        PortSet *port_data;
        
        is_scanner = true;
        
        try{  
          port_data = scan->getServices(string(host));      
        }
        catch (UnknownHostError& err)
        {
          port_data = new PortSet();
        }
        
        
        element->removeAttributeNode(source);
      
        for (PortSet::iterator port_iter = port_data->begin(); port_iter != port_data->end(); port_iter++) {
          DOM_Element el;        
          char  buf[10];
	        DOMString svc = DOMString::transcode((*port_iter)->service_name.c_str());
//          cout << " " << svc;
	      // Check if this is a valid service name
	        if (network->ports.find(svc) == network->ports.end()) continue;
	
//	        cout << " " << svc;
//	        services.insert(svc);
        
          el = curr_doc->createElement(svc);
          sprintf(buf, "%d", (*port_iter)->port_id);
          el.setAttribute(network->auxilary->enames[PORT], DOMString::transcode(buf));
          element->appendChild(el); 
        
        }
        delete port_data;
        
      }
#ifdef OUTPOST
      else {
	         svcdata = network->auxilary->Outpost.DBGetData(host, HOST_SERVICES, BUF_LEN_128);
      }
#endif
      
      delete [] host;
  
      if (!is_scanner) {
        element->removeAttributeNode(source);
      
        for (StringSet::iterator svcname = svcdata->begin(); svcname != svcdata->end(); svcname++) {
          DOM_Element el;        
	        DOMString svc = DOMString::transcode(svcname->c_str());
	        // Check if this is a valid service name
	        if (network->ports.find(svc) == network->ports.end()) continue;
	
//  	      cout << " " << svc;
//	        services.insert(svc);
        
          el = curr_doc->createElement(svc);
          element->appendChild(el); 
        }
        delete svcdata;
      }
    }
  }
  
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    // Check if this is a valid service name
    if (network->ports.find(nodeName) == network->ports.end()) {
      cerr << "    Warning: undefined service " << nodeName
	   << " in definition of host " << name << ", ignored" << endl;
      continue;
    }

    cout << " " << nodeName;
    services.insert(nodeName);
  }
  cout << endl;
}

void Host::GenerateConnectivity(DOM_Element *element)
{
  cout << "  Generating host connectivity:" << endl;
  
  // Check if we are supposed to get the connectivity data from a data source
  DOM_Attr source = element->getAttributeNode(network->auxilary->enames[SOURCE]);
  if (!source.isNull()) {
    
    if ( network->DoesModelHaveFirewalls() ) {
      cerr << "Error: The model with firewalls does not support data source for host connectivity" << endl;
      return;
    }
      
    DOMString src = source.getValue();
    if (network->auxilary->enames[OUTPOST_DS].equals(src) || network->auxilary->enames[ODBC_DS].equals(src))  {
      // Get the connectivity data from Outpost
      // Iterate over all destination hosts      
      for (HostID dest = 0; dest < network->nHosts; dest++) {
        DOMString destname = network->hosts[dest]->GetName();
        
        // Check if some packets can get through
        bool reachable = network->Reachable("network.dat", id, dest);
        if (reachable) {
          connectivity[destname] = new DOMStringSet;
          connectivity[destname]->insert(network->auxilary->enames[PATH]);
          cout << "    -> " << destname << ":";
        }
        
        // Iterate over all services      
        for (map<DOMString, PortID, less_str>::iterator svc = network->ports.begin();
             svc != network->ports.end(); svc++) {
          // Get the port of the service
          PortID port = svc->second;
          bool svc_reachable = network->Reachable("network.dat", id, dest, port);
          if (svc_reachable) {
            cout << " " << svc->first;
            connectivity[destname]->insert(svc->first);
          }
        }
        if (reachable) cout << endl;
      }
    }
  }
  else {
    for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

      if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
      DOM_Element *el = (DOM_Element *) &child;
      if (!el->getNodeName().equals(network->auxilary->enames[REMOTE])) continue;

      DOMString id = el->getAttribute(network->auxilary->enames[ID]);
      if (!id.equals(network->auxilary->enames[EMPTY])) {
        connectivity[id] = new DOMStringSet;
        connectivity[id]->insert(network->auxilary->enames[PATH]);
        cout << "    -> " << id;
        if ( !network->DoesModelHaveFirewalls() ) {
          cout  << ":";
          GenerateConnectivityServices(el, connectivity[id]);
        }
        else {
          if ( !network->IsHostAdded(id) ) {
            cerr << "Warning: Undefined host id \'" << id << "\' in connectivity of host \'" << name << "\', ignored" << endl;
            continue;
          }
          HostID host_id = network->GetHostID(id);
          
          if ( network->hostlinking[GetId()].find( host_id ) != network->hostlinking[GetId()].end() )
            cerr << "Warning: Duplicated connectivity \'" << name << "\' -> \'" << id << "\', ignored" << endl;
          else
            network->hostlinking[GetId()].insert( host_id );
        }
        cout << endl;
      }
      else {
        cerr << "Warning: Missing id of remote host in connectivity specification of host "
             << name << ", ignored" << endl;
      }
    }
  }
}

void Host::GenerateTrust(DOM_Element *element)
{
  cout << "  Generating host trust:";
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    if (!el->getNodeName().equals(network->auxilary->enames[REMOTE])) continue;

    DOMString id = el->getAttribute(network->auxilary->enames[ID]);
    if (!id.equals(network->auxilary->enames[EMPTY])) {
      trust.insert(id);
      cout << " " << id;
    }
    else {
      cerr << "Warning: Missing id of remote host in trust specification of host "
	   << name << ", ignored" << endl;
    }
  }
  cout << endl;
}

void Host::GenerateVulnerabilities(DOM_Element *element)
{
  cout << "  Generating vulnerabilities:";
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOMString nodeName = child.getNodeName();
    cout << " " << nodeName;
    vulnerabilities.insert(nodeName);
  }
  cout << endl;
}

void Host::GenerateObjects( DOM_Element *element )
{
  cout << "  Generating objects:" << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOMString nodeName = child.getNodeName();
    if ( !nodeName.equals(network->auxilary->enames[OBJECT]) )
      cout << "Warning: Incorrect tag " << nodeName << ", ignored" << endl;
    else {
      DOM_Element *el = (DOM_Element *) &child;
      
      GenerateObject( el );
    }
  }
  cout << endl;
}
  
void Host::GenerateObject( DOM_Element *element )
{
  DOMString obj_name = element->getAttribute(network->auxilary->enames[NAME]);
  
  if ( obj_name.equals(network->auxilary->enames[EMPTY]) ) {
    cout << "Warning: Missing name attribute in host object" << obj_name << ", ignored" << endl;
    return;
  }
  
  HostObjectMap::iterator obj_iter = objects.find(obj_name);
  HostObjectAttrNameMap::iterator net_obj_iter = network->host_objects.find(obj_name);
    
  if ( obj_iter != objects.end() )
    cout << "Warning: Host object is duplicated " << obj_name << "; attribute values may be lost" << endl;
  else
  {
    objects[obj_name] = DOMStringMap();
    obj_iter = objects.find(obj_name);
  }
  
  if ( net_obj_iter == network->host_objects.end() ) {
    //Save object name
    network->host_objects[obj_name] = DOMStringSet();
    net_obj_iter = network->host_objects.find(obj_name);
  }
  
  cout << "    Object: " << obj_name << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {
    
    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
      
    DOMString nodeName = child.getNodeName();
    if ( !nodeName.equals(network->auxilary->enames[OBJECT_ATTRIBUTE]) )
      cout << "Warning: Incorrect tag " << nodeName << ", ignored" << endl;
    else
    {
      DOM_Element *el = (DOM_Element *) &child;
      DOMString attr_name = el->getAttribute(network->auxilary->enames[NAME]);
      
      if ( attr_name.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing name attribute in host object attrib. " 
             << obj_name << ", ignored" << endl;
        continue;
      }
      
      DOMString attr_value = el->getAttribute(network->auxilary->enames[VALUE]);
      
      if ( attr_value.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing value attribute in host object attrib. " 
             << obj_name << ":" << attr_value << ", ignored" << endl;
        continue;
      }
      
      //Add names/values to network structure
      cout << "       attrib.:" << attr_name << " value=" << attr_value << endl;
      
      attr_value = network->GetAttrConstant( attr_value );
      net_obj_iter->second.insert( attr_name );
      network->obj_attr_values.insert( attr_value );
           
      obj_iter->second[attr_name] = attr_value;
    }
  }
}

void Host::GenerateConnectivityServices(DOM_Element *element, DOMStringSet *svcs)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    // Check if this is a valid service name
    if (network->ports.find(nodeName) == network->ports.end()) {
      cerr << "    Warning: undefined service " << nodeName
	   << " in definition of connectivity for host " << name
	   << ", ignored" << endl;
      continue;
    }

    cout << " " << nodeName;
    svcs->insert(nodeName);
  }
}
 
void Host::GenerateCVE(DOM_Element *element)
{
  cout << "  Generating CVE:" << endl;

  // Check if we are supposed to get the CVE numbers from a data source
  DOM_Attr source = element->getAttributeNode(network->auxilary->enames[SOURCE]);
  if (!source.isNull()) {
    DOMString src = source.getValue();
    ostringstream ost;
    Scanner *scan;
    ost << src;    
    string src_str = ost.str();

/*    cout << "Check the nessus source: " << src_str << "\n";*/
    
    if (network->auxilary->enames[OUTPOST_DS].equals(src) || 
        network->auxilary->enames[ODBC_DS].equals(src) || 
        ((scan = network->auxilary->scan_mang.get_scanner(src_str)) != 0)) {
      // Get the CVE numbers from Outpost
      char *host = name.transcode();
      StringSet *cvedata;
      if (network->auxilary->enames[ODBC_DS].equals(src)) {
#ifndef NO_ODBC
	cvedata = network->auxilary->Odbc.DBGetData(host, HOST_CVE_VULNERABILITIES, BUF_LEN_32);
#endif
      }
//RL
      else if ((scan = network->auxilary->scan_mang.get_scanner(src_str)) != 0){
        try{
          cvedata = scan->getCVEs(string(host));      
        }
        catch (UnknownHostError& err){
          cvedata = new StringSet();
        }
      }
//      
#ifdef OUTPOST
      else {
	        cvedata = network->auxilary->Outpost.DBGetData(host, HOST_CVE_VULNERABILITIES, BUF_LEN_32);
      }
#endif
      
            
      delete [] host;
  
      element->removeAttributeNode(source);
      
      for (StringSet::iterator cvename = cvedata->begin(); cvename != cvedata->end(); cvename++) {
        DOM_Element el;
//	      cout << "  " << *cvename << endl;
	      char cvecs[20];
	      strcpy(cvecs, cvename->c_str());
	      // Fix it up so that dashes are turned into underscores
	      FixUpCVEname(cvecs);
//	      vulnerabilities.insert(DOMString::transcode(cvecs));
        
        el = curr_doc->createElement(DOMString::transcode(cvecs));
        element->appendChild(el); 
      }
      
      delete cvedata;
    }
  }
  
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOMString nodeName = child.getNodeName();
    cout << "  " << nodeName << endl;
    vulnerabilities.insert(nodeName);
  }
}

void Host::CountingServices(DOM_Element *element)
{
  // Check if we are supposed to get the service names from a data source
  DOM_Attr source = element->getAttributeNode(network->auxilary->enames[SOURCE]);
  bool  is_scanner = false;
  
  if (!source.isNull()) {
    DOMString src = source.getValue();
    ostringstream ost;
    Scanner *scan;
    ost << src;    
    string src_str = ost.str();
    
    if ((network->auxilary->enames[OUTPOST_DS].equals(src)) || (network->auxilary->enames[ODBC_DS].equals(src)) || 
        ((scan = network->auxilary->scan_mang.get_scanner(src_str)) != 0)) {
      // Get the service names from Outpost
      char *host = name.transcode();
      StringSet *svcdata;
      if (network->auxilary->enames[ODBC_DS].equals(src)) {
#ifndef NO_ODBC
	svcdata = network->auxilary->Odbc.DBGetData(host, HOST_SERVICES, BUF_LEN_128);
#endif
      }
//RL
      else if ((scan = network->auxilary->scan_mang.get_scanner(src_str)) != 0) {
        PortSet *port_data;
        
        is_scanner = true;
        
        try{  
          port_data = scan->getServices(string(host));      
        }
        catch (UnknownHostError& err)
        {
          port_data = new PortSet();
        }
        
        
        element->removeAttributeNode(source);
      
        for (PortSet::iterator port_iter = port_data->begin(); port_iter != port_data->end(); port_iter++) {
          DOM_Element el;        
          char  buf[10];
	        DOMString svc = DOMString::transcode((*port_iter)->service_name.c_str());
        
          try {    
            el = curr_doc->createElement(svc);
            sprintf(buf, "%d", (*port_iter)->port_id);
            el.setAttribute(network->auxilary->enames[PORT], DOMString::transcode(buf));
            element->appendChild(el); 
            
            cout << svc << "---" << buf << "\n";
          }
          catch (DOM_DOMException &e)
          {
          }
        
        }
        delete port_data;
        
      }        
#ifdef OUTPOST
        else {
      	  svcdata = network->auxilary->Outpost.DBGetData(host, HOST_SERVICES, BUF_LEN_128);
        }
#endif
      
      delete [] host;
  
      if (!is_scanner) {
        for (StringSet::iterator svcname = svcdata->begin(); svcname != svcdata->end(); svcname++) {
	        DOMString svc = DOMString::transcode(svcname->c_str());
	        network->AddService(svc, 0);
        }
        delete svcdata;
      }
    }
  }
  
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();
    
    DOM_Attr attr_port = el->getAttributeNode(network->auxilary->enames[PORT]);

    if (!attr_port.isNull()) {
      DOMString port = attr_port.getValue();
      if ( !port.equals( network->auxilary->enames[EMPTY] ) )
        network->AddFirewallPort( port );
      network->AddService(nodeName, atoi(port) );
    }
    else
      network->AddService(nodeName, 0);      
  }
}

void Host::CountingConnectivity(DOM_Element *element)
{
  // Check if we are supposed to get the connectivity data from a data source
  DOM_Attr source = element->getAttributeNode(network->auxilary->enames[SOURCE]);
  if (!source.isNull()) {
  }
  else {
    for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

      if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
      DOM_Element *el = (DOM_Element *) &child;
      if (!el->getNodeName().equals(network->auxilary->enames[REMOTE])) continue;

      DOMString id = el->getAttribute(network->auxilary->enames[ID]);
      if (!id.equals(network->auxilary->enames[EMPTY])) {
	      CountingConnectivityServices(el);
      }
    }
  }
}

void Host::CountingConnectivityServices(DOM_Element *element)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    network->AddService(nodeName, 0);
  }
}

void Host::CountingVulnerabilities(DOM_Element *element)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOMString nodeName = child.getNodeName();
    network->AddVul(nodeName);
  }
}

void Host::CountingCVE(DOM_Element *element)
{
  // Check if we are supposed to get the CVE numbers from a data source
  DOM_Attr source = element->getAttributeNode(network->auxilary->enames[SOURCE]);
  if (!source.isNull()) {
    DOMString src = source.getValue();
    if (network->auxilary->enames[OUTPOST_DS].equals(src) || network->auxilary->enames[ODBC_DS].equals(src)) {
      // Get the CVE numbers from Outpost
      char *host = name.transcode();
      StringSet *cvedata;
      if (network->auxilary->enames[ODBC_DS].equals(src)) {
#ifndef NO_ODBC
	cvedata = network->auxilary->Odbc.DBGetData(host, HOST_CVE_VULNERABILITIES, BUF_LEN_32);
#endif
      }
//RL
      else
      {
        ostringstream ost;
        Scanner *scan;
        ost << src;    
        if ((scan = network->auxilary->scan_mang.get_scanner(ost.str())) != 0)
          cvedata = scan->getIP(string(host));      
#ifdef OUTPOST
        else {
	        cvedata = network->auxilary->Outpost.DBGetData(host, HOST_CVE_VULNERABILITIES, BUF_LEN_32);
        }
#endif
      }
      delete [] host;
  
      for (StringSet::iterator cvename = cvedata->begin(); cvename != cvedata->end(); cvename++) {
        char cvecs[20];
        strcpy(cvecs, cvename->c_str());
        // Fix it up so that dashes are turned into underscores
        FixUpCVEname(cvecs);
        DOMString vulname = DOMString::transcode(cvecs);
        network->AddVul(vulname);
      }
      delete cvedata;
    }
  }
  
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOMString nodeName = child.getNodeName();
    network->AddVul(nodeName);
  }
}

//------------------------------------------------------------------
// Adversary
//------------------------------------------------------------------

void Adversary::Generate( DOM_Element *element)
{
  cout << endl << "Generating adversary:" << endl;
  // Process adversary elements
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    if (nodeName.equals(network->auxilary->enames[SERVICES]))
      GenerateServices(el);
    else if (nodeName.equals(network->auxilary->enames[PRIVILEGES]))
      GeneratePrivileges(el);
    else if (nodeName.equals(network->auxilary->enames[KNOWLEDGE]))
      GenerateKnowledge(el);
  }
}

void Adversary::GeneratePrivileges(DOM_Element *element)
{
  cout << "  Generating adversary privileges:" << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();
    if (!el->getNodeName().equals(network->auxilary->enames[PRIVILEGE])) continue;

    DOMString id = el->getAttribute(network->auxilary->enames[HOST]);
    DOMString level = el->getAttribute(network->auxilary->enames[LEVEL]);
    if (id.equals(network->auxilary->enames[EMPTY])) {
      cerr << "Warning: Missing host id in privilege specification of adversary, ignored" << endl;
      continue;
    }
    if (level.equals(network->auxilary->enames[EMPTY])) {
      cerr << "Warning: Missing level in adversary privilege specification on host "
	   << id << ", ignored" << endl;
      continue;
    }
    privileges[id] = level;
    cout << "    " << id << ": level " << level << endl;
  }
}

void Adversary::GenerateServices(DOM_Element *element)
{
  cout << "  Generating adversary services:" << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    DOM_NamedNodeMap attributes = el->getAttributes();

    for (unsigned int i = 0; i < attributes.getLength(); i++) {
      DOM_Node attribute = attributes.item(0);
      if (network->auxilary->enames[PORT].equals(attribute.getNodeName())) {

      DOM_Attr *attrp = (DOM_Attr *) &attribute;
      DOMString port  = attrp->getValue();
        
      if ( !port.equals(network->auxilary->enames[EMPTY]) )
        network->AddFirewallPort( port );
      
      ports[nodeName] = atoi(port);
      cout << "    " << nodeName;
      cout << ": " << ports[nodeName];
      }
    }
    cout << endl;
  }
}

void Adversary::GenerateKnowledge(DOM_Element *element)
{
  cout << "  Generating adversary knowledge:" << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();

    DOM_NamedNodeMap attributes = el->getAttributes();

    for (unsigned int i = 0; i < attributes.getLength(); i++) {
      DOM_Node attribute = attributes.item(0);
      if (network->auxilary->enames[VALUE].equals(attribute.getNodeName())) {

	DOM_Attr *attrp = (DOM_Attr *) &attribute;
	DOMString value = attrp->getValue();
	knowledge[nodeName] = network->auxilary->enames[YES].equals(value);
	cout << "    " << nodeName;
	cout << ": " << value;
      }
    }
    cout << endl;
  }
}

//------------------------------------------------------------------
// IDS
//------------------------------------------------------------------

void IntrusionDetectionSystem::Generate(DOM_Element *element)
{
  cout << endl << "Generating IDS:" << endl;
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();
    if (!el->getNodeName().equals(network->auxilary->enames[PATH])) continue;

    DOMString id1 = el->getAttribute(network->auxilary->enames[HOST1]);
    DOMString id2 = el->getAttribute(network->auxilary->enames[HOST2]);
    if (id1.equals(network->auxilary->enames[EMPTY])) {
      cerr << "Warning: Missing host 1 in IDS path specification, ignored" << endl;
      continue;
    }
    if (id2.equals(network->auxilary->enames[EMPTY])) {
      cerr << "Warning: Missing host 2 in IDS path specification, ignored" << endl;
      continue;
    }

    DOMStringSet *endpoints;
    map <DOMString, DOMStringSet *, less_str>::iterator epset = paths.find(id1);
    if (epset == paths.end()) {
      endpoints = new DOMStringSet;
      paths[id1] = endpoints;
    }
    else {
      endpoints = epset->second;
    }
    
    endpoints->insert(id2);
    cout << "  " << id1 << " <-> " << id2 << endl;
  }
}

//------------------------------------------------------------------
// Attack
//------------------------------------------------------------------

// Generators (from XML)

void Attack::GenerateLocalPreconditions(DOM_Element *element)
{
  cout << "  Local preconditions:" << endl;
  GeneratePreconditions(element, locals);

  for (set <Precondition *>::iterator cond = locals.begin(); cond != locals.end(); cond++) {
    cout << "    " << *cond << endl;
  }
}

void Attack::GenerateGlobalPreconditions(DOM_Element *element)
{
  cout << "  Global preconditions:" << endl;

  // A CVE id is automatically a precondition
  if (cveids.size() <= 1) {
    for (DOMStringSet::iterator cvename = cveids.begin(); cvename != cveids.end(); cvename++) {
      DOMString nm = *cvename;
      globals.insert(new VulnerabilityPrecondition(network->auxilary->enames[TARGET], nm));
      break;
    }
  }
  else {
    OrPrecondition *Disjunction = new OrPrecondition();
    for (DOMStringSet::iterator cvename = cveids.begin(); cvename != cveids.end(); cvename++) {
      DOMString nm = *cvename;
      Disjunction->AddDisjunct(new VulnerabilityPrecondition(network->auxilary->enames[TARGET], nm));
    }
    globals.insert((Precondition *) Disjunction);
  }
  
  GeneratePreconditions(element, globals);

  for (set <Precondition *>::iterator cond = globals.begin(); cond != globals.end(); cond++) {
    cout << "    " << *cond << endl;
  }
}

void Attack::GeneratePreconditions(DOM_Element *element, set <Precondition *>& preconditions)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    // Required privilege level
    if (nodeName.equals(network->auxilary->enames[PRIVILEGE])) {
      DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
      if (!host.equals(network->auxilary->enames[SOURCE]) && !host.equals(network->auxilary->enames[TARGET])) {
        cerr << "Warning: Bad or missing host attribute in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      DOMString rel = el->getAttribute(network->auxilary->enames[REL]);
      char *relstr;
      if (rel.equals(network->auxilary->enames[GTE]))
        relstr = ">=";
      else if (rel.equals(network->auxilary->enames[EQ]))
        relstr =  "=";
      else if (rel.equals(network->auxilary->enames[LTE]))
        relstr =  "<=";
      else {
        cerr << "Warning: Bad or missing relation attribute in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      DOMString value = el->getAttribute(network->auxilary->enames[VALUE]);
      if (!value.equals(network->auxilary->enames[NONE]) && !value.equals(network->auxilary->enames[USER])
          && !value.equals(network->auxilary->enames[ROOT])) {
        cerr << "Warning: Bad or missing privilege value attribute in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      preconditions.insert(new PrivilegePrecondition(host, relstr, value));
    }
    // Attacker's and network service port numbers must agree
    else if (nodeName.equals(network->auxilary->enames[SERVICE_PORT_AGREEMENT])) {
      DOMString service = el->getAttribute(network->auxilary->enames[SERVICE]);
      if (network->sid.find(service) == network->sid.end()) {
        cerr << "Warning: Bad or missing service name attribute in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      preconditions.insert(new SPAPrecondition(service));
    }
    // Required vulnerability on a host
    else if (nodeName.equals(network->auxilary->enames[VULNERABILITY])) {
      DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
      if (!host.equals(network->auxilary->enames[SOURCE]) && !host.equals(network->auxilary->enames[TARGET])) {
        cerr << "Warning: Bad or missing host attribute in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
      if (network->vulnerabilities.find(nm) == network->vulnerabilities.end()) {
        cerr << "Warning: Bad or missing vulnerability name '"
             << nm << "'" << endl << "in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      preconditions.insert(new VulnerabilityPrecondition(host, nm));
    }
    // Required service running on a host
    else if (nodeName.equals(network->auxilary->enames[SERVICE])) {
      DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
      if (!host.equals(network->auxilary->enames[SOURCE]) && !host.equals(network->auxilary->enames[TARGET])) {
        cerr << "Warning: Bad or missing host attribute in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
      if (network->sid.find(nm) == network->sid.end()) {
        cerr << "Warning: Bad or missing service name '"
             << nm << "'" << endl << "in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      preconditions.insert(new ServicePrecondition(host, nm));
    }
    // Required knowledge for the intruder
    else if (nodeName.equals(network->auxilary->enames[KNOWLEDGE])) {
      DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
      if (network->adversary.knowledge.find(nm) == network->adversary.knowledge.end()) {
        cerr << "Warning: Bad or missing knowledge name '"
         << nm << "'" << endl << "in precondition of attack "
         << name << ", ignored" << endl;
        continue;
      }

      DOMString value = el->getAttribute(network->auxilary->enames[VALUE]);
      if (!value.equals(network->auxilary->enames[XML_TRUE]) && !value.equals(network->auxilary->enames[XML_FALSE])) {
        cerr << "Warning: Bad or missing knowledge value in precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      preconditions.insert(new KnowledgePrecondition(nm, value));
    }
    // Required connectivity between source and target hosts
    else if (nodeName.equals(network->auxilary->enames[CONNECTIVITY])) {
      
      if ( network->DoesModelHaveFirewalls() ) {
        cerr << "Warning: attack " << name << ": \"connectivity\" attack precondition in model with firewalls, the precondition is ignored" << endl;
        continue;
      }
      
      DOMString service = el->getAttribute(network->auxilary->enames[SERVICE]);
      if ((!service.equals(network->auxilary->enames[EMPTY])) && (network->sid.find(service) == network->sid.end())) {
        cerr << "Warning: Bad or missing service name attribute in connectivity precondition of attack "
             << name << ", ignored" << endl;
        continue;
      }

      // Check whether the connectivity should go from source to target or vice versa
      int connsource = SOURCE;
      DOMString from = el->getAttribute(network->auxilary->enames[FROM]);
      if (from.equals(network->auxilary->enames[TARGET]))
        connsource = TARGET;
            
      ServiceID id;
      if (service.equals(network->auxilary->enames[EMPTY]))
        id = 0;
      else {
        id = network->sid[service];
      }
      preconditions.insert(new ConnectivityPrecondition( network, service, id, connsource));
    }
    // Required trust between source and target hosts
    else if (nodeName.equals(network->auxilary->enames[TRUST])) {
      preconditions.insert(new TrustPrecondition());
    }
    // Target doesn't yet trust someone
    else if (nodeName.equals(network->auxilary->enames[NO_TRUST])) {
      preconditions.insert(new NoTrustPrecondition( network ));
    }
    else if (nodeName.equals(network->auxilary->enames[SENTOBJECT])) {
      DOMString obj_name = el->getAttribute(network->auxilary->enames[OBJECT]);
      DOMString host = el->getAttribute(network->auxilary->enames[DSTHOST]);
      DOMString dstsvc = el->getAttribute(network->auxilary->enames[DSTSVC]);
      
      if ( obj_name.equals(network->auxilary->enames[EMPTY]) ) {
        cout << "Warning: Missing \'object\' attribute in attack sentobject precondition, ignored" << endl;
        continue;
      }
      
      if ( dstsvc.equals(network->auxilary->enames[EMPTY]) ) {
        cout << "Warning: Missing \'dstsvc\' attribute in attack sentobject precondition, ignored" << endl;
        continue;
      }
      
      if (network->ports.find( dstsvc ) == network->ports.end())
        cerr << "Warning: unknown service " << dstsvc << " in 'passarg' effect, ignored" << endl;
      else {
      
        if ( host.equals(network->auxilary->enames[EMPTY]) ) 
          cout << "Warning: Missing 'dsthost' attribute in attack sentobject precondition, \'target\' is used as default value" << endl;
        
        SentObjectPrecondition *sentobj_precond = new SentObjectPrecondition( (host.equals(network->auxilary->enames[SOURCE])? SOURCE: TARGET), dstsvc, obj_name );
        
        host = el->getAttribute(network->auxilary->enames[SRCHOST]);
        
        if ( !host.equals(network->auxilary->enames[EMPTY]) )
          sentobj_precond->SetSource( host.equals(network->auxilary->enames[SOURCE])? SOURCE: TARGET );
        
        preconditions.insert( sentobj_precond );
        
        HostObjectAttrNameMap::iterator obj_iter = network->host_objects.find(obj_name);
        if ( obj_iter == network->host_objects.end() ) {
          network->host_objects[obj_name] = DOMStringSet();
          obj_iter = network->host_objects.find(obj_name);
        }
        
        network->AddService( dstsvc, 0 );
      }
    }  
    //Required host object
    else if (nodeName.equals(network->auxilary->enames[OBJECT])) {
      DOMString obj_name = el->getAttribute(network->auxilary->enames[NAME]);
      DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
  
      if ( obj_name.equals(network->auxilary->enames[EMPTY]) ) {
        cout << "Warning: Missing name attribute in attack object precondition, ignored" << endl;
        continue;
      }
      
      if ( host.equals(network->auxilary->enames[EMPTY]) ) {
        cout << "Warning: Missing host attribute in attack object precondition" << obj_name << ", ignored" << endl;
        continue;
      }
      
      HostObjectAttrNameMap::iterator obj_iter = network->host_objects.find(obj_name);
      if ( obj_iter == network->host_objects.end() ) {
        network->host_objects[obj_name] = DOMStringSet();
        obj_iter = network->host_objects.find(obj_name);
      }
      
      ObjectPrecondition *obj_precond = new ObjectPrecondition( (host.equals(network->auxilary->enames[SOURCE])? SOURCE: TARGET), obj_name );
      
      for (DOM_Node child = el->getFirstChild(); child != 0; child = child.getNextSibling()) {
        
        if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
          
        DOMString nodeName = child.getNodeName();
        if ( !nodeName.equals(network->auxilary->enames[OBJECT_ATTRIBUTE]) )
          cout << "Warning: Incorrect tag " << nodeName << ", ignored" << endl;
        else
        {
          DOM_Element *elem = (DOM_Element *) &child;
          DOMString attr_name = elem->getAttribute(network->auxilary->enames[NAME]);
          
          if ( attr_name.equals(network->auxilary->enames[EMPTY]) ) {
            cerr << "Warning: Missing name attribute in object attrib. of attack precondition " 
                 << obj_name << ", ignored" << endl;
            continue;
          }
          
          DOMString attr_value = elem->getAttribute(network->auxilary->enames[VALUE]);
          
          if ( attr_value.equals(network->auxilary->enames[EMPTY]) ) {
            cerr << "Warning: Missing value attribute in object attrib. of attack precondition " 
                 << obj_name << ":" << attr_name << ", ignored" << endl;
            continue;
          }
          
          //Add names/values to network structure
          obj_iter->second.insert( attr_name );
          attr_value = network->GetAttrConstant( attr_value );
          network->obj_attr_values.insert( attr_value );
          
          obj_precond->SetObjAttribute( attr_name, attr_value );
        }
      }
      
      preconditions.insert( obj_precond );
    }
    //Reachability through a firewall
    else if ( nodeName.equals(network->auxilary->enames[FIREWALL_REACHABLE]) ) {
           
      if ( !network->DoesModelHaveFirewalls() ) {
        cerr << "Warning: attack " << name << " has \"firewall_reachable\" precondition but the model does not have firewalls, the precondition is ignored" << endl;
        continue;
      }
      
      DOMString srcportname = el->getAttribute(network->auxilary->enames[SRCPORT]);
      if ( srcportname.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing srcport attribute in 'firewall_reachable' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      if ( !network->IsFirewallPortDefined( srcportname ) ) {
        cerr << "Warning: Undefined srcport " << srcportname << " in 'firewall_reachable' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      
      DOMString dstportname = el->getAttribute(network->auxilary->enames[DSTPORT]);
      if ( dstportname.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing dstport attribute in 'firewall_reachable' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      if ( !network->IsFirewallPortDefined( dstportname ) ) {
        cerr << "Warning: Undefined dstport " << dstportname << " in 'firewall_reachable' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      
      int     srchost  = SOURCE;
      int     dsthost  = TARGET;
       
      DOMString srchostname = el->getAttribute(network->auxilary->enames[SRCHOST]);      
      if ( !srchostname.equals(network->auxilary->enames[EMPTY]) ) {
        if ( srchostname.equals(network->auxilary->enames[TARGET]) )
          srchost = TARGET;
        else if ( !srchostname.equals(network->auxilary->enames[SOURCE]) )
          cerr << "Warning: Wrong value of srchost attribute in 'firewall_reachable' precomdition of attack " << name << ", default value 'source' is assumed" << endl;
      }
      
      DOMString dsthostname = el->getAttribute(network->auxilary->enames[DSTHOST]);      
      if ( !dsthostname.equals(network->auxilary->enames[EMPTY]) ) {
        if ( dsthostname.equals(network->auxilary->enames[SOURCE]) )
          dsthost = SOURCE;
        else if ( !dsthostname.equals(network->auxilary->enames[TARGET]) )
          cerr << "Warning: Wrong value of dsthost attribute in 'firewall_reachable' precomdition of attack " << name << ", default value 'target' is assumed" << endl;
      }
      
      FirewallReachablePrecondition *fprecond = new FirewallReachablePrecondition( srchost, srcportname, dsthost, dstportname );
      preconditions.insert( fprecond );
    }
    //firewall allows/denies traffic between hosts/ports
    else if ( nodeName.equals(network->auxilary->enames[RULE]) ) {
      
      PortID srcport;
      PortID dstport;
      HostID srchost;
      HostID dsthost;
      if ( !network->DoesModelHaveFirewalls() ) {
        cerr << "Warning: attack " << name << " has \"rule\" precondition but the model does not have firewalls, precondition is ignored" << endl;
        continue;
      }
      
      DOMString firewallname = el->getAttribute(network->auxilary->enames[FIREWALL]);
      
      if ( !firewallname.equals(network->auxilary->enames[TARGET_FW]) )
        cerr << "Warning: Missing or bad firewall attribute '" << firewallname << "' in precondition of attack '" << name << "', the default 'target_fw' is assumed" << endl;
      
      DOMString srcportname = el->getAttribute(network->auxilary->enames[SRCPORT]);
      if ( srcportname.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing 'srcport' attribute in 'rule' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      if ( !network->IsFirewallPortDefined( srcportname ) ) {
        cerr << "Warning: Undefined value of 'srcport' attribute '" << srcportname << "' in 'rule' precondition of attack " << name << ", precondition ignored" << endl;
        continue;
      }
      srcport = network->GetFirewallPortID( srcportname );
      
      DOMString dstportname = el->getAttribute(network->auxilary->enames[DSTPORT]);
      if ( dstportname.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing 'dstport' attribute in 'rule' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      if ( !network->IsFirewallPortDefined( dstportname ) ) {
        cerr << "Warning: Undefined value of 'dstport' attribute " << dstportname << " in 'rule' precondition of attack " << name << ", ignored" << endl;
        continue;
      }
      dstport = network->GetFirewallPortID( dstportname );
            
             
      DOMString srch = el->getAttribute( network->auxilary->enames[SRCHOST] );
      if ( srch.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing 'srchost' attribute in 'rule' precondition of attack; precondition is ignored" << endl;
        continue;
      }
      
      if ( network->hid.find( srch ) == network->hid.end() ) {
        cerr << "Warning: Undefined value of 'srchost' attribute '" << srch << "' in 'rule' precondition of attack " << name << "; precondition is ignored"  << endl;
        continue;
      }
      srchost = network->GetHostID( srch );
      

      DOMString dsth = el->getAttribute( network->auxilary->enames[DSTHOST] );
      if ( dsth.equals(network->auxilary->enames[EMPTY]) ) {
        cerr << "Warning: Missing 'dsthost' attribute in 'rule' precondition of attack; precondition is ignored" << endl;
        continue;
      }
      
      if ( network->hid.find( dsth ) == network->hid.end() ) {
        cerr << "Warning: Undefined value of 'dsthost' attribute '" << dsth << "' in 'rule' precondition of attack " << name << "; precondition is ignored"  << endl;
        continue;
      }
      dsthost = network->GetHostID( dsth );

      
      bool       result   = true;
      
      DOMString resultname = el->getAttribute(network->auxilary->enames[RESULT]);
      if ( resultname.equals(network->auxilary->enames[EMPTY]) )
        cerr << "Warning: Missing result attribute in 'rule' precondition of attack " << name << ", default value 'allow' is asummed" << endl;
      else if ( resultname.equals(network->auxilary->enames[DENY]) )
        result = false;
      else if ( !resultname.equals(network->auxilary->enames[ALLOW]) )
        cerr << "Warning: Bad value of 'result' attribute '" << resultname << "' in 'rule' precondition of attack " << name << ", default value 'allow' is asummed" << endl;
      
      FirewallRulePrecondition *fprecond = new FirewallRulePrecondition( network, srchost, srcport, dsthost, dstport, result );
      preconditions.insert( fprecond );
      
      SetAttackOnFirewall();
    }
    else
      cerr << "Warning: Unknown precondition tag '" << nodeName << "' in attack '" << name << "', ignored";
  }
}

void Attack::CountingPreconditions(DOM_Element *element)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    // Attacker's and network service port numbers must agree
    if (nodeName.equals(network->auxilary->enames[SERVICE_PORT_AGREEMENT])) {
      DOMString service = el->getAttribute(network->auxilary->enames[SERVICE]);
      network->AddService(service, 0);
    }
    // Required vulnerability on a host
    else if (nodeName.equals(network->auxilary->enames[VULNERABILITY])) {
      DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
      network->AddVul(nm);
    }
    // Required service running on a host
    else if (nodeName.equals(network->auxilary->enames[SERVICE])) {
      DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
      network->AddService(nm, 0);
    }
    else if (nodeName.equals(network->auxilary->enames[SENTOBJECT])) {
      DOMString dstsvc = el->getAttribute(network->auxilary->enames[DSTSVC]);
      network->AddService(dstsvc, 0);
    }
    //Firewall ports
    else if (nodeName.equals(network->auxilary->enames[RULE]) ||
             nodeName.equals(network->auxilary->enames[FIREWALL_REACHABLE])) {
      DOMString port = el->getAttribute(network->auxilary->enames[SRCPORT]);
      if ( !port.equals(network->auxilary->enames[EMPTY]) && 
           !port.equals(network->auxilary->enames[WILDCARD_ALL]))
        network->AddFirewallPort( port );
      
      port = el->getAttribute(network->auxilary->enames[DSTPORT]);
      if ( !port.equals(network->auxilary->enames[EMPTY]) &&
           !port.equals(network->auxilary->enames[WILDCARD_ALL]))
        network->AddFirewallPort( port );
    }
  }
}

void Attack::GenerateTrace(DOM_Element *element)
{
}

void Attack::GenerateLocalEffects(DOM_Element *element)
{
  GenerateEffects(element);
}

void Attack::GenerateGlobalEffects(DOM_Element *element)
{
  GenerateEffects(element);
}

void Attack::GenerateEffects(DOM_Element *element)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
    DOMString source = el->getAttribute(network->auxilary->enames[SOURCE]);
    DOMString value = el->getAttribute(network->auxilary->enames[VALUE]);
    DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
    
    // privilege level
    if (nodeName.equals(network->auxilary->enames[PRIVILEGE])) {
      Effect *effect = new Effect(host, source, nm, value, network->aid[name], Effect::PRIVILEGE);
      network->priveff.push_back(effect);
      effects.push_back(effect);
    }
    // vulnerability on a host
    else if (nodeName.equals(network->auxilary->enames[VULNERABILITY])) {
      Effect *effect = new Effect(host, source, nm, value, network->aid[name], Effect::VULNERABILITY);
      network->vuleff.push_back(effect);
      effects.push_back(effect);
    }
    // service running on a host
    else if (nodeName.equals(network->auxilary->enames[SERVICE])) {
      Effect *effect = new Effect(host, source, nm, value, network->aid[name], Effect::SERVICE);
      network->svceff.push_back(effect);
      effects.push_back(effect);
    }
    // connectivity between source and target hosts
    else if (nodeName.equals(network->auxilary->enames[CONNECTIVITY])) {
      Effect *effect = new Effect(host, source, nm, value, network->aid[name], Effect::CONNECTIVITY);
      network->conneff.push_back(effect);
      effects.push_back(effect);
    }
    // trust between source and target hosts
    else if (nodeName.equals(network->auxilary->enames[TRUST])) {
      Effect *effect = new Effect(host, source, nm, value, network->aid[name], Effect::TRUST);
      network->trusteff.push_back(effect);
      effects.push_back(effect);
    }
    // change in intruder knowledge
    else if (nodeName.equals(network->auxilary->enames[KNOWLEDGE])) {
      Effect *effect = new Effect(host, source, nm, value, network->aid[name], Effect::KNOWLEDGE);
      network->knoweff.push_back(effect);
      effects.push_back(effect);
    }
    //send object from source host to target one
    else if (nodeName.equals(network->auxilary->enames[SENDOBJECT])) {
      DOMString srchost = el->getAttribute(network->auxilary->enames[SRCHOST]);
      DOMString dsthost = el->getAttribute(network->auxilary->enames[DSTHOST]);
      DOMString obj_name = el->getAttribute(network->auxilary->enames[OBJECT]);
      DOMString dst_service = el->getAttribute(network->auxilary->enames[DSTSVC]);
      
      if (network->ports.find( dst_service ) == network->ports.end())
        cerr << "Warning: unknown service " << dst_service << " in 'sendobject' effect, ignored" << endl;
      else {
        HostObjectAttrNameMap::iterator obj_iter = network->host_objects.find(obj_name);
              
        if ( obj_iter == network->host_objects.end() ) {
          network->host_objects[obj_name] = DOMStringSet();
          obj_iter = network->host_objects.find(obj_name);
        }
              
        SendObjectEffect *effect = new SendObjectEffect( srchost, dsthost, dst_service, obj_name, network->aid[name] );
        
        network->objeff.push_back(effect);
        effects.push_back(effect);
      }
    }
    // set service of an object on target host
    else if ( nodeName.equals( network->auxilary->enames[PASSARG] ) ) {
      DOMString obj_name = el->getAttribute(network->auxilary->enames[OBJECT]);
      DOMString service = el->getAttribute(network->auxilary->enames[SERVICE]);
      HostObjectAttrNameMap::iterator obj_iter = network->host_objects.find(obj_name);
      
      if (network->ports.find( service ) == network->ports.end())
        cerr << "Warning: unknown service " << service << " in 'passarg' effect, ignored" << endl;
      else {
      
        if ( obj_iter == network->host_objects.end() ) {
          network->host_objects[obj_name] = DOMStringSet();
          obj_iter = network->host_objects.find(obj_name);
        }
        
        PassArgEffect *effect = new PassArgEffect( service, obj_name, network->aid[name] );
        
        network->passargeff.push_back( effect );
        effects.push_back( effect );
      }
    }
    //firewall allows/denies traffic between hosts/ports
    else if ( nodeName.equals(network->auxilary->enames[RULE]) ) {
      
      if ( !network->DoesModelHaveFirewalls() ) {
        cerr << "Warning: attack " << name << " has \"rule\" effect but the model does not have firewalls, the effect is ignored" << endl;
        continue;
      }
      
      DOMString firewallname = el->getAttribute(network->auxilary->enames[FIREWALL]);
      DOMString dstportname = el->getAttribute(network->auxilary->enames[DSTPORT]);
      DOMString srchostname = el->getAttribute(network->auxilary->enames[SRCHOST]);
      DOMString dsthostname = el->getAttribute(network->auxilary->enames[DSTHOST]);
      DOMString srcportname = el->getAttribute(network->auxilary->enames[SRCPORT]);
      DOMString resultname = el->getAttribute(network->auxilary->enames[RESULT]);
      DOMString statusname = el->getAttribute(network->auxilary->enames[STATUS]);
      FirewallActionEffect *effect = 0;
      
      if ( firewallname.equals(network->auxilary->enames[EMPTY]) )
        cerr << "Warning: Missing firewall name in effect of attack " << name << ", default value 'targed_fw' is assumed" << endl;
        
      if ( !firewallname.equals(network->auxilary->enames[TARGET_FW]) )
        cerr << "Warning: Bad 'firewall' attribute value '" << firewallname << "' in effect of attack " << name << ", default value 'target_fw' is assumed" << endl;
                
      bool fstatus = (srchostname.equals(network->auxilary->enames[EMPTY]) &&
                      dsthostname.equals(network->auxilary->enames[EMPTY]) && 
                      srcportname.equals(network->auxilary->enames[EMPTY]) &&
                      dstportname.equals(network->auxilary->enames[EMPTY]));
      
      if ( fstatus ) {
        fstatus = false;
        if ( statusname.equals(network->auxilary->enames[EMPTY]) ) 
          cerr << "Warning: Missing 'status' attribute in 'rule' effect of attack " << name << ", default value 'off' is assumed" << endl;
        
        if ( statusname.equals(network->auxilary->enames[ON]) )
          fstatus = true;
        else if ( !statusname.equals(network->auxilary->enames[OFF]) )
          cerr << "Warning: Wrong value of 'status' attribute in 'rule' effect of attack " << name << ", default value 'off' is assumed" << endl;
        
        effect = new FirewallActionEffect( network, fstatus, network->aid[name] );
      }
      else {  
        int   srchost;
        int   dsthost;
        int   srcport;
        int   dstport;
        bool  result = true;
      
        if ( srcportname.equals(network->auxilary->enames[EMPTY]) ) {
          cerr << "Warning: Missing 'srcport' attribute in 'rule' effect of attack " << name << ", effect ignored" << endl;
          continue;
        }
        if ( srcportname.equals(network->auxilary->enames[WILDCARD_ALL]) )
          srcport = -1;
        else {
          if ( !network->IsFirewallPortDefined(srcportname) ) {
            cerr << "Warning: Undefined value of 'srcport' attribute '" << srcportname << "' in 'rule' effect of attack " << name << ", effect ignored" << endl;
            continue;
          }
          srcport = (int)network->GetFirewallPortID(srcportname);
        }
        
        if ( dstportname.equals(network->auxilary->enames[EMPTY]) ) {
          cerr << "Warning: Missing 'dstport' attribute in 'rule' effect of attack " << name << ", effect ignored" << endl;
          continue;
        }
        if ( dstportname.equals(network->auxilary->enames[WILDCARD_ALL]) )
          dstport = -1;
        else {
          if ( !network->IsFirewallPortDefined(dstportname) ) {
            cerr << "Warning: Undefined value of 'dstport' attribute '" << dstportname << "' in 'rule' effect of attack " << name << ", effect ignored" << endl;
            continue;
          }
          dstport = (int)network->GetFirewallPortID(dstportname);
        }
        
        if ( srchostname.equals(network->auxilary->enames[EMPTY]) ) {
          cerr << "Warning: Missing 'srchost' attribute in 'rule' effect of attack " << name << ", effect ignored" << endl;
          continue;
        }
        if ( srchostname.equals(network->auxilary->enames[WILDCARD_ALL] ) )
          srchost = -1;
        else {
          if ( network->hid.find(srchostname) == network->hid.end() ) {
            cerr << "Warning: Undefined value of 'srchost' attribute '" << srchostname << "' in 'rule' effect of attack " << name << ", effect ignored" << endl;
            continue;
          }
          srchost = (int)network->hid[srchostname];
        }
               
        if ( dsthostname.equals(network->auxilary->enames[EMPTY]) ) {
          cerr << "Warning: Missing 'dsthost' attribute in 'rule' effect of attack " << name << ", effect ignored" << endl;
          continue;
        }
        if ( dsthostname.equals(network->auxilary->enames[WILDCARD_ALL] ) )
          dsthost = -1;
        else {
          if ( network->hid.find(dsthostname) == network->hid.end() ) {
            cerr << "Warning: Undefined value of 'dsthost' attribute '" << dsthostname << "' in 'rule' effect of attack " << name << ", effect ignored" << endl;
            continue;
          }
          dsthost = (int)network->hid[dsthostname];
        }
                
        if ( resultname.equals(network->auxilary->enames[EMPTY]) )
          cerr << "Warning: Missing result attribute in 'rule' effect of attack " << name << ", default value 'allow' is asummed" << endl;
        else if ( resultname.equals(network->auxilary->enames[DENY]) )
          result = false;
        else if ( !resultname.equals(network->auxilary->enames[ALLOW]) )
          cerr << "Warning: Wrong value of result attribute in 'rule' effect of attack " << name << ", default value 'allow' is asummed" << endl;
        
        effect = new FirewallActionEffect( network, srchost, srcport, dsthost, dstport, result, network->aid[name] );
      }
      
      effects.push_back( effect );
      network->firewalleff.push_back( effect );
      SetAttackOnFirewall();
    }
    else
      cerr << "Warning: Unknown effect tag '" << nodeName << "' in attack '" << name << "', ignored";
  }
}

void Attack::CountingEffects(DOM_Element *element)
{
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    DOMString nodeName = el->getNodeName();
    DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
    
    // vulnerability on a host
    if (nodeName.equals(network->auxilary->enames[VULNERABILITY])) {
      network->AddVul(nm);
    }
    // service running on a host
    else if (nodeName.equals(network->auxilary->enames[SERVICE])) {
      network->AddService(nm, 0);
    }
    // connectivity between source and target hosts
    else if (nodeName.equals(network->auxilary->enames[CONNECTIVITY])) {
      network->AddService(nm, 0);
    }
    //passing object as service arg 
    else if ( nodeName.equals( network->auxilary->enames[PASSARG] ) ) {
      DOMString service = el->getAttribute(network->auxilary->enames[SERVICE]);
      network->AddService( service, 0 );
    }
    //send object
    else if (nodeName.equals(network->auxilary->enames[SENDOBJECT])) {
      DOMString service = el->getAttribute(network->auxilary->enames[DSTSVC]);
      network->AddService( service, 0 );
    }
    //firewall rule
    else if (nodeName.equals(network->auxilary->enames[RULE])) {
      DOMString port = el->getAttribute(network->auxilary->enames[SRCPORT]);
      if ( !port.equals(network->auxilary->enames[EMPTY]) && 
           !port.equals(network->auxilary->enames[WILDCARD_ALL]))
        network->AddFirewallPort( port );
      
      port = el->getAttribute(network->auxilary->enames[DSTPORT]);
      if ( !port.equals(network->auxilary->enames[EMPTY]) &&
           !port.equals(network->auxilary->enames[WILDCARD_ALL]))
        network->AddFirewallPort( port );
    }
    
  }
}

void Attack::GenerateDetectable(DOM_Element *element)
{
  DOMString det = element->getAttribute(network->auxilary->enames[MODE]);
  if (det.equals(network->auxilary->enames[EMPTY])) {
    cerr << "Warning: Missing mode tag in detectability specification of "
	 << name << ", ignored" << endl;
    return;
  }

  if (det.equals(network->auxilary->enames[YES])) {
    detectable = Yes;
    cout << "  detectable" << endl;
  }
  else if (det.equals(network->auxilary->enames[NO])) {
    detectable = No;
    cout << "  stealthy" << endl;
  }
  else if (det.equals(network->auxilary->enames[BOTH])) {
    detectable = Varies;
    cout << "  detectable and stealthy flavors" << endl;
  }
  else {
    detectable = No;
    cerr << "Warning: Unrecognized detectability mode: " << det
	 << ", setting default to stealthy" << endl;
  }
}

void LTLFormula::GenerateAtomicProposition( Network *network, DOM_Element *element )
{
  DOMString prop = element->getAttribute(network->auxilary->enames[NAME]);
  
  if ( prop.equals(network->auxilary->enames[EMPTY]) )
    cerr << "Warning: The name of LTL proposition is not specified, ignored" << endl;
  else if ( m_atomic_precond.find(prop) != m_atomic_precond.end() )
    cerr << "Warning: Duplication of LTL proposition " << prop << ", ignored" << endl;
  else {
    
    DOM_Node child = element->getFirstChild();
    for (; child != 0; child = child.getNextSibling()) 
      if (child.getNodeType() == DOM_Node::ELEMENT_NODE)
        break;
      
    DOM_Element *el = (DOM_Element *) &child;
        
    if ( el == 0 )
      cerr << "Warning: the LTL proposition " << prop << " is not specified, ignored" << endl;
    else {
      
      DOMString nodeName = el->getNodeName();
    
      // Required privilege level
      if (nodeName.equals(network->auxilary->enames[PRIVILEGE])) {

        DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
        
        if ( !network->IsHostAdded( host ) )
          cerr << "Warning: Bad or missing host attribute in privilege LTL proposition " << prop
	              << ", ignored" << endl;
        else {
          HostID    host_id = network->GetHostID( host );
          DOMString rel = el->getAttribute(network->auxilary->enames[REL]);
          string relstr = "=";
          if (rel.equals(network->auxilary->enames[GTE]))
            relstr = ">=";
          else if (rel.equals(network->auxilary->enames[EQ]))
            relstr =  "=";
          else if (rel.equals(network->auxilary->enames[LTE]))
            relstr =  "<=";
          else if (rel.equals(network->auxilary->enames[LS]))
            relstr =  "<";
          else if (rel.equals(network->auxilary->enames[GT]))
            relstr =  ">";
          else {
            cerr << "Warning: Bad or missing relation attribute in privilege LTL proposition " << prop
                  << ", default is 'equal' relation" << endl;
          }
  
          DOMString value = el->getAttribute(network->auxilary->enames[VALUE]);
          
          if (!value.equals(network->auxilary->enames[NONE]) && 
              !value.equals(network->auxilary->enames[USER]) && 
              !value.equals(network->auxilary->enames[ROOT])) {
            cerr << "Warning: Bad or missing privilege value attribute in privilege LTL proposition " << prop
                  << ", ignored" << endl;
          }
          else
            m_atomic_precond[prop] = new LTLPrivilegeProposition(host_id, relstr, value);
        }
      }
      // Required vulnerability on a host
      else if (nodeName.equals(network->auxilary->enames[VULNERABILITY])) {
        
        DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
        if (!network->IsHostAdded( host ))
          cerr << "Warning: Bad or missing host attribute in vulnerability LTL proposition " << prop
               << ", ignored" << endl;
	      else {
          HostID    host_id = network->GetHostID( host );
          DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
          if (network->vulnerabilities.find(nm) == network->vulnerabilities.end())
            cerr << "Warning: Bad or missing vulnerability name '" << nm << "'" << endl 
                 << "vulnerability LTL proposition " << prop << ", ignored" << endl;
          else
            m_atomic_precond[prop] = new LTLVulnerabilityProposition(host_id, nm);
        }
      }
      // Required service running on a host
      else if (nodeName.equals(network->auxilary->enames[SERVICE])) {
        
        DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
        if (!network->IsHostAdded( host ))
          cerr << "Warning: Bad or missing host attribute in service LTL proposition " << prop
               << ", ignored" << endl;
        else {
          HostID    host_id = network->GetHostID( host );
          DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
          if (network->sid.find(nm) == network->sid.end())
            cerr << "Warning: Bad or missing service name '" << nm << "'" << endl 
                 << "in service LTL proposition " << prop << ", ignored" << endl;
          else
            m_atomic_precond[prop] = new LTLServiceProposition(host_id, nm);
        }
      }
      // Required knowledge for the intruder
      else if (nodeName.equals(network->auxilary->enames[KNOWLEDGE])) {
      
        DOMString nm = el->getAttribute(network->auxilary->enames[NAME]);
        if (network->adversary.knowledge.find(nm) == network->adversary.knowledge.end())
          cerr << "Warning: Bad or missing knowledge name '" << nm << "'" << endl 
               << "in knowledge LTL proposition " << prop << ", ignored" << endl;
        else {
          
          DOMString value = el->getAttribute(network->auxilary->enames[VALUE]);
          
          if ( value.equals(network->auxilary->enames[EMPTY]) ) // default value is TRUE
            m_atomic_precond[prop] = new LTLKnowledgeProposition(nm);
          else if (!value.equals(network->auxilary->enames[XML_TRUE]) && !value.equals(network->auxilary->enames[XML_FALSE]))
            cerr << "Warning: Bad or missing knowledge value in knowledge LTL proposition " << prop
                 << ", ignored" << endl;
          else
            m_atomic_precond[prop] = new LTLKnowledgeProposition(nm, value);
        }
      }
      // Required connectivity between source and target hosts
      else if (nodeName.equals(network->auxilary->enames[CONNECTIVITY])) {
      
        DOMString host = el->getAttribute(network->auxilary->enames[SRCHOST]);
        if (!network->IsHostAdded( host ))
          cerr << "Warning: Bad or missing srchost attribute in connectivity LTL proposition " << prop
               << ", ignored" << endl;
        else {
          HostID src_host_id = network->GetHostID( host );
          
          host = el->getAttribute(network->auxilary->enames[DSTHOST]);
          if (!network->IsHostAdded( host ))
            cerr << "Warning: Bad or missing dsthost attribute in connectivity LTL proposition " << prop
                 << ", ignored" << endl;
          else {
            HostID dst_host_id = network->GetHostID( host );
            
            DOMString service = el->getAttribute(network->auxilary->enames[SERVICE]);
            
            if ( service.equals(network->auxilary->enames[EMPTY]) ) 
               m_atomic_precond[prop] = new LTLConnectivityProposition(src_host_id, dst_host_id);
            else if ( network->sid.find(service) == network->sid.end() )
              cerr << "Warning: Bad service name attribute in connectivity LTL proposition " << prop
                   << ", ignored" << endl;
            else
              m_atomic_precond[prop] = new LTLConnectivityProposition(src_host_id, dst_host_id, service );
          }
        }
      }
      // Required trust between source and target hosts
      else if (nodeName.equals(network->auxilary->enames[TRUST])) {
        
        DOMString host = el->getAttribute(network->auxilary->enames[SRCHOST]);
        if (!network->IsHostAdded( host ))
          cerr << "Warning: Bad or missing srchost attribute in trust LTL proposition " << prop
               << ", ignored" << endl;
        else {
          HostID src_host_id = network->GetHostID( host );
          
          host = el->getAttribute(network->auxilary->enames[DSTHOST]);
          if (!network->IsHostAdded( host ))
            cerr << "Warning: Bad or missing dsthost attribute in trust LTL proposition " << prop
                 << ", ignored" << endl;
          else {
            HostID dst_host_id = network->GetHostID( host );
            m_atomic_precond[prop] = new LTLTrustProposition(src_host_id, dst_host_id);
          }
        }
      }
      //SentObject from a source to a target host though a service
      else if (nodeName.equals(network->auxilary->enames[SENTOBJECT])) {
        DOMString obj_name = el->getAttribute(network->auxilary->enames[OBJECT]);
              
        if ( obj_name.equals(network->auxilary->enames[EMPTY]) ||
             network->host_objects.find(obj_name) == network->host_objects.end() )
          cout << "Warning: Bad or missing \'object\' attribute in sentobject LTL proposition" << prop << ", ignored" << endl;
        else {
          DOMString host = el->getAttribute(network->auxilary->enames[DSTHOST]);
          if (!network->IsHostAdded( host ))
            cerr << "Warning: Bad or missing srchost attribute in sentobject LTL proposition " << prop
                 << ", ignored" << endl;
          else {
            HostID dst_host_id = network->GetHostID( host );
            
            DOMString dstsvc = el->getAttribute(network->auxilary->enames[DSTSVC]);
              
            if ( !dstsvc.equals(network->auxilary->enames[EMPTY]) && 
                 network->ports.find( dstsvc ) == network->ports.end() )
              cerr << "Warning: Bad dstsvc attribute in sentobject LTL proposition " << prop
                   << ", ignored" << endl;
            else {
              
              LTLSentObjectProposition *sentobj_prop = 0;
              host = el->getAttribute(network->auxilary->enames[SRCHOST]);
              
              if ( host.equals(network->auxilary->enames[EMPTY]) ) {
                if ( dstsvc.equals(network->auxilary->enames[EMPTY]) )
                  cerr << "Warning: Both dstsvc and srchost attributes are missed in sentobject LTL proposition " << prop
                   << ", ignored" << endl;
                else
                  sentobj_prop = new LTLSentObjectProposition(dst_host_id, dstsvc, obj_name);
              }
              else if (!network->IsHostAdded( host ))
                cerr << "Warning: Bad srchost attribute in trust LTL proposition " << prop
                   << ", ignored" << endl;
              else {
                HostID src_host_id = network->GetHostID( host );
                
                if ( dstsvc.equals(network->auxilary->enames[EMPTY]) )
                  sentobj_prop = new LTLSentObjectProposition(dst_host_id, src_host_id, obj_name);
                else
                  sentobj_prop = new LTLSentObjectProposition(dst_host_id, src_host_id, dstsvc, obj_name);
              }  
              
              if ( sentobj_prop != 0 )
                m_atomic_precond[prop] = sentobj_prop;
            }
          }            
        }
      }  
      //Required host object
      else if (nodeName.equals(network->auxilary->enames[OBJECT])) {
      
        DOMString obj_name = el->getAttribute(network->auxilary->enames[NAME]);
        DOMString host = el->getAttribute(network->auxilary->enames[HOST]);
  
        if ( obj_name.equals(network->auxilary->enames[EMPTY]) ||
             network->host_objects.find(obj_name) == network->host_objects.end() )
          cout << "Warning: Bad or missing name attribute in object LTL proposition" << prop << ", ignored" << endl;
        else if ( host.equals(network->auxilary->enames[EMPTY]) || 
                  !network->IsHostAdded( host ) ) 
          cout << "Warning: Bad or missing host attribute in object LTL proposition" << prop << ", ignored" << endl;
        else {      
          
          HostID host_id = network->GetHostID( host );
          LTLObjectProposition *obj_prop = new LTLObjectProposition( host_id, obj_name );
      
          for (DOM_Node child = el->getFirstChild(); child != 0; child = child.getNextSibling()) {
            
            if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
              
            DOMString nodeName = child.getNodeName();
            if ( !nodeName.equals(network->auxilary->enames[OBJECT_ATTRIBUTE]) )
              cout << "Warning: Incorrect tag " << nodeName << ", ignored" << endl;
            else
            {
              DOM_Element *elem = (DOM_Element *) &child;
              DOMString attr_name = elem->getAttribute(network->auxilary->enames[NAME]);
              
              if ( attr_name.equals(network->auxilary->enames[EMPTY]) ) {
                cerr << "Warning: Missing name attribute in attrib. of object LTL proposition "  
                     << prop << ", ignored" << endl;
                continue;
              }
              
              DOMString attr_value = elem->getAttribute(network->auxilary->enames[VALUE]);
              
              if ( attr_value.equals(network->auxilary->enames[EMPTY]) ) {
                cerr << "Warning: Missing value attribute in attrib. of object LTL proposition " 
                     << prop << ":" << attr_name << ", ignored" << endl;
                continue;
              }
              
              //Add names/values to network structure
              attr_value = network->GetAttrConstant( attr_value );
              network->obj_attr_values.insert( attr_value );
              
              obj_prop->SetObjAttribute( attr_name, attr_value );
            }
          }
          m_atomic_precond[prop] = obj_prop;
        }
      }
    }    
  }
}

void LTLFormula::GenerateLTL( Network *network, DOM_Element *element )
{
  DOMString nodeName = element->getNodeName();

  if ( nodeName.equals(network->auxilary->enames[LTL_FORMULA]) ) {
        
    DOMString formula = element->getAttribute(network->auxilary->enames[FORMULA]);
    
    if ( formula.equals(network->auxilary->enames[EMPTY]) )
      cerr << "Warning: LTL formula is empty, ignored" << endl;
    else {
      
      m_exist = true;
      m_formula = formula;
      
      for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {
  
        if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
        DOM_Element *el = (DOM_Element *) &child;
      
        nodeName = el->getNodeName();
        
        if ( nodeName.equals(network->auxilary->enames[LTL_ATOMIC_PROPOSITION]) ) {
          GenerateAtomicProposition( network, el );
        }
      }   

      if ( m_atomic_precond.empty() )
        cerr << "Warning: there are no defined atomic propositions for LTL formula" << endl;        
    }
  }
}

long Host::GetMemSize() const
{
  long res = 0;
  
  res += GetDOMStringSize( name );
  
  res += sizeof( StringSet );
  for (StringSet::const_iterator sit = ip_addrs->begin(); sit != ip_addrs->end(); sit++)
    res += sit->size() + sizeof(string);
  
  res += strlen(netname) + 1;
  res += GetDOMStringSetSize( services );
  
  map <DOMString, DOMStringSet *, less_str>::const_iterator ssit;
  for ( ssit = connectivity.begin(); ssit != connectivity.end(); ssit++)
    res += sizeof(DOMString) + GetDOMStringSize( ssit->first ) +
           sizeof(DOMStringSet) + sizeof(DOMStringSet*) + 
           GetDOMStringSetSize( *(ssit->second) );
  
  res += GetDOMStringSetSize(trust);
  res += GetDOMStringSetSize(vulnerabilities);
  
  HostObjectMap::const_iterator hoit = objects.begin();
  for ( ; hoit != objects.end(); hoit++ )
    res += sizeof(DOMString) + GetDOMStringSize( hoit->first ) +
           sizeof(DOMStringMap) + GetDOMStringMapSize( hoit->second );
  
  return res;
}

long Attack::GetMemSize() const
{
  long res = 0;
  res += GetDOMStringSize( name );
  res += GetDOMStringSize( description );
  
  res += locals.size() * sizeof(Precondition *);
  res += globals.size() * sizeof(Precondition *);
  res += derived.size() * sizeof(Precondition *);
  
  res += effects.size() * sizeof(Effect *);
  res += GetDOMStringSetSize( cveids );
  
  for ( DOMStringSet::const_iterator it = cveids.begin(); it != cveids.end(); it++ )
    res += GetDOMStringSizeEx( *it );
  
  return res;
}

long LTLFormula::GetMemSize() const
{
  long res = 0;
  
  LTLPropositionMap::const_iterator it = m_atomic_precond.begin();
  
  for ( ; it != m_atomic_precond.end(); it++ )
    res += GetDOMStringSize( it->first ) + sizeof(DOMString) + 
           it->second->GetMemSize() + sizeof(LTLAtomicProposition*);
  
  res += GetDOMStringSize( m_formula );
  
  return res;
}

long Firewall::GetMemSize() const
{
  long res = GetDOMStringSize( m_name );
  
  res += (sizeof(FirewallRule) + sizeof(bool)) * m_rules.size();
  
  return res;
}

long Network::GetEffectsMemSize( const vector<Effect*> &eff ) const
{
  long res = eff.size() * sizeof( Effect* );
  
  for (vector<Effect*>::const_iterator it = eff.begin(); it != eff.end(); it++)
    res += (*it)->GetMemSize();
  
  return res;
}

long Network::GetMemSize() const
{
  long res = 0;
  
  map<DOMString, HostID, less_str>::const_iterator hidit;
  for ( hidit = hid.begin(); hidit != hid.end(); hidit++ )
    res += GetDOMStringSize( hidit->first ) + sizeof(DOMString) + sizeof(HostID);
  
  res += hosts.size() * (sizeof(Host*) + sizeof(Host));
  for (vector<Host*>::const_iterator hit = hosts.begin(); hit != hosts.end(); hit++)
    res += (*hit)->GetMemSize();
  
  map<DOMString, AttackID, less_str>::const_iterator aidit;
  for ( aidit = aid.begin(); aidit != aid.end(); aidit++ )
    res += GetDOMStringSize( aidit->first ) + sizeof(DOMString) + sizeof(AttackID);
  
  res += attacks.size() * (sizeof(Attack*) + sizeof(Attack));
  for (vector<Attack*>::const_iterator ait = attacks.begin(); ait != attacks.end(); ait++)
    res += (*ait)->GetMemSize();
  
  map<DOMString, PortID, less_str>::const_iterator portsit;
  for ( portsit = ports.begin(); portsit != ports.end(); portsit++ )
    res += GetDOMStringSize( portsit->first ) + sizeof(DOMString) + sizeof(PortID);
  
  map<DOMString, ServiceID, less_str>::const_iterator sidit;
  for ( sidit = sid.begin(); sidit != sid.end(); sidit++ )
    res += GetDOMStringSize( sidit->first ) + sizeof(DOMString) + sizeof(ServiceID);
  
  res += sid2name.size() * sizeof(DOMString);
  for ( vector<DOMString>::const_iterator snit = sid2name.begin(); snit != sid2name.end(); snit++ )
    res += GetDOMStringSize( *snit );
  
  res += GetDOMStringSetSize(vulnerabilities);
  
  HostObjectAttrNameMap::const_iterator hoit = host_objects.begin();
  for ( ; hoit != host_objects.end(); hoit++ )
    res += sizeof(DOMString) + GetDOMStringSize( hoit->first ) +
           sizeof(DOMStringSet) + GetDOMStringSetSize( hoit->second );
  
  res += GetDOMStringSetSize(obj_attr_values);
  
  res += ltl_formula.GetMemSize();
  
  res += GetEffectsMemSize( priveff );
  res += GetEffectsMemSize( svceff );
  res += GetEffectsMemSize( vuleff );
  res += GetEffectsMemSize( conneff );
  res += GetEffectsMemSize( trusteff );
  res += GetEffectsMemSize( knoweff );
  res += GetEffectsMemSize( objeff );
  res += GetEffectsMemSize( passargeff );
  res += GetEffectsMemSize( firewalleff );
  
  //res += sizeof(DOMString) * END_MARKER;
  //for ( int i = 0; i < END_MARKER; i++)
  //  res += GetDOMStringSizeEx(network->auxilary->enames[i]);
  
  res += adversary.GetMemSize();
  res += ids.GetMemSize();
  
  //firewalls
  HostID h_id1;
  HostID h_id2;
  unsigned int path_count;
  
  if (!pathes_firewalls.empty()) {
    for ( h_id1 = 0; h_id1 < nHosts; h_id1++ ) {
      for ( h_id2 = 0; h_id2 < nHosts; h_id2++ ) {
        path_count = pathes_firewalls[h_id1][h_id2].size();
          
        res += path_count * (fid2name.size() * sizeof(bool) + sizeof( vector< bool > )) + sizeof(BoolVectorContainer);
       
      }
    }
    res += sizeof(vector<BoolVectorContainer>) * nHosts; 
  }
  
  if ( !hostlinking.empty() )
    for ( h_id1 = 0; h_id1 < nHosts; h_id1++ )
      res += hostlinking[h_id1].size() * sizeof(HostID) + sizeof(HostIdSet);
  
  res += fport2name.size() * sizeof(DOMString);
  res += firewall_ports.size() * (sizeof(DOMString) + sizeof(PortID));
  res += fid2name.size() * sizeof(DOMString);
  
  res += firewall_names.size() * (sizeof(DOMString) + sizeof(FirewallID));
  NameFirewallMap::const_iterator f_it = firewalls.begin();
  for ( ;f_it != firewalls.end(); f_it++ )
    res += f_it->second->GetMemSize() + sizeof(Firewall) + sizeof(Firewall*) + sizeof(DOMString);
  
  return res;
}

long Adversary::GetMemSize() const
{
  long res = 0;
  
  map<DOMString, int, less_str>::const_iterator portsit;
  for ( portsit = ports.begin(); portsit != ports.end(); portsit++ )
    res += GetDOMStringSize( portsit->first ) + sizeof(DOMString) + sizeof(int);
  
  res += GetDOMStringMapSize(privileges);
  
  map<DOMString, bool, less_str>::const_iterator kit;
  for ( kit = knowledge.begin(); kit != knowledge.end(); kit++ )
    res += GetDOMStringSize( kit->first ) + sizeof(DOMString) + sizeof(bool);
  
  return res;
}

long IntrusionDetectionSystem::GetMemSize() const
{
  long res = 0;
  
  map <DOMString, DOMStringSet *, less_str>::const_iterator it = paths.begin();
  for ( ; it != paths.end(); it++ )
    res += sizeof(DOMString) + GetDOMStringSize( it->first ) +
           sizeof(DOMStringSet) + sizeof(DOMStringSet*) + GetDOMStringSetSize( *(it->second) );

  return res;
}

void Network::ComputeFConnectivity()
{
  if ( DoesModelHaveFirewalls() ) {
    
    // verify links correction
    HostID h_id;
    for ( h_id = 0; h_id < nHosts; h_id++ )
      for ( HostIdSet::iterator l_it = hostlinking[h_id].begin(); l_it != hostlinking[h_id].end(); )
        if ( hostlinking[*l_it].find(h_id) == hostlinking[*l_it].end() ) {
          cerr << "Warning: Link \"" << GetHost( h_id )->GetName() << "\" -> \"" << GetHost( *l_it )->GetName() 
               << "\" is defined but \"" << GetHost( *l_it )->GetName() << "\" -> \"" << GetHost( h_id )->GetName() 
               << "\" is not, connectivity ignored" << endl;
          HostIdSet::iterator del_it = l_it++; 
          hostlinking[h_id].erase( del_it );
        }
        else
          l_it++;
    
    // Find paths between hosts
    pathes_firewalls.resize( nHosts, vector<BoolVectorContainer>(nHosts, BoolVectorContainer( )) );
    
    for ( h_id = 0; h_id < nHosts; h_id++ ) {
      vector<Host*> DFS_stack;
      vector<int> DFS_child_stack;
      vector<bool> firewall_existing( fid2name.size(), false );
      int conn_host_id;
      HostID  host_id;
      HostID  parent_host_id;
      HostID  child_host_id;
              
      Host* host = GetHost( h_id );
      Host* conn_host;
      DFS_stack.push_back( host );
      DFS_child_stack.push_back( -1 );
      host->SetFlags( Host::IN_STACK_FLAG, true );
        
      while ( !DFS_stack.empty() ) {
        host = DFS_stack.back();
        host_id = host->GetId();
        conn_host_id = DFS_child_stack.back();
        conn_host = 0;
        
        if ( ++conn_host_id >= hostlinking[host_id].size() ) {
          DFS_stack.pop_back( );
          DFS_child_stack.pop_back();
          host->SetFlags( Host::IN_STACK_FLAG, false );
          
          if ( !DFS_stack.empty() ) {
            host = DFS_stack.back();
            parent_host_id = host->GetId();
            
            //verify whether a firewall exists between the parent_host and the host
            NameFirewallMap::iterator f_it = firewalls.begin();
            for ( ; f_it != firewalls.end(); f_it++ ) {
              if ( f_it->second->IsBetweenHosts( parent_host_id, host_id ) ) {
                       
                // "remove" the firewall from the path
                firewall_existing[f_it->second->GetId()] = false;
                break;
              }
            }
          }
        }
        else {
          //get next child
          DFS_child_stack.back() = conn_host_id;
          
          HostIdSet::iterator h_it= hostlinking[host_id].begin();
          for ( ; conn_host_id > 0; conn_host_id--, h_it++ );
          child_host_id = *( h_it );
          conn_host = GetHost( child_host_id );
        }
        
        if ( conn_host != 0 ) {
          
          if ( (conn_host->GetFlags( ) & Host::IN_STACK_FLAG) == 0 ||
               h_id == child_host_id ) {
            
            bool host_is_child_of_h_id = false;
            
            if ( h_id == child_host_id ) {
              if ( DFS_stack.size() > 1 ) {
                Host *parent_host = *(DFS_stack.end() - 2);
                parent_host_id = parent_host->GetId();
                host_is_child_of_h_id = (parent_host_id == h_id);
              }
            }
            else {
              DFS_stack.push_back( conn_host );
              DFS_child_stack.push_back( -1 );
              conn_host->SetFlags( Host::IN_STACK_FLAG, true );
            }
            
            // the cycle h_id->host->h_id is ignored
            if ( !host_is_child_of_h_id ) {
              //verify whether a firewall exists between the host and the child_host
              NameFirewallMap::iterator f_it = firewalls.begin();
              bool curr_firewall_existing = false;
              for ( ; f_it != firewalls.end(); f_it++ ) {
                if ( f_it->second->IsBetweenHosts( host_id, child_host_id ) ){
                       
                  // "add" the firewall to the path
                  curr_firewall_existing = firewall_existing[f_it->second->GetId()];
                  firewall_existing[f_it->second->GetId()] = true;
                  break;
                }
              }
              
              //add path between the h_id and the child_host
              cout << "Path ";
              for ( unsigned int i = 0; i < DFS_stack.size(); i++ ) {
                cout << "\"" << DFS_stack[i]->GetName() << "\"";
                
                if ( i != DFS_stack.size() - 1 )
                  cout << " -> ";
              }
              if ( h_id == child_host_id )
                cout << " -> \"" << DFS_stack[0]->GetName() << "\"";
              cout << " found " << endl;
              
              pathes_firewalls[h_id][child_host_id].push_back(firewall_existing);
              
              
              // "remove" firewall from "dead end" of path
              if ( h_id == child_host_id && f_it != firewalls.end() ) {
                firewall_existing[f_it->second->GetId()] = curr_firewall_existing;
              }
            }
          }
        }          
      }
    }
    
    max_path_count = 0;
    for ( HostID h_id1 = 0; h_id1 < nHosts; h_id1++ )
      for ( HostID h_id2 = 0; h_id2 < nHosts; h_id2++ )
        if ( max_path_count < pathes_firewalls[h_id2][h_id2].size() ) 
          max_path_count = pathes_firewalls[h_id2][h_id2].size();
  }
}
