#ifndef _COMPONENT_MANAGER_H_
#define _COMPONENT_MANAGER_H_

namespace GraphGraphics
{
/**
* The type for component identifier (index).
*/
typedef int ComponentIndex;
  
class CompInterface;
  
/**
* This class provides component registering functionality. Each class that implements  
* a component manager need to be inherited from this class.
* @see ScenarioApp
*/
class ComponentManager
{
public:
  /**
  * The invalid component identifier.
  */
  static ComponentIndex INVALID_COMP_ID;

public:
  /**
  * Destructor.
  */
  virtual ~ComponentManager() {}
    
  /**
  * This method register a new component in the component manager.
  * Actual implementation of the method need to invoke <code>CompInterface::on_register(...)</code>
  * after successful registration.
  * @param comp A pointer to <code>CompInterface</code> object to be registered.
  * @return An index of just registered component if registration is sucsessful or <code>INVALID_COMP_ID</code>
  */
  virtual ComponentIndex register_component( CompInterface *comp ) = 0;
    
  /**
  * This method returns a number of registered components.
  */
  virtual int count_registered_components() = 0;
    
  /**
  * This method gets a registered component with specified identifier (index).
  * @param comp_id An identifier of component to retrieve. It should be in range from 0 to 
  * <code>count_registered_components()</code> - 1.
  * @return A pointer to requested component.
  */
  virtual CompInterface* get_registered_component( ComponentIndex comp_id ) = 0;
};

};
  
#endif
