
#ifndef  _UNIX_TEMPLATE_CREATION_GUI_H_
#define  _UNIX_TEMPLATE_CREATION_GUI_H_

#include <gtk/gtk.h>
#include "UnixAttrTreeView.h"
#include "GUIWindows.h"

namespace GraphGraphics
{
class GTKGraphAttrPredDialog: public GraphGUIModalWindow
{
  GtkWidget *attr_pred_dialog;
  GtkWidget* m_parent;
  GtkWidget *op_hbox;
  GtkWidget *op_label;
  GtkWidget *op_combo;
  GtkWidget *op_combo_entry;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *not_label;
  GtkWidget *not_checkbutton;

  string     m_attr_op;
  bool       m_negation;

private:
  void create();

public:
  GTKGraphAttrPredDialog( GtkWidget* parent ) 
  { 
    m_parent = parent; 
    m_attr_op = "";
    m_negation = false;
  }
  ~GTKGraphAttrPredDialog() { }
  
  string get_attr_logical_op( ) { return m_attr_op; }
  bool   get_negation( ) { return m_negation; }
  int run();
};

class GTKGraphAttrValueDialog: public GraphGUIModalWindow
{
private:
  static const char *EQUAL;
  static const char *NOT_EQUAL;
  static const char *LESS;
  static const char *NOT_LESS;
  static const char *GREATER;
  static const char *NOT_GREATER;
  
  GtkWidget* m_parent;

  GtkWidget *attr_value;
  GtkWidget *dialog_vbox2;
  GtkWidget *table2;
  GtkWidget *label4;
  GtkWidget *name_entry;
  GtkWidget *label5;
  GtkWidget *value_hbox;
  GtkWidget *value_entry;
  GtkWidget *value_combo;
  GtkWidget *value_combo_entry;

  GtkWidget *op_hbox;
  GtkWidget *op_label;
  GtkWidget *op_combo;
  GtkWidget *op_combo_entry;
  GtkWidget *not_label;
  GtkWidget *not_checkbutton;
  GtkWidget *value_op_label;
  GtkWidget *value_op_alignment;
  GtkWidget *value_op_combo;
  GtkWidget *value_op_combo_entry;
  
  GtkWidget *vr_alignment;
  GtkWidget *range_label;
  GtkWidget *range_checkbutton;
  GtkWidget *value_vbox;
  GtkWidget *range_scrolledwindow;
  GtkWidget *range_listview;
  GtkWidget *range_buttons_hbox;
  GtkWidget *add_value_button;
  GtkWidget *remove_value_button;
  
  GtkListStore *m_store;

  string     m_attr_name;
  string     m_attr_value;
  string     m_attr_value_op;
  string     m_attr_op;
  bool       m_negation;
  bool       m_is_string_value;
  
  bool       m_expression;
  bool       m_aliases;
  GraphAttrValueAliasMap m_all_value_aliases;
  GraphAttrNameStorage *m_name_storage;

private:
  void create();

  string get_aliased_value();
  string get_aliased_value_range( );

public:
  GTKGraphAttrValueDialog( GraphAttrNameStorage *name_storage, GtkWidget* parent, bool expr, bool is_string_value = false ) 
  { 
    m_aliases = false;
    m_name_storage = name_storage;
    m_is_string_value = is_string_value;
    
    if ( name_storage != 0 )
      m_aliases = (name_storage->get_curr_alias_set() >= 0 && !is_string_value);
    m_parent = parent; m_attr_value = "0"; 
    m_attr_value_op = "="; m_attr_op = "";
    m_negation = false;
    m_expression = expr;
  }
  
  ~GTKGraphAttrValueDialog() { }
  void set_attr_name( const StringContainer &attr_name, const string &type ); 
  string get_attr_value( ) { return m_attr_value; }
  string get_attr_value_op( ) { return m_attr_value_op; }
  string get_attr_logical_op( ) { return m_attr_op; }
  bool   get_negation( ) { return m_negation; }
  int run();
  
  void handle_range_checkbutton_event( bool checked );
  void handle_add_value_button_event( );
  void handle_remove_value_button_event( );
  void handle_value_combo_entry_changed_event( );
  void handle_value_entry_changed_event( );
};

class GTKGraphMetaAttrDialog: public GraphGUIModalWindow
{
private:
  GtkWidget* m_parent;

  GtkWidget *meta_attr;
  GtkWidget *dialog_vbox3;
  GtkWidget *table3;
  GtkWidget *check_meta_attr_id;
  GtkWidget *check_meta_attr_name;
  
  GtkWidget *meta_name_entry;
  GtkWidget *meta_id_entry;

  GtkWidget *op_hbox;
  GtkWidget *op_label;
  GtkWidget *op_combo;
  GtkWidget *op_combo_entry;
  GtkWidget *not_label;
  GtkWidget *not_checkbutton;
  
  string     m_attr_name;
  string     m_attr_op;
  bool       m_negation;
  
  bool       m_expression;
  bool       m_aliased;
  bool       m_first_meta;
  
private:
  void create();  

public:
  GTKGraphMetaAttrDialog( GtkWidget* parent, bool expr, bool aliased, bool first_meta ) 
  { 
    m_parent = parent; 
    m_expression = expr;
    m_negation = false;
    m_attr_op = "";
    m_attr_name = "";
    m_aliased = aliased;
    m_first_meta = first_meta;
  }
  ~GTKGraphMetaAttrDialog(){};
  void set_meta_attr_name( const string &attr_name ) { m_attr_name = attr_name; }
  string get_full_meta_attr_name( ) { return m_attr_name; }
  string get_attr_logical_op( ) { return m_attr_op; }
  bool   get_negation( ) { return m_negation; }
    
  void handle_check_meta_attr_id_toggled_event();
  void handle_check_meta_attr_name_toggled_event();
  
  int run();
};

class GTKGraphAttrTemplateCreationView
{
public:
  static const char *NONE;
  static const char *OR;
  static const char *AND;
private:
  UnixGraphAttrView m_attr_template_tree;
  UnixGraphAttrView m_search_template_tree;
  
  GtkWidget *dialog;

  GtkWidget *table1;
  GtkWidget *text_entry;
  GtkWidget *template_scrolledwindow;
  GtkWidget *scrolledwindow4;
  GtkWidget *flow_vbox;
  GtkWidget *paren_button;
  GtkWidget *add_button;
  GtkWidget *remove_button;
  GtkWidget *template_label;
  GtkWidget *search_label;
  GtkWidget *string_checkbutton;
  GtkWidget *alignment1;
  GtkWidget *hbox1;
  GtkWidget *image1;
  GtkWidget *label1;
  GtkTooltips *tooltips;
  GtkWidget   *tree;

  bool m_names_only;
  bool m_show_text;
  string m_base_title;
  string m_result_title;
  
  string m_result_string;
  
  bool m_search_expression;
  GraphAttrNameStorage *m_name_storage;
  bool m_disable_expression;
    
private:
  void destroy() 
  {
    if ( dialog != NULL )
      gtk_widget_destroy( dialog );
    
    dialog = NULL;
    table1 = NULL; 
  }
  
  void update_buttons();
 
public:
  GTKGraphAttrTemplateCreationView( GraphAttrNameStorage *name_storage, UnixGraphAttrView::AttrViewModes base_template_mode, const string &base_template_title, 
                                   UnixGraphAttrView::AttrViewModes result_template_mode, const string &result_template_title ): 
                                    m_attr_template_tree( name_storage, base_template_mode ),
                                    m_search_template_tree( name_storage, result_template_mode )
  {
    m_name_storage = name_storage;
    m_names_only = (result_template_mode == UnixGraphAttrView::ATTRIBUTE_TEMPLATE);
    m_base_title = base_template_title;
    m_result_title = result_template_title;
    m_show_text = !m_names_only;
    m_disable_expression = (result_template_mode != UnixGraphAttrView::ATTRIBUTE_EXPRESSION);
    table1 = NULL;
    m_search_expression = !m_disable_expression;
      
    paren_button = NULL;
        
    if ( m_base_title.empty() )
      m_base_title = "Base attribute template";
    
    if ( m_result_title.empty() )
      m_result_title = "Result attribute template";
    
    m_result_string = "";
    dialog = NULL;
  }
  
  ~GTKGraphAttrTemplateCreationView() { destroy(); };
  GtkWidget *create();
    
  void set_base_template( const string &attr_str ) 
  {
    vector<string> attr_lists;
    attr_lists.push_back( attr_str );
    m_attr_template_tree.set_attributes( attr_lists ); 
  }
  
  void set_base_template( const NodeAttributeList &attr_list )
  {
    vector<NodeAttributeList> attr_lists;
    attr_lists.push_back( attr_list );
    m_attr_template_tree.set_attributes( attr_lists );
  }
  
  void set_init_result_template( const string &attr_str ) 
  {
    vector<string> attr_lists;
    attr_lists.push_back( attr_str );
    m_search_template_tree.set_attributes( attr_lists ); 
    
    GtkTreeIter      iter;
    GtkTreeModel     *model = gtk_tree_view_get_model( GTK_TREE_VIEW( m_search_template_tree.get_widget() ) );
    GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( m_search_template_tree.get_widget() ) );
    
    if ( gtk_tree_model_get_iter_first( model, &iter ) )
      gtk_tree_selection_select_iter( selection, &iter );

    m_result_string = attr_str;

    
    m_search_expression = !m_disable_expression && GraphAttributes::is_predicate( attr_str );
    
    if ( GTK_IS_WIDGET(paren_button) )
      if ( m_search_expression )
        gtk_widget_show( paren_button );
      else
        gtk_widget_hide( paren_button );
  }
  
  void set_init_result_template( const NodeAttributeList &attr_list )
  {
    vector<NodeAttributeList> attr_lists;
    attr_lists.push_back( attr_list );
    m_search_template_tree.set_attributes( attr_lists );
    
    GtkTreeIter      iter;
    GtkTreeModel     *model = gtk_tree_view_get_model( GTK_TREE_VIEW( m_search_template_tree.get_widget() ) );
    GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( m_search_template_tree.get_widget() ) );
    
    if ( gtk_tree_model_get_iter_first( model, &iter ) )
      gtk_tree_selection_select_iter( selection, &iter );
    
    m_result_string = GraphAttributes::make_string( attr_list );
    
    m_search_expression = !m_disable_expression && GraphAttributes::is_predicate( attr_list );
    
    if ( GTK_IS_WIDGET(paren_button) )
      if ( m_search_expression )
        gtk_widget_show( paren_button );
      else
        gtk_widget_hide( paren_button );
  }
  
  void set_show_attr_string( bool show ) { m_show_text = show; }
  
  GtkWidget *get_widget() { return table1; }
  
  int run_dialog( const string &title );
  
  string  get_result_attr_string() { return m_result_string; }
  
  void handle_add_button_clicked_event();
  void handle_remove_button_clicked_event();
  void handle_parentheses_button_clicked_event();
  
  void handle_string_checkbutton_clicked_event();
  void handle_text_entry_changed_event();
};

};

#endif
