
#ifndef _UNIX_GROUP_GUI_H_
#define _UNIX_GROUP_GUI_H_

#include <gtk/gtk.h>

#include "../OS_indep/graphics.h"
#include "../OS_indep/GUIWindows.h"

namespace GraphGraphics
{
 
enum ChangeFlag
{
  UNCHANGED = 0,
  NEW,
  CHANGED,
  REASSIGNED,
  DELETED
};

typedef struct
{
  bool        pen_set;
  DrawingPen  pen;
  bool        color_set;
  Color       color;
  bool        font_set;
  Font        font;
  Color       font_color;
  string      name;
  string      attr_condition;
  bool        shape_set;
  StyleFlags  shape;
  bool        filled_set;
  bool        filled;
  bool        ratio_set;
  double      xratio;
  double      yratio;
  ChangeFlag  change;
  StyleFlags  type;
} GroupStoredData;

typedef map<int, GroupStoredData*> GroupStorage;

class GTKPropertiesGroupGUI: public GraphViewPropertiesGUI
{
private:
  static const int    UNKNOWN;
  static const string font_text;

private:
  
  GraphView    *m_view;
  GraphGUI     *m_gui;
  
  GroupStorage  m_group_data_storage;
  int           m_last_data_ind;
  Font          m_curr_font;
  Color         m_curr_color;
  Color         m_curr_font_color;
  bool          m_attr_changed;
  bool          m_critical;
  StyleFlags    m_curr_shape;
  double        m_curr_xy_ratio;

  int           m_changes_level;

  
  GtkWidget *group_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *label6;
  GtkWidget *frame1;
  GtkWidget *table2;
  GtkWidget *set_filled_checkbutton;
  GtkWidget *filled_checkbutton;
  GtkWidget *set_shape_checkbutton;
  GtkWidget *hseparator2;
  GtkWidget *hseparator_ratio;
  GtkWidget *label10;
  GtkWidget *label1;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *shape_combo;
  GList *shape_combo_items;
  GtkWidget *shape_combo_entry;
  GtkWidget *label11;
  GtkWidget *name_entry;
  GtkWidget *frame2;
  GtkWidget *table3;
  GtkWidget *set_color_checkbutton;
  GtkWidget *label15;
  GtkWidget *label2;
  GtkWidget *hbox2;
  GtkWidget *color_drawingarea;
  GtkWidget *color_button;
  GtkWidget *label14;
  GtkWidget *frame3;
  GtkWidget *table4;
  GtkWidget *set_font_checkbutton;
  GtkWidget *hbox4;
  GtkWidget *font_button;
  GtkWidget *font_color_button;
  GtkWidget *label17;
  GtkWidget *label3;
  GtkWidget *label21;
  GtkWidget *font_drawingarea;
  GtkWidget *label16;
  GtkWidget *frame4;
  GtkWidget *table5;
  GtkWidget *set_pen_checkbutton;
  GtkObject *pen_spinbutton_adj;
  GtkWidget *pen_spinbutton;
  GtkWidget *set_ratio_checkbutton;
  GtkObject *yratio_spinbutton_adj;
  GtkObject *xratio_spinbutton_adj;
  GtkWidget *yratio_spinbutton;
  GtkWidget *xratio_spinbutton;
  GtkWidget *label19;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *pen_style_combo;
  GList *pen_style_combo_items;
  GtkWidget *pen_combo_entry;
  GtkWidget *label18;
  GtkWidget *frame5;
  GtkWidget *table6;
  GtkWidget *attr_button;
  GtkWidget *attr_entry;
  GtkWidget *label8;
  GtkWidget *label20;
  GtkWidget *hbox1;
  GtkWidget *apply_alignment;
  GtkWidget *apply_button;
  GtkWidget *frame6;
  GtkWidget *table7;
  GtkWidget *list_scrolledwindow;
  GtkWidget *group_treeview;
  GtkWidget *new_button;
  GtkWidget *del_button;
  GtkWidget *label22;
  GtkWidget *label_ratio;
  GtkWidget *label_ratio1;
  GtkWidget *label_ratio2;
  GtkWidget *ratio_hbox;

private:
  GroupStoredData* view_properties_to_group_data( GraphViewPropertyGroup *group );
  GraphViewPropertyGroup make_view_properties_group( GroupStoredData *data );
  void view_apply_group( GroupStoredData *data );
  GtkTreeIter add_property_group_to_list( GroupStoredData *data );

  void update_pen_state( bool enabled );
  void update_filled_state( bool enabled );
  void update_shape_state( bool enabled );
  void update_shape_ratio_state( bool enabled );
  void update_color_state( bool enabled, bool init );
  void update_font_state( bool enabled, bool init );
  void update_is_default( GroupStoredData *data );

  void set_pen_properties( GroupStoredData *data );
  void get_pen_properties( GroupStoredData *data );
  void set_shape_properties( GroupStoredData *data );
  void get_shape_properties( GroupStoredData *data );
  void set_color_properties( GroupStoredData *data, bool init );
  void get_color_properties( GroupStoredData *data );
  void set_font_properties( GroupStoredData *data, bool init );
  void get_font_properties( GroupStoredData *data );
  void set_all_properties( bool init );
  void get_all_properties( GroupStoredData *data );
  
  
  void create();

public:
  GTKPropertiesGroupGUI( GraphView *view, GraphGUI *gui ) 
  {
    m_view = view;
    m_gui = gui;
    m_changes_level = UNCHANGED;
    m_critical = false;
    m_last_data_ind = 0;
    shape_combo_items = NULL;
    pen_style_combo_items = NULL;
  }
  ~GTKPropertiesGroupGUI() {}
    
  int get_changes_level() { return m_changes_level; }

  int run();

  void handle_color_button_clicked_event( ); 
  void handle_attr_button_clicked_event( );
  void handle_new_button_clicked_event( );  
  void handle_del_button_activate_event( );   
  void handle_apply_button_clicked_event( );  
  void handle_set_filled_checkbutton_clicked_event( );
  void handle_set_ratio_checkbutton_clicked_event( );   
  void handle_set_shape_checkbutton_clicked_event( ); 
  void handle_set_color_checkbutton_clicked_event( ); 
  gboolean handle_drawingarea1_expose_event( );    
  void handle_set_font_checkbutton_clicked_event( );
  gboolean handle_drawingarea2_expose_event( ); 
  void handle_font_button_clicked_event( );
  void handle_font_color_button_clicked_event( );
  void handle_set_pen_checkbutton_clicked_event( );
  gboolean handle_group_treeview_button_release_event( );

};

};

#endif

