// UnixGraphicArea.h: interface for the UnixGraphicArea class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UNIXGRAPHICAREA_H__68C74AF3_1378_4856_9C60_7F5694271CFB__INCLUDED_)
#define AFX_UNIXGRAPHICAREA_H__68C74AF3_1378_4856_9C60_7F5694271CFB__INCLUDED_

namespace GraphGraphics
{
	
class UnixFontGeometry : public FontGeometry
{
  GdkFont       *m_font;	
  PangoContext  *m_context; 
  PangoLayout	*m_p_layout;

public:
	  UnixFontGeometry( /*PangoContext *context, PangoLayout *p_layout*/ );
   ~UnixFontGeometry( );

   void      set_font( const Font &f );

   OneDValue get_string_height( const string &str );
   OneDValue get_char_height( char ch );
   OneDValue get_char_width( char ch );
   OneDValue get_string_width( const string &str );

   // possible other methods
};

class UnixGraphicArea : public GraphicArea  
{
public:
  //consts
/*  static const  char  *DEFAULT_FONT_NAME;*/

private:

//fields
  PangoContext  *m_context; 
  PangoLayout	*m_p_layout;
  GdkDrawable   *m_draw;
  GdkGC         *m_gc;
  GdkColormap   *m_colormap;
  Font          m_os_indep_font;
	bool					m_is_pixmap;

  UnixFontGeometry *m_font_geometry;
  
public:
	UnixGraphicArea(GdkDrawable *draw, bool resizable = false );
  ~UnixGraphicArea();

  virtual GraphicArea* clone()
  {
    UnixGraphicArea *g_clone = new UnixGraphicArea(m_draw, m_is_pixmap);
    
    return g_clone;       
  }

	GdkDrawable* 	get_drawable() { return m_draw; }
	
  void set_foreground_color( const Color &c );
  Color get_foreground_color();

  void set_background_color( const Color &c );
  Color get_background_color();

  void set_drawing_pen( const DrawingPen &pen );
  DrawingPen get_drawing_pen(  );

  void set_paint_mode( StyleFlags );
  StyleFlags get_paint_mode();
  
  void set_fill_mode( StyleFlags mode );
  StyleFlags get_fill_mode();

  bool set_font( const Font &f );
  Font get_font();

  FontGeometry* get_font_geometry();

  Rectangle get_drawing_bounds();
  void set_drawing_bounds( const Rectangle &bounds );
  Rectangle get_clipping_bounds();
   
   // drowing geometric primitives 
  void draw_point( const TwoDPoint &point );
  void draw_line( const TwoDPoint &start_point, const TwoDPoint &end_point );
  void draw_hollow_rectangle( OneDValue left, OneDValue top, OneDValue right, OneDValue bottom );
  void draw_filled_rectangle( OneDValue left, OneDValue top, OneDValue right, OneDValue bottom );
  void draw_hollow_circle( const TwoDPoint &center, OneDValue radius );
  void draw_filled_circle( const TwoDPoint &center, OneDValue radius );
   //virtual void draw_arc( TwoDPoint center, OneDValue radius, TwoDPoint start_point, double angle ) = 0;

  void draw_text( const TwoDPoint &start_point, const string &text );

  void map_into( const Rectangle &rect, GraphicArea *g_into, const Rectangle &rect_into, bool stretch = false );
};

}

#endif // !defined(AFX_UNIXGRAPHICAREA_H__68C74AF3_1378_4856_9C60_7F5694271CFB__INCLUDED_)
