
#ifndef _UNIX_COMP_MAN_GUI_H_
#define _UNIX_COMP_MAN_GUI_H_

#include <gtk/gtk.h>

#include <vector>
#include <string>
#include "../OS_indep/ComponentManager.h"
#include "../OS_indep/GUIWindows.h"

using namespace std;

namespace GraphGraphics
{
  
class GTKComponentManagerGUI: public GraphGUIModalWindow
{
private:
  GtkWidget *components_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *main_table;
  GtkWidget *active_label;
  GtkWidget *unactive_label;
  GtkWidget *flow_vbox;
  GtkWidget *set_active_button;
  GtkWidget *set_inactive_button;
  GtkWidget *active_scrolledwindow;
  GtkWidget *active_treeview;
  GtkWidget *inactive_scrolledwindow;
  GtkWidget *inactive_treeview;
  GtkTooltips *tooltips;

  ComponentManager *m_comp_manager;

private:
  void create();

public:
  GTKComponentManagerGUI( ComponentManager *comp_manager ) { m_comp_manager = comp_manager; }
  ~GTKComponentManagerGUI() {}
    
  int run();
  
  void handle_set_active_button_clicked_event();
  void handle_set_inactive_button_clicked_event();
};

};
  
#endif
