#include <string>
#include <vector>
#include <gtk/gtk.h>
#include <sys/time.h>
#include "../OS_indep/graphics.h"
#include "UnixGenerateGUI.h"

using namespace GraphGraphics;
using namespace std;

enum PROCESSES_CONSTS
{
  STR_BUF = 1024
};


class TextOutput
{
  //Private data where to copy the output string
  //...

public:
  virtual void insert(const char *str) = 0;
};

class Process;
  
typedef vector<Process*> ProcessesVector; 

struct ThreadArg
{
  GTKUnixGraphGenerationWindow  *window;
  bool              enabling_control;
  ProcessesVector   *procs;
  TextOutput        *txt_out;
  char              orig_dir[255];
  char              tmp_dir[255];  
  bool              is_load;
  guint             timer_id;
};

class Process
{
  char  **m_argv;  
  int   m_argc;
  char  m_path[255];
  char  *m_intr_message;
  char  *m_out_file;
  bool   m_run_timer;
  struct timeval m_start_timer;
  struct timeval m_end_timer;
    
public:
  Process(char **argv, char *path, char *intr_message, bool run_timer = false ) 
  {
    memset(m_path, 0, sizeof(m_path));
    strcpy(m_path, path);
    
    for (m_argc = 0; argv[m_argc] != 0; m_argc++);
    
    m_argv = new char*[m_argc+1];
    memset(m_argv, 0, (m_argc+1)*sizeof(char*));
    
    if (intr_message != 0)
    {
      m_intr_message = new char[strlen(intr_message)+1];
      m_intr_message[0] = 0;
      strcpy(m_intr_message, intr_message);    
    }
    
    for (int i = 0; i < m_argc; i++)
    {
      m_argv[i] = new char[strlen(argv[i]) + 1];
      strcpy(m_argv[i], argv[i]);
    }
    
    m_out_file = 0;
    
    m_run_timer = run_timer;
  };
  
  ~Process() 
  {
    for (int i = 0; i < m_argc; i++)
      if (m_argv[i] != 0)
        delete[] m_argv[i];

    if (m_argv != 0)  
      delete[] m_argv;    
    
    if (m_intr_message != 0)
      delete[] m_intr_message;
    
  };
  
  char** get_argv() { return m_argv; }
  char* get_path() { return m_path; }  
  char* get_intr_message() { return m_intr_message; }
  uint get_argc() { return m_argc; }    
  
  void set_out_file( char *file_name )
  {
    if (m_out_file != 0)
      delete[] m_out_file;
    m_out_file = new char[strlen(file_name) + 1];
    memset(m_out_file, 0, strlen(file_name) + 1);
    strcpy(m_out_file, file_name);
  }
  
  char *get_out_file() { return m_out_file; }
  
  bool get_run_timer() { return m_run_timer; }
  
  void set_timer() { gettimeofday(&m_start_timer, NULL );}
  
  string get_time() {
    gettimeofday(&m_end_timer, NULL ); 
    
    double seconds = (m_end_timer.tv_sec-m_start_timer.tv_sec) + 
                          ((double)m_end_timer.tv_usec-(double)m_start_timer.tv_usec)/1000000;        
    char snum[255];
        
    sprintf( snum, "%.3f", seconds );
    
    return string((const char*)snum);
  }
  
/*  bool  CreateNewProcess(char* path, char** argv, TextOutput *txt_out);*/
};

void* RunProcesses( void* params/*ProcessesVector &procs, TextOutput *txt_out*/);
