
#ifndef _GTKINFORMATIONWINDOW_H
#define _GTKINFORMATIONWINDOW_H

#include "../OS_indep/graphics.h"
#include "../OS_indep/GUIWindows.h"

using namespace GraphGraphics;

class GTKInformationGUI: public GraphInformationGUI
{
private:
  GtkWidget *information_window;
  GtkWidget *dialog_vbox1;
  //GtkWidget *main_table;
  //GtkWidget *value_scrolledwindow;
  //GtkWidget *value_textview;
  GtkWidget *scrolledwindow;
  GtkWidget *info_treeview;
  GtkWidget *dialog_action_area1;
  GtkWidget *closebutton1;
  GtkTreeViewColumn *column;
  GtkTreeViewColumn *column2;
  GtkCellRenderer   *render;
  GtkCellRenderer   *render2;
  GtkTreeStore      *info_store;

  bool               m_docked;
  
  void walk_info_tree( InfoStorageLevel *level, GtkTreeIter *parent_iter);
  void set_network_info( );
  bool set_network_list_info( );
  void create();

public:
  void set_root_level( InfoStorageSubLevel *level );
  
  void show( bool show_window );

  string get_label();
  void make_docked( bool docked );
  bool is_docked() { return m_docked; }
  void* get_dockable();
  
  bool is_dock_handler_registered() { return !m_dock_menu_handler_list.empty(); }
  
  void handle_info_treeview_button_release_event( );
  void handle_value_textview_button_release_event( );
  void handle_close_dialog( );  
  void handle_dock_menu_event( bool docked );
  
  GTKInformationGUI()
  {
    information_window = 0;  
    m_docked = false;
    scrolledwindow = 0;
  }
  
  ~GTKInformationGUI()
  {
    handle_destroy_event( );
  }
  
  void handle_destroy_event( );
};

#endif
