#include "NetGUI.h"
#include "GTKNetPreferencesGUI.h"
#include "GTKAttacksGUI.h"
#include "GTKMeasuresGUI.h"
#include "NetworkComp.h"

using namespace GraphGraphics;

GraphGUIModalWindow* NetworkGUI::create_net_preferences_dialog( GraphView *net_view )
{
  GTKNetPreferencesGUI* dialog = new GTKNetPreferencesGUI( net_view );
  
  return dialog;
}

NetAttacksGUI* NetworkGUI::create_attacks_dialog( Graph *scenario_graph, NetworkComp* netcomp, GraphGUI *gui )
{
  NetAttacksGUI* res = 0;
  
  if ( netcomp->is_network_model_info_enabled() )
  {
    Network *network = netcomp->get_network_model_info();
    res = new GTKAttacksGUI( false, network, scenario_graph, gui );
  }
  return res;
}

NetAttackMeasuresGUI* NetworkGUI::create_attack_measures_dialog( Graph *scenario_graph, NetworkComp* netcomp, GraphGUI *gui )
{
  NetAttackMeasuresGUI* res = 0;
  
  if ( netcomp->is_network_model_info_enabled() )
  {
    Network *network = netcomp->get_network_model_info();
    res = new GTKMeasuresGUI( network, scenario_graph, gui );
  }
  return res;
}

