
#include "GTKMeasuresGUI.h"
#include "GTKAttacksGUI.h"

using namespace GraphGraphics;

GtkTreeIter GTKMeasuresGUI::get_top_measure_iter( GtkTreeIter *child_iter )
{
  GtkTreeIter iter;
  
  if ( !gtk_tree_model_iter_parent( m_tree_model, &iter, child_iter ) )
    iter = *child_iter;
  
  return iter;
}

void GTKMeasuresGUI::set_values( GtkTreeIter *iter, const string &name, const string &attack, const string &src, const string &dst, int id )
{
  gtk_tree_store_set( GTK_TREE_STORE( m_tree_model ), iter, 0, name.c_str(),
                                                            1, attack.c_str(),
                                                            2, src.c_str(),
                                                            3, dst.c_str(),
                                                            4, id, -1 );
}

GtkTreeIter GTKMeasuresGUI::add_measure( AttackMeasureID id )
{
  GtkTreeIter top_iter;
  GtkTreeIter iter;
  AttackMeasure measure = m_measures_set.get_measure( id );
  AttackTriple  attack;
  NetworkInfo  *net_info;
  
  gtk_tree_store_append( GTK_TREE_STORE( m_tree_model ), &top_iter, NULL );
  set_values( &top_iter, measure.get_name(), "", "", "", id );
  
  for ( AttackMeasure::iterator p = measure.begin(); p != measure.end(); p++ )
  {
    attack = *p;
    net_info = attack.get_network_info( m_network );
    
    if ( net_info != 0 )
    {
      gtk_tree_store_append( GTK_TREE_STORE( m_tree_model ), &iter, &top_iter );
      
      if ( net_info->dest_host != 0 )
        set_values( &iter, "", string( net_info->attack->GetName().transcode() ), 
                               string( net_info->src_host->GetName().transcode() ), 
                               string( net_info->dest_host->GetName().transcode() ), id );
      else if ( net_info->dest_firewall )
      {
        string name = string("Firewall: ") + net_info->dest_firewall->GetName().transcode();
        set_values( &iter, "", string( net_info->attack->GetName().transcode() ), 
                               string( net_info->src_host->GetName().transcode() ), 
                               name, id );
      }  
        
      delete net_info;
    }
  }
  
  return top_iter;
}

bool GTKMeasuresGUI::find_measure( GtkTreeIter *res_iter, AttackMeasureID id )
{
  bool     res = false;
  int      t_id;
  GtkTreeIter iter;
  gboolean valid = gtk_tree_model_get_iter_first( m_tree_model, &iter );
  
  while ( valid )
  {
    gtk_tree_model_get( m_tree_model, &iter, 4, &t_id, -1 );
    
    if ( t_id == id )
    {
      res = true;
      if ( res_iter != 0)
        *res_iter = iter;
      
      break;
    }
    
    valid = gtk_tree_model_iter_next( m_tree_model, &iter );
  }
  
  return res;
}

AttackMeasureID GTKMeasuresGUI::get_measure_id( GtkTreeIter *iter )
{
  int t_id = -1;
  
  gtk_tree_model_get( m_tree_model, iter, 4, &t_id, -1 );
  
  return t_id;
}

AttackMeasure GTKMeasuresGUI::get_measure( GtkTreeIter *iter )
{
  AttackMeasureID id = get_measure_id( iter );
  
  return m_measures_set.get_measure( id );
}

void GTKMeasuresGUI::update_measure( GtkTreeIter *iter, AttackMeasureID id )
{
  GtkTreeIter child_iter;
  GtkTreeIter top_iter = get_top_measure_iter( iter );
  AttackMeasure measure = m_measures_set.get_measure( id );
  AttackTriple  attack;
  NetworkInfo  *net_info;
  
  gint n_children = gtk_tree_model_iter_n_children( m_tree_model, &top_iter );
   
  set_values( &top_iter, measure.get_name(), "", "", "", id );
  
  gtk_tree_model_iter_children( m_tree_model, &child_iter, &top_iter );
  
  int diff = n_children;
  
  for ( AttackMeasure::const_iterator p = measure.begin(); p != measure.end(); p++ )
  {
    attack = *p;
    net_info = attack.get_network_info( m_network );
    
    if ( net_info != 0 )
    {
      if ( diff <= 0 )
        gtk_tree_store_append( GTK_TREE_STORE( m_tree_model ), &child_iter, &top_iter );

      if ( net_info->dest_host != 0 )
        set_values( &child_iter, "", string( net_info->attack->GetName().transcode() ), 
                               string( net_info->src_host->GetName().transcode() ), 
                               string( net_info->dest_host->GetName().transcode() ), id );
      else if ( net_info->dest_firewall )
      {
        string name = string("Firewall: ") + net_info->dest_firewall->GetName().transcode();
        set_values( &child_iter, "", string( net_info->attack->GetName().transcode() ), 
                               string( net_info->src_host->GetName().transcode() ), 
                               name, id );
      }  
      diff--;
      
      delete net_info;
    }
  }
  
  n_children = gtk_tree_model_iter_n_children( m_tree_model, &top_iter );
  diff = n_children - (int)measure.size();
  
  if ( diff > 0 )
  {
    gtk_tree_model_iter_nth_child( m_tree_model, &child_iter, &top_iter, (int)measure.size() );
    
    for ( ;diff > 0; diff--)
      gtk_tree_store_remove( GTK_TREE_STORE( m_tree_model), &child_iter );
  }
}

void GTKMeasuresGUI::remove_measure( GtkTreeIter *iter )
{
  GtkTreeIter top_iter = get_top_measure_iter( iter ); 
  GtkTreeIter child_iter;
  int n_children = (int)gtk_tree_model_iter_n_children( m_tree_model, &top_iter );
  gtk_tree_model_iter_children( m_tree_model, &child_iter, &top_iter );
  
  for ( ; n_children > 0; n_children-- )
    gtk_tree_store_remove( GTK_TREE_STORE( m_tree_model), &child_iter );
  
  gtk_tree_store_remove( GTK_TREE_STORE( m_tree_model), &top_iter );
}

void GTKMeasuresGUI::handle_add_button_clicked_event()
{
  GTKAttacksGUI attack_dialog( true, m_network, m_scenario_graph, m_gui );
  
  int res = attack_dialog.run();
  
  if ( res == GraphGUIModalWindow::APPLIED )
  {
    GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( measures_treeview ) );
    GtkTreeIter       iter;
    AttackMeasure     measure = attack_dialog.get_result_measure();
    
    AttackMeasureID id = m_measures_set.add_measure( measure );
    
    if ( !find_measure( &iter, id ) )
      iter = add_measure( id );
    
    gtk_tree_selection_select_iter( selection, &iter ); 
  }
}

void GTKMeasuresGUI::handle_edit_button_clicked_event()
{
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( measures_treeview ) );
  GtkTreeIter       iter;
  GtkTreeModel     *model;
  
  if (gtk_tree_selection_get_selected( selection, &model, &iter ))
  {
    GTKAttacksGUI attack_dialog( true, m_network, m_scenario_graph, m_gui );
    attack_dialog.init_measure( get_measure( &iter ) );
    
    int res = attack_dialog.run();
  
    if ( res == GraphGUIModalWindow::APPLIED )
    {
      AttackMeasureID id;
      AttackMeasure   measure = attack_dialog.get_result_measure();
      if ( (id = m_measures_set.find_measure( measure )) < 0 )
      {
        id  = get_measure_id( &iter );
        m_measures_set.set_measure( id,  measure );
        update_measure( &iter, id );
      }
      
      find_measure( &iter, id );
    
      gtk_tree_selection_select_iter( selection, &iter );
    }
  }
}

void GTKMeasuresGUI::handle_delete_button_clicked_event()
{
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( measures_treeview ) );
  GtkTreeIter       iter;
  GtkTreeModel     *model;
  
  if (gtk_tree_selection_get_selected( selection, &model, &iter ))
  {
    AttackMeasureID id = get_measure_id( &iter );
    m_measures_set.remove_measure( id );
    
    remove_measure( &iter );
  }
}

void GTKMeasuresGUI::handle_load_button_clicked_event()
{
  string file_name = m_gui->run_fileselection_dialog ( "Select attack measure set file", "", "" );
  
  if ( !file_name.empty() )
  {
    gtk_tree_store_clear( GTK_TREE_STORE(m_tree_model) );
    
    if ( m_measures_set.load_from_file( file_name, m_network ) )
    {
      for ( AttackMeasureID id = m_measures_set.get_first_measure_id(); id >= 0; id = m_measures_set.get_next_measure_id( id ) )
        add_measure( id );
    }
  }
}

void GTKMeasuresGUI::handle_save_button_clicked_event()
{
  string file_name = m_gui->run_fileselection_dialog ( "Select attack measure file", "", "" );
  
  if ( !file_name.empty() )
    m_measures_set.save_into_file( file_name, m_network );
}


static void on_add_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKMeasuresGUI *dialog  = (GTKMeasuresGUI*)user_data;
  dialog->handle_add_button_clicked_event();
}

static void on_edit_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKMeasuresGUI *dialog  = (GTKMeasuresGUI*)user_data;
  dialog->handle_edit_button_clicked_event();
}

static void on_delete_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKMeasuresGUI *dialog  = (GTKMeasuresGUI*)user_data;
  dialog->handle_delete_button_clicked_event();
}

static void on_load_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKMeasuresGUI *dialog  = (GTKMeasuresGUI*)user_data;
  dialog->handle_load_button_clicked_event();
}

static void on_save_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKMeasuresGUI *dialog  = (GTKMeasuresGUI*)user_data;
  dialog->handle_save_button_clicked_event();
}

void GTKMeasuresGUI::create()
{
  GtkTreeViewColumn *column = 0;
  GtkCellRenderer   *render = 0;
  
  attak_measure_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (attak_measure_dialog), "Attack measures");
  gtk_window_set_modal (GTK_WINDOW (attak_measure_dialog), TRUE);

  dialog_vbox = GTK_DIALOG (attak_measure_dialog)->vbox;
  gtk_widget_show (dialog_vbox);

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (main_vbox);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), main_vbox, TRUE, TRUE, 0);

  measures_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (measures_scrolledwindow);
  gtk_box_pack_start (GTK_BOX (main_vbox), measures_scrolledwindow, TRUE, TRUE, 0);
  gtk_widget_set_usize (measures_scrolledwindow, 500, 200);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (measures_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  m_tree_model = (GtkTreeModel*)gtk_tree_store_new( 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT );
    
  measures_treeview = gtk_tree_view_new_with_model( m_tree_model );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Measure name", render, "text", 0, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( measures_treeview ), column );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Attack name", render, "text", 1, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( measures_treeview ), column );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Source host", render, "text", 2, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( measures_treeview ), column );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Target host", render, "text", 3, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( measures_treeview ), column );
  
  gtk_widget_show (measures_treeview);
  gtk_container_add (GTK_CONTAINER (measures_scrolledwindow), measures_treeview);

  hbox3 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (main_vbox), hbox3, FALSE, TRUE, 0);

  add_button = gtk_button_new_with_mnemonic ( "Add new" );
  gtk_widget_show (add_button);
  gtk_box_pack_start (GTK_BOX (hbox3), add_button, TRUE, TRUE, 0);

  edit_button = gtk_button_new_with_mnemonic ( "Edit measure" );
  gtk_widget_show (edit_button);
  gtk_box_pack_start (GTK_BOX (hbox3), edit_button, TRUE, TRUE, 0);

  delete_button = gtk_button_new_with_mnemonic ( "Delete measure" );
  gtk_widget_show (delete_button);
  gtk_box_pack_start (GTK_BOX (hbox3), delete_button, TRUE, TRUE, 0);

  load_button = gtk_button_new_with_mnemonic ( "Load from file" );
  gtk_widget_show (load_button);
  gtk_box_pack_start (GTK_BOX (hbox3), load_button, TRUE, TRUE, 0);

  save_button = gtk_button_new_with_mnemonic ( "Save to file" );
  gtk_widget_show (save_button);
  gtk_box_pack_start (GTK_BOX (hbox3), save_button, TRUE, TRUE, 0);

  dialog_action_area = GTK_DIALOG (attak_measure_dialog)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (attak_measure_dialog), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (attak_measure_dialog), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_edit_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
                      GTK_SIGNAL_FUNC (on_delete_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (load_button), "clicked",
                      GTK_SIGNAL_FUNC (on_load_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (save_button), "clicked",
                      GTK_SIGNAL_FUNC (on_save_button_clicked),
                      (gpointer)this);
}

int GTKMeasuresGUI::run()
{
  bool valid = ( m_network != 0 );
  
  if ( valid )
    valid = (m_network->GetNumHosts() > 0 && m_network->GetNumAttacks() > 0);
  
  if ( !valid )
  {
    m_gui->show_message_dialog( "There is no nettwork information." );
    return GraphGUIModalWindow::CANCELED;
  }

  create();
  
  for ( AttackMeasureID id = m_measures_set.get_first_measure_id(); id >= 0; id = m_measures_set.get_next_measure_id( id ) )
    add_measure( id );
    
  gint result = gtk_dialog_run( GTK_DIALOG(attak_measure_dialog) );
    
  if ( result != GTK_RESPONSE_OK )
      m_measures_set.clear();
    
  gtk_widget_destroy( attak_measure_dialog );
    
  return ((result == GTK_RESPONSE_OK && (m_measures_set.size() > 0) )? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
