#ifndef _GTK_ATTACK_GUI_H
#define _GTK_ATTACK_GUI_H

#include <gtk/gtk.h>

#include "graphics.h"
#include "NetGUIWindows.h"

namespace GraphGraphics
{
  
class GTKAttacksGUI: public NetAttacksGUI
{
private:
  static const char *ALL_POSSIBLE;
  static const string FW_PREFIX;

  GtkWidget *attack_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *main_table;
  GtkWidget *attack_combo;
  GtkWidget *attack_combo_entry;
  GtkWidget *source_combo;
  GtkWidget *source_combo_entry;
  GtkWidget *target_combo;
  GtkWidget *target_combo_entry;
  GtkWidget *attacks_scrolledwindow;
  GtkWidget *attacks_treeview;
  GtkWidget *name_entry;
  GtkWidget *name_label;
  GtkWidget *buttons_hbox;
  GtkWidget *add_button;
  GtkWidget *edit_button;
  GtkWidget *delete_button;
  GtkWidget *all_button;
  GtkWidget *load_button;
  GtkWidget *save_button;
  GtkWidget *dialog_action_area;
  GtkWidget *cancel_button;
  GtkWidget *ok_button;
  
  GtkTreeModel *m_list_model;
  
  bool          m_measure_flag;
  Network*      m_network;
  AttackMeasure m_measure;
  Graph        *m_scenario_graph;
  GraphGUI     *m_gui;
    
private:
  void create();
  GtkTreeIter add_attack( const string &attack_name, const string &source_host, const string &target_host );
  void set_attack( GtkTreeIter *iter, const string &attack_name, const string &source_host, const string &target_host );
  void remove_attack( GtkTreeIter *iter );
  void remove_all_attack();
  bool find_attack( const string &attack_name, const string &source_host, const string &target_host, GtkTreeIter *res_iter) ;  
  bool is_dest_firewall( const string &dest );
  string get_dest_data( const string &dest );
public:
  GTKAttacksGUI( bool is_measure, Network* network, Graph *scenario_graph, GraphGUI *gui )
  { 
    m_measure_flag = is_measure;
    m_network = network;
    m_scenario_graph = scenario_graph;
    m_gui    = gui;
  }
  ~GTKAttacksGUI(){}
  
  int run();
  void              init_measure( const AttackMeasure& measure ) { m_measure = measure; }
  AttackMeasure     get_result_measure() { return m_measure; }
  
  gboolean handle_attacks_treeview_button_release_event();
  void     handle_add_button_clicked_event();
  void     handle_edit_button_clicked_event();
  void     handle_delete_button_clicked_event();
  void     handle_all_button_clicked_event();
  void     handle_load_button_clicked_event();
  void     handle_save_button_clicked_event();
};

};

#endif
