#ifndef _NETGUI_H_
#define _NETGUI_H_

#include "graphics.h"
#include "NetGUIWindows.h"

namespace GraphGraphics
{
 
class NetworkComp;
  
class NetworkGUI
{
public:
  NetworkGUI() {}
  ~NetworkGUI() {}
    
  /**
   *  The method creates GUI dialog object for changing network preferences.
   *  These preferences are saved into a file and are used as default properties for first time graph drawing.
   *  The preferences also contain different network scanners options.
   *  @param view The pointer to network <b>GraphView</b> object, which properties are used.
   *  @return A pointer to <b>GraphGUIModalWindow</b> instance.     
   */
  GraphGUIModalWindow* create_net_preferences_dialog( GraphView *net_view );
  NetAttacksGUI*       create_attacks_dialog( Graph *scenario_graph, NetworkComp* netcomp, GraphGUI *gui );
  NetAttackMeasuresGUI* create_attack_measures_dialog( Graph *scenario_graph, NetworkComp* netcomp, GraphGUI *gui );
};

};
#endif
