
#include "graph.hpp"

extern NodeHashSet Nodes;
extern list<Node*> NodeList;
extern unsigned long reconstructing_stack_summ;
extern long max_depth;

bool Node::operator==(Node &other) {
  bool key_cmp = memcmp(packed_state->hash_key, other.packed_state->hash_key, StateHash::HASH_KEY_BYTE_SIZE) == 0;
  
  hash_comparison++;
  
  if (key_cmp) {
    State *OtherState = other.GetState();
    State *CurrState = state;
    bool  gen_curr_state = false, gen_other_state = false;
    
    if (OtherState == 0 && detect_collisions) {
      gen_other_state = true;
      state_restoring++;
      OtherState = other.GenerateNodeState();
    }
    
    if (CurrState == 0 && detect_collisions) {
      gen_curr_state = true;
      state_restoring++;
      CurrState = GenerateNodeState();
    }
    
    if ( CurrState != 0 && OtherState != 0) {
      uchar *comp_curr_st;
      int curr_size = CurrState->get_state_byte_array( &comp_curr_st );
      uchar *comp_other_st;
      int other_size = OtherState->get_state_byte_array( &comp_other_st );
      key_cmp = (curr_size == other_size);
      
      if ( key_cmp )
        key_cmp = (memcmp( comp_curr_st, comp_other_st, curr_size ) == 0);
      
      delete[] comp_curr_st;
      delete[] comp_other_st;
      
      state_comparison++;
/*      if (CurrState->proc_count() != OtherState->proc_count()) 
        key_cmp = false;
      else {
        for (int i = 0; i < CurrState->proc_count(); i++)
          if (CurrState->get_proc(i)->get_curr_state() != OtherState->get_proc(i)->get_curr_state())
            key_cmp = false;
      }
    
      if (CurrState->get_never_claim() != 0 && key_cmp)
        if  (CurrState->get_never_claim()->get_curr_state() != OtherState->get_never_claim()->get_curr_state())      
            key_cmp = false;
      
      if (key_cmp)      
        key_cmp = CurrState->compare_global_vars( OtherState );
*/
      if ( !key_cmp )
        collisions_count++;
    }
    
    if (gen_other_state)
      delete OtherState;
  
    if (gen_curr_state)
      delete CurrState;
  }

  return key_cmp;
}

State* Node::GenerateNodeState() {
  Node        *n, *n_parent, *n_curr;
  int         n_ind;
  NodeStack   stack;
  State       *curr_state;
  CAutomBase  *never, *autom;
  PackedState *pack_state;
  NodeElement *last_child;
  unsigned int st_size;
  
  n = this;
//walk through the branch of the graph up to the "root"  
  while (n->GetParent() != 0 /*&& n->state == 0*/ ) {
    stack.Push(n);
    n = n->GetParent();
    reconstructing_stack_summ++;
  }
//n became a "root" of the graph. This node should always contain non-zero State field    
  curr_state = (State*)n->GetState()->clone();
  while (!stack.Empty()) {
    n = stack.Pop();
    n_parent = n->GetParent();
    pack_state = n->GetPackedState();
    never = curr_state->get_never_claim();
    
    if (never != 0)
      never->new_state(curr_state, pack_state->ltl_trans_id);    
    
    n_ind = 0;
    last_child = n_parent->GetCurrNodeElement();
    n_parent->ResetLastChild();    
    while ((n_curr = n_parent->GetNextChild()) != 0) {
      if (n_curr == n) 
        break;
      else if (n_curr->GetPackedState()->ltl_trans_id == pack_state->ltl_trans_id && n_curr->GetPackedState()->autom_trans_id == pack_state->autom_trans_id
               && n_curr->GetPackedState()->autom_number == pack_state->autom_number)
        n_ind++;        
    }
    n_parent->SetCurrNodeElement(last_child);

    if (never != 0 && never->is_inside_atomic()){
      LISTSTATE ltl_ret_states;
      int       state_count = 0;
      GenerateAtomicStates(-1, curr_state, ltl_ret_states);
      State *st;
      
      while (!ltl_ret_states.empty()){
        st = ltl_ret_states.back(); ltl_ret_states.pop_back();

        autom = st->get_proc(pack_state->autom_number);
        autom->new_state(st, pack_state->autom_trans_id);
        
        if (autom->is_inside_atomic()){
          LISTSTATE ret_states;
          GenerateAtomicStates(pack_state->autom_number, curr_state, ret_states);
          State *st;
          
          state_count += ret_states.size();
          
          if (n_ind < state_count) {
            n_ind = ret_states.size() - (state_count - n_ind);
            
            while (n_ind > 0) {
              delete ret_states.back();
              ret_states.pop_back();
              n_ind--;
            }
            
            curr_state = ret_states.back();
            ret_states.pop_back();            
            
            while (!ret_states.empty()) {
              delete ret_states.back();
              ret_states.pop_back();
            }
            
            break;
          }
        }
        
        delete st;
      }
      
      while (!ltl_ret_states.empty()) {
        delete ltl_ret_states.back();
        ltl_ret_states.pop_back();
      }
    }
    else
    {
      autom = curr_state->get_proc(pack_state->autom_number);
      autom->new_state(curr_state, pack_state->autom_trans_id);
      
      if (autom->is_inside_atomic()){
        LISTSTATE ret_states;
        GenerateAtomicStates(pack_state->autom_number, curr_state, ret_states);
        State *st;
          
        while (n_ind > 0) {
          delete ret_states.back();
          ret_states.pop_back();
          n_ind--;
        }
            
        curr_state = ret_states.back();
        ret_states.pop_back();
        
        while (!ret_states.empty()) {
          delete ret_states.back();
          ret_states.pop_back();
        }
        
      }
    }
    
    
  }
  
  return curr_state;
}

void Node::GenerateAtomicStates(int procnum, State *state, LISTSTATE &states) {
  LISTSTATE curr_states;
     
  curr_states.push_front(state);
  
  while (!curr_states.empty()) {
    state = curr_states.front(); curr_states.pop_front();
    CAutomBase *proc = state->get_proc(procnum);

    proc->set_first_skip_trans(false);

    if (procnum < 0)
      proc = state->get_never_claim();
    else
      proc = state->get_proc(procnum);
 // AR   
    proc->set_moved(false);
    proc->set_else_passed(false);
 //
    int else_trans_id = -1;
    int state_num = proc->get_curr_state();
    bool  enable_trans = false;
    for (int trans_id = proc->get_first_trans_id(state_num); trans_id != 0; trans_id = proc->get_next_trans_id(trans_id)) {
      
      if (!proc->is_trans_enable(state, trans_id)){
        if (proc->get_next_trans_id(trans_id) == 0 && proc->is_else_passed() && !proc->is_moved())
        {
          trans_id = else_trans_id;
          enable_trans = true;
        }
        else
          continue;
      }  
      else{
        if (proc->is_else_passed() && proc->get_next_trans_id(trans_id) != 0)
        {
          else_trans_id = trans_id;
          continue;
      
        }
        enable_trans = true;
      }  
 //     if (proc->is_trans_enable(state, trans_id)) {
      if ( enable_trans ) {
      
        State *next_state = (State*)state->clone();
        CAutomBase *next_proc;
        
        if (procnum < 0)
          next_proc = next_state->get_never_claim();
        else
          next_proc = next_state->get_proc(procnum);
        
        next_proc->set_moved(false);

        next_proc->new_state(next_state, trans_id);
        proc->set_moved(true);
        
        int new_trans_id = next_proc->get_first_trans_id(next_proc->get_curr_state());
        if (next_proc->is_inside_atomic())
          curr_states.push_front(next_state);
        else
          states.push_front(next_state);

        //enable_trans = true;
      }
      
      if (trans_id == else_trans_id)
        break;
    }
      
    if (!enable_trans)
      states.push_back(state);
    else
      delete state;
  }
}
  
  
void Node::GenerateChildren() {
  // Never claim moves first
  CAutomBase *never = state->get_never_claim();
    
  if (never != 0){
    int orig_state = never->get_curr_state();      
    int trans_id = never->get_first_trans_id(orig_state);         
    int else_trans_id = -1; //this varible will contain id of "else" statement (or atomic statement that contains "else")
    never->set_moved(false);
    never->set_else_passed(false);
    
    for (trans_id = never->get_first_trans_id(orig_state); trans_id != 0; trans_id = never->get_next_trans_id(trans_id)){
      if (!never->is_trans_enable(state, trans_id)){
        never->set_curr_state(orig_state);   
        if (never->get_next_trans_id(trans_id) == 0 && never->is_else_passed() && !never->is_moved())
          trans_id = else_trans_id;
        else
          continue;
      }
      else{
        never->set_curr_state(orig_state);
        if (never->is_else_passed() && never->get_next_trans_id(trans_id) != 0)
        {
          else_trans_id = trans_id;
          continue;
        }
      }
      
      State *NextState = (State*)state->clone();
      CAutomBase *never_new = NextState->get_never_claim();
      never_new->new_state(NextState, trans_id);

      never->set_moved(true);
            
      if (never_new->is_inside_atomic()){
        LISTSTATE ret_states;
        GenerateAtomicStates(-1, NextState, ret_states);
        State *st;
        while (!ret_states.empty()){
          st = ret_states.front(); ret_states.pop_front();
          AutomsProcesing(state, st, trans_id);            
          delete st;
        }
      }
      else{
        AutomsProcesing(state, NextState, trans_id);            
        delete NextState;
      }

//we should leave this loop if "else" transition is processed - it should be always the last transition      
      if (trans_id == else_trans_id)
        break;
    }
  }
  else{
    int proc_cnt = state->proc_count();  
    for (int procnum = 0; procnum < proc_cnt; procnum++){
      CAutomBase *proc = state->get_proc(procnum);

      if (proc != 0){
        int else_trans_id = -1; //this varible will contain id of "else" statement (or atomic statement that contains "else")
        int orig_state = proc->get_curr_state();      
        int pr_trans_id = proc->get_first_trans_id(orig_state);         
        proc->set_moved(false);
        proc->set_else_passed(false);
        
        for (int pr_trans_id = proc->get_first_trans_id(proc->get_curr_state()); pr_trans_id != 0; pr_trans_id = proc->get_next_trans_id(pr_trans_id)){
          if (!proc->is_trans_enable(state, pr_trans_id)){
            proc->set_curr_state(orig_state);            
            if (proc->get_next_trans_id(pr_trans_id) == 0 && proc->is_else_passed() && !proc->is_moved())
              pr_trans_id = else_trans_id;
            else
              continue;
          }      
          else{
            proc->set_curr_state(orig_state);            
            if (proc->is_else_passed() && proc->get_next_trans_id(pr_trans_id) != 0)
            {
              else_trans_id = pr_trans_id;
              continue;
            }
          }

          State *NextState = (State*)state->clone();
          CAutomBase *proc_new = NextState->get_proc(procnum);
          proc_new->new_state(NextState, pr_trans_id);
          
          proc->set_moved(true);
          
          if (proc_new->is_inside_atomic()){
            LISTSTATE ret_states;
            GenerateAtomicStates(procnum, NextState, ret_states);
            State *st;
            while (!ret_states.empty()){
              st = ret_states.front(); ret_states.pop_front();
              GenerateChild(st, procnum, pr_trans_id, 0);
            }
          }
          else{
            GenerateChild(NextState, procnum, pr_trans_id, 0);
          }
          
//we should leave this loop if "else" transition is processed - it should be always the last transition      
          if (pr_trans_id == else_trans_id)
            break;
        }
      }
    }
  }
}

void Node::AutomsProcesing(State *state, State *NextState_never, int ltl_trans_id) {
  int proc_cnt = state->proc_count();  
  // One of the processes moves
  for (int procnum = 0; procnum < proc_cnt; procnum++){
    CAutomBase *proc = state->get_proc(procnum);
      
    if (proc != 0){
      int else_trans_id = -1; //this varible will contain id of "else" statement (or atomic statement that contains "else")      
      int orig_state = proc->get_curr_state();      
      int pr_trans_id = proc->get_first_trans_id(orig_state);         
      proc->set_moved(false);
      proc->set_else_passed(false);
      
      for (pr_trans_id = proc->get_first_trans_id(orig_state); pr_trans_id != 0; pr_trans_id = proc->get_next_trans_id(pr_trans_id)){
        if (!proc->is_trans_enable(state, pr_trans_id)){
          proc->set_curr_state(orig_state);            
          if (proc->get_next_trans_id(pr_trans_id) == 0 && proc->is_else_passed() && !proc->is_moved())
            pr_trans_id = else_trans_id;
          else
            continue;
        }      
        else{
          proc->set_curr_state(orig_state);            
          if (proc->is_else_passed() && proc->get_next_trans_id(pr_trans_id) != 0)
          {
            else_trans_id = pr_trans_id;
            continue;
          }
        }
        
        State *NextState = (State*)NextState_never->clone();      
        CAutomBase *proc_new = NextState->get_proc(procnum);
        proc_new->set_moved(false);
        proc_new->new_state(NextState, pr_trans_id);
        
        proc->set_moved(true);
        
        if (proc_new->is_inside_atomic()){
          LISTSTATE ret_states;
          GenerateAtomicStates(procnum, NextState, ret_states);
          State *st;
          while (!ret_states.empty()){
            st = ret_states.front(); ret_states.pop_front();
            GenerateChild(st, procnum, pr_trans_id, ltl_trans_id);
          /*                AddChild(Child);*/
          }
        }
        else{
          GenerateChild(NextState, procnum, pr_trans_id, ltl_trans_id);
      /*              AddChild(Child);*/
        }
        
//we should leave this loop if "else" transition is processed - it should be always the last transition      
        if (pr_trans_id == else_trans_id)
          break;
        
      }
    }
  }
}

void Node::Print() { if ( do_lefty_output ) printf("%d|%d", number, lowlink); }

void Node::PrintSubgraphDotFormat(FILE *fd) {

  if ( do_lefty_output ) {
    fprintf(fd, "st%d [ shape = %s, label = \"%d (%d) st %d\ns=%d\" ];\n",
      GetNumber(), IsAccepting() ? "doublecircle" : "circle",
      GetNumber(), GetLowLink(),
      /*state->statenum[0]*/0, /*state->globals.s*/0);

    NodeElement *element = Children;
    while (element != NULL) {
      if (element->node->GetNumber() > GetNumber())
        element->node->PrintSubgraphDotFormat(fd);
        
        fprintf(fd, "st%d -> st%d;\n", GetNumber(), element->node->GetNumber());
        
      element = element->next;
    }
  }
}

Node *Node::GenerateChild(int procnum, int pr_trans_id, int trans_id) {

  State *NextState = (State*)state->clone();
  
  CAutomBase *never = NextState->get_never_claim();
    
  if (never != 0)
  {
    never->new_state(NextState, trans_id);
    
    if ( never->is_stop_found_first() )
    {
      ForceAccepting( true );
      ForceFinal( true );
    }
  }
  CAutomBase *proc = NextState->get_proc(procnum);
  proc->new_state(NextState, pr_trans_id);

  Node *NextChild = new Node(NextState, procnum, pr_trans_id, trans_id);
  NodeHashSet::iterator PreviouslyFound = Nodes.find(NextChild);
  
  dfs_edges_count++;
    
  if (PreviouslyFound != Nodes.end()) {
    delete NextChild;
    return *PreviouslyFound;
  }
  else {
    unsigned int st_size = NextState->calc_size();
    if ( st_size > StateBase::max_state_size )
      StateBase::max_state_size = st_size;
    Nodes.insert(NextChild);
    NodeList.push_back(NextChild);
    return NextChild;
  }
}

void Node::GenerateChild(State *NextState, short autom_num, int autom_trans_id, int ltl_trans_id) {
   
  Node *NextChild = new Node(NextState, autom_num, autom_trans_id, ltl_trans_id);
  NodeHashSet::iterator PreviouslyFound = Nodes.find(NextChild);
  
  dfs_edges_count++;
  
  CAutomBase *never = NextState->get_never_claim();
  
  if (never != 0)
  {
    if ( never->is_stop_found_first() )
    {
      ForceAccepting( true );
      ForceFinal( true );
    }
  }
    
  if (PreviouslyFound != Nodes.end()) {
    delete NextChild;
    AddChild(*PreviouslyFound);
  }
  else {
    unsigned int st_size = NextState->calc_size();
    long         depth   = 0;
    if ( st_size > StateBase::max_state_size )
      StateBase::max_state_size = st_size;
    
    Nodes.insert(NextChild);
    NodeList.push_back(NextChild);
    AddChild(NextChild);
    
    while ( NextChild != 0 )
    {
      NextChild = NextChild->parent;
      depth++;
    }
    
    if ( depth > max_depth )
      max_depth = depth;
  }

  if (do_lefty_output)
    printf("\n\n");
}

////////////////////////
// Lefty script output

void Node::LeftyInsertNode(FILE *fd, char *GraphTableName, bool DFS_output ) 
{
  /*Save tracing flags*/
  unsigned long flags = Tracer::get_flags();
  ostream  *dbg_stream = Tracer::get_curr_stream();
  long ind = GetNumber();
  State *curr_state = state;
  ofstream &out_graph = ((DFS_output)? dfs_graph_file: graph_file);
  
  if ( curr_state == 0 )
    curr_state = GenerateNodeState();
    
  if ( ascii_file ){
    Tracer::init_tracing( &out_graph, Tracer::GRAPH_ATTR_FORMAT | Tracer::ASCII_OUTPUT );
   
    // cerr << "Node " << GetNumber() << endl;
    out_graph << ind << ": Node{ bool: accept=" << (IsAccepting()? 1: 0) << "; "; 
    out_graph<< "bool: final=" << (IsFinal()? 1: 0) << "; ";
    
    if ( DFS_output )
      out_graph<< "bool: in_scenario=" << (InScenario()? 1: 0) << "; ";
   
    Tracer::trace( curr_state );
   
    // Temporarily output scenario=0, so that it's not highlighted blue.
    // graph_file << "; byte: scenario=" << (inscenario? 1: 0) << ";" << str << "}\n";
   
    out_graph << "}";
    Tracer::finish_ASCII_block( );
  } 
  else {
    unsigned long format_flags = Tracer::GRAPH_ATTR_FORMAT;
    if ( bin32_file )
      format_flags |= Tracer::BIN32; 
    Tracer::init_tracing( &out_graph, format_flags );
   
    Tracer::write_bin_identifier( Tracer::get_name_id( "Node" ), &out_graph );
    //Tracer::write_2bytes( Tracer::get_name_id( "Node" ), &out_graph ); //name - "Node"
    Tracer::write_1bytes( (char)-3, &out_graph ); //type "NODE_START"
    Tracer::write_4bytes( ind, &out_graph ); //value - node id
   
    Tracer::write_bin_identifier( Tracer::get_name_id( "accept" ), &out_graph );
    //Tracer::write_2bytes( Tracer::get_name_id( "accept" ), &out_graph ); //name - "accept"
    Tracer::write_1bytes( Tracer::get_type_id( "bool" ), &out_graph ); //type - "bool"
    Tracer::write_1bytes( (unsigned char)(IsAccepting()? 1: 0), &out_graph ); //value 
    
    Tracer::write_bin_identifier( Tracer::get_name_id( "final" ), &out_graph );
    //Tracer::write_2bytes( Tracer::get_name_id( "final" ), &out_graph ); //name - "final"
    Tracer::write_1bytes( Tracer::get_type_id( "bool" ), &out_graph ); //type - "bool"
    Tracer::write_1bytes( (unsigned char)(IsFinal()? 1: 0), &out_graph ); //value 
    
    if ( DFS_output ) {
      Tracer::write_bin_identifier( Tracer::get_name_id( "in_scenario" ), &out_graph );
      //Tracer::write_2bytes( Tracer::get_name_id( "in_scenario" ), &out_graph ); //name - "in_scenario"
      Tracer::write_1bytes( Tracer::get_type_id( "bool" ), &out_graph ); //type - "bool"
      Tracer::write_1bytes( (unsigned char)(InScenario()? 1: 0), &out_graph ); //value 
    }
   
    Tracer::trace( curr_state );
    
    Tracer::write_bin_identifier( Tracer::get_name_id( "Node" ), &out_graph );
    //Tracer::write_2bytes( Tracer::get_name_id( "Node" ), &out_graph ); //name - "Node"
    Tracer::write_1bytes( (char)-2, &out_graph ); //type "ATTR_END"
    Tracer::write_bin_identifier( -3, &out_graph );
    //Tracer::write_2bytes( (short)-3, &out_graph ); //node separator
  }

  /*Set to make lefty input (minimized) string (State, Automata, Glob./Loc. variables)*/
  //      Tracer::set_flags( Tracer::LEFTY_INPUT );
  /* trace State to string with all set flags*/
  //      Tracer::trace( Tracer::LEFTY_INPUT | Tracer::TRACE_STATE, state );

  /*get output string and restore string buffer*/
  //      str = Tracer::get_output_str();
    
    
  if ( do_lefty_output )
    fprintf(fd,
      "fa.%s.insertnode(fa.%s, null, null, 'st%d', [\"shape\" = \"%s\"; \"label\" = \"%d (%d)\\n%s\";], 1);\n",
      GraphTableName, GraphTableName, GetNumber(), IsAccepting() ? "doublecircle" : "circle",
      GetNumber(), GetLowLink(),
      " "//str.c_str() /* path tracer output string */
      );

  /*Restore tracing flags*/
  Tracer::init_tracing( dbg_stream, flags );

  /*Trace to file or stdout*/
  /*print "Node: " + GetNumber() + "\n"*/
  Tracer::trace( (Tracer *)0, GetNumber(), "Node: ", "\n" );
            
  /*print State info (State, Automata (without tables), Queues, Queues el., Glob./Loc. variables )*/
  flags = Tracer::TRACE_STATE | Tracer::TRACE_AUTOM | Tracer::TRACE_QUEUE | Tracer::EXPAND_QUEUE | Tracer::TRACE_VAR;
  
  if ( curr_state )
    Tracer::trace( flags, curr_state );
  
  if ( state == 0 )
    delete curr_state;
}

void Node::LeftyInsertEdge(FILE *fd, Node *source, Node *sink, char *GraphTableName, bool insert_to_file, bool DFS_output ) 
{
  if ( insert_to_file ) {
    ofstream &out_graph = ((DFS_output)? dfs_graph_file: graph_file);
    // cerr << "Edge " << source->GetNumber() << " -> " << sink->GetNumber() << endl;
      
    if ( ascii_file )
      out_graph << source->GetNumber() << "-> " << sink->GetNumber() << "\n";
    else
    {
      Tracer::write_bin_identifier( -255, &out_graph );
      //Tracer::write_2bytes( (short)-255, &out_graph ); //edge id
      Tracer::write_4bytes( (long)(source->GetNumber()), &out_graph ); //start node id
      Tracer::write_4bytes( (long)(sink->GetNumber()), &out_graph ); //end node id
    }
  }
    
  if ( do_lefty_output )
    fprintf(fd, "fa.%s.insertedge(fa.%s, fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]], null, fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]], null, null, 1);\n",
      GraphTableName, GraphTableName, GraphTableName,
      GraphTableName, source->GetNumber(), GraphTableName, GraphTableName, sink->GetNumber());
}

void Node::LeftyUpdateNode(FILE *fd, char *GraphTableName) 
{
   if ( do_lefty_output ) {
      /*Save tracing flags*/
      unsigned long flags = Tracer::get_flags();

      /*Set to make lefty input (minimized) string (State, Automata, Glob./Loc. variables)*/
      Tracer::set_flags( Tracer::LEFTY_INPUT );
      /* trace State to string with all set flags*/
      Tracer::trace( Tracer::LEFTY_INPUT | Tracer::TRACE_STATE, state );

      /*get output string and restore string buffer*/
      string str = Tracer::get_output_str();

      
      fprintf(fd, "fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]].attr.label = \"%d (%d)\\n%s\";\n",
        GraphTableName, GraphTableName, GetNumber(), GetNumber(), GetLowLink(),
        str.c_str());

      /*Restore tracing flags*/
      Tracer::set_flags( flags );
   }
}

void Node::LeftyInsertNodeStep(FILE *fd, char *GraphTableName) {
  LeftyInsertNode(fd, GraphTableName);
    
  if ( do_lefty_output )
    fprintf(fd, "command done\n");
}    

void Node::LeftyInsertEdgeStep(FILE *fd, Node *source, Node *sink, char *GraphTableName) {
  LeftyInsertEdge(fd, source, sink, GraphTableName);
    
  if ( do_lefty_output )
    fprintf(fd, "command done\n");
}

void Node::LeftyUpdateNodeStep(FILE *fd, char *GraphTableName) {
  LeftyUpdateNode(fd, GraphTableName);
    
  if ( do_lefty_output )
    fprintf(fd, "command done\n");
}

void Node::LeftyHighlight(FILE *fd, char *GraphTableName) {
  if ( do_lefty_output )
    fprintf(fd, "highlightnode(fa.%s, fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]]);",
      GraphTableName, GraphTableName, GraphTableName, GetNumber());
}
      
void Node::LeftyHighlightLabel(FILE *fd, char *GraphTableName) {
  if ( do_lefty_output )
    fprintf(fd, "highlightlabel(fa.%s, fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]]);",
      GraphTableName, GraphTableName, GraphTableName, GetNumber());
}
      
void Node::LeftyHighlightEdge(FILE *fd, Node *source, Node *sink, char *GraphTableName) {
  if ( do_lefty_output )
    fprintf(fd, "highlightedge(fa.%s, fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]], fa.%s.graph.nodes[fa.%s.graph.nodedict[\"st%d\"]]);",
      GraphTableName, GraphTableName, GraphTableName, 
      source->GetNumber(), GraphTableName, GraphTableName, sink->GetNumber());
}

void Node::PrintLeftyProgram(FILE *fd, char *GraphTableName) {

  LeftyInsertNodeStep(fd, GraphTableName);

  NodeElement *element = Children;
  while (element != NULL) {
    if (element->node->GetNumber() > GetNumber())
      element->node->PrintLeftyProgram(fd, GraphTableName);
    LeftyInsertEdgeStep(fd, this, element->node, GraphTableName);
    element = element->next;
  }
}

void ProfileHashCollisions()
{
  ofstream coll;
  coll.open("coll");
  __gnu_cxx::hash<Node *> H;
  cout << endl;
  int nidx = 0, total = 0;
  for (NodeHashSet::iterator nd = Nodes.begin(); nd != Nodes.end(); nd++) {
    int collision = 0;
    for (NodeHashSet::iterator other = Nodes.begin(); other != Nodes.end(); other++) {
      if (H(*nd) == H(*other))
        collision++;
    }
    if (collision > 1) {
      total++;
      coll << "node " << (*nd)->GetNumber() << ": " << collision << endl;
    }
    cout << "node " << nidx << ": " << collision-1 << ", " << total << endl;
    nidx++;
  }
  cout << endl;
  
  coll.close();
}

void Graph::PrintToFile() {
  
  for (NodePointerList::iterator nodeiter = GraphNodes.begin(); nodeiter != GraphNodes.end(); nodeiter++) {
    Node *node = *nodeiter;
    
    if ( node->InScenario() )
    {
      node->RemoveDuplicatedChildren();      
      for (NodeElement *Child = node->Children; Child != NULL; Child = Child->next) {
        if (Child->node->InScenario()) {
          edgecount++;
          node->LeftyInsertEdge(stdout, node, Child->node, "scen", true);
        }
      }
    }
  }
} 

GraphMetrics Graph::CountGraphMetrics( Node *init_node )
{
  GraphMetrics res;
  int       counter = 0;
  int       length = 0;
  NodeStack  PathNodesStack;
  Node      *node;
  Node      *child;
  
  int       acc_number = 0;
  int       max_degree = 0;
  int       max_nf_degree = 0;
  int       graph_depth = 0;
  int       shortest = 0;
  int       longest  = 0;
  
  if ( init_node->InScenario() ) {
    
    for (NodePointerList::iterator nodeiter = GraphNodes.begin(); nodeiter != GraphNodes.end(); nodeiter++) {
      node = *nodeiter;
      node->RemoveDuplicatedChildren();
      node->ResetLastChild();
      
      child = node->GetNextChild();
      counter = 0;
      // calc node degree
      for ( ; child; child = node->GetNextChild() )
        if ( child->InScenario() )
          counter++;
        
      if ( counter > max_degree )
        max_degree = counter;
      
      if ( node->IsAccepting() )
        acc_number++;
      else if ( counter > max_nf_degree )
          max_nf_degree = counter;
    }
    
    shortest = GraphNodes.size();
    counter = 0;
    
    PathNodesStack.Push( init_node );
    
    init_node->SetFixed( true );
    
    //calc scenario length 
    while ( !PathNodesStack.Empty() ) {
      node = PathNodesStack.Top();
      
      child = node->GetNextChild();
      
      if ( child == 0 ) {
        PathNodesStack.Pop();
        node->SetFixed( false );
      }
      else if ( child->InScenario() ) {
        if ( child->IsFinal() ) {
          length = PathNodesStack.GetLength() + 1;
          
          if ( longest < length )
            longest = length;
          
          if ( shortest > length )
            shortest = length;
          
          counter ++;
        }
        else if ( !child->IsFixed() )
        {
          PathNodesStack.Push( child );
          child->SetFixed( true );
        } 
      }
    }
    
    if ( longest == 0 )
      shortest = 0; 
    
    PathNodesStack.Push( init_node );
    
    init_node->SetFixed( true );
    
    //calc whole graph depth 
    while ( !PathNodesStack.Empty() ) {
      node = PathNodesStack.Top();
      
      child = node->GetNextChild();
      
      if ( child == 0 ) {
        length = PathNodesStack.GetLength();
        if ( length > graph_depth )
          graph_depth = length;
        
        PathNodesStack.Pop();
        node->SetFixed( false );
      }
      else if ( child->InScenario() ) {
        if ( !child->IsFixed() )
        {
          PathNodesStack.Push( child );
          child->SetFixed( true );
        } 
      }
    }
  }   

  res.acceptance_number = acc_number;
  res.max_node_out_degree = max_degree;
  res.max_not_final_out_degree = max_nf_degree;
  res.graph_depth = graph_depth;
  res.longest_scenario = longest;
  res.shortest_scenario = shortest;
  

  return res;  
}
  
