
#include "gstructs.h"

uchar StateHash::HASH_KEY_BYTE_SIZE = 8;
uchar StateHash::PearsonX[256];
int   StateHash::max_st_arr_size = 0;
StateHash::HashFunc StateHash::hash_function = StateHash::JENKINS_FUNC;
uchar StateHash::DWORD_BYTE_PER_KEY = 2;

const uchar   Tracer::QUEUE_CLASS = 1;
const uchar   Tracer::AUTOM_CLASS = 2;
const uchar   Tracer::STATE_CLASS = 3;
const uchar   Tracer::QUEUE_EL_CLASS = 4;
const int     Tracer::MAX_ASCII_LINE_LENGTH = 30000;
int           Tracer::m_curr_line_len = 0;

const unsigned long Tracer::ASCII_OUTPUT     = 0x000001;
const unsigned long Tracer::PRINT_TO_STR     = 0x000002;
const unsigned long Tracer::LEFTY_INPUT      = 0x000004;
const unsigned long Tracer::GRAPH_ATTR_FORMAT  = 0x000008;

const unsigned long Tracer::TRACE_STATE      = 0x000010;
const unsigned long Tracer::TRACE_QUEUE      = 0x000020;
const unsigned long Tracer::TRACE_AUTOM      = 0x000040;
const unsigned long Tracer::TRACE_QUEUE_EL   = 0x000080;
const unsigned long Tracer::EXPAND_QUEUE     = 0x000100;
const unsigned long Tracer::TRACE_MEM        = 0x000200;
const unsigned long Tracer::TRACE_TABLE      = 0x000400;
const unsigned long Tracer::ATTR_INIT        = 0x000800;
const unsigned long Tracer::TRACE_LOC_VAR    = 0x001000;
const unsigned long Tracer::TRACE_GL_VAR     = 0x002000;
const unsigned long Tracer::TRACE_VAR        = 0x003000;

const unsigned long Tracer::BIN32            = 0x004000;
   
const unsigned long Tracer::ACTION_DEL       = 0x010000;
const unsigned long Tracer::ACTION_ADD       = 0x020000;
const unsigned long Tracer::ACTION_CLONE     = 0x040000;
const unsigned long Tracer::ACTION_VAR       = 0x080000;
const unsigned long Tracer::ACTION_LOOK      = 0x100000;
const unsigned long Tracer::ACTION_FLAGS     = 0xFF0000;

string              Tracer::EOL              = "\n";
string              Tracer::TAB              = "\t";
string              Tracer::ATTR_START       = "{";
string              Tracer::ATTR_END         = "}";

const unsigned long Tracer::FULL_TRACE       = 0x0FBFF0;
unsigned long       Tracer::m_tracing_flags  = FULL_TRACE;
ostream*            Tracer::m_out_stream = 0;
ostringstream       Tracer::m_out_sstream("");

NameStorage  Tracer::m_name_set;
vector<string>  Tracer::m_name_arr(0);
TypeStorage  Tracer::m_type_set;
vector<string>  Tracer::m_type_arr(0);


/********************************************************************/
/********************************************************************/
int StateBase::state_in_memory = 0;
int StateBase::max_state_in_memory = 0;
unsigned int StateBase::max_state_size = 0;
const uchar CAutomBase::ATOM = 2;
const uchar CAutomBase::L_ATOM = 4;
const uchar CAutomBase::ND_ATOM = 16;
const uchar CAutomBase::D_ATOM = 64;


void StateHash::init_hashing()
{
  int i, j;
  uchar k = 7, s;
  for ( i = 0; i < 256; i++ )
    PearsonX[i] = i;
  
  for ( j = 0; j < 3; j++ )
    for ( i = 0; i < 256; i++ )
    {
      s = PearsonX[i];
      k = (k + s) & 0xFF;
      PearsonX[i] = PearsonX[k];
      PearsonX[k] = s;
    }
    
  DWORD_BYTE_PER_KEY = (HASH_KEY_BYTE_SIZE / 4) * 4;
}

uchar StateHash::pack_state_hash_key( State* st, uchar **key )
{
  uchar *comp_st = 0;
  int state_size = st->get_state_byte_array( &comp_st );
  
  if ( max_st_arr_size < state_size )
    max_st_arr_size = state_size;
    
  *key = new uchar[ HASH_KEY_BYTE_SIZE ];
  
  memset( *key, 0, HASH_KEY_BYTE_SIZE * sizeof(uchar) );
  
  if ( state_size > HASH_KEY_BYTE_SIZE )  
    switch (hash_function)
    {
    case PEARSON_FUNC:
      pearson_hash( comp_st, state_size, *key );
      break;
    default:
      jenkins_hash( comp_st, state_size, *key );
    }
  else
    memcpy( *key, comp_st, state_size );
    
  delete[] comp_st;
  
  return (state_size < HASH_KEY_BYTE_SIZE)? state_size: HASH_KEY_BYTE_SIZE;
}
/********************************************************************/
/* Queue: Queue routines                                            */
/********************************************************************/
Clonable* Queue::clone( )
{
   Clonable *q_clone = m_type_carrier->clone();
   QueueTypeCarrier *q_t = dynamic_cast<QueueTypeCarrier*>(q_clone);

   Queue *the_clone = new Queue( (is_rvz()? 0: m_max_length), q_t );

   QueueEl *q_el = 0;

   for ( int i = 0; i < m_items.size(); i++ )
   {
      if ( m_items[i] != 0 )
      {
         q_clone = m_items[i]->clone();
         q_el = dynamic_cast<QueueEl*>(q_clone);
         the_clone->send( q_el );
      }
   }
   the_clone->m_owner = m_owner;
   return the_clone;
}

void Queue::trace( unsigned long trace_action, long extra_info, const string &line_prefix )
{
   if ( (trace_action & TRACE_QUEUE) )
   {
      if ( (trace_action & GRAPH_ATTR_FORMAT) )
      {
        print_attr( ATTR_START, "channel", extra_info ); 
      }
      else
      {
        if ( (trace_action & LEFTY_INPUT) == 0)
        {
           if ( (trace_action & ACTION_VAR) == 0 )
           {
              print( line_prefix );
              if ( (trace_action & ACTION_DEL) )
                 print( "Delete Queue " );
              else if ( (trace_action & ACTION_ADD) )
                 print( "Add Queue " );
           }
        }
  
        print( "id: ", extra_info,  " " ); 
      }
      
      if ( (trace_action & LEFTY_INPUT) && (trace_action & GRAPH_ATTR_FORMAT) == 0)
      {
         print( "(Q", m_type_carrier->get_type(), ", " );
         print( "len: ", m_items.size(), ")" + EOL );
      }
      else
      {
         if ( (trace_action & GRAPH_ATTR_FORMAT) == 0 )
         {
            print( "(Queue", m_type_carrier->get_type(), ", " );
            print( "max_len: ", ((m_rvz)? 0: m_max_length), ", " );
            print( "len: ", m_items.size(), ")" + EOL );
            print( line_prefix, "{" + EOL );
         }
         
         bool el_created = false;
         
         if ( (trace_action & ATTR_INIT) && (trace_action & EXPAND_QUEUE) && m_items.size() == 0 )
         {
            QueueEl *el = create_el();
            m_items.push_back( el );
            el_created = true;
         }
         
         if ( (trace_action & GRAPH_ATTR_FORMAT) )
           print_attr( "int", "max_size", ((m_rvz)? 0: m_max_length) );
                     
         
         if ( (trace_action & EXPAND_QUEUE) && m_items.size() > 0 )
         {
            for ( int i = 0; i < m_items.size(); i++ )
            {
               if ( (trace_action & GRAPH_ATTR_FORMAT) )
                  print_attr( ATTR_START, "", i );
               
               m_items[i]->trace( trace_action, 0, line_prefix + TAB );
               
               if ( (trace_action & GRAPH_ATTR_FORMAT) )
                  print_attr( ATTR_END );
            }
         }
         
         print_attr( ATTR_END );
         
         if ( el_created )
         {
           delete m_items[ m_items.size() - 1 ];
           m_items.pop_back();
         }
         
         if ( (m_tracing_flags & TRACE_MEM) && (trace_action & GRAPH_ATTR_FORMAT) == 0 )
         {
            long size = sizeof(Queue) + sizeof(*m_type_carrier);

            for (int i = 0; i < m_items.size(); i++ )
               if ( m_items[i] != 0 )
                  size += sizeof(*(m_items[i]));

            size += m_items.size() * sizeof(QueueEl*);

            print( line_prefix + "Queue size: ", size, EOL );
         }
      }
   }
}

void  QueueEl::trace( unsigned long trace_action, long extra_info, const string &line_prefix )
{
   if ( (trace_action & GRAPH_ATTR_FORMAT) && (m_tracing_flags & EXPAND_QUEUE) )
   {
      trace_fld( trace_action, 0, line_prefix );
   }
   else if ( (trace_action & LEFTY_INPUT) == 0 )
   {
      if ( (trace_action & ACTION_FLAGS) != 0  )
      {
         print( line_prefix );

         if ( (trace_action & ACTION_DEL) )
            print( "Delete QueueEl " );
         else if ( (trace_action & ACTION_ADD) )
            print( "Add QueueEl " );
         else if ( (trace_action & ACTION_LOOK) )
            print( "Look QueueEl " );
      
         if ( extra_info < 0 )
            print( "-> not found" + EOL );
         else
         {
            print( "id: ", extra_info,  " " );
            print( "(QueueEl", get_type(), ", " );
            print( "fld_count: ", fld_number(), ")" + EOL );
         }
      }

      if ( (m_tracing_flags & EXPAND_QUEUE) )
      {
         trace_fld( trace_action, 0, line_prefix ); 
      }

      if ( (m_tracing_flags & TRACE_MEM) )
      {
         print( line_prefix + "QueueEl size: ", sizeof( *this ), EOL );
      }
   }
}

/********************************************************************/
/* State:                                     */
/********************************************************************/
unsigned int StateBase::calc_size()
{
  unsigned int size = 0;
  for ( unsigned int i = 0; i < m_autom_list.size(); i++ )
    if ( m_autom_list[i] != 0 )
      size += sizeof( *(m_autom_list[i]) );

  if ( m_ltl != 0 )
    size += sizeof( m_ltl );
      
   size += m_autom_list.size() * sizeof(CAutomBase*);
      
  return size;
}

void StateBase::delete_automs()
{
  int i;
  for ( i = 0; i < m_autom_list.size(); i++ )
    if ( m_autom_list[i] != 0 )
      {
         delete m_autom_list[i];
         m_autom_list[i] = 0;
      }
      
  delete m_ltl;
  m_ltl = 0;
}

bool StateBase::get_enabled_flag(int pid)
{
   CAutomBase *proc = get_proc(pid);

   if (proc != 0)
   {
      for (int pr_trans_id = proc->get_first_trans_id(proc->get_curr_state()); pr_trans_id != 0; pr_trans_id = proc->get_next_trans_id(pr_trans_id)) 
      {
         if (proc->is_trans_enable(dynamic_cast<State*>(this), pr_trans_id)) 
            return true;
      }
   }

   return false;
}

bool StateBase::get_progress_flag()
{
   for (int procnum = 0; procnum < proc_count(); procnum++) 
   {
      CAutomBase *proc = get_proc(procnum);

      if (proc != 0)
      {
         if (proc->is_state_in_progress(proc->get_curr_state()))
            return false;
      }
   }

   return true;
}

int StateBase::get_curr_state(int pid)
{
   CAutomBase *proc = get_proc(pid);

   if (proc != 0)
   {
      return proc->get_curr_state();
   }

   return 0;
}

int StateBase::add_proc( CAutomBase *autom )
{
   int index = 0;

   if ( autom == 0 )
      index = -1;
   else
   {
      m_autom_list.push_back( autom );
      index = m_autom_list.size() - 1;
      autom->set_pid( index );
      autom->m_owner = this;
   }
    
   return index;
}

bool StateBase::del_proc( int a_num )
{
   if ( a_num == m_autom_list.size() - 1 )
   {
      if ( m_autom_list[a_num] != 0 )
      {
         delete m_autom_list[a_num];
         m_autom_list.pop_back();
      }
   }

   return true;
}

void StateBase::clean_proc_list()
{
   for ( int i = m_autom_list.size() - 1; i >= 0; i-- )
   {
      if ( m_autom_list[i] != 0 )
      {
         if ( m_autom_list[i]->get_curr_state() != 0 )
            break;

         if ( !del_proc(i) )
            break;
      }
   }
}

void StateBase::copy_to( StateBase *st )
{
   CAutomBase *a = 0;
   Clonable *t_clone = 0;
   int i;
  
   for ( i = 0; i < m_autom_list.size(); i++ )
   {
      if ( m_autom_list[i] == 0 )
         st->m_autom_list[i] = 0;
      else
      {
         t_clone = m_autom_list[i]->clone();
         a = dynamic_cast<CAutomBase*>(t_clone);
         st->m_autom_list[i] = a;
         a->m_owner = st;
      }
   }
   
   st->m_flags = m_flags;

   if ( m_ltl != 0 )
   {
      t_clone = m_ltl->clone();
      st->m_ltl = dynamic_cast<CAutomBase*>(t_clone);
   }

}

/*
Clonable* StateBase::clone( )
{
   StateBase *the_clone = new StateBase( m_autom_list.size() );
   
   Queue *q = 0;
        
 
   for ( i = 0; i < m_queue_list.size(); i++ )
   {
      if ( m_queue_list[i] == 0 )
         the_clone->m_queue_list[i] = 0;
      else
      {
         t_clone = m_queue_list[i]->clone();
         q = dynamic_cast<Queue*>(t_clone);
         the_clone->m_queue_list[i] = q;
      }
   }
   
   the_clone->m_boq = m_boq;

   
   copy_to( the_clone );

   memcpy( &(the_clone->globals), &globals, sizeof(GlobalVarStruct) );

   the_clone->bit_arr = bit_arr;

   return the_clone;
}
*/

void StateBase::trace( unsigned long trace_action, long extra_info, const string &line_prefix )
{
   if ( (trace_action & GRAPH_ATTR_FORMAT) )
   {
     if ( (trace_action & TRACE_AUTOM) && m_ltl != 0)
        m_ltl->trace( trace_action, -1, line_prefix );
     
/*     if ( (trace_action & TRACE_QUEUE) )
     {
        if ( m_queue_list.size() > 0 )
        {
          print_attr( ATTR_START, "Channels" );
        
          for ( int i = 0; i < m_queue_list.size(); i++ )
          {
             if ( m_queue_list[i] == 0 )
             {
                print_attr( ATTR_START,  "", i );
                print_attr( ATTR_END );
             }
             else
                m_queue_list[i]->trace( trace_action, i, line_prefix );
          }
          print_attr( ATTR_END, "Channels" );
        }
     }
*/     
     if ( (trace_action & TRACE_AUTOM) )
     {
        print_attr( ATTR_START, "Processes" );
       
        for ( int i = 0; i < m_autom_list.size(); i++ )
        {
           if ( m_autom_list[i] != 0 )
              m_autom_list[i]->trace( trace_action, i, line_prefix );
        }
        print_attr( ATTR_END, "Processes" );
     }
     
//     if ( trace_action & TRACE_GL_VAR )
//        trace_vars( trace_action, extra_info, line_prefix );
   }
   else 
   {
     if ( (trace_action & LEFTY_INPUT) == 0 )
     {
        print( line_prefix );
  
        if ( (trace_action & ACTION_CLONE) )
        {
           print( "Clone " );
        }
  
        print( "State:" + EOL );
     }
  
     if ( (trace_action & TRACE_AUTOM) )
     {
        if (m_ltl == 0 )
           print(line_prefix + TAB + "::never:: = 0" + EOL );
        else
           m_ltl->trace( trace_action, -1, line_prefix + TAB );
     }
/*  
     if ( (trace_action & TRACE_QUEUE) )
     {
        if ( (trace_action & LEFTY_INPUT) == 0 )
           print( line_prefix, TAB + "Queues:" + EOL );
        
        for ( int i = 0; i < m_queue_list.size(); i++ )
        {
           if ( m_queue_list[i] == 0 )
           {
              if ( (trace_action & LEFTY_INPUT) == 0 )
                 print( line_prefix + TAB + "  " + "id: ", i + 1, " = (Queue)0" + EOL);
           }
           else
              m_queue_list[i]->trace( trace_action, i + 1, line_prefix + TAB + "  " );
        }
     }
  
     if ( trace_action & TRACE_GL_VAR )
        trace_vars( trace_action, extra_info, line_prefix + TAB );
*/  
     if ( (trace_action & TRACE_AUTOM) )
     {
        if ( (trace_action & LEFTY_INPUT) == 0 )
           print( line_prefix, TAB + "Processes:" + EOL );
        for ( int i = 0; i < m_autom_list.size(); i++ )
        {
           if ( m_autom_list[i] == 0 )
           {
              if ( (trace_action & LEFTY_INPUT) == 0 )
                 print( line_prefix + TAB + "  " + "id: ", i, " = (CAutomBase)0" + EOL);
           }
           else
              m_autom_list[i]->trace( trace_action, i, line_prefix + TAB +"  " );
        }
     }
  
/*     if ( (m_tracing_flags & TRACE_MEM) && ( (trace_action & LEFTY_INPUT) == 0 ) )
     {
        int i;
        long size = sizeof(*this);
  
        size += m_queue_list.size() * sizeof(Queue*);
        for ( i = 0; i < m_queue_list.size(); i++ )
           if ( m_queue_list[i] != 0 )
              size += m_queue_list[i]->calc_size();
  
        size += m_autom_list.size() * sizeof(CAutomBase*);
        for ( i = 0; i < m_autom_list.size(); i++ )
           if ( m_autom_list[i] != 0 )
              size += sizeof( *(m_autom_list[i]) );
  
        if ( m_ltl != 0 )
           size += sizeof( m_ltl );
  
        print( line_prefix + TAB + "State size: ", size, EOL );
     }
*/
   }

}

/********************************************************************/
/* CAutomBase: Automaton routines                                   */
/********************************************************************/

bool CAutomBase::start_table_init( Trans ***table, int ref_count, int len )
{
   /*len is number of automaton states */
   if ( table == 0)
      return false;
    
   if ( ref_count == 0 )
      *table = new Trans*[len];
   
   if ( table == 0 )
      return false;

   if ( ref_count == 0)
   {
      memset( *table, 0, len * sizeof(Trans*) );
   }

   return true;
}

bool CAutomBase::add_transition( 
   Trans ***sst_table, 
   int ref_count, 
   int table_len,
   int t_id, // state id (index in the transition array)
   short atom, // atom falg
   int st, // next state
   int forw, // forward transition
   int backw, // backward transition
   string tp, // src txt of statement (comment)
   int glob, // global flag
   int tpe0, // [0] class of operation (for reduction)
   int tpe1  // [1] class of operation (for reduction)
)
{
   Trans *t = 0;
   
   if ( sst_table == 0 || t_id >= table_len || t_id < 0 )
      return false;

   Trans **table = *sst_table;

   if ( ref_count == 0 )
   {
      t = new Trans;

      if ( t == 0 )
         return false;

      if ( atom & L_ATOM )
         atom |= ATOM;

      t->atom = atom;  
      if ( !glob )
         t->atom |= 8;  /* no global references */

      t->st = st;
      t->t_id = t_id;
      t->this_st = t_id;
      t->tp = tp;
      t->forw = forw;
      t->nxt = 0;
/*
      t->back = backw;
      t->tpe[0] = tpe0;
      t->tpe[1] = tpe1;
*/
      if ( table[t_id] == 0 )
         table[t_id] = t;
      else
      {
         Trans *t_next = table[t_id];
         for ( ; t_next->nxt != 0; t_next = t_next->nxt );

         t_next->nxt = t;
      }

      /*Calc init state (if not present)*/
      if ( m_curr_state == 0 )
         m_curr_state = t_id;
   }

   return true;
}

bool CAutomBase::add_transition( 
               Trans ***sst_table,
               int ref_count,
               int table_len,
               int t_id, // state id (index in the transition array)
               short atom, // atom falg
               int st, // next state
               int forw // forward transition
            )
{
   Trans *t = 0;
   
   if ( sst_table == 0 || t_id >= table_len || t_id < 0 )
      return false;

   Trans **table = *sst_table;

   if ( ref_count == 0 )
   {
      t = new Trans;

      if ( t == 0 )
         return false;

      t->atom = atom;

      t->st = st;
      t->t_id = t_id;
      t->this_st = t_id;
      t->forw = forw;
      t->nxt = 0;

      if ( table[t_id] == 0 )
         table[t_id] = t;
      else
      {
         Trans *t_next = table[t_id];
         for ( ; t_next->nxt != 0; t_next = t_next->nxt );

         t_next->nxt = t;
      }
   }

   return true;
};

bool CAutomBase::add_transition( 
   Trans ***sst_table, 
   int ref_count, 
   int table_len,
   int ind, // index in the transition array 
   string tp // src txt of statement
)
{
   Trans *t = 0;
   
   if ( sst_table == 0 || ind >= table_len || ind < 0 )
      return false;

   Trans **table = *sst_table;

   if ( ref_count == 0 )
   {
      t = new Trans;

      if ( t == 0 )
         return false;

      t->t_id = ind;
      t->this_st = ind;
      t->tp = tp;

      t->atom = 0;
      t->st = 0;
      t->forw = 0;
      t->nxt = 0;

      if ( table[ind] == 0 )
         table[ind] = t;
      else
      {
         Trans *t_next = table[ind];
         for ( ; t_next->nxt != 0; t_next = t_next->nxt );

         t_next->nxt = t;
      }
   }

   return true;
}

void CAutomBase::end_table_init( Trans ***table, bool *accpstate, bool *progstate, int &ref_count, int &table_len, int &init_st ) 
{ 
   Trans **buff = 0;
   if ( table == 0 || *table == 0 )
   {
      table_len = 0;
      ref_count = 0;
   }
   else
   {
      if ( ref_count == 0 )
      {
         /* m_curr_state - calculated init state*/
         init_st = m_curr_state;
         //rebuild_table( table, accpstate, progstate, table_len, init_st );

         buff = *table;
         int state_len = table_len;
         int offset = 0;
         int i = 0;
         Trans *t = 0;
         for ( i = 1; i < state_len; i++ )
         {
            if ( buff[i] != 0 )
               for ( t = buff[i]; t->nxt != 0; t = t->nxt )
                  offset++;
         }

         if ( offset != 0 )
         {
            buff = new Trans*[table_len + offset];

            if ( buff == 0 )
              return;

            memcpy( buff, (*table), table_len * sizeof(Trans*) );
            memset( buff + table_len, 0, offset * sizeof(Trans*) );

            delete[] (*table);

            *table = buff;
            table_len += offset;

            offset = 0;
            for ( i = 1; i < state_len; i++ )
            {
               t = buff[i];
               if ( t != 0 )
                  for ( t = t->nxt; t != 0; t = t->nxt )
                  {
                     buff[ state_len + offset ] = t;
                     t->t_id = state_len + (offset++);
                  }
            }
        }

         Tracer::trace(  TRACE_TABLE | ACTION_ADD, this, 0, "", EOL );
      }

      ref_count++;
      /*init_st - real init state*/
      m_curr_state = init_st;
   }
}

/****************************************************************************************/
Trans::Trans( Trans *a )
{  
   atom      = a->atom;
   st        = a->st;
   this_st   = a->this_st;
/*
  tpe[0] = a->tpe[0];
  tpe[1] = a->tpe[1];
*/
   tp = "";
   tp += a->tp;
   t_id  = a->t_id;
   forw  = a->forw;
   nxt   = 0;
/*
  back  = a->back;
*/
}

void CAutomBase::find_reached( Trans **sst_table, bool *reached, int sst_len, int init_st )
{
   if ( init_st < sst_len && init_st > 0 && sst_table[init_st] != 0 )
      for( Trans *T = sst_table[init_st]; !reached[init_st]; T = sst_table[T->st] )
      {
         reached[init_st] = true;
         find_reached( sst_table, reached, sst_len, T->st );

         for( Trans *T0 = T->nxt; T0 != 0; T0 = T0->nxt )
         {
            find_reached( sst_table, reached, sst_len, T0->st );
         }
      }
}

int calc_max_forward( Trans ** sst_table, int sst_len )
{
   int i, max_forw = 0;
   Trans *T0;
  
   for( i = 0; i < sst_len; i++ )
   {
      T0 = sst_table[i];
      for( ; T0 != 0; T0 = T0->nxt )
        max_forw ++;
   }
   
   return max_forw;
}

void CAutomBase::rebuild_table( Trans *** sst_table, bool *accpstate, bool *progstate, int sst_len, int &init_st )
  /* process n, with m states, is=initial state */
{  
   Trans ** trans = *sst_table;
   Trans *T0, *T1, *T2, *T3;
   int i, j;
   int cnt = calc_max_forward( trans, sst_len );
   bool *reached = new bool[sst_len];
   memset( reached, 0, sizeof(bool) * sst_len );

   bool *forwards_table = new bool[ cnt ];
   memset( forwards_table, 0, cnt * sizeof(bool) );
   
   cout << "max = " << cnt << " ";
   for( i = 0, cnt = 0; i < sst_len; i++ )
   {
      T0 = trans[i];
      for( ; T0 != 0; T0 = T0->nxt )
      {
        if ( !forwards_table[T0->forw] && T0->forw > 2)
        {  
          cnt++;
          forwards_table[T0->forw] = true;
        }
      }
   }
   
   cout << "frwrds = " << cnt << " ";
   delete[] forwards_table;
   
   do 
   {
     for (i = 1, cnt = 0; i < sst_len; i++)
      {  
         T2 = trans[i];
         T1 = T2? T2->nxt: 0;

        //
         for ( T0 = T1; T0; T0 = T0->nxt )
         {  
           //
           if (  T0->st && 
                trans[T0->st] &&  
                trans[T0->st]->nxt
             )
             break;
         }

         if ( T0 )
           for ( T0 = T1; T0; T0 = T0->nxt )
           {  
             T3 = trans[T0->st];

             if ( !T3->nxt )
             {  
                  T2->nxt = new Trans( T0 );
               T2 = T2->nxt;

               imed( accpstate, progstate, T2->st, T0->st );
             }
               else
               {
                do 
                {  
                  T3 = T3->nxt;
               //      if ( T2->nxt != 0 )
               //         delete (Trans*)(T2->nxt);
                  T2->nxt = new Trans( T3 );
                  T2 = T2->nxt;

                  imed( accpstate, progstate, T2->st, T0->st );
                } 
                  while ( T3->nxt );
                cnt++;
               }
           }
    }
  } 
   while ( cnt );

   for (i = 1; i < sst_len; i++)
   {  
      if ( trans[i] != 0 && trans[i]->nxt != 0 ) // optimize 
      {  
         T1 = trans[i]->nxt;
         if ( trans[T1->st] == 0 ) 
            continue;

         T0 = new Trans( trans[T1->st] );

         //delete trans[i];

         trans[i] = T0;
         T0->this_st = i;
         T0->t_id = i;
         
         imed( accpstate, progstate, T0->st, T1->st );

         
         for (T1 = T1->nxt; T1; T1 = T1->nxt)
         {
           if ( trans[T1->st] == 0 ) 
               continue;

            if ( T1->tp == "ATOMIC" ) 
            {
               T0 = T0->nxt;
               continue;
            }

         
           T0->nxt = new Trans( trans[T1->st] );
           T0 = T0->nxt;
            T0->this_st = i;
            T0->t_id = i;
            imed( accpstate, progstate, T0->st, T1->st );
         }
         
      }  
   }

   find_reached( trans, reached, sst_len, init_st );

   /* remove unreached */
   for ( i = 1; i < sst_len; i++ )
   {
      if ( !reached[i] && trans[i] != 0 )
      {
         for ( T0 = trans[i]->nxt; T0 != 0; )
         {
            T1 = T0;
            T0 = T1->nxt;
            delete T0;
         }
         delete trans[i];

         trans[i] = 0;
      }
   }

   /*finish atomic*/
   for ( i = 1; i < sst_len; i++ )
   {
      T0 = trans[i];
      if ( T0 != 0 )
      {
         bool atomic = false;
         for ( T1 = T0; T1 != 0 && !atomic; T1 = T1->nxt )
            atomic = (T1->atom & ATOM) != 0;

         if ( atomic && T0->nxt != 0)
            for ( T1 = T0; T1 != 0; T1 = T1->nxt )
            {
               T1->atom &= ~ATOM;
               T1->atom |= ND_ATOM;
            }
      }
   }


   /* remove skip/goto */
   for ( j = 1; j < sst_len; j++ )
   {
      T0 = trans[j];
      if ( T0 != 0 )
         if ( T0->forw == 1 && 
              T0->nxt == 0 && 
              T0->this_st != T0->st && 
              !(accpstate[T0->this_st]) && 
              !(progstate[T0->this_st])
              )
         {
            for ( i = 1; i < sst_len; i++ )
            {
               if ( trans[i] != 0 && T0->this_st != i )
               {
                  for ( T1 = trans[i]; T1 != 0; T1 = T1->nxt )
                  {
                     if ( T1->st == T0->this_st )
                        T1->st = T0->st;
                  }
               }
            }

            if ( T0->this_st == init_st )
               init_st = T0->st;

            imed( accpstate, progstate, T0->st, T0->this_st );

            trans[j] = 0;
            delete T0;
         }
   }

   delete[] reached; 
   
   cnt = calc_max_forward( trans, sst_len);
   cout << " max = " << cnt;
   forwards_table = new bool[ cnt ];
   memset( forwards_table, 0, cnt );
   
   for( i = 0, cnt = 0; i < sst_len; i++ )
   {
      T0 = trans[i];
      for( ; T0 != 0; T0 = T0->nxt )
      {
        if ( !forwards_table[T0->forw]  && T0->forw > 2 )
        {  
          cnt++;
          forwards_table[T0->forw] = true;
        }
      }
   }
   
   cout << "frwds = " << cnt << "\n";
   delete[] forwards_table;
}

void CAutomBase::trace_table( unsigned long trace_action, Trans *** table, int sst_len, bool *accpstate, bool *progstate, long extra_info, const string &line_prefix )
{
   if ( (trace_action & LEFTY_INPUT) || (trace_action & GRAPH_ATTR_FORMAT) )
      return;

   Trans **trans = *table;
   if ( trace_action & ACTION_DEL )
   {
      print( line_prefix + "Delete Trans Table" ); 
   }
   else if ( trace_action & ACTION_ADD )
   {
      Trans *T0; 
      print( line_prefix + "Add Trans Table" + EOL ); 
         
      /*          <AR> for debugging                     */
      for ( int i = 1; i < sst_len; i++ )
      {
         print( line_prefix + TAB );
         if ( trans[i] == 0 )
            print( "id: ", i, " = (Trans)0" + EOL );
         else
         {
            T0 = trans[i];
            print( "{the_st: ", T0->this_st, "; " );
            //print( "src: ", T0->tp, "; " );
            print( "t_id: ", T0->t_id, "; " );
            print( "st: ", T0->st, "; " );
            print( "atom: ", T0->atom, "; " );
            print( "forw: ", T0->forw, "} ");

            for ( T0 = T0->nxt; T0; T0 = T0->nxt )
            {
               print( "{the_st: ", T0->this_st, "; " );
             //  print( "src: ", T0->tp, "; " );
               print( "t_id: ", T0->t_id, "; " );
               print( "st: ", T0->st, "; " );
               print( "atom: ", T0->atom, "; " );
               print( "forw: ", T0->forw, "} ");
            }
            
            print( EOL );
         
         }
         print( line_prefix + TAB + "accpstate: ", (int)accpstate[i], ", " );
         print( "progstate: ", (int)progstate[i], EOL );
      }
   }

   if ( m_tracing_flags & TRACE_MEM )
   {
      long size = 0;
      Trans *T0;

      for ( int i = 0; i < sst_len; i++ )
      {
         T0 = trans[i];
         size += sizeof(Trans*);
         if ( T0 != 0 )
         {
            size += sizeof(Trans);
            for ( T0 = T0->nxt; T0; T0 = T0->nxt )
               size += sizeof(Trans) + sizeof(Trans*);
         }
      }

      size += sst_len * sizeof(bool);

      print( line_prefix + "Trans Table Size: ", size, EOL );
   }
}
