
#include "drawing.h"

using namespace GraphGraphics;

const Color Color::WHITE( RGB(255, 255, 255) );
const Color Color::RED( RGB(255, 0, 0) );
const Color Color::GREEN( RGB(0, 255, 0) );
const Color Color::BLUE( RGB(0, 0, 255) );
const Color Color::MAGENTA( CMYK(0, 255, 0, 0) );
const Color Color::CYAN( CMYK(255, 0, 0, 0) );
const Color Color::YELLOW( CMYK(0, 0, 255, 0) );
const Color Color::BLACK( RGB(0, 0, 0) );


/*************************************************************/
void GeometryShape::draw_label( GraphicArea* g, const string &label )
{
  TwoDPoint center = get_center();
  FontGeometry *font_geometry = g->get_font_geometry();
  
  OneDValue width = font_geometry->get_string_width( label );
  OneDValue height = font_geometry->get_string_height( label );
  TwoDSize  max_size = get_label_max_size();
  
  if ( width <= max_size.get_width() && height <= max_size.get_height() )
  {    
    g->draw_text( TwoDPoint( center.get_x() - width / 2,
                             center.get_y() - height / 2 ), label );
  }
}

void LineSegment::draw( GraphicArea* g, bool filled )
{
   if ( is_empty() )
      g->draw_point( m_start_point );
   else
      g->draw_line( m_start_point, m_end_point );
}

/*************************************************************/

void Rectangle::draw( GraphicArea* g, bool filled )
{
   if ( is_empty() )
      g->draw_point( m_left_top_point );
   else if ( filled )
   {
      g->draw_filled_rectangle( m_left_top_point.get_x(), m_left_top_point.get_y(), 
                                m_right_bottom_point.get_x(), m_right_bottom_point.get_y() );
   }
   else
   {
      g->draw_hollow_rectangle( m_left_top_point.get_x(), m_left_top_point.get_y(), 
                                m_right_bottom_point.get_x(), m_right_bottom_point.get_y() );
   }
}

/***********************************************************************/

void Circle::draw( GraphicArea* g, bool filled )
{
   if ( is_empty() )
      g->draw_point( m_center );
   else if ( filled )
   {
      g->draw_filled_circle( m_center, m_radius );
   }
   else
   {
      g->draw_hollow_circle( m_center, m_radius );
   }
}

void DoubleCircle::draw( GraphicArea* g, bool filled )
{
   if ( is_empty() )
      g->draw_point( m_center );
   else 
   {
     OneDValue small_radius = m_radius - (m_radius / 5);
     g->draw_hollow_circle( m_center, m_radius );
     if ( filled )
     {
        g->draw_filled_circle( m_center, small_radius );
       
//        g->draw_hollow_circle( m_center, small_radius );
//        g->draw_hollow_circle( m_center, small_radius - 1 );
     }
     else
     {
        g->draw_hollow_circle( m_center, small_radius );
     }
     
   }
}
