
#include <cassert>

#include "ViewProperties.h"
#include "graphics.h"

using namespace GraphGraphics;

const StyleFlags GraphViewPropertyGroup::DEFAULT = (StyleFlags)-1;
StyleFlags GraphViewPropertiesStorage::m_last_group_type = 0;
const StyleFlags GraphViewPropertiesStorage::MIN_USER_MARK_ID = 5;
StyleFlags GraphViewPropertiesStorage::m_last_edge_mark_id = GraphViewPropertiesStorage::MIN_USER_MARK_ID;

GraphViewPropertiesStorage::GraphViewPropertiesStorage( GraphView *view ) 
{ 
  m_view = view; 
  m_backgrnd_color = Color::WHITE;
  m_selected_color = Color::RED;
  m_edge_color     = Color( RGB( 60, 0, 60 ) );
  m_selected_edge_color = Color( RGB( 180, 0, 100 ) );
  m_outgoing_edge_color = Color( RGB( 180, 0, 150 ) );
  m_incoming_edge_color = Color( RGB( 180, 0, 150 ) );
    
   
  m_edge_pen.set_line_width( 1 );
  m_edge_pen.set_line_style( DrawingPen::SOLID );


  m_def_view_properties = new GraphViewPropertyGroup( GraphViewPropertyGroup::DEFAULT, "Default node properties" );
     
  m_def_view_properties->set_color( Color::BLACK );
  m_def_view_properties->set_font( Font( Font::NONE, 12, "" ), Color::RED );
  m_def_view_properties->set_shape_type( GraphViewPropertyGroup::CIRCLE );
  m_def_view_properties->set_shape_filled( false );
  m_def_view_properties->set_pen( DrawingPen( DrawingPen::SOLID, 1) );
  m_def_view_properties->assign_attributes( "{ }" );
  
  EdgeMarkProperties *new_mark = new EdgeMarkProperties( );
  
  new_mark->mark_name = "Selected edges";
  new_mark->mark_color = Color::RED;
  
  m_edge_marking[ EDGE_SELECTED ] = new_mark;
  
  new_mark = new EdgeMarkProperties( );
  
  new_mark->mark_name = "Selected path";
  new_mark->mark_color = Color( RGB( 80, 150, 255) );
  
  m_edge_marking[ EDGE_IN_SCENARIO ] = new_mark;
}

void GraphViewPropertiesStorage::add_node_to_group( NodeIndex node_id, GraphViewPropertyGroup *group )
{
  assert( m_view != 0 );
    
  VNode *node = m_view->m_nodes[node_id];
  ViewGroupList::iterator p = node->node_view_properties.begin();
  if ( p == node->node_view_properties.end() )
    node->node_view_properties.push_back( group );
  else
  {
    for (; p != node->node_view_properties.end(); p++)
    {
      GraphViewPropertyGroup *curr_group = (GraphViewPropertyGroup *)(*p);
      if ( curr_group->get_type() > group->get_type() )
        break;
    }
    node->node_view_properties.insert( p, group );
  }
}

void GraphViewPropertiesStorage::remove_nodes_from_group( StyleFlags view_type )
{
  assert( m_view != 0 );
    
  GraphViewPropertyGroup *group;
  for (unsigned int i = 0; i < m_view->m_nodes.size(); i++ )
  {
    group = 0;
    VNode *node = m_view->m_nodes[i];
    for ( ViewGroupList::iterator p = node->node_view_properties.begin(); p != node->node_view_properties.end(); p++ )
    {
      if ( ((GraphViewPropertyGroup *)(*p))->get_type() == view_type )
      {
        node->node_view_properties.erase( p );
        break;
      }            
    }          
  }             
}

StyleFlags GraphViewPropertiesStorage::add_view_group( const string &attr_string, const GraphViewPropertyGroup &group, bool assign )
{
  assert( m_view != 0 );
  
  StyleFlags group_type = m_last_group_type++;
  GraphViewPropertyGroup *new_group = new GraphViewPropertyGroup( );
  *new_group = group;
  new_group->assign_attributes( attr_string );
  new_group->set_type( group_type );
  
  NodeAttributeList attr_list;
  
  m_view_groups[ group_type ] = new_group;
  
  Graph *graph = m_view->get_app_context()->get_graph();
   
  if ( graph != 0 && m_view->m_nodes.size() > 0 && assign )
  {
    bool is_attr_str = GraphAttributes::parse_string( attr_string, attr_list );
  
    //
    assert( is_attr_str );
    
    if ( is_attr_str )
    {
      for ( NodeIndex id = graph->find_first_node( attr_list ); id != Graph::INVALID_NODE_ID; id = graph->find_next_node( attr_list, id ) )
      {
         add_node_to_group( id, new_group );
      }
    }
  }   
  return group_type;
}

void GraphViewPropertiesStorage::reassign_view_group( StyleFlags type, const string &attr_string )
{
  assert( m_view != 0 );
  
  if ( m_view_groups.find( type ) != m_view_groups.end() && m_view->m_nodes.size() > 0 )
  {
    NodeAttributeList attr_list;
    Graph *graph = m_view->get_app_context()->get_graph();
    GraphViewPropertyGroup *group = m_view_groups[type];
    
    remove_nodes_from_group( type );
    
    group->assign_attributes( attr_string );
    
    bool is_attr_str = GraphAttributes::parse_string( attr_string, attr_list );
  
    if ( is_attr_str )
    {
      for ( NodeIndex id = graph->find_first_node( attr_list ); id != Graph::INVALID_NODE_ID; id = graph->find_next_node( attr_list, id ) )
      {
        add_node_to_group( id, group );
      }
    }
  }
}
/*
void GraphViewPropertiesStorage::set_reserved_edge_color( int reserved_mark_index, const Color &color) 
{ 
  if (reserved_mark_index >= GraphView::EDGE_RESERVED1 && reserved_mark_index <= GraphView::EDGE_RESERVED3)
    m_reserved_colors[reserved_mark_index] = color; 
}
Color& GraphViewPropertiesStorage::get_reserved_edge_color( int reserved_mark_index ) 
{ 
  if (reserved_mark_index >= GraphView::EDGE_RESERVED1 && reserved_mark_index <= GraphView::EDGE_RESERVED3)
    return m_reserved_colors[reserved_mark_index]; 
  else
    return m_edge_color;
}
*/

void GraphViewPropertiesStorage::remove_edge_mark( StyleFlags mark_id )
{
  if ( mark_id >= MIN_USER_MARK_ID )
    if ( m_edge_marking.find( mark_id ) != m_edge_marking.end() )
    {
      m_view->remark_edges( mark_id, 0, EDGE_UNMARKED );
      delete (EdgeMarkProperties*)(m_edge_marking[ mark_id ]);
      m_edge_marking.erase( mark_id );
    }
}
  
void GraphViewPropertiesStorage::remove_all_edge_marks()
{
  for ( EdgeMarkMap::iterator p = m_edge_marking.begin(); p != m_edge_marking.end(); p++ )
  {
    m_view->mark_all_edges( 0, EDGE_UNMARKED );
    
    delete ((EdgeMarkProperties*)(p->second));
  }
  m_edge_marking.clear();
}
