#include <unistd.h>
#include <dirent.h>
#include <fcntl.h>
#include <fstream>
#include "ScenarioApp.h"
#include "storable.h"

using namespace GraphGraphics;
ComponentIndex ComponentManager::INVALID_COMP_ID = -1;

void ScenarioApp::initialize_globals() 
{ 
  GraphGUI::initialize_globals();
}

ScenarioApp::ScenarioApp( void *os_data )
{
  char      *home_path = getenv("HOME");
  char       pref_path[255];
  char  pref_dir_path[255];
  int   fd;
  DIR   *dd;
  
  m_extra_modes = 0;
      
  memset( pref_path, 0, sizeof(pref_path) );
  
  //make preference dir.
  if (home_path != 0)
  {
    sprintf(pref_dir_path, "%s/.sgraph", home_path);    
    sprintf(pref_path, "%s/.sgraph/preferences", home_path);
    
    if ((dd = opendir(pref_dir_path)) == 0)
    {
      if (mkdir(pref_dir_path, S_IRWXU|S_IRWXG|S_IRWXO) == -1)
        perror("opendir");
    }
    else
      closedir(dd);
    
    if ((fd = open(pref_path, O_RDONLY, 0)) == -1)
    {
      if ((fd = open(pref_path, O_WRONLY|O_CREAT, S_IRUSR|S_IWUSR)) == -1)
        perror("openfile");
      else
      {
        unsigned char layout = GraphView::FIT_TO_WINDOW;
        write(fd, &layout, 1);
        write(fd, &layout, 1);
        close(fd);
      }
    }
    else
      close(fd);
  }
  
  m_main_context = new GraphViewContext();
  m_main_context->set_graph( new Graph() );
  m_main_context->set_view( new GraphView( m_main_context ) );
  
  DefaultStatusInfo *status_info = new DefaultStatusInfo(m_main_context);
  m_main_context->get_status_mngr()->status_registration(status_info); 
  string default_status = status_info->get_status_name();       
  m_main_context->get_status_mngr()->set_current_status(default_status); 
    
  HelpStatusInfo *help_info = new HelpStatusInfo(m_main_context);
  m_main_context->get_status_mngr()->status_registration(help_info); 
  
  m_gui = new GraphGUI( this, os_data );
  m_e_handler = new ScenarioEventHandler( m_main_context, m_gui, m_components );
  
  //read preferences
  memset( pref_path, 0, sizeof(pref_path) );
  sprintf(pref_path, "%s/.sgraph/preferences", home_path);
    
  ifstream in_stream( (const char*)pref_path );
    
  if ( in_stream.is_open() )
  {
    unsigned char layout;
    long  modes;
    
    layout = in_stream.get( );
    
    m_main_context->get_view()->set_layout( layout );
    
    in_stream.seekg( BEHAVIOR_MODES );
    
    if ( Storable::read_4bytes( in_stream, modes ) )
      m_e_handler->m_modes = modes;
    
    in_stream.seekg( EXTRA_BEHAVIOR_MODES );
    
    if ( Storable::read_4bytes( in_stream, modes ) )
      m_extra_modes = modes;
    
    in_stream.close();
  }
}

ScenarioApp::~ScenarioApp() 
{
  delete m_gui;
  delete m_main_context;
  delete m_e_handler;
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
  {
    (*p)->on_destroy();
    delete *p;
  }
  
  m_components.clear();

}


ComponentIndex ScenarioApp::register_component( CompInterface *comp ) 
{ 
  ComponentIndex res = INVALID_COMP_ID;
  if ( comp->on_register( m_main_context, m_gui ) )
  {
    char      *home_path = getenv("HOME");
    char      pref_path[255];
    string    comp_name;
    
    res = m_components.size();
    m_components.push_back( comp );
    
    comp_name = comp->get_component_name();
    
    sprintf(pref_path, "%s/.sgraph/preferences", home_path);
  
    ifstream   in_stream( (const char*)pref_path );
  
    if ( in_stream.is_open() )
    {
      short     len = 0;
      in_stream.seekg( ACTIVE_COMP_OFF );
      
      res = Storable::read_2bytes( in_stream, len );
    
      if ( len != 0 && res )
      {
        unsigned short pos = 0;
        char           name_len = 0;
        char           buff[256];
            
        while ( pos < (unsigned short)len && res )
        {
          res = Storable::read_1bytes( in_stream, name_len );
          
          if ( res )
          {
            buff[(unsigned char)name_len] = 0;
            res = Storable::read_bytes( in_stream, buff, name_len );
            
            if ( res && comp_name == string( buff ) )
            {
              comp->set_component_active( true );
              break;
            }
          }
          pos += 1 + name_len;
        }
        
        if ( pos >= (unsigned short)len || !res )
          comp->set_component_active( false );
      }
      in_stream.close();
    }
  }
    
  return res;
}
