#include "graphics.h"
#include "Layout.h"

using namespace GraphGraphics;

void GraphLayout::set_ycoords()
{
	NodeIndex 	i, j;
	int			last = m_radius;
	
	for (i = minrank; i <= maxrank; i++) 
	{
		for (j = 0; j < (long)m_ranks[i]->v.size(); j++) 
			m_ranks[i]->v[j]->center.set_y(last);
		
		last += 2 * m_radius + m_y_separation;		
	}
	
/*DEbug
	FILE	*f = fopen("/home/RL/gr_dbg_rank", "w");
	for (int ind_r = minrank; ind_r <= maxrank; ind_r++)
	{
		fprintf(f, "rank %i: \n", ind_r);
		for (j = 0; j < m_ranks[ind_r]->v.size(); j++) 
			fprintf(f, "(%i, %i), ", m_ranks[ind_r]->v[j]->center.get_y(), m_ranks[ind_r]->v[j]->index);
		
		fprintf(f, "\n");
	}
	
	fprintf(f, "\nNodes:\n");		
  	for ( i = 0; i < m_nodes.size(); i++ )
  	{
    	VNode *vnode = m_nodes[i];
		fprintf(f, "(%i, %i), ", vnode->center.get_y(), vnode->index);
	}

	fprintf(f, "\nEdges:\n");	
	for ( i = 0; i < m_edges.size(); i++ )
  	{	
    	VEdge *e = m_edges[i];
		fprintf(f, "(%i, %i), ", m_nodes[e->tail_indx]->index, m_nodes[e->head_indx]->index);
	}
	
	fclose(f);
End debug*/
	
}

void GraphLayout::allocate_aux_edges()
{
	NodeIndex	i;
	VNode		*n;

	for (i = 0; i < (long)m_nodes.size(); i++)
	{
		n = m_nodes[i];
		
	  n->save_in_edges.insert(n->save_in_edges.begin(), n->in_edges.begin(), n->in_edges.end());
	  n->save_out_edges.insert(n->save_out_edges.begin(), n->out_edges.begin(), n->out_edges.end());		

		n->in_edges.clear();
		n->in_edges.resize(0);
		n->out_edges.clear();
		n->out_edges.resize(0);
	}
	
	m_edges_tmp.resize(0);
	m_nodes_tmp.resize(0);
	m_nodes_tmp.insert(m_nodes_tmp.begin(), m_nodes.begin(), m_nodes.end());	
}

void	GraphLayout::make_aux_edge(OneDValue u_indx, OneDValue v_indx, int len, int wt)
{
	VEdge	*e;

	e = new VEdge;
	e->tail_indx = u_indx;
	e->head_indx = v_indx;
	e->minlen = len;
	e->weight = wt;
	m_edges_tmp.push_back(e);
	
	m_nodes[u_indx]->out_edges.push_back(e);
	m_nodes[v_indx]->in_edges.push_back(e);
}
 
void GraphLayout::make_LR_constraints()
{
	NodeIndex	i,j;
	int			width;
	VNode		*u,*v;

	/* make edges to constrain left-to-right ordering */
	for (i = minrank; i <= maxrank; i++) 
	{
		int		last;
		last = m_ranks[i]->v[0]->rank = m_radius;
		for (j = 0; j < m_ranks[i]->n; j++) 
		{
			u = m_ranks[i]->v[j];
			
			if (j+1 < (long)m_ranks[i]->v.size())
			{
				v = m_ranks[i]->v[j+1];

				width = 2 * m_radius + m_x_separation;
				
// For virtual nodes we use smaller width because they are not drawn          
				if (v->node_type == VIRTUAL)
				{
					if (m_ranks[i]->v[j]->node_type == NORMAL)
						width -= m_radius;
					else 
						width /=3;
				}
				else if (v->node_type == NORMAL && m_ranks[i]->v[j]->node_type == VIRTUAL)
					width -= m_radius;
				
				make_aux_edge(u->index, v->index, width, 0);
				last = (v->rank = last + width);
			}
		}
	}
}

/* make_edge_pairs: make virtual edge pairs corresponding to input edges */
void GraphLayout::make_edge_pairs()
{
	NodeIndex	i; 
	int			ind;
	VNode		*n,*sn;
	VEdge		*e;
	EdgeListIter	e_iter;			

	for (i = 0; i < (long)m_nodes.size(); i++)
	{
		n = m_nodes[i];
		
		e_iter = n->save_out_edges.begin();			
		while (e_iter != n->save_out_edges.end())
		{
			e = *e_iter;
			
			if (e->edge_type != SELFEDGE)
			{
				ind = new_virtual_node();
				sn = m_nodes[ind];
				sn->node_type = SLACKNODE;

				make_aux_edge(sn->index, e->tail_indx, 0, e->weight);
				make_aux_edge(sn->index, e->head_indx, 0, e->weight);
				sn->rank = GGMIN(m_nodes[e->tail_indx]->rank-1, m_nodes[e->head_indx]->rank-1);
			}
			
			e_iter++;
		}
	}
}

void GraphLayout::set_xcoords()
{
	int		i,j;
	VNode	*v;

	for (i = minrank;  i <= maxrank; i++) 
	{
		for (j = 0; j < m_ranks[i]->n; j++) 
		{
			v = m_ranks[i]->v[j];
			v->center.set_x(v->rank + m_radius);
			v->rank = i;
		}
	}
	
/*DEbug
	FILE	*f = fopen("/home/RL/x_y_info", "a");
	for (int ind_r = minrank; ind_r <= maxrank; ind_r++)
	{
		fprintf(f, "rank %i: \n", ind_r);
		for (j = 0; j < m_ranks[ind_r]->v.size(); j++) 
			fprintf(f, "(%i, %i):%i ", m_ranks[ind_r]->v[j]->center.get_y(), m_ranks[ind_r]->v[j]->center.get_x(), m_ranks[ind_r]->v[j]->index);
		
		fprintf(f, "\n");
	}
	
  	for ( i = 0; i < m_nodes.size(); i++ )
  	{
    VNode *vnode = m_nodes[i];
		fprintf(f, "(%i, %i):%i , ", vnode->center.get_y(), vnode->center.get_x(), vnode->index);
	}
	fclose(f);
End debug*/
	
}

void GraphLayout::remove_aux_edges()
{
	NodeIndex		i;
	VNode			*n;
	
	for (i = 0; i < (NodeIndex)m_nodes.size(); i++)
    if (m_nodes[i]->node_type == SLACKNODE)
		  delete m_nodes[i];

	m_nodes.clear();
	m_nodes.resize(0);
	m_nodes.insert(m_nodes.begin(), m_nodes_tmp.begin(), m_nodes_tmp.end());	
	m_nodes_tmp.clear();
	m_nodes_tmp.resize(0);

	for (i = 0; i < (NodeIndex)m_edges_tmp.size(); i++)
		delete m_edges_tmp[i];

	m_edges_tmp.clear();
	m_edges_tmp.resize(0);
	
	for (i = 0; i < (long)m_nodes.size(); i++) 
	{
		n = m_nodes[i];
		
		n->out_edges.clear();
		n->out_edges.resize(0);
		n->in_edges.clear();
		n->in_edges.resize(0);		

	  	n->in_edges.insert(n->in_edges.begin(), n->save_in_edges.begin(), n->save_in_edges.end());
	  	n->out_edges.insert(n->out_edges.begin(), n->save_out_edges.begin(), n->save_out_edges.end());		

		n->save_out_edges.clear();
		n->save_out_edges.resize(0);
		n->save_in_edges.clear();		
		n->save_in_edges.resize(0);		
	}
}

void GraphLayout::position()
{
	set_ycoords();
	allocate_aux_edges();
	make_LR_constraints();
	make_edge_pairs();
	rank_connected_comps(2, INT_MAX);
	set_xcoords();
	remove_aux_edges();
}
