#include "graphics.h"
#include <iostream>
#include "Layout.h"
#include "limits.h"
#include <stdlib.h>
#include <algorithm>

int ordercmpf(const void *i0, const void *i1)
{
	return (*(int*)i0) - (*(int*)i1);
};

using namespace GraphGraphics;

bool GraphLayout::medians(int r0, int r1)
{
	int						i, j/*, lm, rm, lspan, rspan*/;
	int						*list;
	VNode					*n;
	VNodeVector&	v = m_ranks[r0]->v;
	VEdge					*e;
	bool					hasfixed = false;
	EdgeListIter	e_iter;		

	list = TI_list;
	
	for (i = 0; i < m_ranks[r0]->n; i++) 
	{ 
		n = v[i];
		
		if (r1 > r0)
		{
			e_iter = n->out_edges.begin();	j = 0;	
			while (e_iter != n->out_edges.end()) 			
			{
				e = *e_iter;
				list[j] = MC_SCALE * m_nodes[e->head_indx]->order;
				e_iter++;	j++;
			}
		}
		else 
		{
			e_iter = n->in_edges.begin();	j = 0;					
			while (e_iter != n->in_edges.end()) 			
			{
				e = *e_iter;				
				list[j] = MC_SCALE * m_nodes[e->tail_indx]->order;				
				e_iter++;	j++;
			}
		}
			
		switch(j) {
			case 0:
				n->mval = -1;
				break;
			case 1:
				n->mval = list[0];
				break;
			case 2:
				n->mval = (list[0] + list[1])/2;
				break;
			default:
				qsort(list, j, sizeof(int), (qsort_cmpf)ordercmpf);
/*				if (j % 2) */
					n->mval = list[j/2];
/*				else {

					rm = j/2;
					lm = rm - 1;
					rspan = list[j-1] - list[rm];
					lspan = list[lm] - list[0];
					if (lspan == rspan)
						n->u.mval = (list[lm] + list[rm])/2;
					else {
						int w = list[lm]*rspan + list[rm]*lspan;
						n->u.mval = w / (lspan + rspan);
					}
				}*/
		}
	}
	
//RL!! Must be implemented later	
/*	for (i = 0; i < g->u.rank[r0].n; i++) {
		n = v[i];
		if ((n->u.out.size == 0) && (n->u.in.size == 0))
			hasfixed |= flat_mval(n);
	}*/
	return hasfixed;
}

void GraphLayout::mincross_step(int pass)
{
	int		r,other,first,last,dir;
	bool	hasfixed;
	bool	reverse;

	if ((pass % 4) < 2) 
		reverse = true; 
	else 
		reverse = false;
	
	if (pass % 2)		 /* up pass */
	{ 
		r = maxrank - 1; 
		dir = -1; 
	}
	else				/* down pass */
	{ 
		r = 1; 
		dir = 1; 
	}

	if (pass % 2 == 0) 		/* down pass */
	{
		first = minrank + 1;
/*RL!!		if (minrank > Root->u.minrank) first--;*/
		last = maxrank;
		dir = 1;
	}
	else 						/* up pass */
	{
		first = maxrank - 1;
		last = minrank;
/*RL!!		if (g->u.maxrank < Root->u.maxrank) first++;*/
		dir = -1;
	}

	for (r = first; r != last + dir; r += dir) {
		other = r - dir;
		hasfixed = medians(r,other);
		reorder(r,reverse,hasfixed);
	}
/*RL!!	transpose(g,NOT(reverse));*/
}

void GraphLayout::reorder(int r, bool reverse, bool hasfixed)
{
	bool					changed = false;
	int						nelt;
	bool					muststay;
	VNodeVector&	vlist = m_ranks[r]->v;
/*	node_t	**lp,**rp,**ep = vlist + g->u.rank[r].n;*/
	int 					ind1, ind2;
	int						rank_size = m_ranks[r]->n;

	for (nelt = rank_size - 1; nelt >= 0; nelt--) 
	{
		ind1 = 0; 
		while (ind1 < rank_size) 
		{
			/* find leftmost node that can be compared */
			while ((ind1 < rank_size) && (vlist[ind1]->mval < 0)) 
				ind1++;
			
			if (ind1 >= rank_size) 
				break;
			
			/* find the node that can be compared */
			muststay = false;
			for (ind2 = ind1 + 1; ind2 < rank_size; ind2++) 
			{
//RL!!				if (left2right(g,*lp,*rp)) { muststay = TRUE; break; }
				if (vlist[ind2]->mval >= 0) 
					break;
			}
			if (ind2 >= rank_size) 
				break;
			
			if (muststay == false) 
			{
				register int	p1 = (vlist[ind1]->mval);
				register int	p2 = (vlist[ind2]->mval);
				
				if ((p1 > p2)/* || ((p1 == p2) && reverse)*/) 
				{
					exchange(vlist[ind1], vlist[ind2]);
					changed = true;
				}
			}
			ind1 = ind2;
		}
		
		if ((hasfixed == false) && (reverse == false)) 
			rank_size--;
	}

	if (changed) 
	{
		m_ranks[r]->valid = false;
		if (r > 0) 
			m_ranks[r-1]->valid = false;
	}
}

void GraphLayout::exchange(VNode *v, VNode *w)
{
	int		vi,wi,r;
		
	r = v->rank;
	vi = v->order;
	wi = w->order;
	v->order = wi;
	m_ranks[r]->v[wi] = v;
	w->order = vi;
	m_ranks[r]->v[vi] = w;
	
//Debug
/*	FILE	*f = fopen("/home/RL/gr_dbg_exch", "a");
	fprintf(f, "(v->order = %i, w->order = %i, v->rank = %i, w->rank = %i)\n", v->order, w->order, v->rank, w->rank); 
	fclose(f);*/
//End Debug
}

/*RL!! int local_cross(elist l, int dir)
{
	int		i,j,is_out;
	int		cross = 0;
	edge_t	*e,*f;
	if (dir > 0) is_out = TRUE; else is_out = FALSE;
	for (i = 0; (e = l.list[i]); i++) {
		if (is_out) for (j = i+1; (f = l.list[j]); j++)  {
			if ((f->head->u.order - e->head->u.order) * (f->u.tail_port.p.x - e->u.tail_port.p.x) < 0)
					cross += e->u.xpenalty * f->u.xpenalty;
		}
		else for (j = i+1; (f = l.list[j]); j++)  {
			if ((f->tail->u.order - e->tail->u.order) * (f->u.head_port.p.x - e->u.head_port.p.x) < 0)
					cross += e->u.xpenalty * f->u.xpenalty;
		}
	}
	return cross;
}*/

//TODO: Don't forget to initialize max_ranks_nodes and Count properly!!
int GraphLayout::rcross(int r)
{
/* 	static int *Count,C;*/
	int		top, cross, max, k;
/*	VNode	*v;*/
	VNodeVector&	rtop = m_ranks[r]->v;	
	EdgeListIter	e_iter;	

	cross = 0;
	max = 0;

/*	if (C <= Root->u.rank[r+1].n) {
		C = Root->u.rank[r+1].n + 1;
		Count = ALLOC(C,Count,int);
	}*/

	memset(Count, 0, max_ranks_nodes * sizeof(int));
/*	for (i = 0; i < g->u.rank[r+1].n; i++) Count[i] = 0;*/

	for (top = 0; top < m_ranks[r]->n; top++) 
	{
		register VEdge	*e;
		
		if (max > 0) 
		{
			e_iter = rtop[top]->out_edges.begin();			
			while (e_iter != rtop[top]->out_edges.end()) 			
			{
				e = *e_iter;
				for (k = m_nodes[e->head_indx]->order + 1; k <= max; k++)
					cross += Count[k] * e->multiply_edges_count;
				
				e_iter++;
			}
		}
		
		e_iter = rtop[top]->out_edges.begin();					
		while (e_iter != rtop[top]->out_edges.end()) 					
		{
			e = *e_iter;			
			register int	inv = m_nodes[e->head_indx]->order;
			if (inv > max) 
				max = inv;
			Count[inv] += e->multiply_edges_count;
			
			e_iter++;			
		}
	}
	
/*RL!!	for (top = 0; top < g->u.rank[r].n; top++) {
		v = g->u.rank[r].v[top];
		if (v->u.has_port) cross += local_cross(v->u.out,1);
	}
	for (bot = 0; bot < g->u.rank[r+1].n; bot++) {
		v = g->u.rank[r+1].v[bot];
		if (v->u.has_port) cross += local_cross(v->u.in,-1);
	}*/
	
	return cross;
}

int GraphLayout::ncross()
{
	int		r, count, nc;

	count = 0;
	for (r = minrank; r < maxrank; r++) {
		if (m_ranks[r]->valid) 
			count += m_ranks[r]->cache_nc;
		else
		{
			nc = m_ranks[r]->cache_nc = rcross(r);
			count += nc;
			m_ranks[r]->valid = true;
		}
	}
	
	return count;
}

int GraphLayout::mincross(int startpass, int endpass)
{
	int		maxthispass,iter,trying,pass;
	int		cur_cross,best_cross;

	if (startpass > 1) 
	{
		cur_cross = best_cross = ncross();
		save_best();
	}
	
	else 
		cur_cross = best_cross = INT_MAX;
	
	for (pass = startpass; pass <= endpass; pass++) 
	{
		if (pass <= 1) 
		{
			maxthispass = GGMIN(4,MaxIter);
			
			build_ranks(pass);
			
			max_ranks_nodes = 0;
			
			for (int i = minrank; i <= maxrank; i++)
				max_ranks_nodes = GGMAX(max_ranks_nodes, m_ranks[i]->n);
			
			if (Count != 0)
        delete[] Count;
      
      Count = new int[max_ranks_nodes];
			
			if ((cur_cross = ncross()) <= best_cross) 
			{
				save_best();
				best_cross = cur_cross;
			}
			trying = 0;
		}
		else 
		{
			maxthispass = MaxIter;
			if (cur_cross > best_cross) 
				restore_best();
			cur_cross = best_cross;
		}
		
		trying = 0;
		
		for (iter = 0; iter < maxthispass; iter++) 
		{
			if (trying++ >= MinQuit) 
				break;
			
			if (cur_cross == 0) 
				break;
			
			mincross_step(iter);
			
			if ((cur_cross = ncross()) <= best_cross) 
			{
				save_best();
				if (cur_cross < Convergence*best_cross) 
					trying = 0;
				best_cross = cur_cross;
			}
		}
		if (cur_cross == 0) 
			break;
	}
	
	if (cur_cross > best_cross) 
		restore_best();
	
	return best_cross;
}


/* install a node at the current right end of its rank */
void GraphLayout::install_in_rank(VNode* n)
{
	int		i,r;

	r = n->rank;
	i = m_ranks[r]->n;
	
	m_ranks[r]->v.push_back(n);
	n->order = i;
	m_ranks[r]->n++;
}

/*	install nodes in ranks. the initial ordering ensure that series-parallel
 *	graphs such as trees are drawn with no crossings.  it tries searching
 *	in- and out-edges and takes the better of the two initial orderings.
 */
void GraphLayout::build_ranks(int pass)
{
	NodeIndex		i;
	VNode	*n,*n0;
	VNodeQueue	q;
	VRank	*r;
	
	for (i = 0; i < (long)m_nodes.size(); i++) 
		m_nodes[i]->mark = false;

	for (i = minrank; i <= maxrank; i++) 
	{
		if (m_ranks[i] != 0)
			delete m_ranks[i];

		r = new VRank;
		r->n = 0;
		r->valid = false;
		m_ranks[i] = r;
	}

	for (i = 0; i < (long)m_nodes.size(); i++) 	
	{
		n = m_nodes[i];
		VEdgeList& otheredges = ((pass == 0) ? n->in_edges : n->out_edges);
		
		if (!(otheredges.empty())) 
			continue;
		
		if (n->mark == false) 
		{
			n->mark = true;
			q.push_back(n);
			while (!(q.empty())) 
			{
				n0 = q.front();
				q.pop_front();
				install_in_rank(n0);
				enqueue_neighbors(q,n0,pass);
			}
		}
	}
	
/*RL!!	if (dequeue(q)) fprintf(stderr,"surprise\n");*/
	
/*	for (i = g->u.minrank; i <= g->u.maxrank; i++) 
	{
		m_ranks[i]->valid = false;
		if (g->u.left_to_right && (g->u.rank[i].n > 0)) {
			int		n,ndiv2;
			node_t	**vlist = g->u.rank[i].v;
			n = g->u.rank[i].n - 1;  ndiv2 = n / 2;
			for (j = 0; j <= ndiv2; j++)
				exchange(vlist[j],vlist[n - j]);
		}
	}

	if ((g == g->root) && ncross(g) > 0) transpose(g,FALSE);
	free_queue(q);*/

	
	
/*Debug	
	FILE	*f = fopen("/home/RL/gr_dbg2", "w");	
	VEdge	*e;
	EdgeListIter	e_iter;		
	
	fprintf(f, "\n\n\n");
	
	for (int i = minrank; i <= maxrank; i++)
	{
		fprintf(f, "rank %i:\n", i);*/
/*		for (int k = 0; k < m_ranks[i]->v.size(); k++)
		{
			n = m_ranks[i]->v[k];
		
			fprintf(f, "%i in = ", n->index);
			e_iter = n->in_edges.begin();
			while (e_iter != n->in_edges.end())
			{
				e = *e_iter;
				fprintf(f, "(%i, %i); ", e->tail_indx, e->head_indx);			
				e_iter++;
			}
		
			fprintf(f, "\nout = ", n->index);		
			e_iter = n->out_edges.begin();
			while (e_iter != n->out_edges.end())
			{
				e = *e_iter;
				fprintf(f, "(%i, %i); ", e->tail_indx, e->head_indx);			
				e_iter++;			
			}
*/
/*		fprintf(f, "rank %i: \n", i);
		for (int j = 0; j < m_ranks[i]->v.size(); j++) 
			fprintf(f, "(%i, %i), ", m_ranks[i]->v[j]->order, m_ranks[i]->v[j]->index);
		

			fprintf(f, "\n");		*/
/*		}*/
/*		
		fprintf(f, "\n");		
	}
	
	fclose(f);
 End debug*/


}

void GraphLayout::enqueue_neighbors(VNodeQueue& q, VNode* n0, int pass)
{
	VEdge	*e;
	EdgeListIter	e_iter;		
	
	if (pass == 0) 
	{
		e_iter = n0->out_edges.begin();		
		while (e_iter != n0->out_edges.end())		
		{
			e = *e_iter;
			if (m_nodes[e->head_indx]->mark == false) 
			{
				m_nodes[e->head_indx]->mark = true;
				q.push_back(m_nodes[e->head_indx]);
			}
			e_iter++;			
		}
	}
	else 
	{
		e_iter = n0->in_edges.begin();				
		while (e_iter != n0->in_edges.end())			
		{
			e = *e_iter;			
			if (m_nodes[e->tail_indx]->mark == false) 
			{
				m_nodes[e->tail_indx]->mark = true;
				q.push_back(m_nodes[e->tail_indx]);
			}
			e_iter++;						
		}
	}
}

void GraphLayout::restore_best()
{
	int		r;
	
	for (NodeIndex i = 0; i < (long)m_nodes.size(); i++) 
		m_nodes[i]->order = m_nodes[i]->center.get_x();
		
	
	for (r = minrank; r <= maxrank; r++) 
	{
		m_ranks[r]->valid = false;
 		sort(m_ranks[r]->v.begin(), m_ranks[r]->v.end(), VNode_less());
	}
}
 
void GraphLayout::save_best()
{
	for (NodeIndex i = 0; i < (long)m_nodes.size(); i++) 
		m_nodes[i]->center.set_x(m_nodes[i]->order);
}

void GraphLayout::init_mincross()
{
	VEdge		*e;
	NodeIndex	i;
	int			init_size;
	
	MinQuit = 8;
	MaxIter = 24;
	Convergence = .995;

	minrank = INT_MAX;
	maxrank = 0;
	
	for (i = 0; i < (long)m_nodes.size(); i++)
	{
		minrank = GGMIN(minrank, m_nodes[i]->rank);
		maxrank = GGMAX(maxrank, m_nodes[i]->rank);		
	}
	
	m_ranks.resize(maxrank - minrank + 1);

	for (i = minrank; i <= maxrank; i++) 
		m_ranks[i] = 0;
	
	TI_list = new int[m_nodes.size()];

	for (i = 0; i < (long)m_nodes.size(); i++)
		m_nodes[i]->node_type = NORMAL;

	init_size = m_edges.size();
	
	for (i = 0; i < init_size; i++)
	{
		e = m_edges[i];
		
				/* forward edges */
		if (m_nodes[e->head_indx]->rank > m_nodes[e->tail_indx]->rank + 1) 
		{
			make_chain(e->tail_indx, e->head_indx, e->inverse_edge);
			m_nodes[e->tail_indx]->out_edges.remove(e);
			m_nodes[e->head_indx]->in_edges.remove(e);			
		}
		else if (m_nodes[e->tail_indx]->rank > m_nodes[e->head_indx]->rank + 1)
		{
			make_chain(e->head_indx, e->tail_indx, e->inverse_edge);
			m_nodes[e->head_indx]->out_edges.remove(e);			
			m_nodes[e->tail_indx]->in_edges.remove(e);						
		}
	}
}

NodeIndex GraphLayout::new_virtual_node()
{
	VNode		*n;

	n = new VNode;
	n->selfedges_count = 0;
	n->node_type = VIRTUAL;
	m_nodes.push_back(n);
	n->index = m_nodes.size() - 1;
	n->selected = false;
	return m_nodes.size() - 1;
}

VEdge* GraphLayout::new_virtual_edge(NodeIndex u_indx, NodeIndex v_indx)
{
	VEdge		*e;

	e = new VEdge;
	memset(e, 0, sizeof(VEdge));
	e->tail_indx = u_indx;
	e->head_indx = v_indx;
	e->edge_type = VIRTUAL;

	e->weight = 1;
	e->multiply_edges_count = 1;
	e->minlen = 1;
	
	e->inverse_edge = false;	
	
	m_edges.push_back(e);
	
	return e;
}
 
void GraphLayout::make_chain(NodeIndex from_indx, NodeIndex to_indx, bool inverse_edge)
{
	int			r;
	NodeIndex	v_indx = 0;
	VNode		*v_from, *v_to;
	VEdge		*e;
	NodeIndex	curr_from_indx = from_indx;

	v_from = m_nodes[from_indx];
	v_to = m_nodes[to_indx];
	
	for (r = v_from->rank + 1; r <= v_to->rank; r++) 
	{
		if (r < v_to->rank) 
		{
			v_indx = new_virtual_node();
			m_nodes[v_indx]->rank = r;
			m_nodes[v_indx]->center.set_y(r);
			
			e = new_virtual_edge(curr_from_indx, v_indx);
			
			e->real_head_indx = to_indx;
			e->real_tail_indx = from_indx;			
			
			e->inverse_edge = inverse_edge;	
			m_nodes[curr_from_indx]->out_edges.push_back(e);			
			m_nodes[v_indx]->in_edges.push_back(e);
			
			curr_from_indx = v_indx;
		}
		else
		{
			e = new_virtual_edge(v_indx, to_indx);
			
			e->real_head_indx = to_indx;
			e->real_tail_indx = from_indx;			
			
			e->inverse_edge = inverse_edge;				
			m_nodes[curr_from_indx]->out_edges.push_back(e);						
			m_nodes[to_indx]->in_edges.push_back(e);			
		}
	}
}

