
#include "graphics.h"
#include "Layout.h"

using namespace GraphGraphics;

void GraphView::draw_graph_node( GraphicArea *g, VNode *node, bool unselect )
{
  if ( node->node_type != NORMAL )
    return;
    
  TwoDPoint              node_center = transform_point( node->center );
  OneDValue              radius = transform_range( m_radius );
   
  GraphViewPropertyGroup group  = node->get_node_properties( );
		 
  GeometryShape *shape          = group.get_node_shape( node_center, radius );
  bool          filled          = group.is_shape_filled();
  
  g->set_drawing_pen( group.get_pen() );
  
  if ( unselect )
  {
    g->set_foreground_color(  m_view_groups.get_background_color() );
    shape->draw( g, true );
    shape->draw( g, false );
  }
  g->set_foreground_color( group.get_color() );
    
  shape->draw( g, filled );
  
  if ( node->selected )
  {
    g->set_foreground_color( m_view_groups.get_selected_node_color() );
    g->set_fill_mode( GraphicArea::FILL_GRID );
    g->set_paint_mode( GraphicArea::INVERT_MODE );
    shape->draw( g, true );
    g->set_paint_mode( GraphicArea::SOLID_COLOR );
    g->set_fill_mode( GraphicArea::FILL_SOLID );
    
    shape->draw( g, false );
  }
  
/*  static char c_str[255];
  Graph	*graph = m_graph_view_context->get_graph();          
        
  memset( c_str, 0, sizeof(c_str) );
  if (graph->get_node(node->index)->is_label())
    sprintf( c_str, "%s", graph->get_node(node->index)->get_label().c_str() );
  else
    sprintf( c_str, "%d", (int)graph->get_node(node->index)->get_sub_id() );
        
  string str((char*)c_str); 
*/
  g->set_font( group.get_font() );  
  
  g->set_foreground_color( group.get_text_color() );
  shape->draw_label( g, node->label );

  delete shape;
}

void GraphView::draw_graph_edge( GraphicArea *g, VEdge *e/*NodeIndex start_node_id, NodeIndex end_node_id */)
{
  TwoDPoint      trans_start;
  TwoDPoint      trans_middle;	
  TwoDPoint      trans_end;
  
  g->set_paint_mode( GraphicArea::SOLID_COLOR );
  
  g->set_foreground_color( m_view_groups.get_edge_color() );
  g->set_drawing_pen( m_view_groups.get_edge_pen() );
		 
	TwoDPoint 		last;
	NodeIndex		j;
	SplineCoords	*s;
	
	for (j = 0; j < (NodeIndex)e->coords.size(); j++)
	{
		s = e->coords[j];
		
  		trans_start = transform_point( s->start );
  		trans_middle = transform_point( s->middle );	
  		trans_end = transform_point( s->end );
				
		if (j > 0)
		{
			g->draw_line( last, trans_start );  			
		}

		g->draw_line( trans_start, trans_middle );  			
		g->draw_line( trans_middle, trans_end );

		last = trans_end;			
	}			
	
}
	 
bool GraphView::draw_spline_edge( GraphicArea *g, VEdge *e)
{
	TwoDPoint 		last, next;
	int				i;
	NodeIndex		j;
	SplineCoords	*s;
	double		t, t_2, t_3, t_1;
	TwoDPoint      trans_start;
  TwoDPoint      trans_middle, trans_middle1;	
  TwoDPoint      trans_end;
	bool res = false;
  
	g->set_paint_mode( GraphicArea::SOLID_COLOR );
  
  /*if ( e->mark == GraphView::EDGE_SELECTED )
    g->set_foreground_color( m_view_groups.get_selected_edge_color() );		
  else if ( e->mark == GraphView::EDGE_IN_SCENARIO )
    g->set_foreground_color( m_view_groups.get_selected_path_color() );		
  else if ( e->mark >= GraphView::EDGE_RESERVED1 && e->mark <= GraphView::EDGE_RESERVED3 )
    g->set_foreground_color( m_view_groups.get_reserved_edge_color(e->mark) );		
 */
  if ( e->mark != GraphViewPropertiesStorage::EDGE_UNMARKED )
    g->set_foreground_color( m_view_groups.get_edge_mark_color( e->mark ) );
 	else if (m_nodes[e->real_tail_indx]->selected && m_nodes[e->real_head_indx]->selected )
 		g->set_foreground_color( m_view_groups.get_selected_edge_color() );		
	else if ( m_nodes[e->real_tail_indx]->selected )
    g->set_foreground_color( m_view_groups.get_outgoing_edge_color() );		  
  else if ( m_nodes[e->real_head_indx]->selected )  
    g->set_foreground_color( m_view_groups.get_incoming_edge_color() );		
  else
 		g->set_foreground_color( m_view_groups.get_edge_color() );
  
 	g->set_drawing_pen( m_view_groups.get_edge_pen() );

	for (j = 0; j < (NodeIndex)e->coords.size(); j++)
	{
		s = e->coords[j]; 
  	trans_start = transform_point( s->start );
  	trans_middle = transform_point( s->middle );	
   	trans_end = transform_point( s->end );  

		LineSegment l(trans_start, trans_end);		
		if (j > 0)
		{ 
			if (transform_line(last, trans_start, l))
			{
				g->draw_line( l.get_start_point(), l.get_end_point() );									
				res = true;
			}
		}

		if (s->type == SPLINE || s->type == SPLINE4) 
		{ 
			last = trans_start;
			
			if (m_spline_interpltn)
			{
			t = t_step;
			for (i = 0; i < s_iter; i++)
			{
				t_1 = 1 - t;
				t_2 = t * t;
				t_3 = t_2 * t;
			
				if (s->type == SPLINE)
				{
					next.set_x((OneDValue)(((t_1*trans_start.get_x() + 3*t*trans_middle.get_x())*t_1+3*t_2*trans_middle.get_x())*t_1+t_3*trans_end.get_x())); 
					next.set_y((OneDValue)(((t_1*trans_start.get_y() + 3*t*trans_middle.get_y())*t_1+3*t_2*trans_middle.get_y())*t_1+t_3*trans_end.get_y())); 			
				}
				else
				{
					trans_middle1 = transform_point( s->middle1 );	
					next.set_x((OneDValue)(((t_1*trans_start.get_x() + 3*t*trans_middle.get_x())*t_1+3*t_2*trans_middle1.get_x())*t_1+t_3*trans_end.get_x())); 
					next.set_y((OneDValue)(((t_1*trans_start.get_y() + 3*t*trans_middle.get_y())*t_1+3*t_2*trans_middle1.get_y())*t_1+t_3*trans_end.get_y())); 			
				}
			 	
				if (transform_line(last, next, l))
					g->draw_line( l.get_start_point(), l.get_end_point() );									

				last = next;	
				t += t_step;			
			}
			}
			else
			{
				if (transform_line( trans_start, trans_middle, l ))
				{
					g->draw_line( l.get_start_point(), l.get_end_point() );									
					res = true;
				}
				
				if (transform_line( trans_middle, trans_end, l ))
				{
					g->draw_line( l.get_start_point(), l.get_end_point() );									
					res = true;
				}
			}
		}
		else if (s->type == LINE)
    {
			if (transform_line(trans_start, trans_end, l))
			{
				g->draw_line( l.get_start_point(), l.get_end_point() );					
				res = true;
			}
    }
				
		if ( s->type == PIXEL )
			last = trans_start;
		else
			last = trans_end;			
	}			
	
	return res;
}

void GraphView::draw_arrow(GraphicArea *g, VEdge *e)
{
	SplineCoords	*s;	
	TwoDPoint		p_tail, p_head;
	OneDValue			x,y;
	double			x_d, y_d;
	double			l;
	
	TwoDPoint       trans_left;
  	TwoDPoint       trans_head;	
  	TwoDPoint       trans_right;
	
  if ( !m_draw_arrows )
	//if (get_app_context()->get_graph()->get_graph_type() == NETWORK_GRAPH)
    return;
  
  if (!(e->edge_type == SELFEDGE))
	{
		if (e->inverse_edge)
			s = e->coords[0];
		else		
			s = e->coords[e->coords.size()-1];
		
		if (s->type == SPLINE)
		{
			if (e->inverse_edge)			
			{
				p_tail = s->middle;
				p_head = s->start;
			}
			else
			{
				p_tail = s->middle;
				p_head = s->end;
			}
		}
		else if (s->type == LINE)
		{
			if (e->inverse_edge)			
			{
				p_tail = s->end;
				p_head = s->start;
			}
			else
			{			
				p_tail = s->start;
				p_head = s->end;
			}
		}
		else if (s->type == PIXEL)
		{
			p_head = s->start;
			
			if (e->inverse_edge)			
				s = e->coords[1];
			else			
				s = e->coords[e->coords.size()-2];
			
			if (s->type == SPLINE || s->type == LINE)
			{
				if (e->inverse_edge)			
					p_tail = s->start;
				else
					p_tail = s->end;
			}
			else if (s->type == PIXEL)
				p_tail = s->start;				
		}
	}
	else
	{
		s = e->coords[1];
		p_tail = s->middle;
		p_head = s->end;
	}		
			
  l = sqrt((double)((double)(p_head.get_x() - p_tail.get_x())*(double)(p_head.get_x() - p_tail.get_x()) + (double)(p_head.get_y() - p_tail.get_y())*(double)(p_head.get_y() - p_tail.get_y())));
  x = p_tail.get_x() + (OneDValue)((double)((l - m_arrow_len)*(p_head.get_x() - p_tail.get_x())) / l);
  y = p_tail.get_y() + (OneDValue)((double)((l - m_arrow_len)*(p_head.get_y() - p_tail.get_y())) / l);
			
  x_d = (double)(x - p_head.get_x()) * m_cos_alpha - (double)(y - p_head.get_y()) * m_sin_alpha + (double)p_head.get_x();
  y_d = (double)(x - p_head.get_x()) * m_sin_alpha + (double)(y - p_head.get_y()) * m_cos_alpha + (double)p_head.get_y();			
			
  trans_left = transform_point( TwoDPoint((OneDValue)x_d, (OneDValue)y_d) );	 
			
  x_d = (double)(x - p_head.get_x()) * m_cos_alpha + (double)(y - p_head.get_y()) * m_sin_alpha + (double)p_head.get_x();
  y_d = -(double)(x - p_head.get_x()) * m_sin_alpha + (double)(y - p_head.get_y()) * m_cos_alpha + (double)p_head.get_y();			
			
  trans_right = transform_point( TwoDPoint((OneDValue)x_d, (OneDValue)y_d) );	 			
			
  trans_head = transform_point( p_head );	 			 
			
			
  LineSegment arrow_l(trans_left, trans_head);		
	
  if (transform_line(trans_left, trans_head, arrow_l))
    g->draw_line( arrow_l.get_start_point(), arrow_l.get_end_point() );					

  if (transform_line(trans_right, trans_head, arrow_l))
    g->draw_line( arrow_l.get_start_point(), arrow_l.get_end_point() );					
}

void GraphView::draw_virtual_edges( GraphicArea *g, VNode *start_virtual_node, bool is_down)
{
	EdgeListIter	e_iter;
	VEdge			*e;

//virual node can have only pair of in- and out- edges
	if (is_down)
	{
    e_iter = start_virtual_node->out_edges.begin();
		e = *e_iter;
		while ((e != 0) && (m_nodes[e->tail_indx]->node_type == VIRTUAL))
		{
      draw_spline_edge( g, e );		
			draw_arrow( g, e );
		
			if (m_nodes[e->head_indx]->out_edges.empty())
				break;

      e_iter = m_nodes[e->head_indx]->out_edges.begin();
			e = *e_iter;
		}
	}
	else 
	{
    	e_iter = start_virtual_node->in_edges.begin();
		e = *e_iter;
		while ((e != 0) && (m_nodes[e->head_indx]->node_type == VIRTUAL))
		{
    		draw_spline_edge( g, e );		
			draw_arrow( g, e );
		
			if (m_nodes[e->tail_indx]->in_edges.empty())
				break;
			
    		e_iter = m_nodes[e->tail_indx]->in_edges.begin();
			e = *e_iter;
		}
	}
	  
}

bool GraphView::is_edge_visible( VEdge *edge, const Rectangle &rect )
{
  bool res = false;
  VNode *start_node = m_nodes[edge->tail_indx];
  VNode *end_node = m_nodes[edge->head_indx];
  
	TwoDPoint     trans_start;
  TwoDPoint     trans_middle, trans_middle1;	
  TwoDPoint     trans_end;
	TwoDPoint     last, next;  
  
	NodeIndex		  j;
	SplineCoords	*s;  
  
  if ( !(edge->edge_type == SELFEDGE || (start_node->rank - end_node->rank == 1 ||
				start_node->rank - end_node->rank == -1 || start_node->rank - end_node->rank == 0) ))
    return res;

	for (j = 0; j < (NodeIndex)edge->coords.size(); j++)
	{
		s = edge->coords[j]; 

  	trans_start = transform_point( s->start );
  	trans_middle = transform_point( s->middle );	
   	trans_end = transform_point( s->end );  

		LineSegment l(trans_start, trans_end);		
		if (j > 0)
		{ 
			if (transform_line(last, trans_start, l))
				res = true;
		}

		if (s->type == SPLINE || s->type == SPLINE4) 
		{ 
			last = trans_start;
			
			if (transform_line( trans_start, trans_middle, l ))
				res = true;
				
			
			if (transform_line( trans_middle, trans_end, l ))
				res = true;
				
		}
		else if (s->type == LINE)
    {
			if (transform_line(trans_start, trans_end, l))
				res = true;
    }
				
		if ( s->type == PIXEL )
			last = trans_start;
		else
			last = trans_end;			
	}			


  return res;
}

void GraphView::display( GraphicArea *g )
{
  unsigned int i = 0, j = 0;
    
  Rectangle rect = g->get_drawing_bounds();
  m_display_rect = rect;
  TwoDPoint left_top;
  TwoDPoint right_bottom;
  
  do_layout( m_display_rect );  
  
  g->set_paint_mode( GraphicArea::SOLID_COLOR );
  g->set_background_color( m_view_groups.get_background_color() );
  
  g->set_foreground_color( m_view_groups.get_background_color() );
  g->draw_filled_rectangle( rect.get_left_top_corner().get_x(), 
                            rect.get_left_top_corner().get_y(),
                            rect.get_right_bottom_corner().get_x(),
                            rect.get_right_bottom_corner().get_y() );
	
  g->set_foreground_color( Color::BLUE );
  g->draw_hollow_rectangle( rect.get_left_top_corner().get_x(), 
                            rect.get_left_top_corner().get_y(),
                            rect.get_right_bottom_corner().get_x(),
                            rect.get_right_bottom_corner().get_y() );
	
  if (m_nodes.empty() || m_gl == 0 )  
    return;
  
  left_top = inverse_transform_point( rect.get_left_top_corner() );
  right_bottom = inverse_transform_point( rect.get_right_bottom_corner() );
  unsigned int first_rank = find_nearest_rank( left_top.get_y() );
  unsigned int last_rank = find_nearest_rank( right_bottom.get_y() );
  
  for ( i = first_rank; i <= last_rank; i++ )
  {
    unsigned int first_node = find_nearest_node_in_rank( i, left_top.get_x() );
    unsigned int last_node = find_nearest_node_in_rank( i, right_bottom.get_x() );
    
    if ( m_gl->m_ranks[i]->v[ first_node ]->center.get_x() - m_radius <= right_bottom.get_x() &&
         m_gl->m_ranks[i]->v[ last_node ]->center.get_x() + m_radius >= left_top.get_x() )
    {
      for ( j = first_node; j <= last_node; j++ )
        draw_graph_node( g, m_gl->m_ranks[i]->v[j] );
    }
  }
	
  Rectangle view_rect( left_top, right_bottom );
  for ( i = 0; i < m_edges.size(); i++ )
	{
    VEdge *edge = m_edges[i];
    if ( is_edge_visible( edge, view_rect ) )
    {
      draw_spline_edge( g, edge );		
      draw_arrow( g, edge );
    }
  }
}

void GraphView::redraw_nodes( GraphicArea *g, const NodeIndexSet &nodes, bool redraw_edges )
{
  if ( g != 0 )
  {
    for ( NodeIndexSet::const_iterator p = nodes.begin(); p != nodes.end(); p++ )
    {
      if ( *p >= 0 && *p < (NodeIndex)m_nodes.size() )
      {
        VNode *node = m_nodes[*p];
        draw_graph_node( g, node, true );
        
        if ( redraw_edges )
          redraw_node_edges( g, node );
      }
    }
  }
}
