#include <sstream> 
#include "EventHandler.h"
#include "ScenarioApp.h"

using namespace GraphGraphics;

void ScenarioEventHandler::mouse_interaction( const Event &event )
{
  GraphicArea *g  = event.get_graphic_area();
  TwoDPoint    point = event.get_point();
  NodeIndex    node_id;
  GraphGUI    *gui  = m_graph_gui;
  GraphView   *view = m_graph_view_context->get_view();
  Graph       *graph = m_graph_view_context->get_graph();
  string      status_str = "default";
  unsigned int nodes_number, edges_number, sel_nodes_number, sel_edges_number;              
  DefaultStatusInfo *def_status;
  string      def_status_str = "default";              
    
  if ( graph->count_nodes() <= 0 )
    return;
    
  switch ( event.get_type() )
  {
  case Event::MOUSE_PRESSED:
    
    if ( (event.get_modifiers() & Event::SHIFT_MASK) == 0 && 
          m_gui_edge_mark != GraphViewPropertiesStorage::EDGE_UNMARKED )
    {
      view->remark_edges( m_gui_edge_mark, g, GraphViewPropertiesStorage::EDGE_UNMARKED );
    }
        
    if ( m_gui_start_edge_node_id != Graph::INVALID_NODE_ID )
      break;
    
    if ( (event.get_modifiers() & Event::SHIFT_MASK) == 0 )
    {
        if ( (event.get_modifiers() & Event::CTRL_MASK) == 0 )
        {
          view->unselect_all_nodes( g );
          m_gui_last_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
        }  
        
        if ( m_gui_edge_mark != GraphViewPropertiesStorage::EDGE_UNMARKED )
          view->remark_edges( m_gui_edge_mark, g, GraphViewPropertiesStorage::EDGE_UNMARKED );
        else  
          view->mark_all_edges( g );
    }
    
    for ( int i = 0; i < m_selected_pathes.get_pathes_count(); i++ )
      unselect_path( i, g );
      
    m_selected_pathes.uninit();
    m_curr_selected_path = GraphPath::INVALID_PATH_INDEX;
    
    m_gui_start_point = point;
    m_gui_end_point = point;
  
    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_mouse_button_press( event );
          
   
    break;
  
  case Event::MOUSE_RELEASED:
    if ( m_gui_edge_mark == GraphViewPropertiesStorage::EDGE_IN_SCENARIO )
    {
      EdgeList edges;
      node_id = view->get_node_id( point );
      if ( node_id == Graph::INVALID_NODE_ID )
      {
        m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
        if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
          gui->set_cursor( GraphGUI::DEFAULT_CURSOR );
        
        for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
          if ( (*p)->is_component_active() )
          {
            if ( m_gui_start_edge_node_id == Graph::INVALID_NODE_ID)
              (*p)->on_begin_path_finding( m_gui_start_edge_node_id, g );
            else
              (*p)->on_end_path_finding( m_selected_pathes, g );
          }
          
        m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
      }
      else if ( m_gui_start_edge_node_id == Graph::INVALID_NODE_ID )
      {
        m_gui_start_edge_node_id = node_id;
        view->select_node( node_id, g, true );
        
        string status_str = "help";  
        HelpStatusInfo *status;

        m_graph_view_context->get_status_mngr()->block(false);
          
        if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
        { 
          string help_str = "Select final node";
          status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
          status->set_help_string(help_str);
          m_graph_view_context->get_status_mngr()->block(true);
        }
          
          
        for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
          if ( (*p)->is_component_active() )
            (*p)->on_begin_path_finding( m_gui_start_edge_node_id, g );
      }
      else
      {
        m_graph_view_context->get_status_mngr()->block(false);
        NodeIndexSet end_nodes;
        end_nodes.insert( node_id );
        bool find_res = graph->get_graph_path( m_gui_start_edge_node_id, end_nodes, m_selected_pathes );
        
        m_selected_pathes.sort_pathes_by_coords( view );
        
        m_selected_pathes.get_edges( edges );
        
        view->select_node( node_id, g, true );
        
        if ( !find_res || edges.size() == 0 )
        {
          gui->show_message_dialog( "The path is not found." );
        }
        else
        {
          for ( EdgeList::iterator p = edges.begin(); p != edges.end(); p++ )
          {
            view->mark_edge( *p, g, m_gui_edge_mark );
            
            //  view->select_node( p->start_node, g, true );
            //  view->select_node( p->end_node, g, true );
          }   
        } 
        
        if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 )
        {
          string status_str = "help";  
          HelpStatusInfo *status;
      
          if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
          { 
            string help_str = "Select first edge node";
            status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
            status->set_help_string(help_str);
            m_graph_view_context->get_status_mngr()->block(true);
          }
        }
        
        if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
          gui->set_cursor( GraphGUI::DEFAULT_CURSOR );
        
        for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
          if ( (*p)->is_component_active() )
            (*p)->on_end_path_finding( m_selected_pathes, g );
          
        select_path( 0, g );
        
        m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
        m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
      }
    }
    else if ( m_gui_start_edge_node_id != Graph::INVALID_NODE_ID )
    {
      Edge edge;
      bool  exist = false;
      edge.start_node = m_gui_start_edge_node_id;
      
      if ( event.get_button_code() == Event::MOUSE_LEFT_BUTTON )
      {
        node_id = view->get_node_id( point );
        
        edge.end_node = node_id;

        if ( node_id != Graph::INVALID_NODE_ID)        
        {
          Node                *node = graph->get_node( m_gui_start_edge_node_id );  
          NodeLinkList        *node_links = node->get_links();
          
          for ( NodeLinkList::iterator iter = node_links->begin(); iter != node_links->end() && !exist; iter++ )
            if ( *iter == node_id )
              exist = true;
            
          if ( !exist )
          {
            if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 )
            {
              m_gui_start_edge_node_id = node_id;
              view->unselect_all_nodes( g );
              view->select_node( node_id, g, true );
            }
            else
              gui->show_message_dialog( "The edge does not exist between the nodes." );  
          }
          else
          {
                                                        
            if ( edge.is_valid() )
            {
              m_graph_view_context->get_status_mngr()->block(false);                
                
              StyleFlags edge_mark = view->get_edge_mark( edge );
              
              if ( edge_mark != GraphViewPropertiesStorage::EDGE_SELECTED)
                m_gui_last_edge_mark = edge_mark;
              
              view->mark_edge( edge, g );
            }
            
            if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 )
            {
              view->unselect_all_nodes( g );
              
              string status_str = "help";  
              HelpStatusInfo *status;
      
              m_graph_view_context->get_status_mngr()->block(false);
                
              if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
              { 
                string help_str = "Select first edge node";
                status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
                status->set_help_string(help_str);
                m_graph_view_context->get_status_mngr()->block(true);
              }
            }
          }
        }
      }  
      if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
        gui->set_cursor( GraphGUI::DEFAULT_CURSOR );
       
      for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
        if ( (*p)->is_component_active() )
          (*p)->on_end_edge_selecting( edge, exist );
      
      if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 
           || exist)
        m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
      
      m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;      
    }      
    else if ( m_gui_view_rect )
    {
      NodeIndexVector nodes;
      Rectangle       rect( GGMIN( m_gui_start_point.get_x(), m_gui_end_point.get_x()),
                            GGMIN( m_gui_start_point.get_y(), m_gui_end_point.get_y()),
                            GGMAX( m_gui_start_point.get_x(), m_gui_end_point.get_x()),
                            GGMAX( m_gui_start_point.get_y(), m_gui_end_point.get_y()) );
            
      draw_gui_rect( g );
      
      if ( rect.get_width() < 4 && rect.get_height() < 4 && 
            event.get_button_code() == Event::MOUSE_LEFT_BUTTON )
      {
        node_id = view->get_node_id( point );
      
        if ( node_id != Graph::INVALID_NODE_ID )
        {
          view->select_node( node_id, g, !(view->is_node_selected( node_id ) && ((event.get_modifiers() & Event::SHIFT_MASK) != 0)) );
          
          if ( view->is_node_selected( node_id ) && 
               (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT) != 0 )
          {
            GraphNodeAttributesGUI* attr_dialog = gui->create_nodes_info_dialog( view, node_id );
            attr_dialog->show( true );
          }
        }
        else if ( (event.get_modifiers() & Event::SHIFT_MASK) == 0 )
        {
          view->unselect_all_nodes( g );
          
          view->mark_all_edges( g );
          m_selected_pathes.uninit();
          m_curr_selected_path = GraphPath::INVALID_PATH_INDEX;
        }
      }
      else
      {        
        view->get_node_id_from_rect( rect, nodes );
        
        for ( unsigned int i = 0; i < nodes.size(); i++ )
          view->select_node( nodes[i], g, true );
        
        if ( nodes.size() == 1 &&
            (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT) != 0 )
        {
          GraphNodeAttributesGUI* attr_dialog = gui->create_nodes_info_dialog( view, nodes[0] );
          attr_dialog->show( true );
        }
      }
    }
    else if ( event.get_button_code() == Event::MOUSE_LEFT_BUTTON )
    {
      node_id = view->get_node_id( point );
      
      if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 )
      {
        if ( node_id == Graph::INVALID_NODE_ID )
          m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
        else if ( m_gui_start_edge_node_id == Graph::INVALID_NODE_ID )
        {
          m_gui_start_edge_node_id = node_id;
          view->select_node( node_id, g, true );
          
          string status_str = "help";  
          HelpStatusInfo *status;
  
          m_graph_view_context->get_status_mngr()->block(false);
            
          if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
          { 
            string help_str = "Select second edge node";
            status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
            status->set_help_string(help_str);
            m_graph_view_context->get_status_mngr()->block(true);
          }
          
          for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
            if ( (*p)->is_component_active() )
              (*p)->on_init_edge_selecting( node_id );
        }
      }
      else if ( (event.get_modifiers() & Event::CTRL_MASK) != 0 )
      {
        NodeIndexVector selected_nodes;
        view->get_selected_nodes( selected_nodes );
        
        if ( selected_nodes.size() == 1 && node_id != Graph::INVALID_NODE_ID )
        {
          NodeIndex end_node_id = node_id;
          NodeIndex start_node_id = selected_nodes[0];
          Edge      edge;
          EdgeList  marked_edges;
          unsigned int sel_edge_count = view->get_marked_edges( GraphViewPropertiesStorage::EDGE_SELECTED, marked_edges );

          if ( m_gui_edge_mark == GraphViewPropertiesStorage::EDGE_IN_SCENARIO )
          {
            m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
            m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
          }
      
          if ( sel_edge_count > 0 )
          {
            if ( (event.get_modifiers() & Event::SHIFT_MASK) == 0  )
              view->remark_edges( GraphViewPropertiesStorage::EDGE_SELECTED, g, m_gui_last_edge_mark );
            m_gui_last_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
          }
           
          edge.start_node = start_node_id;
          edge.end_node = end_node_id;
                
          if ( graph->does_edge_exist( edge ) )
          {
            StyleFlags edge_mark = view->get_edge_mark( edge );
            if ( edge_mark != GraphViewPropertiesStorage::EDGE_SELECTED)
              m_gui_last_edge_mark = edge_mark;
            view->mark_edge( edge, g );
          }
          
          if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 )
          {        
            string status_str = "help";  
            HelpStatusInfo *status;
            
            m_graph_view_context->get_status_mngr()->block(false);
                      
            if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
            { 
              string help_str = "Select first edge node";
              status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
              status->set_help_string(help_str);
              m_graph_view_context->get_status_mngr()->block(true);
            }
          }
        
          m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
          
          for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
            if ( (*p)->is_component_active() )
              (*p)->on_init_edge_selecting( edge.start_node );
          
          for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
            if ( (*p)->is_component_active() )
              (*p)->on_end_edge_selecting( edge, graph->does_edge_exist( edge ) );
        }
      }
      else
      {        
        if ( node_id != Graph::INVALID_NODE_ID )
        {
          view->select_node( node_id, g, !(view->is_node_selected( node_id ) && ((event.get_modifiers() & Event::SHIFT_MASK) != 0)) );
          
          if ( view->is_node_selected( node_id ) && 
               (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT) != 0 )
          {
            GraphNodeAttributesGUI* attr_dialog = gui->create_nodes_info_dialog( view, node_id );
            attr_dialog->show( true );
          }
        }
        else if ( (event.get_modifiers() & Event::SHIFT_MASK) == 0 )
           view->unselect_all_nodes( g );
      }
    }
    
    m_gui_view_rect = false;
   
    m_graph_view_context->get_status_mngr()->set_current_status(status_str);
	
    view->get_number_info(nodes_number, edges_number, sel_nodes_number, sel_edges_number);    
    def_status = (DefaultStatusInfo*)m_graph_view_context->get_status_mngr()->get_status(def_status_str);              
    def_status->set_default_info(nodes_number, edges_number, sel_nodes_number, sel_edges_number);  


    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_mouse_button_release( event );
      
    break;
   
  case Event::MOUSE_MOVE:
  {  
    
    if ( event.get_button_code() == Event::MOUSE_LEFT_BUTTON && 
         m_gui_start_edge_node_id == Graph::INVALID_NODE_ID &&
         (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
    {
      draw_gui_rect( g );
       
      m_gui_end_point = point;
      draw_gui_rect( g );
      m_gui_view_rect = true;
    }
    else if ( event.get_button_code() == 0 && 
              (m_modes & ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER) != 0 )
    {
      NodeIndex id = view->get_node_id( point );
      
      if ( m_node_mouse_over != id && id != Graph::INVALID_NODE_ID )
      {
        GraphNodeAttributesGUI* attr_dialog = gui->create_nodes_info_dialog( view, id );
        attr_dialog->show( true );
      }
      
      m_node_mouse_over = id;
    }
    
    NodeIndexVector selected_nodes;
    view->get_selected_nodes( selected_nodes );
    
    if ( (event.get_modifiers() & Event::CTRL_MASK) != 0  &&
          event.get_button_code() == 0 && selected_nodes.size() == 1 &&
          m_gui_start_edge_node_id == Graph::INVALID_NODE_ID && !m_ctrl_pressed &&
          m_gui_edge_mark != GraphViewPropertiesStorage::EDGE_IN_SCENARIO )
    {
      string status_str = "help";  
      HelpStatusInfo *status;
  
      m_graph_view_context->get_status_mngr()->block(false);
            
      if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
      { 
        string help_str = "Select second edge node";
        status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
        status->set_help_string(help_str);
        m_graph_view_context->get_status_mngr()->block(true);
      }
      m_ctrl_pressed = true;
    }
    else if ( m_ctrl_pressed && (event.get_modifiers() & Event::CTRL_MASK) == 0 )
    {
      m_ctrl_pressed = false;
      
      if ( m_gui_start_edge_node_id == Graph::INVALID_NODE_ID && 
           m_gui_edge_mark != GraphViewPropertiesStorage::EDGE_IN_SCENARIO )
      {
        string status_str = "help";  
        HelpStatusInfo *status;
        
        m_graph_view_context->get_status_mngr()->block(false);
        
        if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
        {
          status_str = "default";      
          m_graph_view_context->get_status_mngr()->set_current_status(status_str);            
        }
        else if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
        { 
          string help_str = "Select first edge node";
          status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
          status->set_help_string(help_str);
          m_graph_view_context->get_status_mngr()->block(true);
        } 
      }
    }
        
    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_mouse_motion_notify( event );
  } 
    break;
  
  default:;
  }
}

void ScenarioEventHandler::handle_mouse_events( const Event &event )
{
  mouse_interaction( event );
}

void ScenarioEventHandler::handle_init_edge_selecting( GraphicArea *g, NodeIndex start_node_id )
{
  GraphGUI    *gui  = m_graph_gui;
  GraphView   *view = m_graph_view_context->get_view();
  Graph       *graph = m_graph_view_context->get_graph();
  //Edge         edge  = view->get_selected_edge();
  Edge         edge;
  EdgeList  marked_edges;
  NodeIndex    node_id;
  
  if ( m_gui_edge_mark == GraphViewPropertiesStorage::EDGE_IN_SCENARIO )
  {
    m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
    m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
  }
      
  node_id = start_node_id;
  
//  if ( sel_edge_count > 0 )
//  {
//    view->remark_edges( GraphViewPropertiesStorage::EDGE_SELECTED, g, m_gui_last_edge_mark );
  
//    m_gui_last_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
//  }
  
  if ( node_id >= (NodeIndex)graph->count_nodes() || node_id <  0 )
    m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
  else
  {
    NodeIndex            end_node_id = Graph::INVALID_NODE_ID;
    Node                *node = graph->get_node( node_id );  
    NodeLinkList        *node_links = node->get_links();
      
    if ( node_links->empty() )
    {
      m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
      gui->show_message_dialog( "The node does not have outgoing edges." );
      return;
    }
      
    if ( node_links->size() == 1 )
      end_node_id = *(node_links->begin());
    else 
    {
      for( NodeLinkList::iterator iter = node_links->begin(); iter != node_links->end(); iter++)
      {
        if ( view->is_node_selected( *iter ) )
        {
          if ( end_node_id == Graph::INVALID_NODE_ID )
            end_node_id = *iter;
          else if ( end_node_id != *iter )
          {
            end_node_id = Graph::INVALID_NODE_ID;
            break;
          }
        }
      }
    }
    
    if ( end_node_id == node_id )
      end_node_id = Graph::INVALID_NODE_ID;
    
    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_init_edge_selecting( node_id );
      
    if ( end_node_id == Graph::INVALID_NODE_ID )
    {
      m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_SELECTED;
      m_gui_start_edge_node_id = node_id;

      if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
        gui->set_cursor( GraphGUI::CROSS_CURSOR );
        
      string status_str = "help";  
      HelpStatusInfo *status;

      m_graph_view_context->get_status_mngr()->block(false);
          
      if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
      { 
        string help_str = "Select second edge node";
        status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
        status->set_help_string(help_str);
        m_graph_view_context->get_status_mngr()->block(true);
      }
    }
    else
    {
      unsigned int sel_edge_count = view->get_marked_edges( GraphViewPropertiesStorage::EDGE_SELECTED, marked_edges );
      
      if ( sel_edge_count > 0 )
      {
        view->remark_edges( GraphViewPropertiesStorage::EDGE_SELECTED, g, m_gui_last_edge_mark );
      
        m_gui_last_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
      }
        
      m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
        
      edge.start_node = node_id;
      edge.end_node   = end_node_id;
                
      if ( edge.is_valid() )
      {
        StyleFlags edge_mark = view->get_edge_mark( edge );
        if ( edge_mark != GraphViewPropertiesStorage::EDGE_SELECTED)
          m_gui_last_edge_mark = edge_mark;
        view->mark_edge( edge, g );
      }
    
      if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) != 0 )
      {        
        string status_str = "help";  
        HelpStatusInfo *status;
        
        m_graph_view_context->get_status_mngr()->block(false);
                  
        if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
        { 
          string help_str = "Select first edge node";
          status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
          status->set_help_string(help_str);
          m_graph_view_context->get_status_mngr()->block(true);
        }
      }
        
      m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
      for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
        if ( (*p)->is_component_active() )
          (*p)->on_end_edge_selecting( edge, true );
    }
  }

  DefaultStatusInfo *def_status;
  string      def_status_str = "default";              
  unsigned int nodes_number, edges_number, sel_nodes_number, sel_edges_number;              
  
  view->get_number_info(nodes_number, edges_number, sel_nodes_number, sel_edges_number);    
  def_status = (DefaultStatusInfo*)m_graph_view_context->get_status_mngr()->get_status(def_status_str);              
  def_status->set_default_info(nodes_number, edges_number, sel_nodes_number, sel_edges_number);  
  
}

 
void ScenarioEventHandler::handle_init_path_finding(  )
{
  GraphView *view = m_graph_view_context->get_view();
  Graph     *graph = m_graph_view_context->get_graph();
  
  if ( view == 0 || graph == 0 )
    return;
  
  if ( graph->count_nodes() <= 0 )  
      return;
  
  GraphGUI  *gui  = m_graph_gui;
  m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_IN_SCENARIO;

  if ( (m_graph_gui->get_scenario_app()->get_behavior_modes() & ScenarioApp::EDGE_SELECTING) == 0 )
    gui->set_cursor( GraphGUI::CROSS_CURSOR );
  
  if ( m_gui_start_edge_node_id != Graph::INVALID_NODE_ID )
  {
    m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
  }

  string status_str = "help";  
  HelpStatusInfo *status;
  
  m_graph_view_context->get_status_mngr()->block(false);
  if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
  { 
    string help_str = "Select initial node";
    status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
    status->set_help_string(help_str);
    m_graph_view_context->get_status_mngr()->block(true);
  }
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_init_path_finding( );
}

//##ModelId=3EFAA52901A2
bool ScenarioEventHandler::handle_open( const string &file_name )
{
  GraphView *view = m_graph_view_context->get_view();
  Graph     *graph = m_graph_view_context->get_graph();
  GraphGUI  *gui  = m_graph_gui;
  bool is_loaded = m_graph_view_context->load_file( file_name );
  
  
  DefaultStatusInfo *def_status;
  string      def_status_str = "default";              
  unsigned int nodes_number, edges_number, sel_nodes_number, sel_edges_number;              
  
  view->get_number_info(nodes_number, edges_number, sel_nodes_number, sel_edges_number);    
  def_status = (DefaultStatusInfo*)m_graph_view_context->get_status_mngr()->get_status(def_status_str);              
  def_status->set_default_info(nodes_number, edges_number, sel_nodes_number, sel_edges_number);  


  if ( !is_loaded )
    gui->show_message_dialog( Storable::get_error() );
  
  if ( Storable::get_error_level() != Storable::NOT_GRAPH_FILE )
  {
    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_open( file_name );
    
    if ( graph->count_nodes() > 20 )
      gui->show_wait_dialog( "Graph building. Please wait...");
    
    view->make_graph_view();
  }
  
  gui->hide_wait_dialog( );
  
  return is_loaded;
}

//##ModelId=3EFAA531004F
bool ScenarioEventHandler::handle_save( const GraphFileInfo &save_file_info )
{
  GraphFileInfo file_info = save_file_info;
  GraphGUI  *gui  = m_graph_gui;
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_save( file_info );
  
  bool res = m_graph_view_context->save_file( file_info );
  
  if ( !res )
    gui->show_message_dialog( Storable::get_error() );
  
  return res;
}

//##ModelId=3EFAA5350376
void ScenarioEventHandler::handle_close_window()
{
}

//##ModelId=3EFAA5670024
void ScenarioEventHandler::handle_zoom_in()
{
  GraphView *view = m_graph_view_context->get_view();
  view->zoom_in();
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_zoom_in( );
}

//##ModelId=3EFAA56D0023
void ScenarioEventHandler::handle_zoom_out()
{
  GraphView *view = m_graph_view_context->get_view();
  view->zoom_out();
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_zoom_out( );
}

//##ModelId=3EFAA57402CC
void ScenarioEventHandler::handle_fit_to_window()
{
  GraphView *view = m_graph_view_context->get_view();
  view->set_layout( GraphView::FIT_TO_WINDOW );
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_fit_to_window( );
}

//##ModelId=3EFAA57C013D
void ScenarioEventHandler::handle_fit_to_height()
{
  GraphView *view = m_graph_view_context->get_view();
  view->set_layout( GraphView::FIT_TO_HEIGHT );
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_fit_to_height( );
}

void ScenarioEventHandler::handle_fit_to_width()
{
  GraphView *view = m_graph_view_context->get_view();
  view->set_layout( GraphView::FIT_TO_WIDTH );
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_fit_to_width( );
}

//##ModelId=3EFAA58303BE
void ScenarioEventHandler::handle_fit_selection_to_window()
{
  GraphView *view = m_graph_view_context->get_view();
  view->set_layout( GraphView::FIT_SELECTION_TO_WINDOW );
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_fit_selection_to_window( );
}

//##ModelId=3EFAA58D034A
void ScenarioEventHandler::handle_arbitrary_size()
{
  GraphView *view = m_graph_view_context->get_view();
  view->set_layout( GraphView::ARBITRARY_SIZE );
  
  for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
    if ( (*p)->is_component_active() )
      (*p)->on_arbitrary_size( );
}

//##ModelId=3EFAA59A0231
bool ScenarioEventHandler::handle_selection_centering( const Rectangle &display_rect )
{
  GraphView *view = m_graph_view_context->get_view();
  GraphGUI  *gui  = m_graph_gui;
  bool  res = false;
  NodeIndexVector   selected_nodes;
  
  view->get_selected_nodes( selected_nodes );
  
  if ( selected_nodes.size() == 0 )
    gui->show_message_dialog( "Please select nodes" );
  else
  {
    view->centering( display_rect );
    res = true;
    
    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_selection_centering( );
  }
    
  return res;
}

void ScenarioEventHandler::enable_edge_selecting_mode( bool enable )
{
  string status_str = "help";  
  HelpStatusInfo *status;
      
  if ( enable )
  {
    if ( m_gui_edge_mark == GraphViewPropertiesStorage::EDGE_IN_SCENARIO )
    {
      m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
      m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
    }
    else
      m_graph_gui->set_cursor( GraphGUI::CROSS_CURSOR );
    
    m_graph_view_context->get_status_mngr()->block(false);
                
    if (m_graph_view_context->get_status_mngr()->set_current_status(status_str))
    { 
      string help_str = "Select first edge node";
      status = (HelpStatusInfo*)m_graph_view_context->get_status_mngr()->get_current_status();
      status->set_help_string(help_str);
      m_graph_view_context->get_status_mngr()->block(true);
    }
  }
  else if ( m_gui_edge_mark != GraphViewPropertiesStorage::EDGE_IN_SCENARIO  )
  {
    m_graph_gui->set_cursor( GraphGUI::DEFAULT_CURSOR );
    m_graph_view_context->get_status_mngr()->block(false);
    
    m_gui_start_edge_node_id = Graph::INVALID_NODE_ID;
    m_gui_edge_mark = GraphViewPropertiesStorage::EDGE_UNMARKED;
    
    status_str = "default";      
    m_graph_view_context->get_status_mngr()->set_current_status(status_str);
  }
}

bool ScenarioEventHandler::select_path( int path_id, GraphicArea *g )
{
  bool res = (path_id >= 0 && path_id < m_selected_pathes.get_pathes_count());
  GraphView   *view = m_graph_view_context->get_view();
    
  if ( res && path_id != m_curr_selected_path )
  {
    EdgeList edges;
    if ( m_curr_selected_path != GraphPath::INVALID_PATH_INDEX )
    {
      NodeIndex end_node;
      m_selected_pathes.get_path_edges( m_curr_selected_path, edges );
      
      for ( EdgeList::iterator p = edges.begin(); p != edges.end(); p++ )
      {
        if ( view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_IN_SCENARIO ) )
        {
          view->select_node( p->start_node, g, false );
          view->select_node( p->end_node, g, false );
          
          end_node = p->end_node;
        }
      }
      
      view->select_node( end_node, g, true );
    }
    
    m_selected_pathes.get_path_edges( path_id, edges );
    
    for ( EdgeList::iterator p = edges.begin(); p != edges.end(); p++ )
    {
      if ( view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_SELECTED ) )
      {
        view->select_node( p->start_node, g, true );
        view->select_node( p->end_node, g, true );
      }
    }   
    
    m_curr_selected_path = path_id;
    
    for ( ComponentsVector::iterator p = m_components.begin(); p != m_components.end(); p++ )
      if ( (*p)->is_component_active() )
        (*p)->on_path_selecting( path_id, m_selected_pathes, g );
  }
  
  return res;
}

bool ScenarioEventHandler::unselect_path( int path_id, GraphicArea *g )
{
  EdgeList edges;
  GraphView   *view = m_graph_view_context->get_view();
  
  m_selected_pathes.get_path_edges( path_id, edges );
  
  for ( EdgeList::iterator p = edges.begin(); p != edges.end(); p++ )
  {
    if ( view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_UNMARKED ) )
    {
      view->select_node( p->start_node, g, false );
      view->select_node( p->end_node, g, false );
    }
  }
  
  return true;
}

bool ScenarioEventHandler::handle_path_selecting( int path_id, GraphicArea *g )
{
  return select_path( path_id, g );
}

void ScenarioEventHandler::select_all_pathes( GraphicArea *g )
{
  GraphView *view = m_graph_view_context->get_view();
  EdgeList   edges;
  NodeIndex  start_node = m_selected_pathes.get_init_node();
  
  NodeIndexSet end_nodes = m_selected_pathes.get_end_nodes();
        
  m_selected_pathes.sort_pathes_by_coords( view );
  m_selected_pathes.get_edges( edges );
    
  view->select_node( start_node, g, true );
    
  for ( EdgeList::iterator p = edges.begin(); p != edges.end(); p++ )
    view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_IN_SCENARIO );

  select_path( 0, g );
    
  for ( NodeIndexSet::const_iterator q = end_nodes.begin(); q != end_nodes.end(); q++ )
    view->select_node( *q, g, true );
}

bool ScenarioEventHandler::find_path_group( GraphicArea *g, NodeIndex start_node, const NodeAttributeList &end_nodes )
{
  bool res = false;
  Graph   *graph = m_graph_view_context->get_graph();
  EdgeList edges;
  
  for ( int i = 0; i < m_selected_pathes.get_pathes_count(); i++ )
    unselect_path( i, g );
    
  m_selected_pathes.uninit();
  m_curr_selected_path = -1;
    
  res = graph->get_graph_path( start_node, end_nodes, m_selected_pathes );
 
  if ( res )
    select_all_pathes( g );
  
  return res;
}

bool ScenarioEventHandler::find_path_group( GraphicArea *g, NodeIndex start_node, const NodeAttributeList &end_nodes, 
                        const NodeAttributeList &include_nodes, 
                        const NodeAttributeList &exclude_nodes )
{
  bool res = false;
  Graph   *graph = m_graph_view_context->get_graph();
  EdgeList edges;
  
  for ( int i = 0; i < m_selected_pathes.get_pathes_count(); i++ )
    unselect_path( i, g );
    
  m_selected_pathes.uninit();
  m_curr_selected_path = -1;
    
  res = graph->get_graph_path( start_node, end_nodes, include_nodes, exclude_nodes, m_selected_pathes );
 
  if ( res )
    select_all_pathes( g );
  
  return res;
}

bool ScenarioEventHandler::find_path_sub_group( GraphicArea *g, const NodeAttributeList &include_nodes, const NodeAttributeList &exclude_nodes )
{
  bool res = false;
  Graph       *graph = m_graph_view_context->get_graph();
  GraphView   *view = m_graph_view_context->get_view();
  EdgeList edges;
  
  if ( m_selected_pathes.get_pathes_count() > 0 )
  {
    int i;
    NodeIndex  start_node = m_selected_pathes.get_init_node();
    EdgeSet    edges_to_remove;
    EdgeList   removed_edges;
    EdgeList::iterator p;
    NodeIndexSet end_nodes = m_selected_pathes.get_end_nodes();
    
    unselect_path( m_curr_selected_path, g );
      
    m_selected_pathes.get_path_edges( m_curr_selected_path, removed_edges );
      
    for ( i = 0; i < m_selected_pathes.get_pathes_count(); i++ )
    {
      m_selected_pathes.get_path_edges( i, edges );
          
      for ( p = edges.begin(); p != edges.end(); p++ )
          edges_to_remove.insert( *p );
    }
    
    m_curr_selected_path = -1;
    
    res = m_selected_pathes.find_path_sub_group( graph, include_nodes, exclude_nodes );
   
    if ( res )
    {
      NodeIndexSet::const_iterator q;
      NodeIndexSet new_end_nodes = m_selected_pathes.get_end_nodes();
              
      m_selected_pathes.sort_pathes_by_coords( view );
            
      view->select_node( start_node, g, true );
          
      for ( i = 0; i < m_selected_pathes.get_pathes_count() && !edges_to_remove.empty(); i++ )
      {
        m_selected_pathes.get_path_edges( i, edges );
        
        for ( EdgeList::const_iterator p = edges.begin(); p != edges.end() && !edges_to_remove.empty(); p++ )
          edges_to_remove.erase( *p );
      }
      
      for ( EdgeSet::const_iterator it = edges_to_remove.begin(); it != edges_to_remove.end(); it++ )
        view->mark_edge( *it, g, GraphViewPropertiesStorage::EDGE_UNMARKED );
      
      for ( p = removed_edges.begin(); p != removed_edges.end(); p++ )
        if ( edges_to_remove.find( *p ) == edges_to_remove.end() )
          view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_IN_SCENARIO );
        
      for ( q = end_nodes.begin(); q != end_nodes.end(); q++ )
        view->select_node( *q, g, false );
        
      for ( q = new_end_nodes.begin(); q != new_end_nodes.end(); q++ )
        view->select_node( *q, g, true );
    }      
    select_path( 0, g );
  }
  
  return res;
}

bool ScenarioEventHandler::undo_find_path_sub_group( GraphicArea *g )
{
  bool res = false;
  if ( m_selected_pathes.get_pathes_count() > 0 )
  {
    int i;
    GraphView   *view = m_graph_view_context->get_view();
    EdgeList edges;
    NodeLinkList path_nodes;
    EdgeSet edges_to_add;
    EdgeList::const_iterator p;
      
    for ( i = 0; i < m_selected_pathes.get_pathes_count(); i++ )
    {
      m_selected_pathes.get_path_edges( i, edges );
          
      for ( p = edges.begin(); p != edges.end(); p++ )
        edges_to_add.insert( *p );
    }
      
    unselect_path( m_curr_selected_path, g );
    
    m_selected_pathes.get_path_edges( m_curr_selected_path, edges );
    
    for (p = edges.begin(); p != edges.end(); p++ )
      view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_IN_SCENARIO );
    
    m_curr_selected_path = -1;
    
    res = m_selected_pathes.undo_find_sub_group();
    
    if ( res )
    {
      NodeIndex  start_node = m_selected_pathes.get_init_node();
                 
      view->select_node( start_node, g, true );
        
      for ( i = 0; i < m_selected_pathes.get_pathes_count(); i++ )
      {
        m_selected_pathes.get_path_edges( i, edges );
      
        for ( p = edges.begin(); p != edges.end(); p++ )
          if ( edges_to_add.find( *p ) == edges_to_add.end() )
          {
            view->mark_edge( *p, g, GraphViewPropertiesStorage::EDGE_IN_SCENARIO );
            edges_to_add.insert( *p );
          }
      }
          
      NodeIndexSet end_nodes = m_selected_pathes.get_end_nodes();
      for ( NodeIndexSet::const_iterator q = end_nodes.begin(); q != end_nodes.end(); q++ )
        view->select_node( *q, g, true );
    }
    
    select_path( 0, g );
  }
  
  return res;
}
