
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include "UnixPropertiesDialog.h"
#include <gdk/gdk.h>

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)*/
#  define _(String) (String)
#  define N_(String) (String)
#endif

using namespace GraphGraphics; 

Color GTKViewPropertiesGUI::convert_color(char* text_color)
{
  	char *s_tmp;
  	Color 	c;
  	int		R_item = 0, 
  			G_item = 0, 
  			B_item = 0;

  	s_tmp = strchr(text_color, ',');
  	if (s_tmp != 0)
	{
		*s_tmp = 0;
		R_item = atoi(text_color);
		text_color += strlen(text_color) + 1;
	}
  	s_tmp = strchr(text_color, ',');
  	if (s_tmp != 0)
	{
		*s_tmp = 0;
		G_item = atoi(text_color);
		text_color += strlen(text_color) + 1;
	}
	B_item = atoi(text_color);		
	
	c.set_RGB(RGB(R_item, G_item, B_item));
	
	return c;
}

void GTKViewPropertiesGUI::coose_color( GtkWidget *entry )
{
  char *s_entry;
  char *s_ret;
  Color	  c;	
  char 	  s[20];
  RGB     rgb;	
	
  s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry));
  
  s_ret = new char[strlen(s_entry) + 1];
  s_ret[0] = 0;
  strcpy(s_ret, s_entry);

  c = convert_color(s_ret);
  delete[] s_ret;
	
  c = m_gui->run_choose_color_dialog( c );
  
  rgb = c.get_RGB();
  sprintf(s, "%i,%i,%i", rgb.red, rgb.green, rgb.blue);  
  gtk_entry_set_text (GTK_ENTRY(entry), s);
}

void GTKViewPropertiesGUI::handle_button_Back_Choose_clicked_event( )
{
  coose_color( entry_Back );
}

void GTKViewPropertiesGUI::handle_button_Sel_Choose_clicked_event( )
{
  coose_color( entry_Sel );
}

void GTKViewPropertiesGUI::handle_button_Edge_Choose_clicked_event( )
{
  coose_color( entry_Edge );
}

void GTKViewPropertiesGUI::handle_button_Incoming_Choose_clicked_event( )
{
  coose_color( entry_Incoming );
}

void GTKViewPropertiesGUI::handle_button_Outgoing_Choose_clicked_event( )
{
  coose_color( entry_Outgoing );
}

void GTKViewPropertiesGUI::handle_button_Between_Choose_clicked_event( )
{
  coose_color( entry_Between );
}

void on_button_Back_Choose_clicked( GtkButton *button, gpointer user_data )
{
  GTKViewPropertiesGUI *dialog = (GTKViewPropertiesGUI*)user_data;
  dialog->handle_button_Back_Choose_clicked_event();
}

void on_button_Sel_Choose_clicked( GtkButton *button, gpointer user_data )
{
  GTKViewPropertiesGUI *dialog = (GTKViewPropertiesGUI*)user_data;
  dialog->handle_button_Sel_Choose_clicked_event();
}

void on_button_Edge_Choose_clicked( GtkButton *button, gpointer user_data )
{
  GTKViewPropertiesGUI *dialog = (GTKViewPropertiesGUI*)user_data;
  dialog->handle_button_Edge_Choose_clicked_event();
}

void on_button_Incoming_Choose_clicked( GtkButton *button, gpointer user_data )
{
  GTKViewPropertiesGUI *dialog = (GTKViewPropertiesGUI*)user_data;
  dialog->handle_button_Incoming_Choose_clicked_event();
}

void on_button_Outgoing_Choose_clicked( GtkButton *button, gpointer user_data )
{
  GTKViewPropertiesGUI *dialog = (GTKViewPropertiesGUI*)user_data;
  dialog->handle_button_Outgoing_Choose_clicked_event();
}

void on_button_Between_Choose_clicked( GtkButton *button, gpointer user_data )
{
  GTKViewPropertiesGUI *dialog = (GTKViewPropertiesGUI*)user_data;
  dialog->handle_button_Between_Choose_clicked_event();
}

void GTKViewPropertiesGUI::create()
{
  char	s[20];
  
  prop_dialog = gtk_dialog_new_with_buttons ( _("Properties"), NULL, GTK_DIALOG_MODAL, 
                                                  GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                                  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);

  dialog_vbox1 = GTK_DIALOG (prop_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  notebook4 = gtk_notebook_new ();
  gtk_widget_show (notebook4);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), notebook4, TRUE, TRUE, 0);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (notebook4), vbox7);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox7), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 10);

  table4 = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table4);
  gtk_container_add (GTK_CONTAINER (frame3), table4);
  gtk_table_set_row_spacings (GTK_TABLE (table4), 2);

  label42 = gtk_label_new (_("Hor. distance between nodes:"));
  gtk_widget_show (label42);
  gtk_table_attach (GTK_TABLE (table4), label42, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label42), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label42), 0, 0.5);

  hor_spinbutton_adj = gtk_adjustment_new (1, 2, 1000, 1, 1, 1);
  hor_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (hor_spinbutton_adj), 1, 0); 
  gtk_widget_show (hor_spinbutton);

  gtk_table_attach (GTK_TABLE (table4), hor_spinbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (hor_spinbutton), GTK_UPDATE_IF_VALID);
  gtk_spin_button_set_value( GTK_SPIN_BUTTON( hor_spinbutton ), m_view->get_x_separation() );                    

  label43 = gtk_label_new (_("Vert. distance between nodes:"));
  gtk_widget_show (label43);
  gtk_table_attach (GTK_TABLE (table4), label43, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label43), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label43), 0, 0.5);

  vert_spinbutton_adj = gtk_adjustment_new (1, 2, 1000, 1, 1, 1);
  vert_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (vert_spinbutton_adj), 1, 0); 
  gtk_widget_show (vert_spinbutton);

  gtk_table_attach (GTK_TABLE (table4), vert_spinbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (vert_spinbutton), GTK_UPDATE_IF_VALID);
  gtk_spin_button_set_value( GTK_SPIN_BUTTON( vert_spinbutton ), m_view->get_y_separation() );

  label45 = gtk_label_new (_("Node radius"));
  gtk_widget_show (label45);
  gtk_table_attach (GTK_TABLE (table4), label45, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label45), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label45), 0, 0.5);

  radius_spinbutton_adj = gtk_adjustment_new (1, 2, 100, 1, 1, 1);
  radius_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (radius_spinbutton_adj), 1, 0); 
  gtk_widget_show (radius_spinbutton);
  gtk_table_attach (GTK_TABLE (table4), radius_spinbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (radius_spinbutton), GTK_UPDATE_IF_VALID);
  gtk_spin_button_set_value( GTK_SPIN_BUTTON( radius_spinbutton ), m_view->get_radius() );

  label40 = gtk_label_new (_("Basic layout options"));
  gtk_widget_show (label40);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label40);
  gtk_label_set_justify (GTK_LABEL (label40), GTK_JUSTIFY_LEFT);

  frame4 = gtk_frame_new (NULL);
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (vbox7), frame4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 10);

  checkbutton_Spline = gtk_check_button_new_with_mnemonic (_("Spline interpolation"));
  gtk_widget_show (checkbutton_Spline);
  gtk_container_add (GTK_CONTAINER (frame4), checkbutton_Spline);
  if (m_view->is_spline_interpltn())
  	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_Spline), TRUE);
  else
  	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_Spline), FALSE);
  
  label44 = gtk_label_new (_("Edge drawing style"));
  gtk_widget_show (label44);
  gtk_frame_set_label_widget (GTK_FRAME (frame4), label44);
  gtk_label_set_justify (GTK_LABEL (label44), GTK_JUSTIFY_LEFT);

  label37 = gtk_label_new (_("Graph layout options"));
  gtk_widget_show (label37);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook4), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook4), 0), label37);
  gtk_label_set_justify (GTK_LABEL (label37), GTK_JUSTIFY_LEFT);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (notebook4), vbox8);

  frame5 = gtk_frame_new (NULL);
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (vbox8), frame5, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 10);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox9);
  gtk_container_add (GTK_CONTAINER (frame5), vbox9);
  
  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox9), hbox3, TRUE, TRUE, 0);

  label59 = gtk_label_new (_("Background color (R,G,B):     "));
  gtk_widget_show (label59);
  gtk_box_pack_start (GTK_BOX (hbox3), label59, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label59), GTK_JUSTIFY_LEFT);

  entry_Back = gtk_entry_new ();
  gtk_widget_show (entry_Back);
  gtk_box_pack_start (GTK_BOX (hbox3), entry_Back, TRUE, TRUE, 0);

  Color c_back = m_view->get_view_properties_storage().get_background_color();    
  sprintf(s, "%i,%i,%i", c_back.get_RGB().red, c_back.get_RGB().green, c_back.get_RGB().blue);    
  gtk_entry_set_text (GTK_ENTRY (entry_Back), s);  

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (hbox3), hbuttonbox1, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 0);

  button_Back_Choose = gtk_button_new_with_mnemonic (_("Choose..."));
  gtk_widget_show (button_Back_Choose);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_Back_Choose);
  GTK_WIDGET_SET_FLAGS (button_Back_Choose, GTK_CAN_DEFAULT);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox9), hbox4, TRUE, TRUE, 0);

  label60 = gtk_label_new (_("Selected nodes color (R,G,B):"));
  gtk_widget_show (label60);
  gtk_box_pack_start (GTK_BOX (hbox4), label60, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label60), GTK_JUSTIFY_LEFT);

  entry_Sel = gtk_entry_new ();
  gtk_widget_show (entry_Sel);
  gtk_box_pack_start (GTK_BOX (hbox4), entry_Sel, TRUE, TRUE, 0);
  
  Color c_sel = m_view->get_view_properties_storage().get_selected_node_color();    
  sprintf(s, "%i,%i,%i", c_sel.get_RGB().red, c_sel.get_RGB().green, c_sel.get_RGB().blue);    
  gtk_entry_set_text (GTK_ENTRY (entry_Sel), s);  

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (hbox4), hbuttonbox2, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox2), 0);

  button_Sel_Choose = gtk_button_new_with_mnemonic (_("Choose.."));
  gtk_widget_show (button_Sel_Choose);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), button_Sel_Choose);
  GTK_WIDGET_SET_FLAGS (button_Sel_Choose, GTK_CAN_DEFAULT);

  label50 = gtk_label_new (_("Colors"));
  gtk_widget_show (label50);
  gtk_frame_set_label_widget (GTK_FRAME (frame5), label50);
  gtk_label_set_justify (GTK_LABEL (label50), GTK_JUSTIFY_LEFT);

  frame6 = gtk_frame_new (NULL);
  gtk_widget_show (frame6);
  gtk_box_pack_start (GTK_BOX (vbox8), frame6, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame6), 10);
  
//  label_e_f = gtk_label_new (_("Edge width"));
//  gtk_widget_show (label_e_f);
//  gtk_frame_set_label_widget (GTK_FRAME (frame6), label_e_f);
//  gtk_label_set_justify (GTK_LABEL (label_e_f), GTK_JUSTIFY_LEFT);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (frame6), hbox6);
  
  label_edge_w = gtk_label_new (_("Edge width:                              "));
  gtk_widget_show (label_edge_w);
  gtk_box_pack_start (GTK_BOX (hbox6), label_edge_w, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label_edge_w), GTK_JUSTIFY_LEFT);
  
  pen_spinbutton_adj = gtk_adjustment_new (1, 1, 5, 1, 1, 1);
  pen_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (pen_spinbutton_adj), 1, 0);
  gtk_widget_show (pen_spinbutton);
  gtk_box_pack_start (GTK_BOX (hbox6), pen_spinbutton, TRUE, TRUE, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (pen_spinbutton), GTK_UPDATE_IF_VALID);
  gtk_spin_button_set_value( GTK_SPIN_BUTTON( pen_spinbutton ), m_view->get_view_properties_storage().get_edge_pen().get_line_width() );
    
  label38 = gtk_label_new (_("General settings"));
  gtk_widget_show (label38);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook4), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook4), 1), label38);
  gtk_label_set_justify (GTK_LABEL (label38), GTK_JUSTIFY_LEFT);
  
////////////////////////////////////////////////////////////////////////////////////////////////////////  
  edge_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (edge_vbox);
  gtk_container_add (GTK_CONTAINER (notebook4), edge_vbox);

  edge_frame = gtk_frame_new (NULL);
  gtk_widget_show (edge_frame);
  gtk_box_pack_start (GTK_BOX (edge_vbox), edge_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (edge_frame), 10);

  edge_frame_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (edge_frame_vbox);
  gtk_container_add (GTK_CONTAINER (edge_frame), edge_frame_vbox);
///  
  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (edge_frame_vbox), hbox5, TRUE, TRUE, 0);
  
  label_edge_c = gtk_label_new (_("Default edge color:                    "));
  gtk_widget_show (label_edge_c);
  gtk_box_pack_start (GTK_BOX (hbox5), label_edge_c, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_edge_c), GTK_JUSTIFY_LEFT);

  entry_Edge = gtk_entry_new ();
  gtk_widget_show (entry_Edge);
  gtk_box_pack_start (GTK_BOX (hbox5), entry_Edge, TRUE, TRUE, 0);
  
  Color c = m_view->get_view_properties_storage().get_edge_color();    
  sprintf(s, "%i,%i,%i", c.get_RGB().red, c.get_RGB().green, c.get_RGB().blue);    
  gtk_entry_set_text (GTK_ENTRY (entry_Edge), s);  

  hbuttonbox3 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox3);
  gtk_box_pack_start (GTK_BOX (hbox5), hbuttonbox3, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox3), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox3), 0);

  button_Edge_Choose = gtk_button_new_with_mnemonic (_("Choose.."));
  gtk_widget_show (button_Edge_Choose);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), button_Edge_Choose);
  GTK_WIDGET_SET_FLAGS (button_Edge_Choose, GTK_CAN_DEFAULT);
  
///  
  incoming_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (incoming_hbox);
  gtk_box_pack_start (GTK_BOX (edge_frame_vbox), incoming_hbox, TRUE, TRUE, 0);

  incoming_label = gtk_label_new (_("Incoming into selected nodes:  "));
  gtk_widget_show (incoming_label);
  gtk_box_pack_start (GTK_BOX (incoming_hbox), incoming_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (incoming_label), GTK_JUSTIFY_LEFT);

  entry_Incoming = gtk_entry_new ();
  gtk_widget_show (entry_Incoming);
  gtk_box_pack_start (GTK_BOX (incoming_hbox), entry_Incoming, TRUE, TRUE, 0);

  c = m_view->get_view_properties_storage().get_incoming_edge_color();    
  sprintf(s, "%i,%i,%i", c.get_RGB().red, c.get_RGB().green, c.get_RGB().blue);    
  gtk_entry_set_text (GTK_ENTRY (entry_Incoming), s);  

  incoming_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_show (incoming_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (incoming_hbox), incoming_hbuttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (incoming_hbuttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (incoming_hbuttonbox), 0);

  button_Incoming_Choose = gtk_button_new_with_mnemonic (_("Choose..."));
  gtk_widget_show (button_Incoming_Choose);
  gtk_container_add (GTK_CONTAINER (incoming_hbuttonbox), button_Incoming_Choose);
  GTK_WIDGET_SET_FLAGS (button_Incoming_Choose, GTK_CAN_DEFAULT);
////

  outgoing_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (outgoing_hbox);
  gtk_box_pack_start (GTK_BOX (edge_frame_vbox), outgoing_hbox, TRUE, TRUE, 0);

  outgoing_label = gtk_label_new (_("Outgoing from selected nodes:"));
  gtk_widget_show (outgoing_label);
  gtk_box_pack_start (GTK_BOX (outgoing_hbox), outgoing_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (outgoing_label), GTK_JUSTIFY_LEFT);

  entry_Outgoing = gtk_entry_new ();
  gtk_widget_show (entry_Outgoing);
  gtk_box_pack_start (GTK_BOX (outgoing_hbox), entry_Outgoing, TRUE, TRUE, 0);

  c = m_view->get_view_properties_storage().get_outgoing_edge_color();    
  sprintf(s, "%i,%i,%i", c.get_RGB().red, c.get_RGB().green, c.get_RGB().blue);    
  gtk_entry_set_text (GTK_ENTRY (entry_Outgoing), s);  

  outgoing_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_show (outgoing_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (outgoing_hbox), outgoing_hbuttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (outgoing_hbuttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (outgoing_hbuttonbox), 0);

  button_Outgoing_Choose = gtk_button_new_with_mnemonic (_("Choose..."));
  gtk_widget_show (button_Outgoing_Choose);
  gtk_container_add (GTK_CONTAINER (outgoing_hbuttonbox), button_Outgoing_Choose);
  GTK_WIDGET_SET_FLAGS (button_Outgoing_Choose, GTK_CAN_DEFAULT);
////

  between_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (between_hbox);
  gtk_box_pack_start (GTK_BOX (edge_frame_vbox), between_hbox, TRUE, TRUE, 0);

  between_label = gtk_label_new (_("Between selected nodes:         "));
  gtk_widget_show (between_label);
  gtk_box_pack_start (GTK_BOX (between_hbox), between_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (between_label), GTK_JUSTIFY_LEFT);

  entry_Between = gtk_entry_new ();
  gtk_widget_show (entry_Between);
  gtk_box_pack_start (GTK_BOX (between_hbox), entry_Between, TRUE, TRUE, 0);

  c = m_view->get_view_properties_storage().get_selected_edge_color();    
  sprintf(s, "%i,%i,%i", c.get_RGB().red, c.get_RGB().green, c.get_RGB().blue);    
  gtk_entry_set_text (GTK_ENTRY (entry_Between), s);  

  between_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_show (between_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (between_hbox), between_hbuttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (between_hbuttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (between_hbuttonbox), 0);

  button_Between_Choose = gtk_button_new_with_mnemonic (_("Choose..."));
  gtk_widget_show (button_Between_Choose);
  gtk_container_add (GTK_CONTAINER (between_hbuttonbox), button_Between_Choose);
  GTK_WIDGET_SET_FLAGS (button_Between_Choose, GTK_CAN_DEFAULT);
///

  edge_page_label = gtk_label_new (_("Edge setings"));
  gtk_widget_show (edge_page_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook4), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook4), 2), edge_page_label);
  gtk_label_set_justify (GTK_LABEL (edge_page_label), GTK_JUSTIFY_LEFT);
////////////////////////////////////////////////////////////////////////////////

  gtk_signal_connect (GTK_OBJECT (button_Back_Choose), "clicked",
                      GTK_SIGNAL_FUNC (on_button_Back_Choose_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (button_Sel_Choose), "clicked",
                      GTK_SIGNAL_FUNC (on_button_Sel_Choose_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (button_Edge_Choose), "clicked",
                      GTK_SIGNAL_FUNC (on_button_Edge_Choose_clicked),
                      (gpointer)this);

  gtk_signal_connect (GTK_OBJECT (button_Incoming_Choose), "clicked",
                      GTK_SIGNAL_FUNC (on_button_Incoming_Choose_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (button_Outgoing_Choose), "clicked",
                      GTK_SIGNAL_FUNC (on_button_Outgoing_Choose_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (button_Between_Choose), "clicked",
                      GTK_SIGNAL_FUNC (on_button_Between_Choose_clicked),
                      (gpointer)this);

}


int GTKViewPropertiesGUI::run( )
{
  create();
  
  gint result = gtk_dialog_run( GTK_DIALOG(prop_dialog) );
  
  char *s_entry;
  char *s_ret;
  int hor_sep;
  int vert_sep;    
  int radius;
  int		ret = NEED_REDRAW_ONLY;
  Color 	c;
  
  switch( result )
  {
  case GTK_RESPONSE_OK:
    hor_sep = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( hor_spinbutton ) );
    if ( hor_sep != m_view->get_x_separation() )
	  {
      ret = NEED_EDGES_RECONSTRUCTION;
      m_view->set_x_separation(hor_sep);
    }

    vert_sep = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( vert_spinbutton ) );
    if ( vert_sep != m_view->get_y_separation() )
	  {
      ret = NEED_EDGES_RECONSTRUCTION;
      m_view->set_y_separation(vert_sep);  
    }
  
    radius = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( radius_spinbutton ) );
    if ( radius != m_view->get_radius() )
	  {
      ret = NEED_EDGES_RECONSTRUCTION;
      m_view->set_radius(radius);  
    }

	  s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry_Back));
  
  	s_ret = new char[strlen(s_entry) + 1];
  	s_ret[0] = 0;
  	strcpy(s_ret, s_entry);

	  c = convert_color(s_ret);
  	m_view->get_view_properties_storage().set_background_color(c);  

	  delete[] s_ret;
	
	  s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry_Sel));
  
  	s_ret = new char[strlen(s_entry) + 1];
  	s_ret[0] = 0;
  	strcpy(s_ret, s_entry);

	  c = convert_color(s_ret);	
	  m_view->get_view_properties_storage().set_selected_node_color(c);

    s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry_Edge));
  
  	s_ret = new char[strlen(s_entry) + 1];
  	s_ret[0] = 0;
  	strcpy(s_ret, s_entry);

	  c = convert_color(s_ret);	
	  m_view->get_view_properties_storage().set_edge_color(c);

	  delete[] s_ret;
    
    s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry_Incoming));
  
  	s_ret = new char[strlen(s_entry) + 1];
  	s_ret[0] = 0;
  	strcpy(s_ret, s_entry);

	  c = convert_color(s_ret);	
	  m_view->get_view_properties_storage().set_incoming_edge_color(c);

	  delete[] s_ret;
    
    s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry_Outgoing));
  
  	s_ret = new char[strlen(s_entry) + 1];
  	s_ret[0] = 0;
  	strcpy(s_ret, s_entry);

	  c = convert_color(s_ret);	
	  m_view->get_view_properties_storage().set_outgoing_edge_color(c);

	  delete[] s_ret;
    
    s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (entry_Between));
  
  	s_ret = new char[strlen(s_entry) + 1];
  	s_ret[0] = 0;
  	strcpy(s_ret, s_entry);

	  c = convert_color(s_ret);	
	  m_view->get_view_properties_storage().set_selected_edge_color(c);

	  delete[] s_ret;
    
    radius = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( pen_spinbutton ) );
    m_view->get_view_properties_storage().set_edge_pen( DrawingPen( DrawingPen::SOLID, radius) );
	
	  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton_Spline)))
	    m_view->set_spline_interpltn(true);
    else
      m_view->set_spline_interpltn(false);		
    
    break;
  
  default:
	  ret = PROPERTIES_UNCHANGED;
  }
  
  m_changes_level = ret;
  
  gtk_widget_destroy( prop_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
