#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>

#include "UnixPreferenceDialog.h"

#include <fstream>

using namespace GraphGraphics;

bool GTKPreferenceGUI::find_in_list( const string &name, GtkTreeIter *res_iter )
{
  GtkTreeIter iter;
  bool        res       = false;
  char       *comp_name = 0;
  
  if ( gtk_tree_model_get_iter_first( list_model, &iter ) )
  {
    res = true;
    gtk_tree_model_get( list_model, &iter, 0, &comp_name, -1 );
    
    while ( res )
    {
      if ( string( comp_name ) == name )
        break;

      res = (bool)gtk_tree_model_iter_next( list_model, &iter );    
    
      if ( res )
        gtk_tree_model_get( list_model, &iter, 0, &comp_name, -1 );
    }
    
    if ( res && res_iter != 0 )
      (*res_iter) = iter;
  }
  
  return res;
}

bool GTKPreferenceGUI::add_to_list( const string &name, GtkTreeIter *res_iter )
{
  bool res = false;
  
  if ( !find_in_list( name, res_iter ) )
  {
    GtkTreeIter iter;
    res = true;
    gtk_list_store_append( GTK_LIST_STORE(list_model), &iter );
    gtk_list_store_set( GTK_LIST_STORE(list_model), &iter, 0, name.c_str(), -1 );
    
    if ( res_iter != 0 )
      (*res_iter) = iter;
  }
  
  return res;
}

void GTKPreferenceGUI::on_add()
{
  const char *name = gtk_entry_get_text( GTK_ENTRY(comp_combo_entry) );
  
  if ( name != 0 )
  {
    GtkTreeIter iter;
    string comp_name = name;
    
    if ( !comp_name.empty() )
    {
      add_to_list( comp_name, &iter );
    
      GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( comp_treeview ) );
    
      gtk_tree_selection_select_iter( selection, &iter );
    }
  }
}

void GTKPreferenceGUI::on_delete()
{
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( comp_treeview ) );
  GtkTreeIter       sel_iter;
  
  if ( gtk_tree_selection_get_selected( selection, &list_model, &sel_iter) )
    gtk_list_store_remove( GTK_LIST_STORE( list_model ), &sel_iter );
}
void on_add_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKPreferenceGUI* pref = (GTKPreferenceGUI *)user_data;
  pref->on_add();
}


void on_delete_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKPreferenceGUI* pref = (GTKPreferenceGUI *)user_data;
  pref->on_delete();
}

void GTKPreferenceGUI::create()
{
  GtkTreeViewColumn *column;
  GtkCellRenderer   *render;
  
  core_preferences = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (core_preferences), "Preferences");

  dialog_vbox = GTK_DIALOG (core_preferences)->vbox;
  gtk_widget_show (dialog_vbox);

  pref_notebook = gtk_notebook_new ();
  gtk_widget_show (pref_notebook);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), pref_notebook, TRUE, TRUE, 0);

  graph_view_table = gtk_table_new (2, 1, FALSE);
  gtk_widget_show (graph_view_table);
  gtk_container_add (GTK_CONTAINER (pref_notebook), graph_view_table);

  layout_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (layout_combo)->popwin),
                       "GladeParentKey", layout_combo);
  gtk_widget_show (layout_combo);
  gtk_table_attach (GTK_TABLE (graph_view_table), layout_combo, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Arbitrary size");
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Fit to window");
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Fit to window width");
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Fit to window height");
  gtk_combo_set_popdown_strings (GTK_COMBO (layout_combo), layout_combo_items);
  g_list_free (layout_combo_items);
  layout_combo_items = NULL;

  layout_combo_entry = GTK_COMBO (layout_combo)->entry;
  gtk_widget_show (layout_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (layout_combo_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Arbitrary size");

  layout_label = gtk_label_new ("Default graph layout:");
  gtk_widget_show (layout_label);
  gtk_table_attach (GTK_TABLE (graph_view_table), layout_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 2);
  gtk_label_set_justify (GTK_LABEL (layout_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (layout_label), 0, 0.5);

  view_page_label = gtk_label_new ("View preferences");
  gtk_widget_show (view_page_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_notebook), 0), view_page_label);
  gtk_label_set_justify (GTK_LABEL (view_page_label), GTK_JUSTIFY_LEFT);

  comp_table = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (comp_table);
  gtk_container_add (GTK_CONTAINER (pref_notebook), comp_table);

  comp_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (comp_scrolledwindow);
  gtk_table_attach (GTK_TABLE (comp_table), comp_scrolledwindow, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 2, 2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (comp_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (comp_scrolledwindow), GTK_SHADOW_IN);

  list_model = (GtkTreeModel *)gtk_list_store_new( 1, G_TYPE_STRING );
  
  comp_treeview = gtk_tree_view_new_with_model( list_model );
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "", render, "text", 0, NULL );
  gtk_tree_view_append_column( GTK_TREE_VIEW( comp_treeview ), column );
  gtk_widget_show (comp_treeview);
  gtk_container_add (GTK_CONTAINER (comp_scrolledwindow), comp_treeview);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (comp_treeview), FALSE);

  comp_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (comp_combo)->popwin),
                       "GladeParentKey", comp_combo);
  gtk_widget_show (comp_combo);
  gtk_table_attach (GTK_TABLE (comp_table), comp_combo, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 2, 2);
  
  if ( m_comp_manager->count_registered_components() > 0 )
  {
    string            str_name;
    CompInterface    *component;
    ComponentIndex    i = 0;
  
    for ( i = 0; i < m_comp_manager->count_registered_components(); i++ )
    {
      component = m_comp_manager->get_registered_component( i ); 
      str_name = component->get_component_name();
      comp_combo_items = g_list_append (comp_combo_items, (gpointer) (str_name.c_str()) );
    }
    
    gtk_combo_set_popdown_strings (GTK_COMBO (comp_combo), comp_combo_items);
    g_list_free (comp_combo_items);
    comp_combo_items = NULL;
  }
  
  comp_combo_entry = GTK_COMBO (comp_combo)->entry;
  gtk_widget_show (comp_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (comp_combo_entry), FALSE);
  
  add_button = gtk_button_new_with_mnemonic ("Add");
  gtk_widget_show (add_button);
  gtk_table_attach (GTK_TABLE (comp_table), add_button, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  delete_button = gtk_button_new_with_mnemonic ("Remove");
  gtk_widget_show (delete_button);
  gtk_table_attach (GTK_TABLE (comp_table), delete_button, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  comp_page_label = gtk_label_new ("Active components");
  gtk_widget_show (comp_page_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_notebook), 1), comp_page_label);
  gtk_label_set_justify (GTK_LABEL (comp_page_label), GTK_JUSTIFY_LEFT);
  
  modes_table = gtk_table_new (8, 2, FALSE);
  gtk_widget_show (modes_table);
  gtk_container_add (GTK_CONTAINER (pref_notebook), modes_table);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (pref_notebook), modes_table,
                                      TRUE, TRUE, GTK_PACK_START);

  single_aw_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (single_aw_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), single_aw_checkbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (single_aw_checkbutton, GTK_CAN_FOCUS);

  single_iw_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (single_iw_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), single_iw_checkbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (single_iw_checkbutton, GTK_CAN_FOCUS);

  show_a_on_mm_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (show_a_on_mm_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), show_a_on_mm_checkbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (show_a_on_mm_checkbutton, GTK_CAN_FOCUS);

  close_ld_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (close_ld_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), close_ld_checkbutton, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (close_ld_checkbutton, GTK_CAN_FOCUS);

  edge_s_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (edge_s_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), edge_s_checkbutton, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (edge_s_checkbutton, GTK_CAN_FOCUS);

  iw_label = gtk_label_new ("Single Information Window:");
  gtk_widget_show (iw_label);
  gtk_table_attach (GTK_TABLE (modes_table), iw_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (iw_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (iw_label), 0, 0.5);

  aw_label = gtk_label_new ("Single Attributes Window:");
  gtk_widget_show (aw_label);
  gtk_table_attach (GTK_TABLE (modes_table), aw_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (aw_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (aw_label), 0, 0.5);

  mm_label = gtk_label_new ("Show Attributes if the mouse is over a node:");
  gtk_widget_show (mm_label);
  gtk_table_attach (GTK_TABLE (modes_table), mm_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (mm_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (mm_label), 0, 0.5);

  cl_label = gtk_label_new ("Close Graph Load Window after a graph loading:");
  gtk_widget_show (cl_label);
  gtk_table_attach (GTK_TABLE (modes_table), cl_label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (cl_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (cl_label), 0, 0.5);

  es_label = gtk_label_new ("Edge selecting mode:");
  gtk_widget_show (es_label);
  gtk_table_attach (GTK_TABLE (modes_table), es_label, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (es_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (es_label), 0, 0.5);
  
  select_attr_label = gtk_label_new ("Show Attributes Window if an individual node is selected:");
  gtk_widget_show (select_attr_label);
  gtk_table_attach (GTK_TABLE (modes_table), select_attr_label, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (select_attr_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (select_attr_label), 0, 0.5);

  select_attr_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (select_attr_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), select_attr_checkbutton, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (select_attr_checkbutton, GTK_CAN_FOCUS);
  
  aliases_label = gtk_label_new ("Use attribute aliases:");
  gtk_widget_show (aliases_label);
  gtk_table_attach (GTK_TABLE (modes_table), aliases_label, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (aliases_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (aliases_label), 0, 0.5);

  aliases_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (aliases_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), aliases_checkbutton, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (aliases_checkbutton, GTK_CAN_FOCUS);
  
  graph_metrics_label = gtk_label_new ("Display graph metrics on graph load:");
  gtk_widget_show (graph_metrics_label);
  gtk_table_attach (GTK_TABLE (modes_table), graph_metrics_label, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (graph_metrics_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (graph_metrics_label), 0, 0.5);

  graph_metrics_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (graph_metrics_checkbutton);
  gtk_table_attach (GTK_TABLE (modes_table), graph_metrics_checkbutton, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (graph_metrics_checkbutton, GTK_CAN_FOCUS);

  modes_page_label = gtk_label_new ("Modes");
  gtk_widget_show (modes_page_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_notebook), 2), modes_page_label);
  gtk_label_set_justify (GTK_LABEL (modes_page_label), GTK_JUSTIFY_LEFT);

  dialog_action_area1 = GTK_DIALOG (core_preferences)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
  
  docking_table = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (docking_table);
  gtk_container_add (GTK_CONTAINER (pref_notebook), docking_table);

  attr_dock_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (attr_dock_checkbutton);
  gtk_table_attach (GTK_TABLE (docking_table), attr_dock_checkbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (attr_dock_checkbutton, GTK_CAN_FOCUS);

  info_dock_label = gtk_label_new ("Dock Information Window on start:");
  gtk_widget_show (info_dock_label);
  gtk_table_attach (GTK_TABLE (docking_table), info_dock_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (info_dock_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (info_dock_label), 0, 0.5);

  attr_dock_label = gtk_label_new ("Dock Attributes Window on start:");
  gtk_widget_show (attr_dock_label);
  gtk_table_attach (GTK_TABLE (docking_table), attr_dock_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 2, 0);
  gtk_label_set_justify (GTK_LABEL (attr_dock_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (attr_dock_label), 0, 0.5);

  info_dock_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (info_dock_checkbutton);
  gtk_table_attach (GTK_TABLE (docking_table), info_dock_checkbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (info_dock_checkbutton, GTK_CAN_FOCUS);

  docking_page_label = gtk_label_new ("Docking");
  gtk_widget_show (docking_page_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_notebook), 3), docking_page_label);
  gtk_label_set_justify (GTK_LABEL (docking_page_label), GTK_JUSTIFY_LEFT);


  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (core_preferences), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (core_preferences), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
                      GTK_SIGNAL_FUNC (on_delete_button_clicked),
                      (gpointer)this);



  switch (m_view->get_layout())
  {
    case GraphView::FIT_TO_WINDOW:
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window");
      break;
    case GraphView::FIT_TO_WIDTH:      
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window width");
      break;
    case GraphView::FIT_TO_HEIGHT:
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window height");
      break;
    case GraphView::ARBITRARY_SIZE:      
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Arbitrary size");
      break;
  }
}

int GTKPreferenceGUI::run()
{
  char      *s_entry;
  char      *home_path = getenv("HOME");
  char      pref_path[255];
  short     len = 0;
  char      bvalue = 0;
  long      modes, extra_modes;
  bool      res = true;  
  ofstream  out_stream;
  unsigned char layout;
      
  create();
  
  sprintf(pref_path, "%s/.sgraph/preferences", home_path);
  
  ifstream   in_stream( (const char*)pref_path );
  
  if ( in_stream.is_open() )
  {
    Storable::read_1bytes( in_stream, bvalue );
    
    switch ( (StyleFlags)bvalue )
    {
      case GraphView::FIT_TO_WINDOW:
        gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window");
        break;
      case GraphView::FIT_TO_WIDTH:      
        gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window width");
        break;
      case GraphView::FIT_TO_HEIGHT:
        gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window height");
        break;
      case GraphView::ARBITRARY_SIZE:  
      default:        
        gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Arbitrary size");
    }
    
    res = Storable::read_4bytes( in_stream, modes );
    
    if ( res )
    {
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( single_iw_checkbutton ), modes & ScenarioApp::SINGLE_INFO_WINDOW );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( single_aw_checkbutton ), modes & ScenarioApp::SINGLE_ATTR_WINDOW );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( show_a_on_mm_checkbutton ), modes & ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( close_ld_checkbutton ), modes & ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( edge_s_checkbutton ), modes & ScenarioApp::EDGE_SELECTING );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( select_attr_checkbutton ), modes & ScenarioApp::SHOW_ATTR_ON_NODE_SELECT );
    }
    
    in_stream.seekg( EXTRA_BEHAVIOR_MODES );
    
    res = Storable::read_4bytes( in_stream, extra_modes );
    
    if ( res )
    {
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( info_dock_checkbutton ), extra_modes & ScenarioApp::DOCK_INFO_ON_START );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( attr_dock_checkbutton ), extra_modes & ScenarioApp::DOCK_ATTR_ON_START );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( aliases_checkbutton ), extra_modes & ScenarioApp::USE_ATTR_ALIASES );
      gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( graph_metrics_checkbutton ), extra_modes & ScenarioApp::OUTPUT_GEN_GRAPH_METRICS );
    }
    
    in_stream.seekg( ACTIVE_COMP_OFF );
    
    res = Storable::read_2bytes( in_stream, len );
    
    if ( len != 0 && res )
    {
      unsigned short pos = 0;
      char           name_len = 0;
      char           buff[256];
      
      while ( pos < (unsigned short)len && res )
      {
        res = Storable::read_1bytes( in_stream, name_len );
        
        if ( res )
        {
          buff[(unsigned char)name_len] = 0;
          res = Storable::read_bytes( in_stream, buff, name_len );
          
          if ( res )
            add_to_list( string( buff ) );
        }
        pos += 1 + name_len;
      }
    }
    in_stream.close();
  }
  
  
  gint result = gtk_dialog_run( GTK_DIALOG(core_preferences) );
  
  modes = 0;
  extra_modes = 0;
  
  switch( result )
  {
  case GTK_RESPONSE_OK:
    s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (layout_combo_entry));
    
    layout = GraphView::ARBITRARY_SIZE;
    if (strcmp(s_entry, "Fit to window") == 0)
      layout = GraphView::FIT_TO_WINDOW;
    else if (strcmp(s_entry, "Fit to window width") == 0)
      layout = GraphView::FIT_TO_WIDTH;
    else if (strcmp(s_entry, "Fit to window height") == 0)
      layout = GraphView::FIT_TO_HEIGHT;
    else if (strcmp(s_entry, "Arbitrary size") == 0)
      layout = GraphView::ARBITRARY_SIZE;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(single_iw_checkbutton)) )
      modes |= ScenarioApp::SINGLE_INFO_WINDOW;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(single_aw_checkbutton)) )
      modes |= ScenarioApp::SINGLE_ATTR_WINDOW;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(show_a_on_mm_checkbutton)) )
      modes |= ScenarioApp::SHOW_ATTR_ON_MOUSE_OVER;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(close_ld_checkbutton)) )
      modes |= ScenarioApp::CLOSE_OPEN_DIALOG_AFTER_GRAPH_LOAD;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(edge_s_checkbutton)) )
      modes |= ScenarioApp::EDGE_SELECTING;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(select_attr_checkbutton)) )
      modes |= ScenarioApp::SHOW_ATTR_ON_NODE_SELECT;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(info_dock_checkbutton)) )
      extra_modes |= ScenarioApp::DOCK_INFO_ON_START;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(attr_dock_checkbutton)) )
      extra_modes |= ScenarioApp::DOCK_ATTR_ON_START;
    
    if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(aliases_checkbutton)) )
      extra_modes |= ScenarioApp::USE_ATTR_ALIASES;
    
    if ( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( graph_metrics_checkbutton )) )
      extra_modes |= ScenarioApp::OUTPUT_GEN_GRAPH_METRICS;
    
    out_stream.open( (const char*)pref_path );
    
    if ( out_stream.is_open() )
    {
      GtkTreeIter iter;
      CompInterface    *component;
      ComponentIndex i;
      map<ComponentIndex, int> comp_activity;
      long   reserved_val = 0;
                  
      out_stream.put( layout );
      
      Storable::write_4bytes( out_stream, modes );
      
      //Storable::write_4bytes( out_stream, reserved_val );
      Storable::write_4bytes( out_stream, extra_modes );
      
      Storable::write_4bytes( out_stream, reserved_val );
      
      for ( i = 0; i < m_comp_manager->count_registered_components(); i++ )
           comp_activity[i] = 0;
      
      if ( gtk_tree_model_get_iter_first( list_model, &iter ) )
      {
        gboolean valid = TRUE;
        char        *name;
        string      comp_name;
        GtkTreeIter root_iter = iter;
        
        unsigned short comp_len = 0;
        
        while ( valid )
        {
          gtk_tree_model_get( list_model, &iter, 0, &name, -1 );
          
          comp_name = string( name );
          comp_len += 1 + comp_name.length();

          valid = (bool)gtk_tree_model_iter_next( list_model, &iter );    
        }
        
        Storable::write_2bytes( out_stream, comp_len );
        
               
        iter = root_iter;
        valid = TRUE;
        while ( valid )
        {
          gtk_tree_model_get( list_model, &iter, 0, &name, -1 );
          
          comp_name = string( name );
          
          for ( i = 0; i < m_comp_manager->count_registered_components(); i++ )
          {
            component = m_comp_manager->get_registered_component( i ); 
        
            if ( component->get_component_name() == comp_name )
              comp_activity[i] = 1;
          }
          
          Storable::write_1bytes( out_stream, (unsigned char) comp_name.length() );
          Storable::write_bytes( out_stream, (char*) comp_name.c_str(), comp_name.length() );
              
          valid = (bool)gtk_tree_model_iter_next( list_model, &iter );    
        }
      }
      out_stream.close( );
      
      if ( m_apply )
      {
        m_view->set_layout( layout );
        for ( i = 0; i < m_comp_manager->count_registered_components(); i++ )
        {
          component = m_comp_manager->get_registered_component( i ); 
          component->set_component_active( (comp_activity[i] == 1) );
        }
        m_comp_manager->set_behavior_modes( m_comp_manager->get_behavior_modes(), false );
        m_comp_manager->set_behavior_modes( modes, true );
        m_comp_manager->set_extra_behavior_modes( m_comp_manager->get_extra_behavior_modes(), false );
        m_comp_manager->set_extra_behavior_modes( extra_modes, true );
      }
    }
  
    break;
  
  default:
    break;
  }
  
  gtk_widget_destroy( core_preferences );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}

