

#include "UnixCompManGUI.h"
#include "../OS_indep/CompInterface.h"

using namespace GraphGraphics;

void GTKComponentManagerGUI::handle_set_active_button_clicked_event()
{
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( inactive_treeview ) );
  
  GtkTreeIter       sel_iter;
  GtkTreeIter       iter;
  GtkTreeModel     *inactive_model;
  GtkTreeModel     *active_model = gtk_tree_view_get_model( GTK_TREE_VIEW( active_treeview ) );
  char             *comp_name = 0;
  int               ind;
  
  if ( gtk_tree_selection_get_selected( selection, &inactive_model, &sel_iter) )
  {
    gtk_tree_model_get( inactive_model, &sel_iter, 0, &comp_name, 1, &ind, -1 );
    gtk_list_store_remove( GTK_LIST_STORE( inactive_model ), &sel_iter );
    
    gtk_list_store_append( GTK_LIST_STORE( active_model ), &iter );
  
    gtk_list_store_set( GTK_LIST_STORE(active_model), &iter, 0, comp_name, 1, ind, -1 );
  }
}

void GTKComponentManagerGUI::handle_set_inactive_button_clicked_event()
{
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( active_treeview ) );
  
  GtkTreeIter       sel_iter;
  GtkTreeIter       iter;
  GtkTreeModel     *active_model;
  GtkTreeModel     *inactive_model = gtk_tree_view_get_model( GTK_TREE_VIEW( inactive_treeview ) );
  char             *comp_name = 0;
  int               ind;
  
  if ( gtk_tree_selection_get_selected( selection, &active_model, &sel_iter) )
  {
    gtk_tree_model_get( active_model, &sel_iter, 0, &comp_name, 1, &ind, -1 );
    gtk_list_store_remove( GTK_LIST_STORE( active_model ), &sel_iter );
    
    gtk_list_store_append( GTK_LIST_STORE( inactive_model ), &iter );
  
    gtk_list_store_set( GTK_LIST_STORE(inactive_model), &iter, 0, comp_name, 1, ind, -1 );
  }
}

void on_set_active_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKComponentManagerGUI *dialog = (GTKComponentManagerGUI *)user_data;
  dialog->handle_set_active_button_clicked_event();
}

void on_set_inactive_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKComponentManagerGUI *dialog = (GTKComponentManagerGUI *)user_data;
  dialog->handle_set_inactive_button_clicked_event();
}

void GTKComponentManagerGUI::create()
{
  GtkTreeModel *active_list_model = (GtkTreeModel *)gtk_list_store_new(  2, G_TYPE_STRING, G_TYPE_INT  );
  GtkTreeModel *inactive_list_model = (GtkTreeModel *)gtk_list_store_new(  2, G_TYPE_STRING, G_TYPE_INT  );
  GtkTreeViewColumn *column;
  GtkCellRenderer   *render;
  
  tooltips = gtk_tooltips_new ();

  components_dialog = gtk_dialog_new_with_buttons( "Component managment...", NULL, GTK_DIALOG_MODAL, 
                                                                GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                                                GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL );
  gtk_window_set_resizable (GTK_WINDOW (components_dialog), FALSE);

  dialog_vbox1 = GTK_DIALOG (components_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  main_table = gtk_table_new (2, 3, FALSE);
  gtk_widget_show (main_table);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), main_table, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (main_table), 2);
  gtk_table_set_col_spacings (GTK_TABLE (main_table), 5);

  active_label = gtk_label_new ("Active components:");
  gtk_widget_show (active_label);
  gtk_table_attach (GTK_TABLE (main_table), active_label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 1, 0);
  gtk_label_set_justify (GTK_LABEL (active_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (active_label), 0, 0.5);

  unactive_label = gtk_label_new ("Inactive components:");
  gtk_widget_show (unactive_label);
  gtk_table_attach (GTK_TABLE (main_table), unactive_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 1, 0);
  gtk_label_set_justify (GTK_LABEL (unactive_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (unactive_label), 0, 0.5);

  flow_vbox = gtk_vbox_new (FALSE, 2);
  gtk_widget_show (flow_vbox);
  gtk_table_attach (GTK_TABLE (main_table), flow_vbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);

  set_active_button = gtk_button_new_with_mnemonic ("   >>   ");
  gtk_widget_show (set_active_button);
  gtk_box_pack_start (GTK_BOX (flow_vbox), set_active_button, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (set_active_button), 1);
  gtk_tooltips_set_tip (tooltips, set_active_button, "Make selected component active", NULL);

  set_inactive_button = gtk_button_new_with_mnemonic ("   <<   ");
  gtk_widget_show (set_inactive_button);
  gtk_box_pack_start (GTK_BOX (flow_vbox), set_inactive_button, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (set_inactive_button), 1);
  gtk_tooltips_set_tip (tooltips, set_inactive_button, "Make selected component inactive", NULL);

  active_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (active_scrolledwindow);
  gtk_table_attach (GTK_TABLE (main_table), active_scrolledwindow, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (active_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (active_scrolledwindow), GTK_SHADOW_ETCHED_IN);
 
  active_treeview = gtk_tree_view_new_with_model( active_list_model );
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "", render, "text", 0, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( active_treeview ), column );
  
  gtk_widget_show (active_treeview);
  gtk_container_add (GTK_CONTAINER (active_scrolledwindow), active_treeview);
  gtk_widget_set_usize (active_treeview, 150, 200);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (active_treeview), FALSE);

  inactive_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (inactive_scrolledwindow);
  gtk_table_attach (GTK_TABLE (main_table), inactive_scrolledwindow, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (inactive_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (inactive_scrolledwindow), GTK_SHADOW_ETCHED_IN);

  inactive_treeview = gtk_tree_view_new_with_model( inactive_list_model );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "", render, "text", 0, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( inactive_treeview ), column );
  
  gtk_widget_show (inactive_treeview);
  gtk_container_add (GTK_CONTAINER (inactive_scrolledwindow), inactive_treeview);
  gtk_widget_set_usize (inactive_treeview, 150, 200);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (inactive_treeview), FALSE);

  gtk_signal_connect (GTK_OBJECT (set_active_button), "clicked",
                      GTK_SIGNAL_FUNC (on_set_active_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (set_inactive_button), "clicked",
                      GTK_SIGNAL_FUNC (on_set_inactive_button_clicked),
                      (gpointer)this);
}

int GTKComponentManagerGUI::run( )
{
  ComponentIndex i = 0;
  create();
  
  GtkTreeModel     *inactive_model = gtk_tree_view_get_model( GTK_TREE_VIEW( inactive_treeview ) );
  GtkTreeModel     *active_model = gtk_tree_view_get_model( GTK_TREE_VIEW( active_treeview ) );
  GtkTreeIter       iter;
  string            str_name;
  CompInterface    *component;
  
  for ( i = 0; i < m_comp_manager->count_registered_components(); i++ )
  {
    component = m_comp_manager->get_registered_component( i ); 
    str_name = component->get_component_name();
    
    if ( component->is_component_active() )
    {
      gtk_list_store_append( GTK_LIST_STORE( active_model ), &iter );
      gtk_list_store_set( GTK_LIST_STORE(active_model), &iter, 0, str_name.c_str(), 1, i, -1 );
    }
    else
    {
      gtk_list_store_append( GTK_LIST_STORE( inactive_model ), &iter );
      gtk_list_store_set( GTK_LIST_STORE(inactive_model), &iter, 0, str_name.c_str(), 1, i, -1 );
    }
  } 

  gint result = gtk_dialog_run( GTK_DIALOG(components_dialog) );
  
  if ( result == GTK_RESPONSE_OK )
  {
    gboolean valid = false;
    ComponentIndex ind;
    
    valid = gtk_tree_model_get_iter_first( active_model, &iter );
    
    while ( valid )
    {
      gtk_tree_model_get( active_model, &iter, 1, &ind, -1 );
      m_comp_manager->get_registered_component( ind )->set_component_active( true );
      valid = gtk_tree_model_iter_next( active_model, &iter );
    }

    valid = gtk_tree_model_get_iter_first( inactive_model, &iter );
    
    while ( valid )
    {
      gtk_tree_model_get( inactive_model, &iter, 1, &ind, -1 );
      m_comp_manager->get_registered_component( ind )->set_component_active( false );
      valid = gtk_tree_model_iter_next( inactive_model, &iter );
    }    
  }
  
  gtk_widget_destroy( components_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}

  
