#include "GTKScenarioGroupGUI.h"
#include "UnixTemplateCreationGUI.h"

using namespace GraphGraphics;

void GTKScenarioGroupGUI::handle_set_exclude_button_event()
{
  string search_str   = m_exclude_tree.get_string();
  string template_str = m_name_storage->get_search_format_string();
  
  GTKGraphAttrTemplateCreationView templ_creation( m_name_storage, 
                                                   UnixGraphAttrView::ATTRIBUTE_TEMPLATE, "", 
                                                   UnixGraphAttrView::ATTRIBUTE_EXPRESSION, "" );
 
  templ_creation.set_base_template( template_str );
  templ_creation.set_init_result_template( search_str );
  
  int res = templ_creation.run_dialog( "Exclude nodes restriction..." ); 

  if ( res == GraphGUIModalWindow::APPLIED )
  {
    search_str = templ_creation.get_result_attr_string();
    
    m_exclude_tree.set_attribute_string( search_str );
    m_exclude_tree.expand_all();
  }    
}

void GTKScenarioGroupGUI::handle_del_exclude_button_event()
{
  m_exclude_tree.set_attribute_string( "" );
}

void GTKScenarioGroupGUI::handle_set_include_button_event()
{
  string search_str   = m_include_tree.get_string();
  string template_str = m_name_storage->get_search_format_string();
  
  GTKGraphAttrTemplateCreationView templ_creation( m_name_storage, 
                                                   UnixGraphAttrView::ATTRIBUTE_TEMPLATE, "", 
                                                   UnixGraphAttrView::ATTRIBUTE_EXPRESSION, "" );
 
  templ_creation.set_base_template( template_str );
  templ_creation.set_init_result_template( search_str );
  
  int res = templ_creation.run_dialog( "Include nodes restriction..." ); 

  if ( res == GraphGUIModalWindow::APPLIED )
  {
    search_str = templ_creation.get_result_attr_string();
    
    m_include_tree.set_attribute_string( search_str );
    m_include_tree.expand_all();
  }    

}

void GTKScenarioGroupGUI::handle_del_include_button_event()
{
  m_include_tree.set_attribute_string( "" );
}

static void on_exclude_set_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKScenarioGroupGUI *dialog = (GTKScenarioGroupGUI*)user_data;
  dialog->handle_set_exclude_button_event();
}

static void on_del_exclude_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKScenarioGroupGUI *dialog = (GTKScenarioGroupGUI*)user_data;
  dialog->handle_del_exclude_button_event();
}

static void on_set_include_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKScenarioGroupGUI *dialog = (GTKScenarioGroupGUI*)user_data;
  dialog->handle_set_include_button_event();
}

static void on_del_include_button_clicked (GtkButton *button, gpointer user_data )
{
  GTKScenarioGroupGUI *dialog = (GTKScenarioGroupGUI*)user_data;
  dialog->handle_del_include_button_event();
}

void GTKScenarioGroupGUI::create()
{
  GtkWidget *tree;
  scenario_group_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (scenario_group_dialog), "Set scenario group restrictions...");

  dialog_vbox1 = GTK_DIALOG (scenario_group_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  main_table = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (main_table);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), main_table, TRUE, TRUE, 0);
  
  include_label = gtk_label_new ("Include nodes ");
  gtk_widget_show (include_label);
  gtk_table_attach (GTK_TABLE (main_table), include_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 4, 0);
  gtk_label_set_justify (GTK_LABEL (include_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (include_label), 0, 0.5);

  exclude_label = gtk_label_new ("Exclude nodes");
  gtk_widget_show (exclude_label);
  gtk_table_attach (GTK_TABLE (main_table), exclude_label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 4, 0);
  gtk_label_set_justify (GTK_LABEL (exclude_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (exclude_label), 0, 0.5);
  
  
  include_scrolledwindow = gtk_scrolled_window_new( NULL, NULL );
  gtk_widget_show( include_scrolledwindow );
  gtk_table_attach( GTK_TABLE (main_table), include_scrolledwindow, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0 );
  gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW (include_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC );
  gtk_scrolled_window_set_placement( GTK_SCROLLED_WINDOW (include_scrolledwindow), GTK_CORNER_TOP_RIGHT );
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (include_scrolledwindow), GTK_SHADOW_OUT);
  
  tree = m_include_tree.get_widget();
  gtk_widget_show( tree );
  gtk_container_add( GTK_CONTAINER (include_scrolledwindow), tree );

  exclude_scrolledwindow = gtk_scrolled_window_new( NULL, NULL );
  gtk_widget_show( exclude_scrolledwindow );
  gtk_table_attach( GTK_TABLE (main_table), exclude_scrolledwindow, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0 );
  gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW (exclude_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC );
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (exclude_scrolledwindow), GTK_SHADOW_OUT);
  
  tree = m_exclude_tree.get_widget();
  gtk_widget_show( tree );
  gtk_container_add( GTK_CONTAINER (exclude_scrolledwindow), tree );
    

  exclude_hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (exclude_hbox);
  gtk_table_attach (GTK_TABLE (main_table), exclude_hbox, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  exclude_set_button = gtk_button_new_with_mnemonic("Set exclude restriction");
  gtk_widget_show (exclude_set_button);
  gtk_box_pack_start (GTK_BOX (exclude_hbox), exclude_set_button, TRUE, TRUE, 0);

  del_exclude_button = gtk_button_new_with_mnemonic("Remove exclude restriction");
  gtk_widget_show (del_exclude_button);
  gtk_box_pack_start (GTK_BOX (exclude_hbox), del_exclude_button, TRUE, TRUE, 0);

  inblude_hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (inblude_hbox);
  gtk_table_attach (GTK_TABLE (main_table), inblude_hbox, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  set_include_button = gtk_button_new_with_mnemonic("Set include restriction");
  gtk_widget_show (set_include_button);
  gtk_box_pack_start (GTK_BOX (inblude_hbox), set_include_button, TRUE, TRUE, 0);

  del_include_button = gtk_button_new_with_mnemonic("Remove include restriction");
  gtk_widget_show (del_include_button);
  gtk_box_pack_start (GTK_BOX (inblude_hbox), del_include_button, TRUE, TRUE, 0);

  dialog_action_area = GTK_DIALOG (scenario_group_dialog)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (scenario_group_dialog), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (scenario_group_dialog), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (exclude_set_button), "clicked",
                      GTK_SIGNAL_FUNC (on_exclude_set_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (del_exclude_button), "clicked",
                      GTK_SIGNAL_FUNC (on_del_exclude_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (set_include_button), "clicked",
                      GTK_SIGNAL_FUNC (on_set_include_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (del_include_button), "clicked",
                      GTK_SIGNAL_FUNC (on_del_include_button_clicked),
                      (gpointer)this);

}


int GTKScenarioGroupGUI::run( )
{
  create();

  gint result = gtk_dialog_run( GTK_DIALOG(scenario_group_dialog) );
  
  if ( result == GTK_RESPONSE_OK )
  {
    m_include_restriction = m_include_tree.get_string();
    m_exclude_restriction = m_exclude_tree.get_string();
  }
  
  gtk_widget_destroy( scenario_group_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
  
