#ifndef _NET_INTERFACE_H_
#define _NET_INTERFACE_H_

#include "ScenarioApp.h"
#include "GUIWindows.h"
#include "CompInterface.h"
#include "NetworkComp.h"

#define    NETWORK_COMP_NAME "Network component"

using namespace GraphGraphics;

typedef struct 
{
  GtkWidget        *drawing_area;  
  GtkWidget        *parent_drawing_area;  
  NetworkComp      *net_comp;
} NetDrawingData;

GtkWidget* create_net_window (  NetDrawingData *net_draw_data, ScenarioApp *graph_app, GtkWidget *parent  );
GtkWidget *make_net_view_menu( NetDrawingData *net_draw_data );

class NetCompActivityHandler: public CompActivityChangesEventHandler
{
private:
  GtkWidget *m_main_window;
  ScenarioApp *m_app;
  NetworkComp *m_net_comp;

public:
  NetCompActivityHandler( GtkWidget *main_window, NetworkComp *net_comp, ScenarioApp *app ) 
  { 
    m_main_window = main_window; 
    m_net_comp = net_comp;
    m_app = app;
  }
  ~NetCompActivityHandler() {}
  void operator () ( bool active )
  {
    GtkWidget *net_window = (GtkWidget *)g_object_get_data( G_OBJECT(m_main_window), "net_window" );
    
    if ( !active )
      m_net_comp->clear_network_context();
        
    if ( net_window == NULL )
    {
      if ( active )
      {
        NetDrawingData *net_draw_data = new NetDrawingData();
        net_draw_data->net_comp = m_net_comp;
      
        net_window = create_net_window ( net_draw_data, m_app, m_main_window );
        gtk_widget_show (net_window);
        m_net_comp->set_graphic_area(m_app->get_GUI()->get_graphic_area( net_draw_data->drawing_area ));
      }
    }
    else    
    {
      if ( active )
        gtk_widget_show( net_window );
      else
        gtk_widget_hide( net_window );
    }
  }
};


#endif 
