#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <fstream>
#include <stdio.h>

#include "callbacks.h"
#include "interface.h"
#include "net_callbacks.h"
#include "net_interface.h"

#include "support.h"

gboolean
on_net_window_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return TRUE;
}

gboolean
on_net_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GtkWidget* parent = (GtkWidget*)g_object_get_data( G_OBJECT(widget), "parent_window" );
  NetDrawingData *net_draw_data = (NetDrawingData *)user_data;
  
  if ( parent != NULL )
    g_object_set_data( G_OBJECT(parent), "net_window" , (gpointer)NULL );
  
  net_draw_data->net_comp->set_graphic_area( 0 );
  
  delete net_draw_data;
  gtk_widget_destroy( widget );
  return TRUE;
}

gboolean
on_net_drawingarea_expose_event            (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
  GraphView        *view = net_draw_data->net_comp->get_network_context()->get_view();
  GraphicArea      *gr_area = gui->get_graphic_area( widget );
	
  view->display( gr_area );
  
  if (gr_area != 0)
    delete gr_area;
  
  return TRUE;
}

void
on_net_zoom_in_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_zoom_in();
  
  update_scrollbars( net_draw_data->drawing_area, view);
  
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
}


void
on_net_zoom_out_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_zoom_out();
  
  update_scrollbars( net_draw_data->drawing_area, view );
  
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
}


void on_net_fit_to_window_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_fit_to_window();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( net_draw_data->drawing_area, view );
  
}

void on_net_fit_to_width_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_fit_to_width();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( net_draw_data->drawing_area, view );
}

void on_net_fit_to_height_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_fit_to_height();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( net_draw_data->drawing_area, view );
}

void on_net_fit_selected_to_window_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_fit_selection_to_window();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( net_draw_data->drawing_area, view );
}

void on_net_arbitrary_size_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  
  net_draw_data->net_comp->handle_arbitrary_size();
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  
  update_scrollbars( net_draw_data->drawing_area, view );
}

void on_net_centering_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphView      *view = net_draw_data->net_comp->get_network_context()->get_view();
  GdkRectangle   invalidate_rect;
  Rectangle         rect;
  NodeIndexVector   selected_nodes;
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
  rect.set_left_top_corner( TwoDPoint( invalidate_rect.x, invalidate_rect.y) );
  rect.set_right_bottom_corner( TwoDPoint( invalidate_rect.width, invalidate_rect.height) );
  
  if ( net_draw_data->net_comp->handle_selection_centering( rect ) )
  {
    update_scrollbars( net_draw_data->drawing_area, view );
    
    gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  }
}

gboolean
on_net_drawingarea_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  NetDrawingData *net_draw_data = (NetDrawingData*)user_data;
  GraphGUI         *gui  = net_draw_data->net_comp->get_GUI(); 
  GraphicArea      *main_g    = gui->get_graphic_area( net_draw_data->parent_drawing_area );  
  GraphicArea      *g    = gui->get_graphic_area( widget );
  Event             g_event;
  KeyCode           modifiers = 0;
  
  g_event.set_type( Event::MOUSE_PRESSED );
    
  switch( event->button )
  {
  case 1: // left button
    g_event.set_button_code( Event::MOUSE_LEFT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    net_draw_data->net_comp->handle_mouse_events( g_event, main_g );
    
    break;
  case 3: // right button
  default:;
  }  

  if (g != 0)
    delete g;

  
  return TRUE;
}

gboolean
on_net_drawingarea_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
  GraphGUI        *gui = net_draw_data->net_comp->get_GUI(); 
  GraphicArea     *main_g    = gui->get_graphic_area( net_draw_data->parent_drawing_area );    
  GraphicArea     *g   = gui->get_graphic_area( widget );
//  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view();
  Event           g_event;
  KeyCode         modifiers = 0;
//  NodeIndex       node_id = Graph::INVALID_NODE_ID;
  GtkWidget       *node_menu = 0;
  GdkRectangle    invalidate_rect;  

  g_event.set_type( Event::MOUSE_RELEASED );
    
  switch( event->button )
  {
  case 1: // left button
    g_event.set_button_code( Event::MOUSE_LEFT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    net_draw_data->net_comp->handle_mouse_events( g_event, main_g );
    
    invalidate_rect.x = 0;
    invalidate_rect.y = 0;
    gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
    gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
    
    gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
    gdk_window_invalidate_rect( net_draw_data->parent_drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( net_draw_data->parent_drawing_area->window, TRUE );
    
    break;
    
  case 3: // right button
    g_event.set_button_code( Event::MOUSE_RIGHT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    net_draw_data->net_comp->handle_mouse_events( g_event, main_g );
    
    node_menu = make_net_view_menu( net_draw_data );
    
    gtk_menu_popup (GTK_MENU (node_menu), NULL, NULL, NULL, NULL,
                      0, event->time);
    
    break;
    
  default:;
  }  

  if (g != 0)
    delete g;

    
  return TRUE;
}

gboolean
on_net_drawingarea_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{

  if ( event->state & GDK_BUTTON1_MASK/* && event->axes == NULL*/ )
  {
    NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
    GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
    GraphicArea      *main_g    = gui->get_graphic_area( net_draw_data->parent_drawing_area );        
    GraphicArea      *g = gui->get_graphic_area( widget );
    Event             g_event;
    KeyCode           modifiers = 0;
    
    g_event.set_type( Event::MOUSE_MOVE );

    g_event.set_button_code( Event::MOUSE_LEFT_BUTTON );
    g_event.set_point( TwoDPoint( (OneDValue)(event->x), (OneDValue)(event->y) ) ); 
    g_event.set_graphic_area( g );
  
    if ( event->state & GDK_SHIFT_MASK )
      modifiers |= Event::SHIFT_MASK;
    if ( event->state & GDK_CONTROL_MASK )
      modifiers |= Event::CTRL_MASK;
    
    g_event.set_modifiers( modifiers );
    
    net_draw_data->net_comp->handle_mouse_events( g_event,  main_g);
    
    if (g != 0)
      delete g;

  }  
 
  
  return TRUE;
}

void on_net_groups_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
  GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view();  
  GdkRectangle      invalidate_rect;
  
  GraphViewPropertiesGUI *dialog = gui->create_group_properties_dialog( view );
  
  dialog->run();
  int chang_level = dialog->get_changes_level();
  
  if ( chang_level != GraphViewPropertiesGUI::PROPERTIES_UNCHANGED )
  {
    if ( chang_level == GraphViewPropertiesGUI::NEED_EDGES_RECONSTRUCTION )
      view->redraw_edges( false );
    
    invalidate_rect.x = 0;
    invalidate_rect.y = 0;
    gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
    gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE ); 
    update_scrollbars( net_draw_data->drawing_area, view );  
  }
}

void on_net_properties_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
  GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view();  
  Graph           *graph = net_draw_data->net_comp->get_network_context()->get_graph();    
  GdkRectangle      invalidate_rect;
  
  GraphViewPropertiesGUI* dialog  = gui->create_view_properties_dialog( view );
  dialog->run();
  int chang_level = dialog->get_changes_level();
  
  if ( chang_level != GraphViewPropertiesGUI::PROPERTIES_UNCHANGED )
  {
    if ( chang_level == GraphViewPropertiesGUI::NEED_EDGES_RECONSTRUCTION )
    {
      if ( graph->count_nodes() > 20 )
        gui->show_wait_dialog( "Graph building. Please wait...");
      view->redraw_edges();
    
      gui->hide_wait_dialog();
    }
    
    invalidate_rect.x = 0;
    invalidate_rect.y = 0;
    gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
    gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
    gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
    update_scrollbars( net_draw_data->drawing_area, view );	
  }
}

void on_net_preference_activate( GtkMenuItem *menuitem, gpointer user_data )
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
  NetworkGUI      *net_gui = net_draw_data->net_comp->get_net_GUI();
  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view(); 
  
  GdkRectangle     invalidate_rect;
    
  GraphGUIModalWindow* dialog = net_gui->create_net_preferences_dialog( view );
  
  dialog->run();

  delete dialog;
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  gdk_window_get_size( net_draw_data->drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
    
  gdk_window_invalidate_rect( net_draw_data->drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( net_draw_data->drawing_area->window, TRUE );
  update_scrollbars( net_draw_data->drawing_area, view );
}

void
on_net_vscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
//  GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view();  
//  Graph           *graph = net_draw_data->net_comp->get_network_context()->get_graph();    
  
  GtkAdjustment *adjustment = gtk_range_get_adjustment( range );
  GdkRectangle   invalidate_rect;
  Rectangle      view_rect;  
  GtkWidget     *drawing_area = net_draw_data->drawing_area;
  gdouble       *last_vscroll_value = (gdouble*)g_object_get_data( G_OBJECT(range), "last_value" );
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  
  if ( view->get_layout() == GraphView::FIT_SELECTION_TO_WINDOW )
    view->set_layout( GraphView::ARBITRARY_SIZE );
  
  gdk_window_get_size( drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  view->set_vscroll_value( (OneDValue)DROUND(adjustment->value - *last_vscroll_value) );
  
  view_rect = view->get_view_rect();
  
  if ( view_rect.get_left_top_corner().get_y() > 0 )
  {
    view->set_vscroll_value( view_rect.get_left_top_corner().get_y() );
  }
  else if ( view_rect.get_right_bottom_corner().get_y() < invalidate_rect.height )
  {
    view->set_vscroll_value( view_rect.get_right_bottom_corner().get_y() - invalidate_rect.height );
  }
  
  *last_vscroll_value = adjustment->value;
 
  gdk_window_invalidate_rect( drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( drawing_area->window, TRUE );
}

void
on_net_hscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
//  GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view();  
//  Graph           *graph = net_draw_data->net_comp->get_network_context()->get_graph();    
  
  GtkAdjustment *adjustment = gtk_range_get_adjustment( range );
  GdkRectangle   invalidate_rect;
  Rectangle      view_rect;
  gdouble        *last_hscroll_value = (gdouble*)g_object_get_data( G_OBJECT(range), "last_value" );
  
  GtkWidget     *drawing_area = net_draw_data->drawing_area;
  
  invalidate_rect.x = 0;
  invalidate_rect.y = 0;
  
  if ( view->get_layout() == GraphView::FIT_SELECTION_TO_WINDOW )
    view->set_layout( GraphView::ARBITRARY_SIZE );

  
  gdk_window_get_size( drawing_area->window, &(invalidate_rect.width), &(invalidate_rect.height) );
  
  view->set_hscroll_value( (OneDValue)DROUND(adjustment->value - *last_hscroll_value) );
  
  view_rect = view->get_view_rect();
    
  if ( view_rect.get_left_top_corner().get_x() > 0 )
  {
    view->set_hscroll_value( view_rect.get_left_top_corner().get_x() );
  }
  else if ( view_rect.get_right_bottom_corner().get_x() < invalidate_rect.width )
  {
    view->set_hscroll_value( view_rect.get_right_bottom_corner().get_x() - invalidate_rect.width );
  }
  
  *last_hscroll_value = adjustment->value;
  
  gdk_window_invalidate_rect( drawing_area->window, &invalidate_rect, TRUE );
  gdk_window_process_updates( drawing_area->window, TRUE );
}

gboolean
on_net_drawingarea_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  NetDrawingData  *net_draw_data = (NetDrawingData*)user_data;
//  GraphGUI         *gui = net_draw_data->net_comp->get_GUI();
  GraphView       *view = net_draw_data->net_comp->get_network_context()->get_view();  
//  Graph           *graph = net_draw_data->net_comp->get_network_context()->get_graph();    
  
  gint           width;
  gint           height;
  Rectangle      display_rect;
  
  gdk_window_get_size( widget->window, &width, &height );
  
  display_rect.set_left_top_corner( TwoDPoint(0, 0) );
  display_rect.set_right_bottom_corner( TwoDPoint(width, height) );
  
  view->do_layout( display_rect ); 

  gdk_window_process_updates( widget->window, TRUE );
  update_scrollbars( widget, view );

  return TRUE;
}

