#ifndef _DOCKED_H_
#define _DOCKED_H_

#include <vector>
#include "GUIWindows.h"

using namespace std;
using namespace GraphGraphics;

struct PageLabel
{
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *image;
  GtkWidget *box;
};

struct DockNotebook
{
  GtkWidget                      *notebook;
  vector<PageLabel*>              labels;
  vector<GraphGUIDockableWindow*> windows;
};

PageLabel* create_page_label( const string &page_name );
void update_page_labels( DockNotebook *dock, int page_num );

DockNotebook *create_dock_notebook();
void add_dock_notebook_page( DockNotebook * dock, GraphGUIDockableWindow* window );
int get_dock_notebook_page_number( DockNotebook * dock );
GraphGUIDockableWindow* get_dock_notebook_page_window( DockNotebook * dock, int page_pos );
void remove_dock_notebook_page( DockNotebook * dock, int page_pos, bool delete_window );
int find_dock_notebook_page( DockNotebook * dock, GraphGUIDockableWindow* window );

class DockNotebookHandler: public GUIDockMenuHandler
{
private:
  DockNotebook *m_dock;
  GraphGUIDockableWindow* m_window;

public:
  DockNotebookHandler( DockNotebook *dock, GraphGUIDockableWindow* window )
  {
    m_dock = dock;
    m_window = window;
  }
  ~DockNotebookHandler(){}
   
  void operator () ( bool docking )
  {
    if ( m_window->is_docked() )
    {
      if ( !docking ) //undock
      {
        GtkWidget *dockable = (GtkWidget*)m_window->get_dockable();
        if ( dockable != 0 )
        {
          int page_pos = gtk_notebook_page_num( GTK_NOTEBOOK( m_dock->notebook ), dockable );
          remove_dock_notebook_page( m_dock, page_pos, false );
          
          m_window->make_docked( false );
          
          m_window->show( true );
        }
      }
    }
    else if ( docking ) //dock
    {
      m_window->show( false );
      add_dock_notebook_page( m_dock, m_window );
    }
  }
};

class PathInfoWindowCloseHandler: public GUICloseHandler
{
private:
  DockNotebook *m_dock;
  GraphGUIDockableWindow* m_window;
public:
  PathInfoWindowCloseHandler( DockNotebook *dock, GraphGUIDockableWindow* window )
  {
    m_dock = dock;
    m_window = window;
  }
  ~PathInfoWindowCloseHandler(){}

  void operator () ( )
  {
    if ( m_window->is_docked() )
    {
      GtkWidget *dockable = (GtkWidget*)m_window->get_dockable();
      if ( dockable != 0 )
      {
        int page_pos = gtk_notebook_page_num( GTK_NOTEBOOK( m_dock->notebook ), dockable );
        remove_dock_notebook_page( m_dock, page_pos, false );
      }
    }
  }    
};

#endif
